/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntitySorter
extends TileEntityIEBase
implements IEBlockInterfaces.IGuiTile {
    public SorterInventory filter;
    public int[] sideFilter = new int[]{0, 0, 0, 0, 0, 0};
    public static final int filterSlotsPerSide = 8;
    private boolean isRouting = false;
    IItemHandler[] insertionHandlers = new IItemHandler[]{new SorterInventoryHandler(this, EnumFacing.DOWN), new SorterInventoryHandler(this, EnumFacing.UP), new SorterInventoryHandler(this, EnumFacing.NORTH), new SorterInventoryHandler(this, EnumFacing.SOUTH), new SorterInventoryHandler(this, EnumFacing.WEST), new SorterInventoryHandler(this, EnumFacing.EAST)};

    public TileEntitySorter() {
        this.filter = new SorterInventory(this);
    }

    public ItemStack routeItem(EnumFacing inputSide, ItemStack stack, boolean simulate) {
        if (!this.world.isRemote) {
            int i;
            int rand;
            Integer[][] validOutputs = this.getValidOutputs(inputSide, stack, true, false);
            if (validOutputs[0].length > 0 && !(stack = this.outputItemToInv(stack, EnumFacing.getFront((int)validOutputs[0][rand = Utils.RAND.nextInt(validOutputs[0].length)]), simulate)).isEmpty()) {
                for (i = 0; i < validOutputs[0].length; ++i) {
                    if (i == rand || !(stack = this.outputItemToInv(stack, EnumFacing.getFront((int)validOutputs[0][i]), simulate)).isEmpty()) continue;
                    return ItemStack.EMPTY;
                }
            }
            if (!stack.isEmpty() && validOutputs[1].length > 0) {
                if (!simulate) {
                    rand = Utils.RAND.nextInt(validOutputs[1].length);
                    EnumFacing fd = EnumFacing.getFront((int)validOutputs[1][rand]);
                    EntityItem ei = new EntityItem(this.world, (double)this.getPos().getX() + 0.5 + (double)fd.getFrontOffsetX(), (double)this.getPos().getY() + 0.5 + (double)fd.getFrontOffsetY(), (double)this.getPos().getZ() + 0.5 + (double)fd.getFrontOffsetZ(), stack.copy());
                    ei.motionX = 0.075f * (float)fd.getFrontOffsetX();
                    ei.motionY = 0.025000000372529;
                    ei.motionZ = 0.075f * (float)fd.getFrontOffsetZ();
                    this.world.spawnEntity((Entity)ei);
                }
                return ItemStack.EMPTY;
            }
            if (validOutputs[2].length > 0 && !(stack = this.outputItemToInv(stack, EnumFacing.getFront((int)validOutputs[2][rand = Utils.RAND.nextInt(validOutputs[2].length)]), simulate)).isEmpty()) {
                for (i = 0; i < validOutputs[2].length; ++i) {
                    if (i == rand || !(stack = this.outputItemToInv(stack, EnumFacing.getFront((int)validOutputs[2][i]), simulate)).isEmpty()) continue;
                    return ItemStack.EMPTY;
                }
            }
            if (!stack.isEmpty() && validOutputs[3].length > 0) {
                if (!simulate) {
                    rand = Utils.RAND.nextInt(validOutputs[3].length);
                    EnumFacing fd = EnumFacing.getFront((int)validOutputs[1][rand]);
                    EntityItem ei = new EntityItem(this.world, (double)this.getPos().getX() + 0.5 + (double)fd.getFrontOffsetX(), (double)this.getPos().getY() + 0.5 + (double)fd.getFrontOffsetY(), (double)this.getPos().getZ() + 0.5 + (double)fd.getFrontOffsetZ(), stack.copy());
                    ei.motionX = 0.075f * (float)fd.getFrontOffsetX();
                    ei.motionY = 0.025000000372529;
                    ei.motionZ = 0.075f * (float)fd.getFrontOffsetZ();
                    this.world.spawnEntity((Entity)ei);
                }
                return ItemStack.EMPTY;
            }
        }
        return stack;
    }

    public boolean doOredict(int side) {
        if (side >= 0 && side < this.sideFilter.length) {
            return (this.sideFilter[side] & 1) != 0;
        }
        return false;
    }

    public boolean doNBT(int side) {
        if (side >= 0 && side < this.sideFilter.length) {
            return (this.sideFilter[side] & 2) != 0;
        }
        return false;
    }

    public boolean doFuzzy(int side) {
        if (side >= 0 && side < this.sideFilter.length) {
            return (this.sideFilter[side] & 4) != 0;
        }
        return false;
    }

    @Override
    public boolean canOpenGui() {
        return true;
    }

    @Override
    public int getGuiID() {
        return 6;
    }

    @Override
    public TileEntity getGuiMaster() {
        return this;
    }

    @Override
    public void receiveMessageFromClient(NBTTagCompound message) {
        if (message.hasKey("sideConfig")) {
            this.sideFilter = message.getIntArray("sideConfig");
        }
    }

    public Integer[][] getValidOutputs(EnumFacing inputSide, ItemStack stack, boolean allowUnmapped, boolean allowThrowing) {
        if (this.isRouting || stack.isEmpty()) {
            return new Integer[][]{new Integer[0], new Integer[0], new Integer[0], new Integer[0]};
        }
        this.isRouting = true;
        ArrayList<Integer> validFilteredInvOuts = new ArrayList<Integer>(6);
        ArrayList<Integer> validFilteredEntityOuts = new ArrayList<Integer>(6);
        ArrayList<Integer> validUnfilteredInvOuts = new ArrayList<Integer>(6);
        ArrayList<Integer> validUnfilteredEntityOuts = new ArrayList<Integer>(6);
        for (EnumFacing side : EnumFacing.values()) {
            TileEntity inventory;
            if (side == inputSide) continue;
            boolean unmapped = true;
            boolean allowed = false;
            for (ItemStack filterStack : this.filter.filters[side.ordinal()]) {
                if (filterStack.isEmpty()) continue;
                unmapped = false;
                boolean b = OreDictionary.itemMatches((ItemStack)filterStack, (ItemStack)stack, (boolean)true);
                if (!b && this.doFuzzy(side.ordinal())) {
                    b = filterStack.getItem().equals(stack.getItem());
                }
                if (!b && this.doOredict(side.ordinal())) {
                    for (String name : OreDictionary.getOreNames()) {
                        if (!Utils.compareToOreName(stack, name) || !Utils.compareToOreName(filterStack, name)) continue;
                        b = true;
                        break;
                    }
                }
                if (this.doNBT(side.ordinal())) {
                    b &= Utils.compareItemNBT(filterStack, stack);
                }
                if (!b) continue;
                allowed = true;
                break;
            }
            if (allowed) {
                inventory = Utils.getExistingTileEntity(this.world, this.getPos().offset(side));
                if (Utils.canInsertStackIntoInventory(inventory, stack, side.getOpposite())) {
                    validFilteredInvOuts.add(side.ordinal());
                    continue;
                }
                if (!allowThrowing) continue;
                validFilteredEntityOuts.add(side.ordinal());
                continue;
            }
            if (!allowUnmapped || !unmapped) continue;
            inventory = Utils.getExistingTileEntity(this.world, this.getPos().offset(side));
            if (Utils.canInsertStackIntoInventory(inventory, stack, side.getOpposite())) {
                validUnfilteredInvOuts.add(side.ordinal());
                continue;
            }
            if (!allowThrowing) continue;
            validUnfilteredEntityOuts.add(side.ordinal());
        }
        this.isRouting = false;
        return new Integer[][]{validFilteredInvOuts.toArray(new Integer[validFilteredInvOuts.size()]), validFilteredEntityOuts.toArray(new Integer[validFilteredEntityOuts.size()]), validUnfilteredInvOuts.toArray(new Integer[validUnfilteredInvOuts.size()]), validUnfilteredEntityOuts.toArray(new Integer[validUnfilteredEntityOuts.size()])};
    }

    public ItemStack outputItemToInv(ItemStack stack, EnumFacing side, boolean simulate) {
        TileEntity inventory = Utils.getExistingTileEntity(this.world, this.getPos().offset(side));
        return Utils.insertStackIntoInventory(inventory, stack, side.getOpposite(), simulate);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.sideFilter = nbt.getIntArray("sideFilter");
        if (!descPacket) {
            NBTTagList filterList = nbt.getTagList("filter", 10);
            this.filter = new SorterInventory(this);
            this.filter.readFromNBT(filterList);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.setIntArray("sideFilter", this.sideFilter);
        if (!descPacket) {
            NBTTagList filterList = new NBTTagList();
            this.filter.writeToNBT(filterList);
            nbt.setTag("filter", (NBTBase)filterList);
        }
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != null) {
            return (T)this.insertionHandlers[facing.ordinal()];
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean receiveClientEvent(int id, int arg) {
        return id == 0;
    }

    public static class SorterInventory
    implements IInventory {
        public ItemStack[][] filters = new ItemStack[6][8];
        final TileEntitySorter tile;

        public SorterInventory(TileEntitySorter tile) {
            this.tile = tile;
            this.clear();
        }

        public int getSizeInventory() {
            return 48;
        }

        public boolean isEmpty() {
            for (int i = 0; i < 6; ++i) {
                for (int j = 0; j < 8; ++j) {
                    if (this.filters[i][j].isEmpty()) continue;
                    return false;
                }
            }
            return true;
        }

        public ItemStack getStackInSlot(int slot) {
            return this.filters[slot / 8][slot % 8];
        }

        public ItemStack decrStackSize(int slot, int amount) {
            ItemStack stack = this.getStackInSlot(slot);
            if (!stack.isEmpty()) {
                if (stack.getCount() <= amount) {
                    this.setInventorySlotContents(slot, null);
                } else if ((stack = stack.splitStack(amount)).getCount() == 0) {
                    this.setInventorySlotContents(slot, null);
                }
            }
            return stack;
        }

        public ItemStack removeStackFromSlot(int slot) {
            ItemStack stack = this.getStackInSlot(slot);
            if (!stack.isEmpty()) {
                this.setInventorySlotContents(slot, null);
            }
            return stack;
        }

        public void setInventorySlotContents(int slot, ItemStack stack) {
            this.filters[slot / 8][slot % 8] = stack;
            if (!stack.isEmpty() && stack.getCount() > this.getInventoryStackLimit()) {
                stack.setCount(this.getInventoryStackLimit());
            }
        }

        public void clear() {
            for (int i = 0; i < this.filters.length; ++i) {
                for (int j = 0; j < this.filters[i].length; ++j) {
                    this.filters[i][j] = ItemStack.EMPTY;
                }
            }
        }

        public String getName() {
            return "IESorterLayout";
        }

        public boolean hasCustomName() {
            return false;
        }

        public ITextComponent getDisplayName() {
            return new TextComponentString(this.getName());
        }

        public int getInventoryStackLimit() {
            return 1;
        }

        public boolean isUsableByPlayer(EntityPlayer player) {
            return true;
        }

        public void openInventory(EntityPlayer player) {
        }

        public void closeInventory(EntityPlayer player) {
        }

        public boolean isItemValidForSlot(int slot, ItemStack stack) {
            return true;
        }

        public void markDirty() {
            this.tile.markDirty();
        }

        public void writeToNBT(NBTTagList list) {
            for (int i = 0; i < this.filters.length; ++i) {
                for (int j = 0; j < this.filters[i].length; ++j) {
                    if (this.filters[i][j].isEmpty()) continue;
                    NBTTagCompound itemTag = new NBTTagCompound();
                    itemTag.setByte("Slot", (byte)(i * 8 + j));
                    this.filters[i][j].writeToNBT(itemTag);
                    list.appendTag((NBTBase)itemTag);
                }
            }
        }

        public void readFromNBT(NBTTagList list) {
            for (int i = 0; i < list.tagCount(); ++i) {
                NBTTagCompound itemTag = list.getCompoundTagAt(i);
                int slot = itemTag.getByte("Slot") & 0xFF;
                if (slot < 0 || slot >= this.getSizeInventory()) continue;
                this.filters[slot / 8][slot % 8] = new ItemStack(itemTag);
            }
        }

        public int getField(int id) {
            return 0;
        }

        public void setField(int id, int value) {
        }

        public int getFieldCount() {
            return 0;
        }
    }

    public static class SorterInventoryHandler
    implements IItemHandlerModifiable {
        TileEntitySorter sorter;
        EnumFacing side;

        public SorterInventoryHandler(TileEntitySorter sorter, EnumFacing side) {
            this.sorter = sorter;
            this.side = side;
        }

        public int getSlots() {
            return 1;
        }

        public ItemStack getStackInSlot(int slot) {
            return ItemStack.EMPTY;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return this.sorter.routeItem(this.side, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.EMPTY;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public void setStackInSlot(int slot, ItemStack stack) {
        }
    }
}

