/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.api.tool.IConfigurableTool;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityModWorkbench
extends TileEntityIEBase
implements IIEInventory,
IEBlockInterfaces.IDirectionalTile,
IEBlockInterfaces.IHasDummyBlocks,
IEBlockInterfaces.IGuiTile {
    NonNullList<ItemStack> inventory = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
    EnumFacing facing = EnumFacing.NORTH;
    public boolean dummy = false;
    public int dummyOffset = 0;
    @SideOnly(value=Side.CLIENT)
    private AxisAlignedBB renderAABB;

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.facing = EnumFacing.getFront((int)nbt.getInteger("facing"));
        this.dummy = nbt.getBoolean("dummy");
        this.dummyOffset = nbt.getInteger("dummyOffset");
        this.inventory = Utils.readInventory(nbt.getTagList("inventory", 10), 1);
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.setInteger("facing", this.facing.ordinal());
        nbt.setBoolean("dummy", this.dummy);
        nbt.setInteger("dummyOffset", this.dummyOffset);
        nbt.setTag("inventory", (NBTBase)Utils.writeInventory(this.inventory));
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = new AxisAlignedBB((double)(this.getPos().getX() - 1), (double)this.getPos().getY(), (double)(this.getPos().getZ() - 1), (double)(this.getPos().getX() + 2), (double)(this.getPos().getY() + 2), (double)(this.getPos().getZ() + 2));
        }
        return this.renderAABB;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 1;
    }

    @Override
    public void doGraphicalUpdates(int slot) {
    }

    @Override
    public EnumFacing getFacing() {
        return this.facing;
    }

    @Override
    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    @Override
    public int getFacingLimitation() {
        return 2;
    }

    @Override
    public boolean mirrorFacingOnPlacement(EntityLivingBase placer) {
        return false;
    }

    @Override
    public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity) {
        return false;
    }

    @Override
    public boolean canRotate(EnumFacing axis) {
        return false;
    }

    @Override
    public void receiveMessageFromClient(NBTTagCompound message) {
        if (!((ItemStack)this.inventory.get(0)).isEmpty() && ((ItemStack)this.inventory.get(0)).getItem() instanceof IConfigurableTool) {
            for (String key : message.getKeySet()) {
                if (key.startsWith("b_")) {
                    ((IConfigurableTool)((ItemStack)this.inventory.get(0)).getItem()).applyConfigOption((ItemStack)this.inventory.get(0), key.substring(2), message.getBoolean(key));
                    continue;
                }
                if (!key.startsWith("f_")) continue;
                ((IConfigurableTool)((ItemStack)this.inventory.get(0)).getItem()).applyConfigOption((ItemStack)this.inventory.get(0), key.substring(2), Float.valueOf(message.getFloat(key)));
            }
        }
    }

    @Override
    public boolean isDummy() {
        return this.dummy;
    }

    @Override
    public void placeDummies(BlockPos pos, IBlockState state, EnumFacing side, float hitX, float hitY, float hitZ) {
        EnumFacing dummyDir = this.facing.getAxis() == EnumFacing.Axis.X ? ((double)hitZ < 0.5 ? EnumFacing.NORTH : EnumFacing.SOUTH) : ((double)hitX < 0.5 ? EnumFacing.WEST : EnumFacing.EAST);
        boolean mirror = false;
        BlockPos dummyPos = pos.offset(dummyDir);
        if (!this.world.getBlockState(dummyPos).getBlock().isReplaceable((IBlockAccess)this.world, dummyPos)) {
            dummyDir = dummyDir.getOpposite();
            dummyPos = pos.offset(dummyDir);
        }
        mirror = dummyDir != this.facing.rotateY();
        int n = this.dummyOffset = mirror ? -1 : 1;
        if (mirror) {
            this.dummy = true;
        }
        this.world.setBlockState(dummyPos, state);
        TileEntityModWorkbench tileEntityDummy = (TileEntityModWorkbench)this.world.getTileEntity(dummyPos);
        tileEntityDummy.facing = this.facing;
        tileEntityDummy.dummy = !mirror;
        tileEntityDummy.dummyOffset = mirror ? -1 : 1;
    }

    @Override
    public void breakDummies(BlockPos pos, IBlockState state) {
        EnumFacing dummyDir = this.dummy ? this.facing.rotateYCCW() : this.facing.rotateY();
        this.world.setBlockToAir(pos.offset(dummyDir));
    }

    @Override
    public boolean canOpenGui() {
        return true;
    }

    @Override
    public int getGuiID() {
        return 4;
    }

    @Override
    public TileEntity getGuiMaster() {
        if (!this.dummy) {
            return this;
        }
        EnumFacing dummyDir = this.dummy ? this.facing.rotateYCCW() : this.facing.rotateY();
        TileEntity tileEntityModWorkbench = this.world.getTileEntity(this.pos.offset(dummyDir));
        if (tileEntityModWorkbench instanceof TileEntityModWorkbench) {
            return tileEntityModWorkbench;
        }
        return null;
    }
}

