/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.ArrayList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class TileEntityFluidSorter
extends TileEntityIEBase
implements IEBlockInterfaces.IGuiTile {
    public byte[] sortWithNBT = new byte[]{1, 1, 1, 1, 1, 1};
    public FluidStack[][] filters = new FluidStack[6][8];
    boolean isRouting = false;
    IFluidHandler[] insertionHandlers = new IFluidHandler[]{new SorterFluidHandler(this, EnumFacing.DOWN), new SorterFluidHandler(this, EnumFacing.UP), new SorterFluidHandler(this, EnumFacing.NORTH), new SorterFluidHandler(this, EnumFacing.SOUTH), new SorterFluidHandler(this, EnumFacing.WEST), new SorterFluidHandler(this, EnumFacing.EAST)};

    public int routeFluid(EnumFacing inputSide, FluidStack stack, boolean doFill) {
        if (!this.world.isRemote) {
            int rand;
            int accepted;
            IFluidHandler[][] validOutputs = this.getValidOutputs(inputSide, stack, true);
            if (validOutputs[0].length > 0 && (accepted = validOutputs[0][rand = Utils.RAND.nextInt(validOutputs[0].length)].fill(stack.copy(), doFill)) > 0) {
                return accepted;
            }
            if (validOutputs[1].length > 0 && (accepted = validOutputs[1][rand = Utils.RAND.nextInt(validOutputs[1].length)].fill(stack.copy(), doFill)) > 0) {
                return accepted;
            }
        }
        return 0;
    }

    public boolean doNBT(int side) {
        if (side >= 0 && side < this.sortWithNBT.length) {
            return this.sortWithNBT[side] == 1;
        }
        return false;
    }

    @Override
    public boolean canOpenGui() {
        return true;
    }

    @Override
    public int getGuiID() {
        return 14;
    }

    @Override
    public TileEntity getGuiMaster() {
        return this;
    }

    @Override
    public void receiveMessageFromClient(NBTTagCompound message) {
        if (message.hasKey("sideConfig")) {
            this.sortWithNBT = message.getByteArray("sideConfig");
        }
        if (message.hasKey("filter_side")) {
            int side = message.getInteger("filter_side");
            int slot = message.getInteger("filter_slot");
            this.filters[side][slot] = FluidStack.loadFluidStackFromNBT((NBTTagCompound)message.getCompoundTag("filter"));
        }
        this.markDirty();
    }

    public IFluidHandler[][] getValidOutputs(EnumFacing inputSide, FluidStack fluidStack, boolean allowUnmapped) {
        if (this.isRouting || fluidStack == null) {
            return new IFluidHandler[2][0];
        }
        this.isRouting = true;
        ArrayList<IFluidHandler> validFilteredInvOuts = new ArrayList<IFluidHandler>(6);
        ArrayList<IFluidHandler> validUnfilteredInvOuts = new ArrayList<IFluidHandler>(6);
        for (EnumFacing side : EnumFacing.values()) {
            IFluidHandler handler;
            TileEntity tile;
            if (side == inputSide || !this.world.isBlockLoaded(this.getPos().offset(side))) continue;
            boolean unmapped = true;
            boolean allowed = false;
            for (FluidStack filterStack : this.filters[side.ordinal()]) {
                boolean b;
                if (filterStack == null) continue;
                unmapped = false;
                boolean bl = b = filterStack.getFluid() == fluidStack.getFluid();
                if (this.doNBT(side.ordinal())) {
                    b &= FluidStack.areFluidStackTagsEqual((FluidStack)filterStack, (FluidStack)fluidStack);
                }
                if (!b) continue;
                allowed = true;
                break;
            }
            if (!allowed && (!allowUnmapped || !unmapped) || (tile = Utils.getExistingTileEntity(this.world, this.getPos().offset(side))) == null || !tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.getOpposite()) || (handler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.getOpposite())).fill(fluidStack.copy(), false) <= 0) continue;
            if (allowed) {
                validFilteredInvOuts.add(handler);
                continue;
            }
            validUnfilteredInvOuts.add(handler);
        }
        this.isRouting = false;
        return new IFluidHandler[][]{validFilteredInvOuts.toArray(new IFluidHandler[validFilteredInvOuts.size()]), validUnfilteredInvOuts.toArray(new IFluidHandler[validUnfilteredInvOuts.size()])};
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.sortWithNBT = nbt.getByteArray("sortWithNBT");
        for (int side = 0; side < 6; ++side) {
            NBTTagList filterList = nbt.getTagList("filter_" + side, 10);
            for (int i = 0; i < filterList.tagCount(); ++i) {
                this.filters[side][i] = FluidStack.loadFluidStackFromNBT((NBTTagCompound)filterList.getCompoundTagAt(i));
            }
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.setByteArray("sortWithNBT", this.sortWithNBT);
        for (int side = 0; side < 6; ++side) {
            NBTTagList filterList = new NBTTagList();
            for (int i = 0; i < this.filters[side].length; ++i) {
                NBTTagCompound tag = new NBTTagCompound();
                if (this.filters[side][i] != null) {
                    this.filters[side][i].writeToNBT(tag);
                }
                filterList.appendTag((NBTBase)tag);
            }
            nbt.setTag("filter_" + side, (NBTBase)filterList);
        }
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && facing != null) {
            return (T)this.insertionHandlers[facing.ordinal()];
        }
        return super.getCapability(capability, facing);
    }

    static class SorterFluidHandler
    implements IFluidHandler {
        TileEntityFluidSorter tile;
        EnumFacing facing;

        SorterFluidHandler(TileEntityFluidSorter tile, EnumFacing facing) {
            this.tile = tile;
            this.facing = facing;
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (resource == null) {
                return 0;
            }
            return this.tile.routeFluid(this.facing, resource, doFill);
        }

        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return null;
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            return null;
        }

        public IFluidTankProperties[] getTankProperties() {
            return new IFluidTankProperties[]{new FluidTankProperties(null, 0)};
        }
    }
}

