/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.BlockIETileProvider;
import blusunrize.immersiveengineering.common.blocks.ItemBlockIEBase;
import blusunrize.immersiveengineering.common.blocks.wooden.BlockTypes_WoodenDevice0;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityFluidSorter;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityModWorkbench;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntitySorter;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityTurntable;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityWoodenBarrel;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityWoodenCrate;
import blusunrize.immersiveengineering.common.entities.EntityIEExplosive;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockWoodenDevice0
extends BlockIETileProvider<BlockTypes_WoodenDevice0> {
    boolean isExploding = false;

    public BlockWoodenDevice0() {
        super("wooden_device0", Material.WOOD, PropertyEnum.create((String)"type", BlockTypes_WoodenDevice0.class), ItemBlockIEBase.ItemBlockIENoInventory.class, new Object[]{IEProperties.FACING_ALL, IEProperties.SIDECONFIG[0], IEProperties.SIDECONFIG[1], IEProperties.MULTIBLOCKSLAVE});
        this.setHardness(2.0f);
        this.setResistance(5.0f);
        this.setMetaLightOpacity(BlockTypes_WoodenDevice0.WORKBENCH.getMeta(), 0);
        this.setNotNormalBlock(BlockTypes_WoodenDevice0.WORKBENCH.getMeta());
        this.setMetaMobilityFlag(BlockTypes_WoodenDevice0.WORKBENCH.getMeta(), EnumPushReaction.BLOCK);
    }

    @Override
    protected EnumFacing getDefaultFacing() {
        return EnumFacing.UP;
    }

    @Override
    public boolean useCustomStateMapper() {
        return true;
    }

    @Override
    public String getCustomStateMapping(int meta, boolean itemBlock) {
        if (meta == BlockTypes_WoodenDevice0.WORKBENCH.getMeta()) {
            return "workbench";
        }
        if (Config.seaonal_festive && (meta == BlockTypes_WoodenDevice0.CRATE.getMeta() || meta == BlockTypes_WoodenDevice0.REINFORCED_CRATE.getMeta() || meta == BlockTypes_WoodenDevice0.GUNPOWDER_BARREL.getMeta())) {
            return "festive";
        }
        return null;
    }

    public int getExplosivesType(IBlockState state) {
        if (!state.getPropertyKeys().contains(this.property)) {
            return -1;
        }
        if (state.getValue((IProperty)this.property) == BlockTypes_WoodenDevice0.GUNPOWDER_BARREL) {
            return 0;
        }
        return -1;
    }

    public void doExplosion(World world, BlockPos pos, IBlockState state, EntityLivingBase igniter, int explosivesType) {
        if (!world.isRemote && explosivesType == 0) {
            EntityIEExplosive explosive = new EntityIEExplosive(world, pos, igniter, state, 4.0f).setDropChance(1.0f);
            world.spawnEntity((Entity)explosive);
            world.playSound(null, explosive.posX, explosive.posY, explosive.posZ, SoundEvents.ENTITY_TNT_PRIMED, SoundCategory.BLOCKS, 1.0f, 1.0f);
            world.setBlockToAir(pos);
        }
    }

    @Override
    public boolean canIEBlockBePlaced(World world, BlockPos pos, IBlockState newState, EnumFacing side, float hitX, float hitY, float hitZ, EntityPlayer player, ItemStack stack) {
        EnumFacing f;
        return stack.getItemDamage() != BlockTypes_WoodenDevice0.WORKBENCH.getMeta() || !((f = EnumFacing.fromAngle((double)player.rotationYaw)).getAxis() == EnumFacing.Axis.Z ? !world.getBlockState(pos.add(1, 0, 0)).getBlock().isReplaceable((IBlockAccess)world, pos.add(1, 0, 0)) && !world.getBlockState(pos.add(-1, 0, 0)).getBlock().isReplaceable((IBlockAccess)world, pos.add(-1, 0, 0)) : !world.getBlockState(pos.add(0, 0, 1)).getBlock().isReplaceable((IBlockAccess)world, pos.add(0, 0, 1)) && !world.getBlockState(pos.add(0, 0, -1)).getBlock().isReplaceable((IBlockAccess)world, pos.add(0, 0, -1)));
    }

    @Override
    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        Item item;
        ItemStack stack = player.getHeldItem(hand);
        int explosivesType = this.getExplosivesType(state);
        if (!(explosivesType < 0 || stack.isEmpty() || (item = stack.getItem()) != Items.FLINT_AND_STEEL && item != Items.FIRE_CHARGE)) {
            this.doExplosion(world, pos, state, (EntityLivingBase)player, explosivesType);
            if (item == Items.FLINT_AND_STEEL) {
                stack.damageItem(1, (EntityLivingBase)player);
            } else if (!player.capabilities.isCreativeMode) {
                stack.shrink(1);
            }
            return true;
        }
        return super.onBlockActivated(world, pos, state, player, hand, side, hitX, hitY, hitZ);
    }

    public boolean canDropFromExplosion(Explosion explosionIn) {
        this.isExploding = true;
        return super.canDropFromExplosion(explosionIn);
    }

    public void dropBlockAsItemWithChance(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (!this.isExploding || this.getExplosivesType(state) < 0) {
            super.dropBlockAsItemWithChance(worldIn, pos, state, chance, fortune);
        }
        this.isExploding = false;
    }

    @Override
    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        if (this.getMetaFromState(world.getBlockState(pos)) == BlockTypes_WoodenDevice0.REINFORCED_CRATE.getMeta()) {
            return 1200000.0f;
        }
        return super.getExplosionResistance(world, pos, exploder, explosion);
    }

    @Override
    public void neighborChanged(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        super.neighborChanged(state, world, pos, block, fromPos);
        int explosivesType = this.getExplosivesType(world.getBlockState(pos));
        if (world instanceof World && explosivesType >= 0 && world.isBlockPowered(pos)) {
            this.doExplosion(world, pos, world.getBlockState(pos), null, explosivesType);
        }
    }

    public void onBlockAdded(World world, BlockPos pos, IBlockState state) {
        super.onBlockAdded(world, pos, state);
        int explosivesType = this.getExplosivesType(state);
        if (explosivesType >= 0 && world.isBlockPowered(pos)) {
            this.doExplosion(world, pos, state, null, explosivesType);
        }
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosionIn) {
        int explosivesType = this.getExplosivesType(world.getBlockState(pos));
        if (explosivesType >= 0) {
            this.doExplosion(world, pos, world.getBlockState(pos), null, explosivesType);
        }
        super.onBlockExploded(world, pos, explosionIn);
    }

    @Override
    public void onEntityCollidedWithBlock(World world, BlockPos pos, IBlockState state, Entity entity) {
        super.onEntityCollidedWithBlock(world, pos, state, entity);
        int explosivesType = this.getExplosivesType(state);
        if (!world.isRemote && entity instanceof EntityArrow && entity.isBurning() && explosivesType >= 0) {
            this.doExplosion(world, pos, state, ((EntityArrow)entity).shootingEntity instanceof EntityLivingBase ? (EntityLivingBase)((EntityArrow)entity).shootingEntity : null, explosivesType);
        }
    }

    @Override
    public TileEntity createBasicTE(World world, BlockTypes_WoodenDevice0 type) {
        switch (type) {
            case CRATE: {
                return new TileEntityWoodenCrate();
            }
            case WORKBENCH: {
                return new TileEntityModWorkbench();
            }
            case BARREL: {
                return new TileEntityWoodenBarrel();
            }
            case SORTER: {
                return new TileEntitySorter();
            }
            case REINFORCED_CRATE: {
                return new TileEntityWoodenCrate();
            }
            case TURNTABLE: {
                return new TileEntityTurntable();
            }
            case FLUID_SORTER: {
                return new TileEntityFluidSorter();
            }
        }
        return null;
    }

    @Override
    public boolean allowHammerHarvest(IBlockState state) {
        return true;
    }
}

