/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.common.blocks.BlockIEBase;
import blusunrize.immersiveengineering.common.blocks.ItemBlockIEBase;
import blusunrize.immersiveengineering.common.blocks.metal.BlockMetalDecoration1;
import blusunrize.immersiveengineering.common.blocks.wooden.BlockTypes_WoodenDecoration;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockFence;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockWoodenDecoration
extends BlockIEBase.IELadderBlock<BlockTypes_WoodenDecoration> {
    public BlockWoodenDecoration() {
        super("wooden_decoration", Material.WOOD, PropertyEnum.create((String)"type", BlockTypes_WoodenDecoration.class), ItemBlockIEBase.class, BlockFence.NORTH, BlockFence.SOUTH, BlockFence.WEST, BlockFence.EAST);
        this.setHardness(2.0f);
        this.setResistance(5.0f);
        this.setBlockLayer(BlockRenderLayer.CUTOUT);
        this.setAllNotNormalBlock();
        this.lightOpacity = 0;
    }

    @Override
    public boolean useCustomStateMapper() {
        return true;
    }

    @Override
    public String getCustomStateMapping(int meta, boolean itemBlock) {
        if (meta == 0 && !itemBlock) {
            return "fence";
        }
        return null;
    }

    public boolean canBeConnectedTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        int meta = this.getMetaFromState(world.getBlockState(pos));
        if (meta == BlockTypes_WoodenDecoration.FENCE.getMeta()) {
            IBlockState connector = world.getBlockState(pos.offset(facing));
            return connector.getBlock() instanceof BlockMetalDecoration1 && this.getMetaFromState(connector) == meta;
        }
        return super.canBeConnectedTo(world, pos, facing);
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        int meta = this.getMetaFromState(state);
        if (meta == BlockTypes_WoodenDecoration.FENCE.getMeta()) {
            return side == EnumFacing.UP;
        }
        if (meta == BlockTypes_WoodenDecoration.SCAFFOLDING.getMeta()) {
            return true;
        }
        return super.isSideSolid(state, world, pos, side);
    }

    public BlockFaceShape getBlockFaceShape(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
        int meta = this.getMetaFromState(state);
        if (meta == BlockTypes_WoodenDecoration.FENCE.getMeta()) {
            return side != EnumFacing.UP && side != EnumFacing.DOWN ? BlockFaceShape.MIDDLE_POLE : BlockFaceShape.CENTER;
        }
        return BlockFaceShape.SOLID;
    }

    public boolean shouldSideBeRendered(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        IBlockState state2;
        int meta = this.getMetaFromState(state);
        if (meta == BlockTypes_WoodenDecoration.SCAFFOLDING.getMeta() && this.equals((state2 = world.getBlockState(pos.offset(side))).getBlock())) {
            int meta2 = this.getMetaFromState(state2);
            return meta2 != BlockTypes_WoodenDecoration.SCAFFOLDING.getMeta();
        }
        return super.shouldSideBeRendered(state, world, pos, side);
    }

    @Override
    public IBlockState getActualState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (this.getMetaFromState(state = super.getActualState(state, world, pos)) == BlockTypes_WoodenDecoration.FENCE.getMeta()) {
            for (EnumFacing f : EnumFacing.HORIZONTALS) {
                state = state.withProperty((IProperty)(f == EnumFacing.NORTH ? BlockFence.NORTH : (f == EnumFacing.SOUTH ? BlockFence.SOUTH : (f == EnumFacing.WEST ? BlockFence.WEST : BlockFence.EAST))), (Comparable)Boolean.valueOf(Utils.canFenceConnectTo(world, pos, f, this.blockMaterial)));
            }
        }
        return state;
    }

    public void addCollisionBoxToList(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        if (this.getMetaFromState(state = state.getActualState((IBlockAccess)worldIn, pos)) == BlockTypes_WoodenDecoration.FENCE.getMeta()) {
            BlockWoodenDecoration.addCollisionBoxToList((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BlockFence.PILLAR_AABB);
            if (((Boolean)state.getValue((IProperty)BlockFence.NORTH)).booleanValue()) {
                BlockWoodenDecoration.addCollisionBoxToList((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BlockFence.NORTH_AABB);
            }
            if (((Boolean)state.getValue((IProperty)BlockFence.EAST)).booleanValue()) {
                BlockWoodenDecoration.addCollisionBoxToList((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BlockFence.EAST_AABB);
            }
            if (((Boolean)state.getValue((IProperty)BlockFence.SOUTH)).booleanValue()) {
                BlockWoodenDecoration.addCollisionBoxToList((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BlockFence.SOUTH_AABB);
            }
            if (((Boolean)state.getValue((IProperty)BlockFence.WEST)).booleanValue()) {
                BlockWoodenDecoration.addCollisionBoxToList((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BlockFence.WEST_AABB);
            }
        } else {
            BlockWoodenDecoration.addCollisionBoxToList((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 1.0, 0.9375));
        }
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess world, BlockPos pos) {
        int meta = this.getMetaFromState(state);
        if (meta == BlockTypes_WoodenDecoration.FENCE.getMeta()) {
            return new AxisAlignedBB(Utils.canFenceConnectTo(world, pos, EnumFacing.WEST, this.blockMaterial) ? 0.0 : 0.375, 0.0, Utils.canFenceConnectTo(world, pos, EnumFacing.NORTH, this.blockMaterial) ? 0.0 : 0.375, Utils.canFenceConnectTo(world, pos, EnumFacing.EAST, this.blockMaterial) ? 1.0 : 0.625, 1.0, Utils.canFenceConnectTo(world, pos, EnumFacing.SOUTH, this.blockMaterial) ? 1.0 : 0.625);
        }
        if (meta == BlockTypes_WoodenDecoration.SCAFFOLDING.getMeta()) {
            return FULL_BLOCK_AABB;
        }
        return super.getBoundingBox(state, world, pos);
    }

    private static int getBoundingBoxIdx(IBlockState state) {
        int i = 0;
        if (((Boolean)state.getValue((IProperty)BlockFence.NORTH)).booleanValue()) {
            i |= 1 << EnumFacing.NORTH.getHorizontalIndex();
        }
        if (((Boolean)state.getValue((IProperty)BlockFence.EAST)).booleanValue()) {
            i |= 1 << EnumFacing.EAST.getHorizontalIndex();
        }
        if (((Boolean)state.getValue((IProperty)BlockFence.SOUTH)).booleanValue()) {
            i |= 1 << EnumFacing.SOUTH.getHorizontalIndex();
        }
        if (((Boolean)state.getValue((IProperty)BlockFence.WEST)).booleanValue()) {
            i |= 1 << EnumFacing.WEST.getHorizontalIndex();
        }
        return i;
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return world.getBlockState(pos).getValue((IProperty)this.property) == BlockTypes_WoodenDecoration.SCAFFOLDING;
    }
}

