/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.stone;

import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;
import net.minecraftforge.common.DimensionManager;

public class TileEntityCoresample
extends TileEntityIEBase
implements IEBlockInterfaces.IDirectionalTile,
IEBlockInterfaces.ITileDrop,
IEBlockInterfaces.IPlayerInteraction,
IEBlockInterfaces.IBlockOverlayText {
    public ItemStack coresample = ItemStack.EMPTY;
    public EnumFacing facing = EnumFacing.NORTH;
    private String[] overlay = null;

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.coresample = new ItemStack(nbt.getCompoundTag("coresample"));
        this.facing = EnumFacing.getFront((int)nbt.getInteger("facing"));
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.setTag("coresample", (NBTBase)this.coresample.writeToNBT(new NBTTagCompound()));
        nbt.setInteger("facing", this.facing.ordinal());
    }

    @Override
    public EnumFacing getFacing() {
        return this.facing;
    }

    @Override
    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    @Override
    public int getFacingLimitation() {
        return 2;
    }

    @Override
    public boolean mirrorFacingOnPlacement(EntityLivingBase placer) {
        return true;
    }

    @Override
    public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity) {
        return true;
    }

    @Override
    public boolean canRotate(EnumFacing axis) {
        return true;
    }

    @Override
    public boolean interact(EnumFacing side, EntityPlayer player, EnumHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        if (player.isSneaking()) {
            if (!this.getWorld().isRemote) {
                EntityItem entityitem = new EntityItem(this.getWorld(), (double)this.getPos().getX() + 0.5, (double)this.getPos().getY() + 0.5, (double)this.getPos().getZ() + 0.5, this.getTileDrop(player, this.getWorld().getBlockState(this.getPos())));
                entityitem.setDefaultPickupDelay();
                this.getWorld().setBlockToAir(this.getPos());
                this.getWorld().spawnEntity((Entity)entityitem);
            }
            return true;
        }
        if (!heldItem.isEmpty() && heldItem.getItem() == Items.FILLED_MAP && ItemNBTHelper.hasKey(this.coresample, "coords")) {
            MapData mapData;
            if (!this.getWorld().isRemote && (mapData = ((ItemMap)heldItem.getItem()).getMapData(heldItem, player.getEntityWorld())) != null) {
                int[] coords = ItemNBTHelper.getIntArray(this.coresample, "coords");
                String ident = "ie:coresample_" + coords[0] + ";" + coords[1] + ";" + coords[2];
                if (mapData.mapDecorations.containsKey(ident)) {
                    mapData.mapDecorations.remove(ident);
                    return true;
                }
                double sampleX = (double)(coords[1] * 16) + 8.5;
                double sampleZ = (double)(coords[2] * 16) + 8.5;
                int mapScale = 1 << mapData.scale;
                float distX = (float)(sampleX - (double)mapData.xCenter) / (float)mapScale;
                float distZ = (float)(sampleZ - (double)mapData.zCenter) / (float)mapScale;
                byte mapX = (byte)((double)(distX * 2.0f) + 0.5);
                byte mapZ = (byte)((double)(distZ * 2.0f) + 0.5);
                byte b2 = 8;
                if (distX >= -63.0f && distX <= 63.0f && distZ >= -63.0f && distZ <= 63.0f) {
                    mapData.mapDecorations.put(ident, new MapDecoration(MapDecoration.Type.TARGET_POINT, mapX, mapZ, b2));
                } else {
                    player.sendMessage((ITextComponent)new TextComponentTranslation("chat.immersiveengineering.info.coresample.mapFail", new Object[0]));
                }
            }
            return true;
        }
        return false;
    }

    @Nullable
    public ITextComponent getDisplayName() {
        return this.coresample.hasDisplayName() ? new TextComponentString(this.coresample.getDisplayName()) : new TextComponentTranslation("item.immersiveengineering.coresample.name", new Object[0]);
    }

    @Override
    public ItemStack getTileDrop(EntityPlayer player, IBlockState state) {
        return this.coresample;
    }

    @Override
    public void readOnPlacement(EntityLivingBase placer, ItemStack stack) {
        this.coresample = stack.copy();
    }

    @Override
    public boolean preventInventoryDrop() {
        return true;
    }

    @Override
    public String[] getOverlayText(EntityPlayer player, RayTraceResult mop, boolean hammer) {
        if (this.coresample != null && ItemNBTHelper.hasKey(this.coresample, "coords")) {
            if (this.overlay == null) {
                this.overlay = new String[3];
                int[] coords = ItemNBTHelper.getIntArray(this.coresample, "coords");
                this.overlay[0] = I18n.format((String)"chat.immersiveengineering.info.coresample.noMineral", (Object[])new Object[0]);
                if (ItemNBTHelper.hasKey(this.coresample, "mineral")) {
                    String mineral = ItemNBTHelper.getString(this.coresample, "mineral");
                    String unloc = "desc.immersiveengineering.info.mineral." + mineral;
                    String loc = I18n.format((String)unloc, (Object[])new Object[0]);
                    this.overlay[0] = TextFormatting.GOLD + I18n.format((String)"chat.immersiveengineering.info.coresample.mineral", (Object[])new Object[]{unloc.equals(loc) ? mineral : loc});
                }
                WorldServer world = DimensionManager.getWorld((int)coords[0]);
                String s0 = coords[1] * 16 + ", " + coords[2] * 16;
                String s1 = coords[1] * 16 + 16 + ", " + (coords[2] * 16 + 16);
                if (world != null && world.provider != null) {
                    String name = world.provider.getDimensionType().getName();
                    if (name.toLowerCase(Locale.ENGLISH).startsWith("the ")) {
                        name = name.substring(4);
                    }
                    this.overlay[1] = name;
                } else {
                    this.overlay[1] = "Dimension " + coords[0];
                }
                this.overlay[2] = I18n.format((String)"chat.immersiveengineering.info.coresample.pos", (Object[])new Object[]{s0, s1, ""});
            }
            return this.overlay;
        }
        return new String[0];
    }

    @Override
    public boolean useNixieFont(EntityPlayer player, RayTraceResult mop) {
        return false;
    }
}

