/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.stone;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.crafting.CokeOvenRecipe;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityMultiblockPart;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityCokeOven
extends TileEntityMultiblockPart<TileEntityCokeOven>
implements IIEInventory,
IEBlockInterfaces.IActiveState,
IEBlockInterfaces.IGuiTile,
IEBlockInterfaces.IProcessTile {
    public FluidTank tank = new FluidTank(12000);
    NonNullList<ItemStack> inventory = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    public int process = 0;
    public int processMax = 0;
    public boolean active = false;
    private static final int[] size = new int[]{3, 3, 3};
    IItemHandler invHandler = new IEInventoryHandler(4, (IIEInventory)this, 0, new boolean[]{true, false, true, false}, new boolean[]{false, true, false, true});

    public TileEntityCokeOven() {
        super(size);
    }

    @Override
    public IEProperties.PropertyBoolInverted getBoolProperty(Class<? extends IEBlockInterfaces.IUsesBooleanProperty> inf) {
        return inf == IEBlockInterfaces.IActiveState.class ? IEProperties.BOOLEANS[0] : null;
    }

    @Override
    public boolean getIsActive() {
        return this.active;
    }

    @Override
    public boolean canOpenGui() {
        return this.formed;
    }

    @Override
    public int getGuiID() {
        return 0;
    }

    @Override
    public TileEntity getGuiMaster() {
        return this.master();
    }

    @Override
    public float[] getBlockBounds() {
        return null;
    }

    @Override
    public ItemStack getOriginalBlock() {
        return new ItemStack((Block)IEContent.blockStoneDecoration, 1, 0);
    }

    @Override
    public boolean isDummy() {
        return this.offset[0] != 0 || this.offset[1] != 0 || this.offset[2] != 0;
    }

    public void update() {
        ApiUtils.checkForNeedlessTicking(this);
        if (!this.world.isRemote && this.formed && !this.isDummy()) {
            ItemStack filledContainer;
            CokeOvenRecipe recipe;
            boolean a = this.active;
            boolean b = false;
            if (this.process > 0) {
                if (((ItemStack)this.inventory.get(0)).isEmpty()) {
                    this.process = 0;
                    this.processMax = 0;
                } else {
                    recipe = this.getRecipe();
                    if (recipe == null || recipe.time != this.processMax) {
                        this.process = 0;
                        this.processMax = 0;
                        this.active = false;
                    } else {
                        --this.process;
                    }
                }
                this.markContainingBlockForUpdate(null);
            } else {
                if (this.active) {
                    recipe = this.getRecipe();
                    if (recipe != null) {
                        Utils.modifyInvStackSize(this.inventory, 0, -1);
                        if (!((ItemStack)this.inventory.get(1)).isEmpty()) {
                            ((ItemStack)this.inventory.get(1)).grow(recipe.output.copy().getCount());
                        } else if (((ItemStack)this.inventory.get(1)).isEmpty()) {
                            this.inventory.set(1, (Object)recipe.output.copy());
                        }
                        this.tank.fill(new FluidStack(IEContent.fluidCreosote, recipe.creosoteOutput), true);
                    }
                    this.processMax = 0;
                    this.active = false;
                }
                if ((recipe = this.getRecipe()) != null) {
                    this.processMax = this.process = recipe.time;
                    this.active = true;
                }
            }
            if (this.tank.getFluidAmount() > 0 && this.tank.getFluid() != null && (((ItemStack)this.inventory.get(3)).isEmpty() || ((ItemStack)this.inventory.get(3)).getCount() + 1 <= ((ItemStack)this.inventory.get(3)).getMaxStackSize()) && !(filledContainer = Utils.fillFluidContainer((IFluidHandler)this.tank, (ItemStack)this.inventory.get(2), (ItemStack)this.inventory.get(3), null)).isEmpty()) {
                if (!((ItemStack)this.inventory.get(3)).isEmpty() && OreDictionary.itemMatches((ItemStack)((ItemStack)this.inventory.get(3)), (ItemStack)filledContainer, (boolean)true)) {
                    ((ItemStack)this.inventory.get(3)).grow(filledContainer.getCount());
                } else if (((ItemStack)this.inventory.get(3)).isEmpty()) {
                    this.inventory.set(3, (Object)filledContainer.copy());
                }
                Utils.modifyInvStackSize(this.inventory, 2, -filledContainer.getCount());
                b = true;
            }
            if (a != this.active || b) {
                this.markDirty();
                for (int yy = -1; yy <= 1; ++yy) {
                    for (int xx = -1; xx <= 1; ++xx) {
                        for (int zz = -1; zz <= 1; ++zz) {
                            TileEntity tileEntity = Utils.getExistingTileEntity(this.world, this.getPos().add(xx, yy, zz));
                            if (tileEntity != null) {
                                tileEntity.markDirty();
                            }
                            this.markBlockForUpdate(this.getPos().add(xx, yy, zz), null);
                            this.world.addBlockEvent(this.getPos().add(xx, yy, zz), (Block)IEContent.blockStoneDevice, 1, this.active ? 1 : 0);
                        }
                    }
                }
            }
        }
    }

    public CokeOvenRecipe getRecipe() {
        CokeOvenRecipe recipe = CokeOvenRecipe.findRecipe((ItemStack)this.inventory.get(0));
        if (recipe == null) {
            return null;
        }
        if ((((ItemStack)this.inventory.get(1)).isEmpty() || OreDictionary.itemMatches((ItemStack)((ItemStack)this.inventory.get(1)), (ItemStack)recipe.output, (boolean)false) && ((ItemStack)this.inventory.get(1)).getCount() + recipe.output.getCount() <= this.getSlotLimit(1)) && this.tank.getFluidAmount() + recipe.creosoteOutput <= this.tank.getCapacity()) {
            return recipe;
        }
        return null;
    }

    @Override
    public int[] getCurrentProcessesStep() {
        TileEntityCokeOven master = (TileEntityCokeOven)this.master();
        if (master != this && master != null) {
            return master.getCurrentProcessesStep();
        }
        return new int[]{this.processMax - this.process};
    }

    @Override
    public int[] getCurrentProcessesMax() {
        TileEntityCokeOven master = (TileEntityCokeOven)this.master();
        if (master != this && master != null) {
            return master.getCurrentProcessesMax();
        }
        return new int[]{this.processMax};
    }

    @Override
    public boolean receiveClientEvent(int id, int arg) {
        if (id == 0) {
            this.formed = arg == 1;
        } else if (id == 1) {
            this.active = arg == 1;
        }
        this.markDirty();
        this.markContainingBlockForUpdate(null);
        return true;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.process = nbt.getInteger("process");
        this.processMax = nbt.getInteger("processMax");
        this.active = nbt.getBoolean("active");
        this.tank.readFromNBT(nbt.getCompoundTag("tank"));
        if (!descPacket) {
            this.inventory = Utils.readInventory(nbt.getTagList("inventory", 10), 4);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.setInteger("process", this.process);
        nbt.setInteger("processMax", this.processMax);
        nbt.setBoolean("active", this.active);
        NBTTagCompound tankTag = this.tank.writeToNBT(new NBTTagCompound());
        nbt.setTag("tank", (NBTBase)tankTag);
        if (!descPacket) {
            nbt.setTag("inventory", (NBTBase)Utils.writeInventory(this.inventory));
        }
    }

    @Override
    public BlockPos getOrigin() {
        return this.getPos().add(-this.offset[0], -this.offset[1] - 1, -this.offset[2]).offset(this.facing.getOpposite()).offset(this.facing.rotateYCCW());
    }

    @Override
    protected IFluidTank[] getAccessibleFluidTanks(EnumFacing side) {
        TileEntityCokeOven master = (TileEntityCokeOven)this.master();
        if (master != null) {
            return new FluidTank[]{master.tank};
        }
        return new FluidTank[0];
    }

    @Override
    protected boolean canFillTankFrom(int iTank, EnumFacing side, FluidStack resource) {
        return false;
    }

    @Override
    protected boolean canDrainTankFrom(int iTank, EnumFacing side) {
        return true;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        TileEntityCokeOven master = (TileEntityCokeOven)this.master();
        if (master != null && master.formed && this.formed) {
            return master.inventory;
        }
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        if (slot == 0) {
            return CokeOvenRecipe.findRecipe(stack) != null;
        }
        if (slot == 2) {
            return Utils.isFluidRelatedItemStack(stack);
        }
        return false;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public void doGraphicalUpdates(int slot) {
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.master() != null;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            TileEntityCokeOven master = (TileEntityCokeOven)this.master();
            if (master == null) {
                return null;
            }
            return (T)master.invHandler;
        }
        return super.getCapability(capability, facing);
    }
}

