/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.stone;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.crafting.BlastFurnaceRecipe;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityMultiblockPart;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityBlastFurnace
extends TileEntityMultiblockPart<TileEntityBlastFurnace>
implements IIEInventory,
IEBlockInterfaces.IActiveState,
IEBlockInterfaces.IGuiTile,
IEBlockInterfaces.IProcessTile {
    NonNullList<ItemStack> inventory = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    public int process = 0;
    public int processMax = 0;
    public boolean active = false;
    public int burnTime = 0;
    public int lastBurnTime = 0;
    private static final int[] size = new int[]{3, 3, 3};

    public TileEntityBlastFurnace() {
        super(size);
    }

    public TileEntityBlastFurnace(int[] size) {
        super(size);
    }

    @Override
    public IEProperties.PropertyBoolInverted getBoolProperty(Class<? extends IEBlockInterfaces.IUsesBooleanProperty> inf) {
        return inf == IEBlockInterfaces.IActiveState.class ? IEProperties.BOOLEANS[0] : null;
    }

    @Override
    public boolean getIsActive() {
        return this.active;
    }

    @Override
    public boolean canOpenGui() {
        return this.formed;
    }

    @Override
    public int getGuiID() {
        return 2;
    }

    @Override
    public TileEntity getGuiMaster() {
        return this.master();
    }

    @Override
    public float[] getBlockBounds() {
        return null;
    }

    @Override
    public ItemStack getOriginalBlock() {
        return new ItemStack((Block)IEContent.blockStoneDecoration, 1, 1);
    }

    @Override
    public boolean isDummy() {
        return this.offset[0] != 0 || this.offset[1] != 0 || this.offset[2] != 0;
    }

    public void update() {
        ApiUtils.checkForNeedlessTicking(this);
        if (!this.world.isRemote && this.formed && !this.isDummy()) {
            boolean a = this.active;
            if (this.burnTime > 0) {
                BlastFurnaceRecipe recipe;
                int processSpeed = 1;
                if (this.process > 0) {
                    processSpeed = this.getProcessSpeed();
                    if (((ItemStack)this.inventory.get(0)).isEmpty()) {
                        this.process = 0;
                        this.processMax = 0;
                    } else {
                        recipe = this.getRecipe();
                        if (recipe != null && recipe.time != this.processMax) {
                            this.processMax = 0;
                            this.process = 0;
                            this.active = false;
                        } else {
                            this.process -= processSpeed;
                            if (!this.active) {
                                this.active = true;
                            }
                        }
                    }
                    this.markContainingBlockForUpdate(null);
                }
                this.burnTime -= processSpeed;
                if (this.process <= 0) {
                    if (this.processMax > 0) {
                        recipe = this.getRecipe();
                        if (recipe != null) {
                            Utils.modifyInvStackSize(this.inventory, 0, -(recipe.input instanceof ItemStack ? ((ItemStack)recipe.input).getCount() : 1));
                            if (!((ItemStack)this.inventory.get(2)).isEmpty()) {
                                ((ItemStack)this.inventory.get(2)).grow(recipe.output.copy().getCount());
                            } else {
                                this.inventory.set(2, (Object)recipe.output.copy());
                            }
                            if (!recipe.slag.isEmpty()) {
                                if (!((ItemStack)this.inventory.get(3)).isEmpty()) {
                                    ((ItemStack)this.inventory.get(3)).grow(recipe.slag.copy().getCount());
                                } else {
                                    this.inventory.set(3, (Object)recipe.slag.copy());
                                }
                            }
                        }
                        this.processMax = 0;
                        this.burnTime -= this.process;
                    }
                    if ((recipe = this.getRecipe()) != null) {
                        this.processMax = this.process = recipe.time;
                        this.active = true;
                    }
                }
            } else if (this.active) {
                this.active = false;
            }
            if (this.burnTime <= 10 && this.getRecipe() != null && BlastFurnaceRecipe.isValidBlastFuel((ItemStack)this.inventory.get(1))) {
                this.burnTime += BlastFurnaceRecipe.getBlastFuelTime((ItemStack)this.inventory.get(1));
                this.lastBurnTime = BlastFurnaceRecipe.getBlastFuelTime((ItemStack)this.inventory.get(1));
                Utils.modifyInvStackSize(this.inventory, 1, -1);
                this.markContainingBlockForUpdate(null);
            }
            if (a != this.active) {
                this.markDirty();
                for (int yy = -1; yy <= 1; ++yy) {
                    for (int xx = -1; xx <= 1; ++xx) {
                        for (int zz = -1; zz <= 1; ++zz) {
                            TileEntity tileEntity = Utils.getExistingTileEntity(this.world, this.getPos().add(xx, yy, zz));
                            if (tileEntity != null) {
                                tileEntity.markDirty();
                            }
                            this.markBlockForUpdate(this.getPos().add(xx, yy, zz), null);
                            this.world.addBlockEvent(this.getPos().add(xx, yy, zz), (Block)IEContent.blockStoneDevice, 1, this.active ? 1 : 0);
                        }
                    }
                }
            }
        }
    }

    public BlastFurnaceRecipe getRecipe() {
        BlastFurnaceRecipe recipe = BlastFurnaceRecipe.findRecipe((ItemStack)this.inventory.get(0));
        if (recipe == null) {
            return null;
        }
        if ((((ItemStack)this.inventory.get(0)).getCount() >= (recipe.input instanceof ItemStack ? ((ItemStack)recipe.input).getCount() : 1) && ((ItemStack)this.inventory.get(2)).isEmpty() || OreDictionary.itemMatches((ItemStack)((ItemStack)this.inventory.get(2)), (ItemStack)recipe.output, (boolean)true) && ((ItemStack)this.inventory.get(2)).getCount() + recipe.output.getCount() <= this.getSlotLimit(2)) && (((ItemStack)this.inventory.get(3)).isEmpty() || OreDictionary.itemMatches((ItemStack)((ItemStack)this.inventory.get(3)), (ItemStack)recipe.slag, (boolean)true) && ((ItemStack)this.inventory.get(3)).getCount() + recipe.slag.getCount() <= this.getSlotLimit(3))) {
            return recipe;
        }
        return null;
    }

    protected int getProcessSpeed() {
        return 1;
    }

    @Override
    public int[] getCurrentProcessesStep() {
        TileEntityBlastFurnace master = (TileEntityBlastFurnace)this.master();
        if (master != this && master != null) {
            return master.getCurrentProcessesStep();
        }
        return new int[]{this.processMax - this.process};
    }

    @Override
    public int[] getCurrentProcessesMax() {
        TileEntityBlastFurnace master = (TileEntityBlastFurnace)this.master();
        if (master != this && master != null) {
            return master.getCurrentProcessesMax();
        }
        return new int[]{this.processMax};
    }

    @Override
    public boolean receiveClientEvent(int id, int arg) {
        if (id == 0) {
            this.formed = arg == 1;
        } else if (id == 1) {
            this.active = arg == 1;
        }
        this.markDirty();
        this.markContainingBlockForUpdate(null);
        return true;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.process = nbt.getInteger("process");
        this.processMax = nbt.getInteger("processMax");
        this.active = nbt.getBoolean("active");
        this.burnTime = nbt.getInteger("burnTime");
        this.lastBurnTime = nbt.getInteger("lastBurnTime");
        if (!descPacket) {
            this.inventory = Utils.readInventory(nbt.getTagList("inventory", 10), 4);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.setInteger("process", this.process);
        nbt.setInteger("processMax", this.processMax);
        nbt.setBoolean("active", this.active);
        nbt.setInteger("burnTime", this.burnTime);
        nbt.setInteger("lastBurnTime", this.lastBurnTime);
        if (!descPacket) {
            nbt.setTag("inventory", (NBTBase)Utils.writeInventory(this.inventory));
        }
    }

    @Override
    public BlockPos getOrigin() {
        return this.getPos().add(-this.offset[0], -this.offset[1] - 1, -this.offset[2]).offset(this.facing.getOpposite()).offset(this.facing.rotateYCCW());
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return slot == 0 ? BlastFurnaceRecipe.findRecipe(stack) != null : slot == 1 && BlastFurnaceRecipe.isValidBlastFuel(stack);
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public void doGraphicalUpdates(int slot) {
    }

    @Override
    protected IFluidTank[] getAccessibleFluidTanks(EnumFacing side) {
        return new FluidTank[0];
    }

    @Override
    protected boolean canFillTankFrom(int iTank, EnumFacing side, FluidStack resources) {
        return false;
    }

    @Override
    protected boolean canDrainTankFrom(int iTank, EnumFacing side) {
        return false;
    }
}

