/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.stone;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.crafting.AlloyRecipe;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityMultiblockPart;
import blusunrize.immersiveengineering.common.blocks.stone.BlockTypes_StoneDecoration;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityAlloySmelter
extends TileEntityMultiblockPart<TileEntityAlloySmelter>
implements IIEInventory,
IEBlockInterfaces.IActiveState,
IEBlockInterfaces.IGuiTile,
IEBlockInterfaces.IProcessTile {
    NonNullList<ItemStack> inventory = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    public int process = 0;
    public int processMax = 0;
    public boolean active = false;
    public int burnTime = 0;
    public int lastBurnTime = 0;
    private static final int[] size = new int[]{2, 2, 2};

    public TileEntityAlloySmelter() {
        super(size);
    }

    @Override
    public IEProperties.PropertyBoolInverted getBoolProperty(Class<? extends IEBlockInterfaces.IUsesBooleanProperty> inf) {
        return inf == IEBlockInterfaces.IActiveState.class ? IEProperties.BOOLEANS[0] : null;
    }

    @Override
    public boolean getIsActive() {
        return this.active;
    }

    @Override
    public boolean canOpenGui() {
        return this.formed;
    }

    @Override
    public int getGuiID() {
        return 1;
    }

    @Override
    public TileEntity getGuiMaster() {
        return this.master();
    }

    @Override
    public float[] getBlockBounds() {
        return null;
    }

    @Override
    public ItemStack getOriginalBlock() {
        return new ItemStack((Block)IEContent.blockStoneDecoration, 1, BlockTypes_StoneDecoration.ALLOYBRICK.getMeta());
    }

    @Override
    public boolean isDummy() {
        return this.offset[0] != 0 || this.offset[1] != 0 || this.offset[2] != 0;
    }

    public void update() {
        ApiUtils.checkForNeedlessTicking(this);
        if (!this.world.isRemote && this.formed && !this.isDummy()) {
            boolean a = this.active;
            if (this.burnTime > 0) {
                AlloyRecipe recipe;
                if (this.process > 0) {
                    if (((ItemStack)this.inventory.get(0)).isEmpty() || ((ItemStack)this.inventory.get(1)).isEmpty()) {
                        this.process = 0;
                        this.processMax = 0;
                    } else {
                        recipe = this.getRecipe();
                        if (recipe != null && recipe.time != this.processMax) {
                            this.processMax = 0;
                            this.process = 0;
                            this.active = false;
                        } else {
                            --this.process;
                            if (!this.active) {
                                this.active = true;
                            }
                        }
                    }
                    this.markContainingBlockForUpdate(null);
                }
                --this.burnTime;
                if (this.process <= 0) {
                    if (this.processMax > 0) {
                        recipe = this.getRecipe();
                        if (recipe != null) {
                            boolean flip = !recipe.input0.matchesItemStack((ItemStack)this.inventory.get(0));
                            Utils.modifyInvStackSize(this.inventory, flip ? 1 : 0, -recipe.input0.inputSize);
                            Utils.modifyInvStackSize(this.inventory, flip ? 0 : 1, -recipe.input1.inputSize);
                            if (!((ItemStack)this.inventory.get(3)).isEmpty()) {
                                ((ItemStack)this.inventory.get(3)).grow(recipe.output.copy().getCount());
                            } else {
                                this.inventory.set(3, (Object)recipe.output.copy());
                            }
                        }
                        this.processMax = 0;
                    }
                    if ((recipe = this.getRecipe()) != null) {
                        this.processMax = this.process = recipe.time;
                        this.active = true;
                    }
                }
            } else if (this.active) {
                this.active = false;
            }
            if (this.burnTime <= 10 && this.getRecipe() != null && TileEntityFurnace.isItemFuel((ItemStack)((ItemStack)this.inventory.get(2)))) {
                this.lastBurnTime = TileEntityFurnace.getItemBurnTime((ItemStack)((ItemStack)this.inventory.get(2)));
                this.burnTime += this.lastBurnTime;
                Utils.modifyInvStackSize(this.inventory, 2, -1);
                this.markContainingBlockForUpdate(null);
            }
            if (a != this.active) {
                this.markDirty();
                for (int yy = -1; yy <= 1; ++yy) {
                    for (int xx = -1; xx <= 1; ++xx) {
                        for (int zz = -1; zz <= 1; ++zz) {
                            TileEntity tileEntity = Utils.getExistingTileEntity(this.world, this.getPos().add(xx, yy, zz));
                            if (tileEntity != null) {
                                tileEntity.markDirty();
                            }
                            this.markBlockForUpdate(this.getPos().add(xx, yy, zz), null);
                            this.world.addBlockEvent(this.getPos().add(xx, yy, zz), (Block)IEContent.blockStoneDevice, 1, this.active ? 1 : 0);
                        }
                    }
                }
            }
        }
    }

    public AlloyRecipe getRecipe() {
        AlloyRecipe recipe = AlloyRecipe.findRecipe((ItemStack)this.inventory.get(0), (ItemStack)this.inventory.get(1));
        if (recipe == null) {
            return null;
        }
        if (((ItemStack)this.inventory.get(3)).isEmpty() || OreDictionary.itemMatches((ItemStack)((ItemStack)this.inventory.get(3)), (ItemStack)recipe.output, (boolean)true) && ((ItemStack)this.inventory.get(3)).getCount() + recipe.output.getCount() <= this.getSlotLimit(3)) {
            return recipe;
        }
        return null;
    }

    @Override
    public int[] getCurrentProcessesStep() {
        TileEntityAlloySmelter master = (TileEntityAlloySmelter)this.master();
        if (master != this && master != null) {
            return master.getCurrentProcessesStep();
        }
        return new int[]{this.processMax - this.process};
    }

    @Override
    public int[] getCurrentProcessesMax() {
        TileEntityAlloySmelter master = (TileEntityAlloySmelter)this.master();
        if (master != this && master != null) {
            return master.getCurrentProcessesMax();
        }
        return new int[]{this.processMax};
    }

    @Override
    public boolean receiveClientEvent(int id, int arg) {
        if (id == 0) {
            this.formed = arg == 1;
        } else if (id == 1) {
            this.active = arg == 1;
        }
        this.markDirty();
        this.markContainingBlockForUpdate(null);
        return true;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.process = nbt.getInteger("process");
        this.processMax = nbt.getInteger("processMax");
        this.active = nbt.getBoolean("active");
        this.burnTime = nbt.getInteger("burnTime");
        this.lastBurnTime = nbt.getInteger("lastBurnTime");
        if (!descPacket) {
            this.inventory = Utils.readInventory(nbt.getTagList("inventory", 10), 4);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.setInteger("process", this.process);
        nbt.setInteger("processMax", this.processMax);
        nbt.setBoolean("active", this.active);
        nbt.setInteger("burnTime", this.burnTime);
        nbt.setInteger("lastBurnTime", this.lastBurnTime);
        if (!descPacket) {
            nbt.setTag("inventory", (NBTBase)Utils.writeInventory(this.inventory));
        }
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return slot == 0 || slot == 1 && TileEntityFurnace.isItemFuel((ItemStack)stack);
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public void doGraphicalUpdates(int slot) {
    }

    @Override
    protected IFluidTank[] getAccessibleFluidTanks(EnumFacing side) {
        return new FluidTank[0];
    }

    @Override
    protected boolean canFillTankFrom(int iTank, EnumFacing side, FluidStack resources) {
        return false;
    }

    @Override
    protected boolean canDrainTankFrom(int iTank, EnumFacing side) {
        return false;
    }

    @Override
    public BlockPos getOrigin() {
        return this.getPos().add(-this.offset[0], -this.offset[1], -this.offset[2]).offset(this.facing, -1).offset(this.facing.rotateYCCW());
    }
}

