/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.plant;

import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.BlockIEBase;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockIECrop<E extends Enum<E>>
extends BlockBush
implements IGrowable,
IEBlockInterfaces.IIEMetaBlock {
    protected static IProperty[] tempProperties;
    protected static BlockRenderLayer currentRenderLayer;
    public final String name;
    public final PropertyEnum<E> property;
    public final E[] enumValues;
    static final AxisAlignedBB box0;
    static final AxisAlignedBB box1;
    static final AxisAlignedBB box2;

    public BlockIECrop(String name, PropertyEnum<E> mainProperty) {
        super(BlockIECrop.setTempProperties(Material.PLANTS, mainProperty));
        this.name = name;
        this.property = mainProperty;
        this.enumValues = (Enum[])mainProperty.getValueClass().getEnumConstants();
        this.setDefaultState(this.getInitDefaultState());
        this.setUnlocalizedName("immersiveengineering." + name);
        this.setTickRandomly(true);
        this.setCreativeTab(null);
        this.setHardness(0.0f);
        this.setSoundType(SoundType.PLANT);
        this.disableStats();
        IEContent.registeredIEBlocks.add((Block)this);
        IEContent.registeredIEItems.add((Item)new ItemBlock((Block)this));
    }

    @Override
    public String getIEBlockName() {
        return this.name;
    }

    @Override
    public Enum[] getMetaEnums() {
        return this.enumValues;
    }

    @Override
    public IBlockState getInventoryState(int meta) {
        IBlockState state = this.blockState.getBaseState().withProperty(this.property, this.enumValues[meta]);
        return state;
    }

    @Override
    public IProperty getMetaProperty() {
        return this.property;
    }

    @Override
    public boolean useCustomStateMapper() {
        return false;
    }

    @Override
    public String getCustomStateMapping(int meta, boolean itemBlock) {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public StateMapperBase getCustomMapper() {
        return null;
    }

    @Override
    public boolean appendPropertiesToState() {
        return true;
    }

    protected static Material setTempProperties(Material material, PropertyEnum<?> property) {
        tempProperties = new IProperty[1];
        BlockIECrop.tempProperties[0] = property;
        return material;
    }

    protected BlockStateContainer createNotTempBlockState() {
        IProperty[] array = new IProperty[]{this.property};
        return new BlockStateContainer((Block)this, array);
    }

    protected IBlockState getInitDefaultState() {
        IBlockState state = this.blockState.getBaseState().withProperty(this.property, this.enumValues[0]);
        return state;
    }

    public void onIEBlockPlacedBy(World world, BlockPos pos, IBlockState state, EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase placer, ItemStack stack) {
    }

    protected BlockStateContainer createBlockState() {
        return this.property != null ? this.createNotTempBlockState() : new BlockStateContainer((Block)this, tempProperties);
    }

    public void onBlockPlacedBy(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.onBlockPlacedBy(worldIn, pos, state, placer, stack);
    }

    public int getMetaFromState(IBlockState state) {
        return ((BlockIEBase.IBlockEnum)((Object)((Enum)((Object)state.getValue(this.property))))).getMeta();
    }

    public IBlockState getActualState(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state;
    }

    public IBlockState getStateFromMeta(int meta) {
        IBlockState state = this.getDefaultState().withProperty(this.property, this.fromMeta(meta));
        return state;
    }

    protected E fromMeta(int meta) {
        if (meta < 0 || meta >= this.enumValues.length) {
            meta = 0;
        }
        return this.enumValues[meta];
    }

    public int getMinMeta(int meta) {
        return meta <= 4 ? 0 : 5;
    }

    public int getMaxMeta(int meta) {
        return meta <= 4 ? 4 : 5;
    }

    public boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        boolean b = super.canBlockStay(world, pos, state);
        if (this.getMetaFromState(state) == 5) {
            IBlockState stateBelow = world.getBlockState(pos.add(0, -1, 0));
            b = stateBelow.getBlock().equals(this) && this.getMetaFromState(stateBelow) == this.getMaxMeta(0);
        }
        return b;
    }

    protected boolean canSustainBush(IBlockState state) {
        return state.getBlock() == Blocks.FARMLAND;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Crop;
    }

    public AxisAlignedBB getSelectedBoundingBox(IBlockState state, World world, BlockPos pos) {
        int meta = this.getMetaFromState(world.getBlockState(pos));
        return meta == 0 ? box0 : (meta == 1 ? box1 : (meta == 2 ? box2 : FULL_BLOCK_AABB));
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        int meta = this.getMetaFromState(state);
        if (meta >= 4) {
            for (int i = 0; i < 3 + fortune; ++i) {
                if (Utils.RAND.nextInt(8) > meta) continue;
                drops.add((Object)new ItemStack((Item)IEContent.itemMaterial, 1, 4));
            }
            drops.add((Object)new ItemStack((Item)IEContent.itemSeeds, 1, 0));
        }
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos block) {
        super.onNeighborChange(world, pos, block);
        if (this.getMetaFromState(world.getBlockState(pos)) < this.getMaxMeta(0) && world instanceof World) {
            ((World)world).notifyNeighborsOfStateChange(pos.add(0, 1, 0), (Block)this, true);
        }
    }

    public void updateTick(World world, BlockPos pos, IBlockState state, Random random) {
        this.checkAndDropBlock(world, pos, state);
        int light = world.getLight(pos);
        if (light >= 12) {
            int meta = this.getMetaFromState(state);
            if (meta > 4) {
                return;
            }
            float growth = this.getGrowthSpeed(world, pos, state, light);
            if (random.nextInt((int)(50.0f / growth) + 1) == 0) {
                if (this.getMaxMeta(meta) != meta) {
                    world.setBlockState(pos, this.getStateFromMeta(++meta));
                }
                if (meta > 3 && world.isAirBlock(pos.add(0, 1, 0))) {
                    world.setBlockState(pos.add(0, 1, 0), this.getStateFromMeta(meta + 1));
                }
            }
        }
    }

    float getGrowthSpeed(World world, BlockPos pos, IBlockState sate, int light) {
        IBlockState soil;
        float growth = 0.125f * (float)(light - 11);
        if (world.canBlockSeeSky(pos)) {
            growth += 2.0f;
        }
        if ((soil = world.getBlockState(pos.add(0, -1, 0))).getBlock().isFertile(world, pos.add(0, -1, 0))) {
            growth *= 1.5f;
        }
        return 1.0f + growth;
    }

    public boolean canPlaceBlockAt(World worldIn, BlockPos pos) {
        IBlockState soil = worldIn.getBlockState(pos.down());
        return super.canPlaceBlockAt(worldIn, pos) && soil.getBlock().canSustainPlant(soil, (IBlockAccess)worldIn, pos.down(), EnumFacing.UP, (IPlantable)this);
    }

    public boolean canGrow(World world, BlockPos pos, IBlockState state, boolean isClient) {
        int meta = this.getMetaFromState(state);
        if (meta < this.getMaxMeta(meta)) {
            return true;
        }
        return meta == 4 && !world.getBlockState(pos.add(0, 1, 0)).getBlock().equals(this);
    }

    public boolean canUseBonemeal(World world, Random rand, BlockPos pos, IBlockState state) {
        int meta = this.getMetaFromState(state);
        if (meta < this.getMaxMeta(meta)) {
            return true;
        }
        return meta == 4 && !world.getBlockState(pos.add(0, 1, 0)).getBlock().equals(this);
    }

    public void grow(World world, Random rand, BlockPos pos, IBlockState state) {
        int meta = this.getMetaFromState(state);
        if (meta < this.getMaxMeta(meta)) {
            int span = this.getMaxMeta(meta) - meta;
            int newMeta = meta + rand.nextInt(span) + 1;
            if (newMeta != meta) {
                world.setBlockState(pos, this.getStateFromMeta(newMeta));
            }
            meta = newMeta;
        }
        if (meta == 4 && world.isAirBlock(pos.add(0, 1, 0))) {
            world.setBlockState(pos.add(0, 1, 0), this.getStateFromMeta(meta + 1));
        }
    }

    static {
        box0 = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0);
        box1 = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.625, 1.0);
        box2 = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.875, 1.0);
    }
}

