/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.MultiblockHandler;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.BlockTypes_MetalsAll;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalMultiblock;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntitySilo;
import blusunrize.immersiveengineering.common.blocks.wooden.BlockTypes_WoodenDecoration;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MultiblockSilo
implements MultiblockHandler.IMultiblock {
    public static MultiblockSilo instance = new MultiblockSilo();
    static ItemStack[][][] structure = new ItemStack[7][3][3];
    static ItemStack renderStack;
    static final IngredientStack[] materials;

    @Override
    public ItemStack[][][] getStructureManual() {
        return structure;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean overwriteBlockRender(ItemStack stack, int iterator) {
        return false;
    }

    @Override
    public float getManualScale() {
        return 10.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canRenderFormedStructure() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderFormedStructure() {
        if (renderStack.isEmpty()) {
            renderStack = new ItemStack((Block)IEContent.blockMetalMultiblock, 1, BlockTypes_MetalMultiblock.SILO.getMeta());
        }
        GlStateManager.translate((double)2.0, (double)2.5, (double)1.0);
        GlStateManager.rotate((float)-45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotate((float)-20.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.scale((float)8.0f, (float)8.0f, (float)8.0f);
        ClientUtils.mc().getRenderItem().renderItem(renderStack, ItemCameraTransforms.TransformType.GUI);
    }

    @Override
    public String getUniqueName() {
        return "IE:Silo";
    }

    @Override
    public boolean isBlockTrigger(IBlockState state) {
        return Utils.compareToOreName(new ItemStack(state.getBlock(), 1, state.getBlock().getMetaFromState(state)), "blockSheetmetalIron");
    }

    @Override
    public boolean createStructure(World world, BlockPos pos, EnumFacing side, EntityPlayer player) {
        EnumFacing f = EnumFacing.fromAngle((double)player.rotationYaw);
        if (!Utils.isOreBlockAt(world, (pos = pos.offset(f)).offset(f, -1).offset(f.rotateY()), "fenceTreatedWood") || !Utils.isOreBlockAt(world, pos.offset(f, -1).offset(f.rotateYCCW()), "fenceTreatedWood")) {
            for (int i = 0; i < 6; ++i) {
                if (!Utils.isOreBlockAt(world, pos.add(0, -i, 0).offset(f, -1).offset(f.rotateY()), "fenceTreatedWood") || !Utils.isOreBlockAt(world, pos.add(0, -i, 0).offset(f, -1).offset(f.rotateYCCW()), "fenceTreatedWood")) continue;
                pos = pos.add(0, -i, 0);
                break;
            }
        }
        for (int h = 0; h <= 6; ++h) {
            for (int xx = -1; xx <= 1; ++xx) {
                for (int zz = -1; zz <= 1; ++zz) {
                    if (!(h == 0 ? (Math.abs(xx) == 1 && Math.abs(zz) == 1 ? !Utils.isOreBlockAt(world, pos.add(xx, h, zz), "fenceTreatedWood") : xx == 0 && zz == 0 && !Utils.isOreBlockAt(world, pos.add(xx, h, zz), "blockSheetmetalIron")) : (h < 6 && xx == 0 && zz == 0 ? !world.isAirBlock(pos.add(xx, h, zz)) : !Utils.isOreBlockAt(world, pos.add(xx, h, zz), "blockSheetmetalIron")))) continue;
                    return false;
                }
            }
        }
        IBlockState state = IEContent.blockMetalMultiblock.getStateFromMeta(BlockTypes_MetalMultiblock.SILO.getMeta());
        state = state.withProperty((IProperty)IEProperties.FACING_HORIZONTAL, (Comparable)f.getOpposite());
        for (int h = 0; h <= 6; ++h) {
            for (int l = -1; l <= 1; ++l) {
                for (int w = -1; w <= 1; ++w) {
                    int xx;
                    if (h == 0 && (l != 0 || w != 0) && (Math.abs(l) != 1 || Math.abs(w) != 1) || h > 0 && h < 6 && l == 0 && w == 0) continue;
                    int n = f == EnumFacing.EAST ? l : (f == EnumFacing.WEST ? -l : (xx = f == EnumFacing.NORTH ? -w : w));
                    int zz = f == EnumFacing.NORTH ? l : (f == EnumFacing.SOUTH ? -l : (f == EnumFacing.EAST ? w : -w));
                    world.setBlockState(pos.add(xx, h, zz), state);
                    BlockPos pos2 = pos.add(xx, h, zz);
                    TileEntity curr = world.getTileEntity(pos2);
                    if (!(curr instanceof TileEntitySilo)) continue;
                    TileEntitySilo currTank = (TileEntitySilo)curr;
                    currTank.offset = new int[]{xx, h, zz};
                    currTank.pos = h * 9 + (l + 1) * 3 + (w + 1);
                    currTank.formed = true;
                    currTank.offset = new int[]{xx, h, zz};
                    currTank.markDirty();
                    world.addBlockEvent(pos2, (Block)IEContent.blockMetalMultiblock, 255, 0);
                }
            }
        }
        return true;
    }

    @Override
    public IngredientStack[] getTotalMaterials() {
        return materials;
    }

    static {
        for (int h = 0; h < 7; ++h) {
            for (int l = 0; l < 3; ++l) {
                for (int w = 0; w < 3; ++w) {
                    if (h == 0) {
                        if (!(l != 0 && l != 2 || w != 0 && w != 2)) {
                            MultiblockSilo.structure[h][l][w] = new ItemStack((Block)IEContent.blockWoodenDecoration, 1, BlockTypes_WoodenDecoration.FENCE.getMeta());
                            continue;
                        }
                        if (l != 1 || w != 1) continue;
                        MultiblockSilo.structure[h][l][w] = new ItemStack((Block)IEContent.blockSheetmetal, 1, BlockTypes_MetalsAll.IRON.getMeta());
                        continue;
                    }
                    if (h >= 1 && h <= 5 && w == 1 && l == 1) continue;
                    MultiblockSilo.structure[h][l][w] = new ItemStack((Block)IEContent.blockSheetmetal, 1, BlockTypes_MetalsAll.IRON.getMeta());
                }
            }
        }
        renderStack = ItemStack.EMPTY;
        materials = new IngredientStack[]{new IngredientStack("fenceTreatedWood", 4), new IngredientStack("blockSheetmetalIron", 50)};
    }
}

