/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.MultiblockHandler;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalDecoration0;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalDecoration1;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalMultiblock;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityConveyorBelt;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMetalPress;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MultiblockMetalPress
implements MultiblockHandler.IMultiblock {
    public static MultiblockMetalPress instance = new MultiblockMetalPress();
    static ItemStack[][][] structure = new ItemStack[3][3][1];
    static ItemStack renderStack;
    static final IngredientStack[] materials;

    @Override
    public ItemStack[][][] getStructureManual() {
        return structure;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean overwriteBlockRender(ItemStack stack, int iterator) {
        if (iterator == 3 || iterator == 5) {
            return ImmersiveEngineering.proxy.drawConveyorInGui("immersiveengineering:conveyor", EnumFacing.EAST);
        }
        return false;
    }

    @Override
    public float getManualScale() {
        return 13.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canRenderFormedStructure() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderFormedStructure() {
        if (renderStack.isEmpty()) {
            renderStack = new ItemStack((Block)IEContent.blockMetalMultiblock, 1, BlockTypes_MetalMultiblock.METAL_PRESS.getMeta());
        }
        GlStateManager.scale((float)4.0f, (float)4.0f, (float)4.0f);
        GlStateManager.translate((double)0.375, (double)0.375, (double)0.125);
        GlStateManager.rotate((float)-45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotate((float)-20.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        ClientUtils.mc().getRenderItem().renderItem(renderStack, ItemCameraTransforms.TransformType.GUI);
    }

    @Override
    public String getUniqueName() {
        return "IE:MetalPress";
    }

    @Override
    public boolean isBlockTrigger(IBlockState state) {
        return state.getBlock() == Blocks.PISTON && state.getBlock().getMetaFromState(state) == 0;
    }

    @Override
    public boolean createStructure(World world, BlockPos pos, EnumFacing side, EntityPlayer player) {
        EnumFacing dir;
        if (side == EnumFacing.UP || side == EnumFacing.DOWN) {
            side = EnumFacing.fromAngle((double)player.rotationYaw);
        }
        if (world.getTileEntity(pos.offset(dir = side.rotateY())) instanceof TileEntityConveyorBelt) {
            dir = ((TileEntityConveyorBelt)world.getTileEntity(pos.offset(dir))).getFacing();
        }
        for (int l = -1; l <= 1; ++l) {
            for (int h = -1; h <= 1; ++h) {
                if (h == 1 && l != 0) continue;
                BlockPos pos2 = pos.offset(dir, l).add(0, h, 0);
                if (!(h == -1 ? (l == 0 ? !Utils.isBlockAt(world, pos2, IEContent.blockMetalDecoration0, BlockTypes_MetalDecoration0.RS_ENGINEERING.getMeta()) : !Utils.isOreBlockAt(world, pos2, "scaffoldingSteel")) : (h == 0 ? (l == 0 ? !Utils.isBlockAt(world, pos2, (Block)Blocks.PISTON, 0) : !ConveyorHandler.isConveyor(world, pos2, "immersiveengineering:conveyor", dir)) : !Utils.isBlockAt(world, pos2, IEContent.blockMetalDecoration0, BlockTypes_MetalDecoration0.HEAVY_ENGINEERING.getMeta())))) continue;
                return false;
            }
        }
        IBlockState state = IEContent.blockMetalMultiblock.getStateFromMeta(BlockTypes_MetalMultiblock.METAL_PRESS.getMeta());
        state = state.withProperty((IProperty)IEProperties.FACING_HORIZONTAL, (Comparable)dir);
        for (int l = -1; l <= 1; ++l) {
            for (int h = -1; h <= 1; ++h) {
                if (h == 1 && l != 0) continue;
                BlockPos pos2 = pos.offset(dir, l).add(0, h, 0);
                world.setBlockState(pos2, state);
                TileEntity curr = world.getTileEntity(pos2);
                if (!(curr instanceof TileEntityMetalPress)) continue;
                TileEntityMetalPress tile = (TileEntityMetalPress)curr;
                tile.formed = true;
                tile.pos = (h + 1) * 3 + (l + 1);
                tile.offset = new int[]{dir == EnumFacing.WEST ? -l : (dir == EnumFacing.EAST ? l : 0), h, dir == EnumFacing.NORTH ? -l : (dir == EnumFacing.SOUTH ? l : 0)};
                tile.markDirty();
                world.addBlockEvent(pos2, (Block)IEContent.blockMetalMultiblock, 255, 0);
            }
        }
        return true;
    }

    @Override
    public IngredientStack[] getTotalMaterials() {
        return materials;
    }

    static {
        for (int h = 0; h < 3; ++h) {
            for (int l = 0; l < 3; ++l) {
                if (h == 0) {
                    if (l == 1) {
                        MultiblockMetalPress.structure[h][l][0] = new ItemStack((Block)IEContent.blockMetalDecoration0, 1, BlockTypes_MetalDecoration0.RS_ENGINEERING.getMeta());
                        continue;
                    }
                    MultiblockMetalPress.structure[h][l][0] = new ItemStack((Block)IEContent.blockMetalDecoration1, 1, BlockTypes_MetalDecoration1.STEEL_SCAFFOLDING_0.getMeta());
                    continue;
                }
                if (h == 1) {
                    if (l == 1) {
                        MultiblockMetalPress.structure[h][l][0] = new ItemStack((Block)Blocks.PISTON, 1, 0);
                        continue;
                    }
                    MultiblockMetalPress.structure[h][l][0] = ConveyorHandler.getConveyorStack("immersiveengineering:conveyor");
                    continue;
                }
                if (h != 2 || l != 1) continue;
                MultiblockMetalPress.structure[h][l][0] = new ItemStack((Block)IEContent.blockMetalDecoration0, 1, BlockTypes_MetalDecoration0.HEAVY_ENGINEERING.getMeta());
            }
        }
        renderStack = ItemStack.EMPTY;
        materials = new IngredientStack[]{new IngredientStack("scaffoldingSteel", 2), new IngredientStack(new ItemStack((Block)IEContent.blockMetalDecoration0, 1, BlockTypes_MetalDecoration0.RS_ENGINEERING.getMeta())), new IngredientStack(new ItemStack((Block)Blocks.PISTON)), new IngredientStack(Utils.copyStackWithAmount(ConveyorHandler.getConveyorStack("immersiveengineering:conveyor"), 2)), new IngredientStack(new ItemStack((Block)IEContent.blockMetalDecoration0, 1, BlockTypes_MetalDecoration0.HEAVY_ENGINEERING.getMeta()))};
    }
}

