/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.MultiblockHandler;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.BlockTypes_MetalsAll;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalDecoration0;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalDecoration1;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalDevice1;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalMultiblock;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityFermenter;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MultiblockFermenter
implements MultiblockHandler.IMultiblock {
    public static MultiblockFermenter instance = new MultiblockFermenter();
    static ItemStack[][][] structure = new ItemStack[3][3][3];
    static ItemStack renderStack;
    static final IngredientStack[] materials;

    @Override
    public ItemStack[][][] getStructureManual() {
        return structure;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean overwriteBlockRender(ItemStack stack, int iterator) {
        if (iterator == 4) {
            ImmersiveEngineering.proxy.drawSpecificFluidPipe("010010");
            return true;
        }
        if (iterator == 5) {
            ImmersiveEngineering.proxy.drawSpecificFluidPipe("000001");
            return true;
        }
        return false;
    }

    @Override
    public IBlockState getBlockstateFromStack(int index, ItemStack stack) {
        if (!stack.isEmpty()) {
            if (stack.getItem() == Items.CAULDRON) {
                return Blocks.CAULDRON.getDefaultState();
            }
            if (stack.getItem() instanceof ItemBlock) {
                return ((ItemBlock)stack.getItem()).getBlock().getStateFromMeta(stack.getItemDamage());
            }
        }
        return null;
    }

    @Override
    public float getManualScale() {
        return 13.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canRenderFormedStructure() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderFormedStructure() {
        if (renderStack.isEmpty()) {
            renderStack = new ItemStack((Block)IEContent.blockMetalMultiblock, 1, BlockTypes_MetalMultiblock.FERMENTER.getMeta());
        }
        GlStateManager.translate((double)1.5, (double)1.5, (double)1.5);
        GlStateManager.rotate((float)-45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotate((float)-20.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.scale((float)4.0f, (float)4.0f, (float)4.0f);
        GlStateManager.disableCull();
        ClientUtils.mc().getRenderItem().renderItem(renderStack, ItemCameraTransforms.TransformType.GUI);
        GlStateManager.enableCull();
    }

    @Override
    public String getUniqueName() {
        return "IE:Fermenter";
    }

    @Override
    public boolean isBlockTrigger(IBlockState state) {
        return state.getBlock() == Blocks.CAULDRON;
    }

    @Override
    public boolean createStructure(World world, BlockPos pos, EnumFacing side, EntityPlayer player) {
        boolean mirror;
        boolean b;
        if ((side = side.getOpposite()) == EnumFacing.UP || side == EnumFacing.DOWN) {
            side = EnumFacing.fromAngle((double)player.rotationYaw);
        }
        if (!(b = this.structureCheck(world, pos, side, mirror = false))) {
            mirror = true;
            b = this.structureCheck(world, pos, side, mirror);
        }
        if (!b) {
            return false;
        }
        IBlockState state = IEContent.blockMetalMultiblock.getStateFromMeta(BlockTypes_MetalMultiblock.FERMENTER.getMeta());
        state = state.withProperty((IProperty)IEProperties.FACING_HORIZONTAL, (Comparable)side);
        for (int h = -1; h <= 1; ++h) {
            for (int l = -1; l <= 1; ++l) {
                for (int w = -1; w <= 1; ++w) {
                    if (h == 0 && w == 0 && l == -1 || h == 0 && w == 1 && l > -1 || h == 1 && (l < 0 || w > 0)) continue;
                    int ww = mirror ? -w : w;
                    BlockPos pos2 = pos.offset(side, l).offset(side.rotateY(), ww).add(0, h, 0);
                    world.setBlockState(pos2, state);
                    TileEntity curr = world.getTileEntity(pos2);
                    if (!(curr instanceof TileEntityFermenter)) continue;
                    TileEntityFermenter tile = (TileEntityFermenter)curr;
                    tile.formed = true;
                    tile.pos = (h + 1) * 9 + (l + 1) * 3 + (w + 1);
                    tile.offset = new int[]{side == EnumFacing.WEST ? -l : (side == EnumFacing.EAST ? l : (side == EnumFacing.NORTH ? ww : -ww)), h, side == EnumFacing.NORTH ? -l : (side == EnumFacing.SOUTH ? l : (side == EnumFacing.EAST ? ww : -ww))};
                    tile.mirrored = mirror;
                    tile.markDirty();
                    world.addBlockEvent(pos2, (Block)IEContent.blockMetalMultiblock, 255, 0);
                }
            }
        }
        return true;
    }

    boolean structureCheck(World world, BlockPos startPos, EnumFacing dir, boolean mirror) {
        for (int h = -1; h <= 1; ++h) {
            for (int l = -1; l <= 1; ++l) {
                for (int w = -1; w <= 1; ++w) {
                    if (h == 0 && w == 0 && l == -1 || h == 0 && w == 1 && l > -1 || h == 1 && (l < 0 || w > 0)) continue;
                    int ww = mirror ? -w : w;
                    BlockPos pos = startPos.offset(dir, l).offset(dir.rotateY(), ww).add(0, h, 0);
                    if (!(h == -1 ? (l == -1 && w == -1 ? !Utils.isBlockAt(world, pos, IEContent.blockMetalDecoration0, BlockTypes_MetalDecoration0.LIGHT_ENGINEERING.getMeta()) : (l == 0 && w > -1 ? !Utils.isBlockAt(world, pos, IEContent.blockMetalDevice1, BlockTypes_MetalDevice1.FLUID_PIPE.getMeta()) : !Utils.isOreBlockAt(world, pos, "scaffoldingSteel"))) : (h == 0 ? (l == -1 && w == -1 ? !Utils.isBlockAt(world, pos, IEContent.blockMetalDecoration0, BlockTypes_MetalDecoration0.LIGHT_ENGINEERING.getMeta()) : (l == -1 && w == 1 ? !Utils.isBlockAt(world, pos, IEContent.blockMetalDecoration0, BlockTypes_MetalDecoration0.RS_ENGINEERING.getMeta()) : l > -1 && w < 1 && !Utils.isBlockAt(world, pos, (Block)Blocks.CAULDRON, 0))) : h == 1 && l > -1 && w < 1 && !Utils.isOreBlockAt(world, pos, "blockSheetmetalIron")))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public IngredientStack[] getTotalMaterials() {
        return materials;
    }

    static {
        for (int h = 0; h < 3; ++h) {
            for (int l = 0; l < 3; ++l) {
                for (int w = 0; w < 3; ++w) {
                    if (h == 0) {
                        if (l == 0 && w == 0) {
                            MultiblockFermenter.structure[h][l][w] = new ItemStack((Block)IEContent.blockMetalDecoration0, 1, BlockTypes_MetalDecoration0.LIGHT_ENGINEERING.getMeta());
                            continue;
                        }
                        if (l == 1 && w > 0) {
                            MultiblockFermenter.structure[h][l][w] = new ItemStack((Block)IEContent.blockMetalDevice1, 1, BlockTypes_MetalDevice1.FLUID_PIPE.getMeta());
                            continue;
                        }
                        MultiblockFermenter.structure[h][l][w] = new ItemStack((Block)IEContent.blockMetalDecoration1, 1, BlockTypes_MetalDecoration1.STEEL_SCAFFOLDING_0.getMeta());
                        continue;
                    }
                    if (h == 1) {
                        if (l == 0 && w == 0) {
                            MultiblockFermenter.structure[h][l][w] = new ItemStack((Block)IEContent.blockMetalDecoration0, 1, BlockTypes_MetalDecoration0.LIGHT_ENGINEERING.getMeta());
                            continue;
                        }
                        if (l == 0 && w == 2) {
                            MultiblockFermenter.structure[h][l][w] = new ItemStack((Block)IEContent.blockMetalDecoration0, 1, BlockTypes_MetalDecoration0.RS_ENGINEERING.getMeta());
                            continue;
                        }
                        if (l <= 0 || w >= 2) continue;
                        MultiblockFermenter.structure[h][l][w] = new ItemStack(Items.CAULDRON);
                        continue;
                    }
                    if (h != 2 || l <= 0 || w >= 2) continue;
                    MultiblockFermenter.structure[h][l][w] = new ItemStack((Block)IEContent.blockSheetmetal, 1, BlockTypes_MetalsAll.IRON.getMeta());
                }
            }
        }
        renderStack = ItemStack.EMPTY;
        materials = new IngredientStack[]{new IngredientStack("scaffoldingSteel", 6), new IngredientStack(new ItemStack((Block)IEContent.blockMetalDevice1, 2, BlockTypes_MetalDevice1.FLUID_PIPE.getMeta())), new IngredientStack(new ItemStack((Block)IEContent.blockMetalDecoration0, 1, BlockTypes_MetalDecoration0.RS_ENGINEERING.getMeta())), new IngredientStack(new ItemStack((Block)IEContent.blockMetalDecoration0, 2, BlockTypes_MetalDecoration0.LIGHT_ENGINEERING.getMeta())), new IngredientStack(new ItemStack(Items.CAULDRON, 4, 0)), new IngredientStack("blockSheetmetalIron", 4)};
    }
}

