/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.MultiblockHandler;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalDecoration0;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalDecoration1;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalMultiblock;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityAutoWorkbench;
import blusunrize.immersiveengineering.common.blocks.wooden.BlockTypes_TreatedWood;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MultiblockAutoWorkbench
implements MultiblockHandler.IMultiblock {
    public static MultiblockAutoWorkbench instance = new MultiblockAutoWorkbench();
    static ItemStack[][][] structure = new ItemStack[2][3][3];
    static ItemStack renderStack;
    static final IngredientStack[] materials;

    @Override
    public ItemStack[][][] getStructureManual() {
        return structure;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean overwriteBlockRender(ItemStack stack, int iterator) {
        if (iterator == 13 || iterator == 14 || iterator == 15) {
            return ImmersiveEngineering.proxy.drawConveyorInGui("immersiveengineering:conveyor", EnumFacing.SOUTH);
        }
        if (iterator == 16) {
            return ImmersiveEngineering.proxy.drawConveyorInGui("immersiveengineering:conveyor", EnumFacing.WEST);
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canRenderFormedStructure() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderFormedStructure() {
        if (renderStack.isEmpty()) {
            renderStack = new ItemStack((Block)IEContent.blockMetalMultiblock, 1, BlockTypes_MetalMultiblock.AUTO_WORKBENCH.getMeta());
        }
        GlStateManager.translate((double)1.5, (double)1.5, (double)1.5);
        GlStateManager.rotate((float)-45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotate((float)-20.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.scale((float)4.0f, (float)4.0f, (float)4.0f);
        GlStateManager.disableCull();
        ClientUtils.mc().getRenderItem().renderItem(renderStack, ItemCameraTransforms.TransformType.GUI);
        GlStateManager.enableCull();
    }

    @Override
    public float getManualScale() {
        return 15.0f;
    }

    @Override
    public String getUniqueName() {
        return "IE:AutoWorkbench";
    }

    @Override
    public boolean isBlockTrigger(IBlockState state) {
        return Utils.compareToOreName(new ItemStack(state.getBlock(), 1, state.getBlock().getMetaFromState(state)), "slabTreatedWood");
    }

    @Override
    public boolean createStructure(World world, BlockPos pos, EnumFacing side, EntityPlayer player) {
        boolean mirrored;
        boolean b = this.structureCheck(world, pos, side = side.getAxis() == EnumFacing.Axis.Y ? EnumFacing.fromAngle((double)player.rotationYaw) : side.getOpposite(), mirrored = false);
        if (!b) {
            mirrored = true;
            b = this.structureCheck(world, pos, side, mirrored);
        }
        if (!b) {
            return false;
        }
        IBlockState state = IEContent.blockMetalMultiblock.getStateFromMeta(BlockTypes_MetalMultiblock.AUTO_WORKBENCH.getMeta());
        state = state.withProperty((IProperty)IEProperties.FACING_HORIZONTAL, (Comparable)side);
        for (int l = 0; l < 3; ++l) {
            for (int w = -1; w <= 1; ++w) {
                for (int h = -1; h <= 0; ++h) {
                    int ww = mirrored ? -w : w;
                    BlockPos pos2 = pos.offset(side, l).offset(side.rotateY(), ww).add(0, h, 0);
                    world.setBlockState(pos2, state);
                    TileEntity curr = world.getTileEntity(pos2);
                    if (!(curr instanceof TileEntityAutoWorkbench)) continue;
                    TileEntityAutoWorkbench tile = (TileEntityAutoWorkbench)curr;
                    tile.formed = true;
                    tile.pos = (h + 1) * 9 + l * 3 + (w + 1);
                    tile.offset = new int[]{side == EnumFacing.WEST ? 1 - l : (side == EnumFacing.EAST ? l - 1 : (side == EnumFacing.NORTH ? ww : -ww)), h, side == EnumFacing.NORTH ? 1 - l : (side == EnumFacing.SOUTH ? l - 1 : (side == EnumFacing.EAST ? ww : -ww))};
                    tile.mirrored = mirrored;
                    tile.markDirty();
                    world.addBlockEvent(pos2, (Block)IEContent.blockMetalMultiblock, 255, 0);
                }
            }
        }
        return true;
    }

    boolean structureCheck(World world, BlockPos startPos, EnumFacing dir, boolean mirror) {
        for (int l = 0; l < 3; ++l) {
            for (int h = -1; h <= 0; ++h) {
                for (int w = -1; w <= 1; ++w) {
                    int ww = mirror ? -w : w;
                    BlockPos pos2 = startPos.offset(dir, l).offset(dir.rotateY(), ww).add(0, h, 0);
                    if (!(h == -1 ? (l == 0 && w == 0 ? !Utils.isBlockAt(world, pos2, IEContent.blockMetalDecoration0, BlockTypes_MetalDecoration0.RS_ENGINEERING.getMeta()) : (w == -1 && l < 2 ? !Utils.isBlockAt(world, pos2, IEContent.blockMetalDecoration0, BlockTypes_MetalDecoration0.LIGHT_ENGINEERING.getMeta()) : (w == 1 && l == 2 ? !Utils.isBlockAt(world, pos2, IEContent.blockMetalDecoration0, BlockTypes_MetalDecoration0.HEAVY_ENGINEERING.getMeta()) : !Utils.isOreBlockAt(world, pos2, "scaffoldingSteel")))) : h == 0 && (w == -1 && l < 2 ? !Utils.isBlockAt(world, pos2, IEContent.blockMetalDecoration0, BlockTypes_MetalDecoration0.LIGHT_ENGINEERING.getMeta()) : (w == 1 && l == 2 ? !Utils.isBlockAt(world, pos2, IEContent.blockMetalDecoration0, BlockTypes_MetalDecoration0.HEAVY_ENGINEERING.getMeta()) : (l == 0 ? !Utils.isOreBlockAt(world, pos2, "slabTreatedWood") : !ConveyorHandler.isConveyor(world, pos2, "immersiveengineering:conveyor", null)))))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public IngredientStack[] getTotalMaterials() {
        return materials;
    }

    static {
        for (int h = 0; h < 2; ++h) {
            for (int l = 0; l < 3; ++l) {
                for (int w = 0; w < 3; ++w) {
                    if (h == 0) {
                        if (l == 0 && w == 1) {
                            MultiblockAutoWorkbench.structure[h][l][w] = new ItemStack((Block)IEContent.blockMetalDecoration0, 1, BlockTypes_MetalDecoration0.RS_ENGINEERING.getMeta());
                            continue;
                        }
                        if (w == 0 && l < 2) {
                            MultiblockAutoWorkbench.structure[h][l][w] = new ItemStack((Block)IEContent.blockMetalDecoration0, 1, BlockTypes_MetalDecoration0.LIGHT_ENGINEERING.getMeta());
                            continue;
                        }
                        if (w == 2 && l == 2) {
                            MultiblockAutoWorkbench.structure[h][l][w] = new ItemStack((Block)IEContent.blockMetalDecoration0, 1, BlockTypes_MetalDecoration0.HEAVY_ENGINEERING.getMeta());
                            continue;
                        }
                        MultiblockAutoWorkbench.structure[h][l][w] = new ItemStack((Block)IEContent.blockMetalDecoration1, 1, BlockTypes_MetalDecoration1.STEEL_SCAFFOLDING_0.getMeta());
                        continue;
                    }
                    if (h != 1) continue;
                    MultiblockAutoWorkbench.structure[h][l][w] = w == 0 && l < 2 ? new ItemStack((Block)IEContent.blockMetalDecoration0, 1, BlockTypes_MetalDecoration0.LIGHT_ENGINEERING.getMeta()) : (w == 2 && l == 2 ? new ItemStack((Block)IEContent.blockMetalDecoration0, 1, BlockTypes_MetalDecoration0.HEAVY_ENGINEERING.getMeta()) : (l == 0 ? new ItemStack((Block)IEContent.blockTreatedWoodSlabs, 1, BlockTypes_TreatedWood.HORIZONTAL.getMeta()) : ConveyorHandler.getConveyorStack("immersiveengineering:conveyor")));
                }
            }
        }
        renderStack = ItemStack.EMPTY;
        materials = new IngredientStack[]{new IngredientStack("scaffoldingSteel", 5), new IngredientStack("slabTreatedWood", 2), new IngredientStack(new ItemStack((Block)IEContent.blockMetalDecoration0, 1, BlockTypes_MetalDecoration0.RS_ENGINEERING.getMeta())), new IngredientStack(new ItemStack((Block)IEContent.blockMetalDecoration0, 4, BlockTypes_MetalDecoration0.LIGHT_ENGINEERING.getMeta())), new IngredientStack(new ItemStack((Block)IEContent.blockMetalDecoration0, 2, BlockTypes_MetalDecoration0.HEAVY_ENGINEERING.getMeta())), new IngredientStack(Utils.copyStackWithAmount(ConveyorHandler.getConveyorStack("immersiveengineering:conveyor"), 4))};
    }
}

