/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal.conveyors;

import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.ModelConveyor;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.ConveyorBasic;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ConveyorVertical
extends ConveyorBasic {
    static final AxisAlignedBB[] verticalBounds = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.125), new AxisAlignedBB(0.0, 0.0, 0.875, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.125, 1.0, 1.0), new AxisAlignedBB(0.875, 0.0, 0.0, 1.0, 1.0, 1.0)};
    public static ResourceLocation texture_on = new ResourceLocation("immersiveengineering:blocks/conveyor_vertical");
    public static ResourceLocation texture_off = new ResourceLocation("immersiveengineering:blocks/conveyor_vertical_off");

    @Override
    public boolean renderWall(TileEntity tile, EnumFacing facing, int wall) {
        return true;
    }

    @Override
    public boolean changeConveyorDirection() {
        return false;
    }

    @Override
    public boolean setConveyorDirection(ConveyorHandler.ConveyorDirection dir) {
        return false;
    }

    @Override
    public String getModelCacheKey(TileEntity tile, EnumFacing facing) {
        String key = ConveyorHandler.reverseClassRegistry.get(this.getClass()).toString();
        key = key + "f" + facing.ordinal();
        key = key + "a" + (this.isActive(tile) ? 1 : 0);
        key = key + "b" + (this.renderBottomBelt(tile, facing) ? "1" + (this.renderBottomWall(tile, facing, 0) ? "1" : "0") + (this.renderBottomWall(tile, facing, 1) ? "1" : "0") : "000");
        key = key + "c" + this.getDyeColour();
        return key;
    }

    boolean renderBottomBelt(TileEntity tile, EnumFacing facing) {
        TileEntity te = tile.getWorld().getTileEntity(tile.getPos().add(0, -1, 0));
        if (te instanceof ConveyorHandler.IConveyorTile && ((ConveyorHandler.IConveyorTile)te).getConveyorSubtype() != null) {
            for (EnumFacing f : ((ConveyorHandler.IConveyorTile)te).getConveyorSubtype().sigTransportDirections(te, ((ConveyorHandler.IConveyorTile)te).getFacing())) {
                if (f != EnumFacing.UP) continue;
                return false;
            }
        }
        for (EnumFacing f : EnumFacing.HORIZONTALS) {
            if (f == facing || !this.isInwardConveyor(tile, f)) continue;
            return true;
        }
        return false;
    }

    protected boolean isInwardConveyor(TileEntity tile, EnumFacing f) {
        ConveyorHandler.IConveyorBelt sub;
        TileEntity te = tile.getWorld().getTileEntity(tile.getPos().offset(f));
        if (te instanceof ConveyorHandler.IConveyorTile && (sub = ((ConveyorHandler.IConveyorTile)te).getConveyorSubtype()) != null) {
            for (EnumFacing f2 : sub.sigTransportDirections(te, ((ConveyorHandler.IConveyorTile)te).getFacing())) {
                if (f != f2.getOpposite()) continue;
                return true;
            }
        }
        if ((te = tile.getWorld().getTileEntity(tile.getPos().add(0, -1, 0).offset(f))) instanceof ConveyorHandler.IConveyorTile && (sub = ((ConveyorHandler.IConveyorTile)te).getConveyorSubtype()) != null) {
            int b = 0;
            for (EnumFacing f2 : sub.sigTransportDirections(te, ((ConveyorHandler.IConveyorTile)te).getFacing())) {
                if (f == f2.getOpposite()) {
                    ++b;
                } else if (EnumFacing.UP == f2) {
                    ++b;
                }
                if (b != 2) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean renderBottomWall(TileEntity tile, EnumFacing facing, int wall) {
        return super.renderWall(tile, facing, wall);
    }

    @Override
    public EnumFacing[] sigTransportDirections(TileEntity conveyorTile, EnumFacing facing) {
        return new EnumFacing[]{EnumFacing.UP, facing};
    }

    @Override
    public Vec3d getDirection(TileEntity conveyorTile, Entity entity, EnumFacing facing) {
        BlockPos posWall = conveyorTile.getPos().offset(facing);
        double d = 0.625 + (double)entity.width;
        double distToWall = Math.abs((double)(facing.getAxis() == EnumFacing.Axis.Z ? posWall.getZ() : posWall.getX()) + 0.5 - (facing.getAxis() == EnumFacing.Axis.Z ? entity.posZ : entity.posX));
        if (distToWall > d) {
            return super.getDirection(conveyorTile, entity, facing);
        }
        double vBase = entity instanceof EntityLivingBase ? 1.5 : 1.15;
        double distY = Math.abs((double)conveyorTile.getPos().add(0, 1, 0).getY() + 0.5 - entity.posY);
        double treshold = 0.9;
        boolean contact = distY < treshold;
        double vX = entity.motionX;
        double vY = 0.1 * vBase;
        double vZ = entity.motionZ;
        if (entity.motionY < 0.0) {
            vY += entity.motionY * 0.9;
        }
        if (!(entity instanceof EntityPlayer)) {
            vX = 0.05 * (double)facing.getFrontOffsetX();
            vZ = 0.05 * (double)facing.getFrontOffsetZ();
            if (facing == EnumFacing.WEST || facing == EnumFacing.EAST) {
                if (entity.posZ > (double)conveyorTile.getPos().getZ() + 0.65) {
                    vZ = -0.1 * vBase;
                } else if (entity.posZ < (double)conveyorTile.getPos().getZ() + 0.35) {
                    vZ = 0.1 * vBase;
                }
            } else if (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH) {
                if (entity.posX > (double)conveyorTile.getPos().getX() + 0.65) {
                    vX = -0.1 * vBase;
                } else if (entity.posX < (double)conveyorTile.getPos().getX() + 0.35) {
                    vX = 0.1 * vBase;
                }
            }
        }
        BlockPos upForward = conveyorTile.getPos().add(0, 1, 0);
        if (contact && !(Utils.getExistingTileEntity(conveyorTile.getWorld(), upForward) instanceof ConveyorHandler.IConveyorTile)) {
            vY *= 2.25;
        }
        return new Vec3d(vX, vY, vZ);
    }

    @Override
    public void onEntityCollision(TileEntity tile, Entity entity, EnumFacing facing) {
        if (!this.isActive(tile)) {
            return;
        }
        BlockPos posWall = tile.getPos().offset(facing);
        double d = 0.625 + (double)entity.width;
        double distToWall = Math.abs((double)(facing.getAxis() == EnumFacing.Axis.Z ? posWall.getZ() : posWall.getX()) + 0.5 - (facing.getAxis() == EnumFacing.Axis.Z ? entity.posZ : entity.posX));
        if (distToWall > d) {
            super.onEntityCollision(tile, entity, facing);
            return;
        }
        if (!(entity == null || entity.isDead || entity instanceof EntityPlayer && entity.isSneaking())) {
            double treshold;
            double distY = Math.abs((double)tile.getPos().add(0, 1, 0).getY() + 0.5 - entity.posY);
            boolean contact = distY < (treshold = 0.9);
            entity.onGround = false;
            entity.fallDistance = entity.fallDistance < 3.0f ? 0.0f : (float)((double)entity.fallDistance * 0.9);
            Vec3d vec = this.getDirection(tile, entity, facing);
            entity.motionX = vec.x;
            entity.motionY = vec.y;
            entity.motionZ = vec.z;
            if (!contact) {
                ConveyorHandler.applyMagnetSupression(entity, (ConveyorHandler.IConveyorTile)tile);
            } else {
                BlockPos posTop = tile.getPos().add(0, 1, 0);
                if (!(tile.getWorld().getTileEntity(posTop) instanceof ConveyorHandler.IConveyorTile || tile.getWorld().isAirBlock(posTop) && tile.getWorld().getTileEntity(posTop.offset(facing)) instanceof ConveyorHandler.IConveyorTile)) {
                    ConveyorHandler.revertMagnetSupression(entity, (ConveyorHandler.IConveyorTile)tile);
                }
            }
            if (entity instanceof EntityItem) {
                ItemStack stack;
                ((EntityItem)entity).setNoDespawn();
                TileEntity inventoryTile = tile.getWorld().getTileEntity(tile.getPos().add(0, 1, 0));
                if (!tile.getWorld().isRemote && contact && inventoryTile != null && !(inventoryTile instanceof ConveyorHandler.IConveyorTile) && !(stack = ((EntityItem)entity).getItem()).isEmpty()) {
                    ItemStack ret = Utils.insertStackIntoInventory(inventoryTile, stack, EnumFacing.DOWN);
                    if (ret.isEmpty()) {
                        entity.setDead();
                    } else if (ret.getCount() < stack.getCount()) {
                        ((EntityItem)entity).setItem(ret);
                    }
                }
            }
        }
    }

    @Override
    public List<AxisAlignedBB> getSelectionBoxes(TileEntity tile, EnumFacing facing) {
        ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
        if (facing.ordinal() > 1) {
            list.add(verticalBounds[facing.ordinal() - 2]);
        }
        if (this.renderBottomBelt(tile, facing) || list.isEmpty()) {
            list.add(conveyorBounds);
        }
        return list;
    }

    @Override
    public List<AxisAlignedBB> getColisionBoxes(TileEntity tile, EnumFacing facing) {
        ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
        if (facing.ordinal() > 1) {
            list.add(verticalBounds[facing.ordinal() - 2]);
        }
        if (this.renderBottomBelt(tile, facing) || list.isEmpty()) {
            list.add(conveyorBounds);
        }
        return list;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Matrix4f modifyBaseRotationMatrix(Matrix4f matrix, TileEntity tile, EnumFacing facing) {
        return new Matrix4(matrix).translate(0.0, 1.0, 0.0).rotate(1.5707963267948966, 1.0, 0.0, 0.0).toMatrix4f();
    }

    @Override
    public ResourceLocation getActiveTexture() {
        return texture_on;
    }

    @Override
    public ResourceLocation getInactiveTexture() {
        return texture_off;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<BakedQuad> modifyQuads(List<BakedQuad> baseModel, @Nullable TileEntity tile, EnumFacing facing) {
        if (tile != null && this.renderBottomBelt(tile, facing)) {
            TextureAtlasSprite sprite = ClientUtils.getSprite(this.isActive(tile) ? ConveyorBasic.texture_on : ConveyorBasic.texture_off);
            TextureAtlasSprite spriteColour = ClientUtils.getSprite(this.getColouredStripesTexture());
            boolean[] walls = new boolean[]{this.renderBottomWall(tile, facing, 0), this.renderBottomWall(tile, facing, 1)};
            baseModel.addAll(ModelConveyor.getBaseConveyor(facing, 0.875f, new Matrix4(facing), ConveyorHandler.ConveyorDirection.HORIZONTAL, sprite, walls, new boolean[]{true, false}, spriteColour, this.getDyeColour()));
        }
        return baseModel;
    }
}

