/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal.conveyors;

import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.ModelConveyor;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.ConveyorBasic;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Vector3f;

public class ConveyorSplit
extends ConveyorBasic {
    EnumFacing outputFace = EnumFacing.NORTH;
    public static ResourceLocation texture_on = new ResourceLocation("immersiveengineering:blocks/conveyor_split");
    public static ResourceLocation texture_off = new ResourceLocation("immersiveengineering:blocks/conveyor_split_off");
    public static ResourceLocation texture_casing = new ResourceLocation("immersiveengineering:blocks/conveyor_split_wall");

    public ConveyorSplit(EnumFacing startingOutputFace) {
        this.outputFace = startingOutputFace.rotateY();
    }

    @Override
    public ConveyorHandler.ConveyorDirection getConveyorDirection() {
        return ConveyorHandler.ConveyorDirection.HORIZONTAL;
    }

    @Override
    public boolean changeConveyorDirection() {
        return false;
    }

    @Override
    public boolean setConveyorDirection(ConveyorHandler.ConveyorDirection dir) {
        return false;
    }

    @Override
    public void afterRotation(EnumFacing oldDir, EnumFacing newDir) {
        this.outputFace = newDir.rotateY();
    }

    @Override
    public void handleInsertion(TileEntity tile, EntityItem entity, EnumFacing facing, ConveyorHandler.ConveyorDirection conDir, double distX, double distZ) {
        String nbtKey = "immersiveengineering:conveyorDir" + Integer.toHexString(tile.getPos().hashCode());
        if (entity.getEntityData().hasKey(nbtKey)) {
            EnumFacing redirect = EnumFacing.values()[entity.getEntityData().getInteger(nbtKey)];
            BlockPos nextPos = tile.getPos().offset(redirect);
            double distNext = Math.abs((double)(redirect.getAxis() == EnumFacing.Axis.Z ? nextPos.getZ() : nextPos.getX()) + 0.5 - (redirect.getAxis() == EnumFacing.Axis.Z ? entity.posZ : entity.posX));
            if (distNext < 0.7) {
                super.handleInsertion(tile, entity, redirect, conDir, distX, distZ);
            }
        }
    }

    @Override
    public void onEntityCollision(TileEntity tile, Entity entity, EnumFacing facing) {
        BlockPos nextPos;
        String nbtKey;
        if (!this.isActive(tile)) {
            return;
        }
        EnumFacing redirect = null;
        if (entity != null && !entity.isDead) {
            nbtKey = "immersiveengineering:conveyorDir" + Integer.toHexString(tile.getPos().hashCode());
            if (entity.getEntityData().hasKey(nbtKey)) {
                redirect = EnumFacing.values()[entity.getEntityData().getInteger(nbtKey)];
            } else {
                redirect = this.outputFace;
                entity.getEntityData().setInteger(nbtKey, redirect.ordinal());
                nextPos = tile.getPos().offset(this.outputFace.getOpposite());
                if (tile.getWorld().isBlockLoaded(nextPos)) {
                    TileEntity nextTile = tile.getWorld().getTileEntity(nextPos);
                    if (!(nextTile instanceof ConveyorHandler.IConveyorTile)) {
                        this.outputFace = this.outputFace.getOpposite();
                    } else if (((ConveyorHandler.IConveyorTile)nextTile).getFacing() != this.outputFace) {
                        this.outputFace = this.outputFace.getOpposite();
                    }
                }
            }
        }
        super.onEntityCollision(tile, entity, facing);
        if (redirect != null) {
            boolean contact;
            nbtKey = "immersiveengineering:conveyorDir" + Integer.toHexString(tile.getPos().hashCode());
            nextPos = tile.getPos().offset(redirect);
            double distNext = Math.abs((double)(redirect.getAxis() == EnumFacing.Axis.Z ? nextPos.getZ() : nextPos.getX()) + 0.5 - (redirect.getAxis() == EnumFacing.Axis.Z ? entity.posZ : entity.posX));
            double treshold = 0.4;
            boolean bl = contact = distNext < treshold;
            if (contact) {
                entity.getEntityData().removeTag(nbtKey);
            }
        }
    }

    @Override
    public boolean renderWall(TileEntity tile, EnumFacing facing, int wall) {
        return false;
    }

    @Override
    public EnumFacing[] sigTransportDirections(TileEntity conveyorTile, EnumFacing facing) {
        return new EnumFacing[]{facing.rotateY(), facing.rotateYCCW()};
    }

    @Override
    public Vec3d getDirection(TileEntity conveyorTile, Entity entity, EnumFacing facing) {
        Vec3d vec = super.getDirection(conveyorTile, entity, facing);
        String nbtKey = "immersiveengineering:conveyorDir" + Integer.toHexString(conveyorTile.getPos().hashCode());
        if (!entity.getEntityData().hasKey(nbtKey)) {
            return vec;
        }
        EnumFacing redirect = EnumFacing.getFront((int)entity.getEntityData().getInteger(nbtKey));
        BlockPos wallPos = conveyorTile.getPos().offset(facing);
        double distNext = Math.abs((double)(facing.getAxis() == EnumFacing.Axis.Z ? wallPos.getZ() : wallPos.getX()) + 0.5 - (facing.getAxis() == EnumFacing.Axis.Z ? entity.posZ : entity.posX));
        if (distNext < 1.33) {
            double sideMove = Math.pow(1.0 + distNext, 0.1) * 0.2;
            if (distNext < 0.8) {
                vec = new Vec3d(facing.getAxis() == EnumFacing.Axis.X ? 0.0 : vec.x, vec.y, facing.getAxis() == EnumFacing.Axis.Z ? 0.0 : vec.z);
            }
            vec = vec.addVector((double)redirect.getFrontOffsetX() * sideMove, 0.0, (double)redirect.getFrontOffsetZ() * sideMove);
        }
        return vec;
    }

    @Override
    public NBTTagCompound writeConveyorNBT() {
        NBTTagCompound nbt = super.writeConveyorNBT();
        nbt.setInteger("outputFace", this.outputFace.ordinal());
        return nbt;
    }

    @Override
    public void readConveyorNBT(NBTTagCompound nbt) {
        super.readConveyorNBT(nbt);
        this.outputFace = EnumFacing.values()[nbt.getInteger("outputFace")];
    }

    @Override
    public ResourceLocation getActiveTexture() {
        return texture_on;
    }

    @Override
    public ResourceLocation getInactiveTexture() {
        return texture_off;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<BakedQuad> modifyQuads(List<BakedQuad> baseModel, @Nullable TileEntity tile, EnumFacing facing) {
        TextureAtlasSprite tex_casing0 = ClientUtils.getSprite(texture_casing);
        Matrix4 matrix = new Matrix4(facing);
        float[] colour = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        Vector3f[] vertices = new Vector3f[]{new Vector3f(0.0625f, 0.1875f, 0.0f), new Vector3f(0.0625f, 0.1875f, 1.0f), new Vector3f(0.9375f, 0.1875f, 1.0f), new Vector3f(0.9375f, 0.1875f, 0.0f)};
        baseModel.add(ClientUtils.createBakedQuad(DefaultVertexFormats.ITEM, ClientUtils.applyMatrixToVertices(matrix, vertices), EnumFacing.UP, tex_casing0, new double[]{1.0, 16.0, 15.0, 0.0}, colour, false));
        vertices = new Vector3f[]{new Vector3f(0.0625f, 0.0f, 0.0f), new Vector3f(0.0625f, 0.1875f, 0.0f), new Vector3f(0.9375f, 0.1875f, 0.0f), new Vector3f(0.9375f, 0.0f, 0.0f)};
        baseModel.set(15, ClientUtils.createBakedQuad(DefaultVertexFormats.ITEM, ClientUtils.applyMatrixToVertices(matrix, vertices), facing, ClientUtils.getSprite(ModelConveyor.rl_casing[1]), new double[]{1.0, 16.0, 15.0, 13.0}, colour, false));
        vertices = new Vector3f[]{new Vector3f(0.0625f, 0.125f, 0.0f), new Vector3f(0.0625f, 0.1875f, 0.0f), new Vector3f(0.9375f, 0.1875f, 0.0f), new Vector3f(0.9375f, 0.125f, 0.0f)};
        Vector3f[] vertices2 = new Vector3f[]{new Vector3f(0.5f, 0.125f, 0.0f), new Vector3f(0.5f, 0.125f, 0.5f), new Vector3f(0.5f, 0.1875f, 0.5f), new Vector3f(0.5f, 0.1875f, 0.0f)};
        Vector3f[] vertices3 = new Vector3f[]{new Vector3f(0.5f, 0.125f, 0.0f), new Vector3f(0.5f, 0.125f, 0.5f), new Vector3f(0.5f, 0.1875f, 0.5f), new Vector3f(0.5f, 0.1875f, 0.0f)};
        for (int i = 0; i < 8; ++i) {
            for (int iv = 0; iv < vertices.length; ++iv) {
                vertices[iv].setZ((float)(i + 1) * 0.0625f);
                vertices2[iv].setX(vertices2[iv].getX() + 0.0625f);
                vertices3[iv].setX(vertices3[iv].getX() - 0.0625f);
            }
            double v = 16 - i;
            baseModel.add(ClientUtils.createBakedQuad(DefaultVertexFormats.ITEM, ClientUtils.applyMatrixToVertices(matrix, vertices), facing, tex_casing0, new double[]{1.0, v - 1.0, 15.0, v}, colour, true));
            if (i >= 7) continue;
            double u = 8 - i;
            baseModel.add(ClientUtils.createBakedQuad(DefaultVertexFormats.ITEM, ClientUtils.applyMatrixToVertices(matrix, vertices2), facing, tex_casing0, new double[]{u - 1.0, 16.0, u, 8.0}, colour, true));
            baseModel.add(ClientUtils.createBakedQuad(DefaultVertexFormats.ITEM, ClientUtils.applyMatrixToVertices(matrix, vertices3), facing, tex_casing0, new double[]{u - 1.0, 16.0, u, 8.0}, colour, false));
        }
        return baseModel;
    }
}

