/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal.conveyors;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.ConveyorBasic;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ConveyorDrop
extends ConveyorBasic {
    public static ResourceLocation texture_on = new ResourceLocation("immersiveengineering:blocks/conveyor_dropper");
    public static ResourceLocation texture_off = new ResourceLocation("immersiveengineering:blocks/conveyor_dropper_off");

    @Override
    public void handleInsertion(TileEntity tile, EntityItem entity, EnumFacing facing, ConveyorHandler.ConveyorDirection conDir, double distX, double distZ) {
        boolean contact;
        BlockPos posDown = tile.getPos().down();
        TileEntity inventoryTile = tile.getWorld().getTileEntity(posDown);
        boolean bl = contact = Math.abs(facing.getAxis() == EnumFacing.Axis.Z ? (double)tile.getPos().getZ() + 0.5 - entity.posZ : (double)tile.getPos().getX() + 0.5 - entity.posX) < 0.2;
        if (contact && inventoryTile != null && !(inventoryTile instanceof ConveyorHandler.IConveyorTile)) {
            ItemStack stack;
            if (!tile.getWorld().isRemote && !(stack = entity.getItem()).isEmpty()) {
                ItemStack ret = ApiUtils.insertStackIntoInventory(inventoryTile, stack, EnumFacing.UP);
                if (ret.isEmpty()) {
                    entity.setDead();
                } else if (ret.getCount() < stack.getCount()) {
                    entity.setItem(ret);
                }
            }
        } else if (contact && this.isEmptySpace(tile.getWorld(), posDown, inventoryTile)) {
            entity.motionX = 0.0;
            entity.motionZ = 0.0;
            entity.setPosition((double)tile.getPos().getX() + 0.5, (double)tile.getPos().getY() - 0.5, (double)tile.getPos().getZ() + 0.5);
            if (!(inventoryTile instanceof ConveyorHandler.IConveyorTile)) {
                ConveyorHandler.revertMagnetSupression((Entity)entity, (ConveyorHandler.IConveyorTile)tile);
            }
        } else {
            super.handleInsertion(tile, entity, facing, conDir, distX, distZ);
        }
    }

    boolean isEmptySpace(World world, BlockPos pos, TileEntity tile) {
        if (world.isAirBlock(pos)) {
            return true;
        }
        if (tile instanceof ConveyorHandler.IConveyorTile) {
            return true;
        }
        IBlockState state = world.getBlockState(pos);
        if (state.getBlock() instanceof BlockTrapDoor) {
            return (Boolean)state.getValue((IProperty)BlockTrapDoor.OPEN);
        }
        return false;
    }

    @Override
    public ResourceLocation getActiveTexture() {
        return texture_on;
    }

    @Override
    public ResourceLocation getInactiveTexture() {
        return texture_off;
    }
}

