/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal.conveyors;

import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalDecoration1;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.ConveyorBasic;
import blusunrize.immersiveengineering.common.blocks.wooden.BlockTypes_WoodenDecoration;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.util.vector.Vector3f;

public class ConveyorCovered
extends ConveyorBasic {
    public static ArrayList<Function<ItemStack, Boolean>> validCoveyorCovers = new ArrayList();
    public ItemStack cover = ItemStack.EMPTY;
    static final ItemStack defaultCover;
    static final AxisAlignedBB topBox;

    @Override
    public void onEntityCollision(TileEntity tile, Entity entity, EnumFacing facing) {
        super.onEntityCollision(tile, entity, facing);
        if (entity instanceof EntityItem) {
            ((EntityItem)entity).setPickupDelay(10);
        }
    }

    @Override
    public void onItemDeployed(TileEntity tile, EntityItem entity, EnumFacing facing) {
        entity.setPickupDelay(10);
    }

    @Override
    public String getModelCacheKey(TileEntity tile, EnumFacing facing) {
        String key = super.getModelCacheKey(tile, facing);
        if (!this.cover.isEmpty()) {
            key = key + "s" + this.cover.getItem().getRegistryName() + this.cover.getMetadata();
        }
        return key;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<BakedQuad> modifyQuads(List<BakedQuad> baseModel, @Nullable TileEntity tile, EnumFacing facing) {
        ItemStack cover = !this.cover.isEmpty() ? this.cover : defaultCover;
        Block b = Block.getBlockFromItem((Item)cover.getItem());
        IBlockState state = !cover.isEmpty() ? b.getStateFromMeta(cover.getMetadata()) : Blocks.STONE.getDefaultState();
        IBakedModel model = Minecraft.getMinecraft().getBlockRendererDispatcher().getBlockModelShapes().getModelForState(state);
        if (model != null) {
            TextureAtlasSprite sprite = model.getParticleTexture();
            HashMap<EnumFacing, TextureAtlasSprite> sprites = new HashMap<EnumFacing, TextureAtlasSprite>();
            ConveyorHandler.ConveyorDirection conDir = this.getConveyorDirection();
            for (EnumFacing f2 : EnumFacing.VALUES) {
                for (BakedQuad q : model.getQuads(state, f2, 0L)) {
                    if (q == null || q.getSprite() == null) continue;
                    sprites.put(f2, q.getSprite());
                }
            }
            for (BakedQuad q : model.getQuads(state, null, 0L)) {
                if (q == null || q.getSprite() == null || q.getFace() == null) continue;
                sprites.put(q.getFace(), q.getSprite());
            }
            java.util.function.Function<EnumFacing, TextureAtlasSprite> getSprite = f -> sprites.containsKey(f) ? (TextureAtlasSprite)sprites.get(f) : sprite;
            java.util.function.Function<EnumFacing, TextureAtlasSprite> getSpriteHorizontal = f -> f.getAxis() == EnumFacing.Axis.Y ? null : (sprites.containsKey(f) ? (TextureAtlasSprite)sprites.get(f) : sprite);
            float[] colour = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
            Matrix4 matrix = new Matrix4(facing);
            boolean wallLeft = tile == null || this.renderWall(tile, facing, 0);
            boolean wallRight = tile == null || this.renderWall(tile, facing, 1);
            java.util.function.Function<Vector3f[], Vector3f[]> vertexTransformer = conDir == ConveyorHandler.ConveyorDirection.HORIZONTAL ? vertices -> vertices : vertices -> {
                Vector3f[] ret = new Vector3f[((Vector3f[])vertices).length];
                for (int i = 0; i < ret.length; ++i) {
                    ret[i] = new Vector3f(vertices[i].x, vertices[i].y + (float)(vertices[i].z == (float)(conDir != ConveyorHandler.ConveyorDirection.UP ? 1 : 0) ? 1 : 0), vertices[i].z);
                }
                return ret;
            };
            baseModel.addAll(ClientUtils.createBakedBox(new Vector3f(0.0f, 0.75f, 0.0f), new Vector3f(1.0f, 1.0f, 1.0f), matrix, facing, vertexTransformer, getSprite, colour));
            if (wallLeft) {
                baseModel.addAll(ClientUtils.createBakedBox(new Vector3f(0.0f, 0.1875f, 0.0f), new Vector3f(0.0625f, 0.75f, 1.0f), matrix, facing, vertexTransformer, getSpriteHorizontal, colour));
            } else {
                baseModel.addAll(ClientUtils.createBakedBox(new Vector3f(0.0f, 0.1875f, 0.0f), new Vector3f(0.0625f, 0.75f, 0.0625f), matrix, facing, getSpriteHorizontal, colour));
                baseModel.addAll(ClientUtils.createBakedBox(new Vector3f(0.0f, 0.1875f, 0.9375f), new Vector3f(0.0625f, 0.75f, 1.0f), matrix, facing, getSpriteHorizontal, colour));
            }
            if (wallRight) {
                baseModel.addAll(ClientUtils.createBakedBox(new Vector3f(0.9375f, 0.1875f, 0.0f), new Vector3f(1.0f, 0.75f, 1.0f), matrix, facing, vertexTransformer, getSpriteHorizontal, colour));
            } else {
                baseModel.addAll(ClientUtils.createBakedBox(new Vector3f(0.9375f, 0.1875f, 0.0f), new Vector3f(1.0f, 0.75f, 0.0625f), matrix, facing, getSpriteHorizontal, colour));
                baseModel.addAll(ClientUtils.createBakedBox(new Vector3f(0.9375f, 0.1875f, 0.9375f), new Vector3f(1.0f, 0.75f, 1.0f), matrix, facing, getSpriteHorizontal, colour));
            }
        }
        return baseModel;
    }

    @Override
    public boolean playerInteraction(TileEntity tile, EntityPlayer player, EnumHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ, EnumFacing side) {
        if (heldItem.isEmpty() && player.isSneaking() && !this.cover.isEmpty()) {
            EntityItem entityitem;
            if (!tile.getWorld().isRemote && tile.getWorld().getGameRules().getBoolean("doTileDrops") && (entityitem = player.dropItem(this.cover.copy(), false)) != null) {
                entityitem.setNoPickupDelay();
            }
            this.cover = ItemStack.EMPTY;
            return true;
        }
        if (!heldItem.isEmpty() && !player.isSneaking()) {
            for (Function<ItemStack, Boolean> func : validCoveyorCovers) {
                EntityItem entityitem;
                if (func.apply((Object)heldItem) != Boolean.TRUE || OreDictionary.itemMatches((ItemStack)this.cover, (ItemStack)heldItem, (boolean)true)) continue;
                if (!tile.getWorld().isRemote && !this.cover.isEmpty() && tile.getWorld().getGameRules().getBoolean("doTileDrops") && (entityitem = player.dropItem(this.cover.copy(), false)) != null) {
                    entityitem.setNoPickupDelay();
                }
                this.cover = Utils.copyStackWithAmount(heldItem, 1);
                heldItem.shrink(1);
                if (heldItem.getCount() <= 0) {
                    player.setHeldItem(hand, heldItem);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public List<AxisAlignedBB> getColisionBoxes(TileEntity tile, EnumFacing facing) {
        ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{conveyorBounds});
        if (this.getConveyorDirection() == ConveyorHandler.ConveyorDirection.HORIZONTAL) {
            list.add(topBox);
        } else {
            boolean up = this.getConveyorDirection() == ConveyorHandler.ConveyorDirection.UP;
            list.add(new AxisAlignedBB(facing == EnumFacing.WEST && !up || facing == EnumFacing.EAST && up ? 0.5 : 0.0, 1.75, facing == EnumFacing.NORTH && !up || facing == EnumFacing.SOUTH && up ? 0.5 : 0.0, facing == EnumFacing.WEST && up || facing == EnumFacing.EAST && !up ? 0.5 : 1.0, 2.0, facing == EnumFacing.NORTH && up || facing == EnumFacing.SOUTH && !up ? 0.5 : 1.0));
            list.add(new AxisAlignedBB(facing == EnumFacing.WEST && up || facing == EnumFacing.EAST && !up ? 0.5 : 0.0, 1.25, facing == EnumFacing.NORTH && up || facing == EnumFacing.SOUTH && !up ? 0.5 : 0.0, facing == EnumFacing.WEST && !up || facing == EnumFacing.EAST && up ? 0.5 : 1.0, 1.5, facing == EnumFacing.NORTH && !up || facing == EnumFacing.SOUTH && up ? 0.5 : 1.0));
        }
        return list;
    }

    @Override
    public List<AxisAlignedBB> getSelectionBoxes(TileEntity tile, EnumFacing facing) {
        if (this.getConveyorDirection() == ConveyorHandler.ConveyorDirection.HORIZONTAL) {
            return Lists.newArrayList((Object[])new AxisAlignedBB[]{Block.FULL_BLOCK_AABB});
        }
        boolean up = this.getConveyorDirection() == ConveyorHandler.ConveyorDirection.UP;
        ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(facing == EnumFacing.WEST && !up || facing == EnumFacing.EAST && up ? 0.5 : 0.0, 0.5, facing == EnumFacing.NORTH && !up || facing == EnumFacing.SOUTH && up ? 0.5 : 0.0, facing == EnumFacing.WEST && up || facing == EnumFacing.EAST && !up ? 0.5 : 1.0, 2.0, facing == EnumFacing.NORTH && up || facing == EnumFacing.SOUTH && !up ? 0.5 : 1.0), new AxisAlignedBB(facing == EnumFacing.WEST && up || facing == EnumFacing.EAST && !up ? 0.5 : 0.0, 0.0, facing == EnumFacing.NORTH && up || facing == EnumFacing.SOUTH && !up ? 0.5 : 0.0, facing == EnumFacing.WEST && !up || facing == EnumFacing.EAST && up ? 0.5 : 1.0, 1.5, facing == EnumFacing.NORTH && !up || facing == EnumFacing.SOUTH && up ? 0.5 : 1.0)});
        return list;
    }

    @Override
    public NBTTagCompound writeConveyorNBT() {
        NBTTagCompound nbt = super.writeConveyorNBT();
        if (this.cover != null) {
            nbt.setTag("cover", (NBTBase)this.cover.writeToNBT(new NBTTagCompound()));
        }
        return nbt;
    }

    @Override
    public void readConveyorNBT(NBTTagCompound nbt) {
        super.readConveyorNBT(nbt);
        this.cover = new ItemStack(nbt.getCompoundTag("cover"));
    }

    static {
        final ArrayList scaffolds = Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((Block)IEContent.blockWoodenDecoration, 1, BlockTypes_WoodenDecoration.SCAFFOLDING.getMeta()), new ItemStack((Block)IEContent.blockMetalDecoration1, 1, BlockTypes_MetalDecoration1.STEEL_SCAFFOLDING_1.getMeta()), new ItemStack((Block)IEContent.blockMetalDecoration1, 1, BlockTypes_MetalDecoration1.STEEL_SCAFFOLDING_2.getMeta()), new ItemStack((Block)IEContent.blockMetalDecoration1, 1, BlockTypes_MetalDecoration1.ALUMINUM_SCAFFOLDING_0.getMeta()), new ItemStack((Block)IEContent.blockMetalDecoration1, 1, BlockTypes_MetalDecoration1.ALUMINUM_SCAFFOLDING_1.getMeta()), new ItemStack((Block)IEContent.blockMetalDecoration1, 1, BlockTypes_MetalDecoration1.ALUMINUM_SCAFFOLDING_2.getMeta())});
        validCoveyorCovers.add(new Function<ItemStack, Boolean>(){

            @Nullable
            public Boolean apply(@Nullable ItemStack input) {
                if (input == null) {
                    return Boolean.FALSE;
                }
                for (ItemStack stack : scaffolds) {
                    if (!OreDictionary.itemMatches((ItemStack)stack, (ItemStack)input, (boolean)false)) continue;
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        validCoveyorCovers.add((Function<ItemStack, Boolean>)((Function)input -> input == null ? Boolean.FALSE : Utils.compareToOreName(input, "blockGlass")));
        defaultCover = new ItemStack((Block)IEContent.blockMetalDecoration1, 1, BlockTypes_MetalDecoration1.STEEL_SCAFFOLDING_0.getMeta());
        topBox = new AxisAlignedBB(0.0, 0.75, 0.0, 1.0, 1.0, 1.0);
    }
}

