/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal.conveyors;

import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;

public class ConveyorBasic
implements ConveyorHandler.IConveyorBelt {
    ConveyorHandler.ConveyorDirection direction = ConveyorHandler.ConveyorDirection.HORIZONTAL;
    int dyeColour = -1;
    public static ResourceLocation texture_on = new ResourceLocation("immersiveengineering:blocks/conveyor");
    public static ResourceLocation texture_off = new ResourceLocation("immersiveengineering:blocks/conveyor_off");

    @Override
    public ConveyorHandler.ConveyorDirection getConveyorDirection() {
        return this.direction;
    }

    @Override
    public boolean changeConveyorDirection() {
        this.direction = this.direction == ConveyorHandler.ConveyorDirection.HORIZONTAL ? ConveyorHandler.ConveyorDirection.UP : (this.direction == ConveyorHandler.ConveyorDirection.UP ? ConveyorHandler.ConveyorDirection.DOWN : ConveyorHandler.ConveyorDirection.HORIZONTAL);
        return true;
    }

    @Override
    public boolean setConveyorDirection(ConveyorHandler.ConveyorDirection dir) {
        this.direction = dir;
        return true;
    }

    @Override
    public boolean isActive(TileEntity tile) {
        return tile.getWorld().isBlockIndirectlyGettingPowered(tile.getPos()) <= 0;
    }

    @Override
    public boolean canBeDyed() {
        return true;
    }

    @Override
    public boolean setDyeColour(int colour) {
        if (colour == this.dyeColour) {
            return false;
        }
        this.dyeColour = colour;
        return true;
    }

    @Override
    public int getDyeColour() {
        return this.dyeColour;
    }

    @Override
    public NBTTagCompound writeConveyorNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.setInteger("direction", this.direction.ordinal());
        nbt.setInteger("dyeColour", this.dyeColour);
        return nbt;
    }

    @Override
    public void readConveyorNBT(NBTTagCompound nbt) {
        this.direction = ConveyorHandler.ConveyorDirection.values()[nbt.getInteger("direction")];
        this.dyeColour = nbt.hasKey("dyeColour") ? nbt.getInteger("dyeColour") : -1;
    }

    @Override
    public ResourceLocation getActiveTexture() {
        return texture_on;
    }

    @Override
    public ResourceLocation getInactiveTexture() {
        return texture_off;
    }
}

