/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityTurret;
import blusunrize.immersiveengineering.common.entities.EntityRevolvershot;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import blusunrize.immersiveengineering.common.util.network.MessageTileSync;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityTurretGun
extends TileEntityTurret {
    public int cycleRender;
    private NonNullList<ItemStack> inventory = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);
    public boolean expelCasings = false;
    IItemHandler itemHandler = new IEInventoryHandler(2, (IIEInventory)this, 0, new boolean[]{true, false}, new boolean[]{false, true});

    @Override
    protected double getRange() {
        return 16.0;
    }

    @Override
    protected boolean canActivate() {
        return this.energyStorage.getEnergyStored() >= Config.IEConfig.Machines.turret_gun_consumption && !((ItemStack)this.inventory.get(0)).isEmpty();
    }

    @Override
    protected int getChargeupTicks() {
        return 5;
    }

    @Override
    protected int getActiveTicks() {
        return 5;
    }

    @Override
    protected boolean loopActivation() {
        return false;
    }

    @Override
    protected void activate() {
        String key;
        BulletHandler.IBullet bullet;
        int energy = Config.IEConfig.Machines.turret_gun_consumption;
        ItemStack bulletStack = (ItemStack)this.inventory.get(0);
        if (!bulletStack.isEmpty() && this.energyStorage.extractEnergy(energy, true) == energy && (bullet = BulletHandler.getBullet(key = ItemNBTHelper.getString(bulletStack, "bullet"))) != null && bullet.isValidForTurret()) {
            ItemStack casing = bullet.getCasing(bulletStack);
            if (this.expelCasings || casing.isEmpty() || ((ItemStack)this.inventory.get(1)).isEmpty() || OreDictionary.itemMatches((ItemStack)casing, (ItemStack)((ItemStack)this.inventory.get(1)), (boolean)false) && ((ItemStack)this.inventory.get(1)).getCount() + casing.getCount() <= ((ItemStack)this.inventory.get(1)).getMaxStackSize()) {
                SoundEvent sound;
                this.energyStorage.extractEnergy(energy, false);
                this.sendRenderPacket();
                double dX = this.target.posX - ((double)this.getPos().getX() + 0.5);
                double dY = this.target.posY - ((double)this.getPos().getY() + 0.5);
                double dZ = this.target.posZ - ((double)this.getPos().getZ() + 0.5);
                Vec3d vec = new Vec3d(dX, dY, dZ).normalize();
                int count = bullet.getProjectileCount(null);
                if (count == 1) {
                    EntityRevolvershot entBullet = this.getBulletEntity(this.world, vec, bullet);
                    this.world.spawnEntity(bullet.getProjectile(null, bulletStack, entBullet, false));
                } else {
                    for (int i = 0; i < count; ++i) {
                        Vec3d vecDir = vec.addVector(Utils.RAND.nextGaussian() * 0.1, Utils.RAND.nextGaussian() * 0.1, Utils.RAND.nextGaussian() * 0.1);
                        EntityRevolvershot entBullet = this.getBulletEntity(this.world, vecDir, bullet);
                        this.world.spawnEntity(bullet.getProjectile(null, bulletStack, entBullet, false));
                    }
                }
                bulletStack.shrink(1);
                if (bulletStack.getCount() <= 0) {
                    this.inventory.set(0, (Object)ItemStack.EMPTY);
                }
                if (!casing.isEmpty()) {
                    if (this.expelCasings) {
                        double cX = (double)this.getPos().getX() + 0.5;
                        double cY = (double)this.getPos().getY() + 1.375;
                        double cZ = (double)this.getPos().getZ() + 0.5;
                        Vec3d vCasing = vec.rotateYaw(-1.57f);
                        this.world.spawnParticle(EnumParticleTypes.REDSTONE, cX + vCasing.x, cY + vCasing.y, cZ + vCasing.z, 0.0, 0.0, 0.0, new int[]{1, 0});
                        EntityItem entCasing = new EntityItem(this.world, cX + vCasing.x, cY + vCasing.y, cZ + vCasing.z, casing.copy());
                        entCasing.motionX = 0.0;
                        entCasing.motionY = -0.01;
                        entCasing.motionZ = 0.0;
                        this.world.spawnEntity((Entity)entCasing);
                    } else if (((ItemStack)this.inventory.get(1)).isEmpty()) {
                        this.inventory.set(1, (Object)casing.copy());
                    } else {
                        ((ItemStack)this.inventory.get(1)).grow(casing.getCount());
                    }
                }
                if ((sound = bullet.getSound()) == null) {
                    sound = IESounds.revolverFire;
                }
                this.world.playSound(null, this.getPos(), sound, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    protected void sendRenderPacket() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.setBoolean("cycle", true);
        ImmersiveEngineering.packetHandler.sendToAll((IMessage)new MessageTileSync(this, tag));
    }

    EntityRevolvershot getBulletEntity(World world, Vec3d vecDir, BulletHandler.IBullet type) {
        EntityRevolvershot bullet = new EntityRevolvershot(world, (double)this.getPos().getX() + 0.5 + vecDir.x, (double)this.getPos().getY() + 1.375 + vecDir.y, (double)this.getPos().getZ() + 0.5 + vecDir.z, 0.0, 0.0, 0.0, type);
        bullet.motionX = vecDir.x;
        bullet.motionY = vecDir.y;
        bullet.motionZ = vecDir.z;
        return bullet;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public void update() {
        if (this.world.isRemote && !this.dummy && this.cycleRender > 0) {
            --this.cycleRender;
        }
        super.update();
    }

    @Override
    public void receiveMessageFromServer(NBTTagCompound message) {
        if (message.hasKey("cycle")) {
            this.cycleRender = 5;
        }
    }

    @Override
    public void receiveMessageFromClient(NBTTagCompound message) {
        super.receiveMessageFromClient(message);
        if (message.hasKey("expelCasings")) {
            this.expelCasings = message.getBoolean("expelCasings");
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.expelCasings = nbt.getBoolean("expelCasings");
        if (!descPacket) {
            this.inventory = Utils.readInventory(nbt.getTagList("inventory", 10), 2);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.setBoolean("expelCasings", this.expelCasings);
        if (!descPacket) {
            nbt.setTag("inventory", (NBTBase)Utils.writeInventory(this.inventory));
        }
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (!(this.dummy || capability != CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || facing != null && facing != EnumFacing.DOWN && facing != this.facing.getOpposite())) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (!(this.dummy || capability != CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || facing != null && facing != EnumFacing.DOWN && facing != this.facing.getOpposite())) {
            return (T)this.itemHandler;
        }
        return super.getCapability(capability, facing);
    }
}

