/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.tool.ChemthrowerHandler;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityTurret;
import blusunrize.immersiveengineering.common.entities.EntityChemthrowerShot;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.Utils;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class TileEntityTurretChem
extends TileEntityTurret {
    public FluidTank tank = new FluidTank(4000);
    public boolean ignite = false;

    @Override
    protected double getRange() {
        return 8.0;
    }

    @Override
    protected boolean canActivate() {
        return this.tank.getFluidAmount() > 0 && this.energyStorage.getEnergyStored() >= Config.IEConfig.Machines.turret_chem_consumption;
    }

    @Override
    protected int getChargeupTicks() {
        return 10;
    }

    @Override
    protected int getActiveTicks() {
        return 1;
    }

    @Override
    protected boolean loopActivation() {
        return true;
    }

    @Override
    protected void activate() {
        FluidStack fs = this.tank.getFluid();
        if (fs != null && fs.getFluid() != null) {
            int consumed = Config.IEConfig.Tools.chemthrower_consumption;
            int energy = Config.IEConfig.Machines.turret_chem_consumption;
            if (consumed <= fs.amount && this.energyStorage.extractEnergy(energy, true) >= energy) {
                this.tank.drain(consumed, true);
                this.energyStorage.extractEnergy(energy, false);
                double dX = this.target.posX - ((double)this.getPos().getX() + 0.5);
                double dY = this.target.posY - ((double)this.getPos().getY() + 0.5);
                double dZ = this.target.posZ - ((double)this.getPos().getZ() + 0.5);
                Vec3d v = new Vec3d(dX, dY, dZ).normalize();
                int split = 8;
                boolean isGas = fs.getFluid().isGaseous() || ChemthrowerHandler.isGas(fs.getFluid());
                float scatter = isGas ? 0.15f : 0.05f;
                float range = isGas ? 0.5f : 1.0f;
                boolean ignite = ChemthrowerHandler.isFlammable(fs.getFluid()) && this.ignite;
                for (int i = 0; i < split; ++i) {
                    Vec3d vecDir = v.addVector(Utils.RAND.nextGaussian() * (double)scatter, Utils.RAND.nextGaussian() * (double)scatter, Utils.RAND.nextGaussian() * (double)scatter);
                    EntityChemthrowerShot chem = new EntityChemthrowerShot(this.world, (double)this.getPos().getX() + 0.5 + v.x * 0.875, (double)this.getPos().getY() + 1.5 + v.y * 0.875, (double)this.getPos().getZ() + 0.5 + v.z * 0.875, 0.0, 0.0, 0.0, fs);
                    chem.motionX = vecDir.x * (double)range;
                    chem.motionY = vecDir.y * (double)range;
                    chem.motionZ = vecDir.z * (double)range;
                    if (ignite) {
                        chem.setFire(10);
                    }
                    if (this.world.isRemote) continue;
                    this.world.spawnEntity((Entity)chem);
                }
                if (this.tick % 4 == 0) {
                    if (ignite) {
                        this.world.playSound(null, this.getPos(), IESounds.sprayFire, SoundCategory.BLOCKS, 0.5f, 1.5f);
                    } else {
                        this.world.playSound(null, this.getPos(), IESounds.spray, SoundCategory.BLOCKS, 0.5f, 0.75f);
                    }
                }
            }
        }
    }

    @Override
    public void receiveMessageFromClient(NBTTagCompound message) {
        super.receiveMessageFromClient(message);
        if (message.hasKey("ignite")) {
            this.ignite = message.getBoolean("ignite");
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.tank.readFromNBT(nbt.getCompoundTag("tank"));
        this.ignite = nbt.getBoolean("ignite");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.setTag("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        nbt.setBoolean("ignite", this.ignite);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (!(this.dummy || capability != CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || facing != null && facing != EnumFacing.DOWN && facing != this.facing.getOpposite())) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (!(this.dummy || capability != CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || facing != null && facing != EnumFacing.DOWN && facing != this.facing.getOpposite())) {
            return (T)this.tank;
        }
        return super.getCapability(capability, facing);
    }
}

