/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorage;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.ChatUtils;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileEntityTurret
extends TileEntityIEBase
implements ITickable,
EnergyHelper.IIEInternalFluxHandler,
IIEInventory,
IEBlockInterfaces.IHasDummyBlocks,
IEBlockInterfaces.ITileDrop,
IEBlockInterfaces.IDirectionalTile,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IGuiTile,
IEBlockInterfaces.IEntityProof,
IEBlockInterfaces.IHammerInteraction,
IEBlockInterfaces.IHasObjProperty {
    public boolean dummy = false;
    public FluxStorage energyStorage = new FluxStorage(16000);
    public boolean redstoneControlInverted = false;
    public EnumFacing facing = EnumFacing.NORTH;
    public String owner;
    public List<String> targetList = new ArrayList<String>();
    public boolean whitelist = false;
    public boolean attackAnimals = false;
    public boolean attackPlayers = false;
    public boolean attackNeutrals = false;
    protected int tick = 0;
    protected EntityLivingBase target;
    public float rotationYaw;
    public float rotationPitch;
    private UUID targetId;
    AxisAlignedBB renderBB;
    EnergyHelper.IEForgeEnergyWrapper[] wrappers = EnergyHelper.IEForgeEnergyWrapper.getDefaultWrapperArray(this);
    static ArrayList<String> displayList = Lists.newArrayList((Object[])new String[]{"base"});

    public void update() {
        ApiUtils.checkForNeedlessTicking(this);
        if (this.dummy) {
            return;
        }
        double range = this.getRange();
        if (this.targetId != null) {
            AxisAlignedBB validBox = Block.FULL_BLOCK_AABB.offset(this.pos).grow(range);
            List entities = this.world.getEntitiesWithinAABB(EntityLivingBase.class, validBox);
            for (EntityLivingBase entity : entities) {
                if (!entity.getUniqueID().equals(this.targetId) || !this.isValidTarget(entity)) continue;
                this.target = entity;
                break;
            }
            this.targetId = null;
        }
        if (this.target != null) {
            double dZ;
            double dY;
            double dX = this.target.posX - ((double)this.getPos().getX() + 0.5);
            double dSq = dX * dX + (dY = this.target.posY - ((double)this.getPos().getY() + 0.5)) * dY + (dZ = this.target.posZ - ((double)this.getPos().getZ() + 0.5)) * dZ;
            if (dSq > range * range) {
                this.target = null;
            } else if (this.world.isRemote) {
                float facingYaw = this.facing == EnumFacing.NORTH ? 180.0f : (this.facing == EnumFacing.WEST ? -90.0f : (this.facing == EnumFacing.EAST ? 90.0f : 0.0f));
                double yaw = MathHelper.atan2((double)dX, (double)dZ) * 57.29577951308232 - (double)facingYaw;
                this.rotationPitch = (float)(Math.atan2(Math.sqrt(dZ * dZ + dX * dX), dY) * 57.29577951308232) - 90.0f;
                this.rotationYaw = this.rotationYaw == 0.0f ? (float)(yaw * 0.5) : (float)yaw;
            }
        } else if (this.world.isRemote) {
            this.rotationYaw = (float)((double)this.rotationYaw * 0.75);
            if (Math.abs(this.rotationYaw) < 10.0f) {
                this.rotationYaw = 0.0f;
            }
            this.rotationPitch = (float)((double)this.rotationPitch * 0.75);
            if (Math.abs(this.rotationPitch) < 10.0f) {
                this.rotationPitch = 0.0f;
            }
        }
        if (this.world.isRemote) {
            return;
        }
        if (this.world.getTotalWorldTime() % 64L == (long)((this.getPos().getX() ^ this.getPos().getZ()) & 0x3F)) {
            this.markContainingBlockForUpdate(null);
        }
        int energy = Config.IEConfig.Machines.turret_consumption;
        if (this.world.isBlockIndirectlyGettingPowered(this.getPos()) > 0 ^ this.redstoneControlInverted) {
            if (this.energyStorage.extractEnergy(energy, true) == energy) {
                this.energyStorage.extractEnergy(energy, false);
                if (this.target == null || this.target.isDead || this.world.getEntityByID(this.target.getEntityId()) == null || this.target.getHealth() <= 0.0f || !this.canSeeEntity(this.target)) {
                    this.target = this.getTarget();
                    if (this.target != null) {
                        this.markDirty();
                        this.markContainingBlockForUpdate(null);
                    }
                }
                if (this.target != null && this.canActivate()) {
                    ++this.tick;
                    int chargeup = this.getChargeupTicks();
                    if (this.tick == chargeup) {
                        this.activate();
                    } else if (this.tick > chargeup) {
                        if (this.loopActivation()) {
                            this.activate();
                        } else if (this.tick == chargeup + this.getActiveTicks()) {
                            this.tick = 0;
                        }
                    }
                } else {
                    this.tick = 0;
                }
            }
        } else if (this.target != null) {
            this.target = null;
        }
    }

    private boolean canSeeEntity(EntityLivingBase entity) {
        return Utils.rayTraceForFirst(new Vec3d((double)this.getPos().getX() + 0.5, (double)this.getPos().getY() + 1.375, (double)this.getPos().getZ() + 0.5), new Vec3d(entity.posX, entity.posY + (double)entity.getEyeHeight(), entity.posZ), this.world, Collections.singleton(this.getPos().up())) == null;
    }

    private EntityLivingBase getTarget() {
        double range = this.getRange();
        List list = this.world.getEntitiesWithinAABB(EntityLivingBase.class, new AxisAlignedBB((double)this.getPos().getX() - range, (double)this.getPos().getY(), (double)this.getPos().getZ() - range, (double)this.getPos().getX() + range, (double)(this.getPos().getY() + 3), (double)this.getPos().getZ() + range));
        if (list.isEmpty()) {
            return null;
        }
        for (EntityLivingBase entity : list) {
            if (!this.isValidTarget(entity)) continue;
            return entity;
        }
        return null;
    }

    public boolean isValidTarget(EntityLivingBase entity) {
        Entity entityOwner;
        if (entity == null || entity.isDead || entity.getHealth() <= 0.0f || !this.canSeeEntity(entity)) {
            return false;
        }
        if (this.whitelist ^ this.isListedName(this.targetList, entity.getName())) {
            return false;
        }
        if (entity instanceof IEntityOwnable && (entityOwner = ((IEntityOwnable)entity).getOwner()) != null && this.whitelist ^ this.isListedName(this.targetList, entityOwner.getName())) {
            return false;
        }
        if (entity instanceof EntityAnimal && !this.attackAnimals) {
            return false;
        }
        if (entity instanceof EntityPlayer && !this.attackPlayers) {
            return false;
        }
        if (!(entity instanceof EntityPlayer || entity instanceof EntityAnimal || entity.isCreatureType(EnumCreatureType.MONSTER, false) || this.attackNeutrals)) {
            return false;
        }
        return this.target == null || entity.getDistanceSq(this.getPos()) < this.target.getDistanceSq(this.getPos());
    }

    private boolean isListedName(List<String> list, String name) {
        for (String s : list) {
            if (s == null || !s.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    protected abstract double getRange();

    protected abstract boolean canActivate();

    protected abstract int getChargeupTicks();

    protected abstract int getActiveTicks();

    protected abstract boolean loopActivation();

    protected abstract void activate();

    protected boolean hasOwnerRights(EntityPlayer player) {
        if (player.capabilities.isCreativeMode || this.owner == null || this.owner.isEmpty()) {
            return true;
        }
        return this.owner.equalsIgnoreCase(player.getName());
    }

    @Override
    public void receiveMessageFromClient(NBTTagCompound message) {
        if (message.hasKey("add")) {
            this.targetList.add(message.getString("add"));
        }
        if (message.hasKey("remove")) {
            this.targetList.remove(message.getInteger("remove"));
        }
        if (message.hasKey("whitelist")) {
            this.whitelist = message.getBoolean("whitelist");
        }
        if (message.hasKey("attackAnimals")) {
            this.attackAnimals = message.getBoolean("attackAnimals");
        }
        if (message.hasKey("attackPlayers")) {
            this.attackPlayers = message.getBoolean("attackPlayers");
        }
        if (message.hasKey("attackNeutrals")) {
            this.attackNeutrals = message.getBoolean("attackNeutrals");
        }
        this.markDirty();
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.dummy = nbt.getBoolean("dummy");
        this.redstoneControlInverted = nbt.getBoolean("redstoneInverted");
        this.facing = EnumFacing.getFront((int)nbt.getInteger("facing"));
        this.energyStorage.readFromNBT(nbt);
        if (nbt.hasKey("owner")) {
            this.owner = nbt.getString("owner");
        }
        NBTTagList list = nbt.getTagList("targetList", 8);
        this.targetList.clear();
        for (int i = 0; i < list.tagCount(); ++i) {
            this.targetList.add(list.getStringTagAt(i));
        }
        this.whitelist = nbt.getBoolean("whitelist");
        this.attackAnimals = nbt.getBoolean("attackAnimals");
        this.attackPlayers = nbt.getBoolean("attackPlayers");
        this.attackNeutrals = nbt.getBoolean("attackNeutrals");
        this.target = null;
        if (nbt.hasKey("target", 8)) {
            this.targetId = UUID.fromString(nbt.getString("target"));
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.setBoolean("dummy", this.dummy);
        nbt.setBoolean("redstoneInverted", this.redstoneControlInverted);
        if (this.facing != null) {
            nbt.setInteger("facing", this.facing.ordinal());
        }
        this.energyStorage.writeToNBT(nbt);
        if (this.owner != null) {
            nbt.setString("owner", this.owner);
        }
        NBTTagList list = new NBTTagList();
        for (String s : this.targetList) {
            list.appendTag((NBTBase)new NBTTagString(s));
        }
        nbt.setTag("targetList", (NBTBase)list);
        nbt.setBoolean("whitelist", this.whitelist);
        nbt.setBoolean("attackAnimals", this.attackAnimals);
        nbt.setBoolean("attackPlayers", this.attackPlayers);
        nbt.setBoolean("attackNeutrals", this.attackNeutrals);
        if (this.target != null) {
            nbt.setString("target", this.target.getUniqueID().toString());
        }
    }

    @Override
    public float[] getBlockBounds() {
        if (!this.dummy) {
            return null;
        }
        switch (this.facing) {
            case NORTH: {
                return new float[]{0.125f, 0.0625f, 0.125f, 0.875f, 0.875f, 1.0f};
            }
            case SOUTH: {
                return new float[]{0.125f, 0.0625f, 0.0f, 0.875f, 0.875f, 0.875f};
            }
            case WEST: {
                return new float[]{0.125f, 0.0625f, 0.125f, 1.0f, 0.875f, 0.875f};
            }
            case EAST: {
                return new float[]{0.0f, 0.0625f, 0.125f, 0.875f, 0.875f, 0.875f};
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderBB == null) {
            this.renderBB = new AxisAlignedBB(this.getPos().add(-8, -8, -8), this.getPos().add(8, 8, 8));
        }
        return this.renderBB;
    }

    @Override
    public boolean hammerUseSide(EnumFacing side, EntityPlayer player, float hitX, float hitY, float hitZ) {
        if (this.dummy) {
            TileEntity te = this.world.getTileEntity(this.getPos().down());
            if (te instanceof TileEntityTurret) {
                return ((TileEntityTurret)te).hammerUseSide(side, player, hitX, hitY, hitZ);
            }
            return false;
        }
        if (player.isSneaking()) {
            this.redstoneControlInverted = !this.redstoneControlInverted;
            ChatUtils.sendServerNoSpamMessages(player, new ITextComponent[]{new TextComponentTranslation("chat.immersiveengineering.info.rsControl." + (this.redstoneControlInverted ? "invertedOn" : "invertedOff"), new Object[0])});
            this.markDirty();
            this.markContainingBlockForUpdate(null);
        }
        return true;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return NonNullList.create();
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public void doGraphicalUpdates(int slot) {
    }

    @Override
    public boolean canOpenGui(EntityPlayer player) {
        if (this.hasOwnerRights(player)) {
            return true;
        }
        ChatUtils.sendServerNoSpamMessages(player, new ITextComponent[]{new TextComponentTranslation("chat.immersiveengineering.info.notOwner", new Object[]{this.owner})});
        return false;
    }

    @Override
    public boolean canOpenGui() {
        return false;
    }

    @Override
    public int getGuiID() {
        return 13;
    }

    @Override
    public TileEntity getGuiMaster() {
        if (!this.dummy) {
            return this;
        }
        TileEntity te = this.world.getTileEntity(this.getPos().down());
        if (te instanceof TileEntityTurret) {
            return te;
        }
        return null;
    }

    @Override
    public EnumFacing getFacing() {
        return this.facing;
    }

    @Override
    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    @Override
    public int getFacingLimitation() {
        return 2;
    }

    @Override
    public boolean mirrorFacingOnPlacement(EntityLivingBase placer) {
        return false;
    }

    @Override
    public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity) {
        return false;
    }

    @Override
    public boolean canRotate(EnumFacing axis) {
        return false;
    }

    @Override
    public boolean canEntityDestroy(Entity entity) {
        TileEntity te;
        if (this.dummy && (te = this.world.getTileEntity(this.getPos().down())) instanceof TileEntityTurret) {
            return ((TileEntityTurret)te).canEntityDestroy(entity);
        }
        if (entity instanceof EntityPlayer) {
            return this.hasOwnerRights((EntityPlayer)entity);
        }
        return true;
    }

    @Override
    public boolean isDummy() {
        return this.dummy;
    }

    @Override
    public void placeDummies(BlockPos pos, IBlockState state, EnumFacing side, float hitX, float hitY, float hitZ) {
        this.world.setBlockState(pos.up(), state);
        ((TileEntityTurret)this.world.getTileEntity((BlockPos)pos.up())).dummy = true;
        ((TileEntityTurret)this.world.getTileEntity((BlockPos)pos.up())).facing = this.facing;
    }

    @Override
    public void breakDummies(BlockPos pos, IBlockState state) {
        if (this.world.getTileEntity(this.dummy ? this.getPos().down() : this.getPos().up()) instanceof TileEntityTurret) {
            this.world.setBlockToAir(this.dummy ? this.getPos().down() : this.getPos().up());
        }
    }

    @Override
    public ItemStack getTileDrop(EntityPlayer player, IBlockState state) {
        ItemStack stack = new ItemStack(state.getBlock(), 1, state.getBlock().getMetaFromState(state));
        TileEntityTurret turret = this;
        if (this.dummy) {
            TileEntity t = this.world.getTileEntity(this.getPos().down());
            if (t instanceof TileEntityTurret) {
                turret = (TileEntityTurret)t;
            } else {
                return stack;
            }
        }
        NBTTagCompound tag = new NBTTagCompound();
        if (!(turret.owner == null || player != null && player.getName().equalsIgnoreCase(turret.owner))) {
            tag.setString("owner", turret.owner);
        }
        if (turret.targetList.size() != 1 || !this.isListedName(turret.targetList, turret.owner)) {
            NBTTagList list = new NBTTagList();
            for (String s : turret.targetList) {
                list.appendTag((NBTBase)new NBTTagString(s));
            }
            tag.setTag("targetList", (NBTBase)list);
        }
        if (turret.whitelist) {
            tag.setBoolean("whitelist", turret.whitelist);
        }
        if (turret.attackAnimals) {
            tag.setBoolean("attackAnimals", turret.attackAnimals);
        }
        if (!turret.attackPlayers) {
            tag.setBoolean("attackPlayers", turret.attackPlayers);
        }
        if (turret.attackNeutrals) {
            tag.setBoolean("attackNeutrals", turret.attackNeutrals);
        }
        if (turret.redstoneControlInverted) {
            tag.setBoolean("redstoneControlInverted", turret.redstoneControlInverted);
        }
        if (!tag.hasNoTags()) {
            stack.setTagCompound(tag);
        }
        return stack;
    }

    @Override
    public void readOnPlacement(@Nullable EntityLivingBase placer, ItemStack stack) {
        if (stack.hasTagCompound()) {
            NBTTagCompound tag = stack.getTagCompound();
            if (tag.hasKey("owner")) {
                this.owner = tag.getString("owner");
            } else if (placer != null) {
                this.owner = placer.getName();
            }
            if (tag.hasKey("targetList")) {
                NBTTagList list = tag.getTagList("targetList", 8);
                this.targetList.clear();
                for (int i = 0; i < list.tagCount(); ++i) {
                    this.targetList.add(list.getStringTagAt(i));
                }
            } else if (this.owner != null) {
                this.targetList.add(this.owner);
            }
            if (tag.hasKey("whitelist")) {
                this.whitelist = tag.getBoolean("whitelist");
            }
            if (tag.hasKey("attackAnimals")) {
                this.attackAnimals = tag.getBoolean("attackAnimals");
            }
            if (tag.hasKey("attackPlayers")) {
                this.attackPlayers = tag.getBoolean("attackPlayers");
            }
            if (tag.hasKey("attackNeutrals")) {
                this.attackNeutrals = tag.getBoolean("attackNeutrals");
            }
            if (tag.hasKey("redstoneControlInverted")) {
                this.redstoneControlInverted = tag.getBoolean("redstoneControlInverted");
            }
        } else if (placer != null) {
            this.owner = placer.getName();
            this.targetList.add(this.owner);
        }
    }

    @Override
    @Nonnull
    public FluxStorage getFluxStorage() {
        TileEntity te;
        if (this.dummy && (te = this.world.getTileEntity(this.getPos().down())) instanceof TileEntityTurret) {
            return ((TileEntityTurret)te).getFluxStorage();
        }
        return this.energyStorage;
    }

    @Override
    @Nonnull
    public IEEnums.SideConfig getEnergySideConfig(EnumFacing facing) {
        return !this.dummy ? IEEnums.SideConfig.INPUT : IEEnums.SideConfig.NONE;
    }

    @Override
    public EnergyHelper.IEForgeEnergyWrapper getCapabilityWrapper(EnumFacing facing) {
        if (!this.dummy) {
            return this.wrappers[facing == null ? 0 : facing.ordinal()];
        }
        return null;
    }

    @Override
    public ArrayList<String> compileDisplayList() {
        return displayList;
    }
}

