/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.items.ItemInternalStorage;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityToolbox
extends TileEntityIEBase
implements IEBlockInterfaces.IDirectionalTile,
IEBlockInterfaces.IBlockBounds,
IIEInventory,
IEBlockInterfaces.IGuiTile,
IEBlockInterfaces.ITileDrop,
IEBlockInterfaces.IPlayerInteraction {
    NonNullList<ItemStack> inventory = NonNullList.withSize((int)23, (Object)ItemStack.EMPTY);
    public String name;
    private EnumFacing facing = EnumFacing.NORTH;
    private NBTTagList enchantments;
    private static final float[] boundsZ = new float[]{0.125f, 0.0f, 0.25f, 0.875f, 0.625f, 0.75f};
    private static final float[] boundsX = new float[]{0.25f, 0.0f, 0.125f, 0.75f, 0.625f, 0.875f};

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.facing = EnumFacing.getFront((int)nbt.getInteger("facing"));
        if (nbt.hasKey("name")) {
            this.name = nbt.getString("name");
        }
        if (nbt.hasKey("enchantments")) {
            this.enchantments = nbt.getTagList("enchantments", 10);
        }
        if (!descPacket) {
            this.inventory = Utils.readInventory(nbt.getTagList("inventory", 10), 23);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.setInteger("facing", this.facing.ordinal());
        if (this.name != null) {
            nbt.setString("name", this.name);
        }
        if (this.enchantments != null) {
            nbt.setTag("enchantments", (NBTBase)this.enchantments);
        }
        if (!descPacket) {
            nbt.setTag("inventory", (NBTBase)Utils.writeInventory(this.inventory));
        }
    }

    @Override
    public boolean interact(EnumFacing side, EntityPlayer player, EnumHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        if (player.isSneaking()) {
            if (!this.getWorld().isRemote) {
                EntityItem entityitem = new EntityItem(this.getWorld(), (double)this.getPos().getX() + 0.5, (double)this.getPos().getY() + 0.5, (double)this.getPos().getZ() + 0.5, this.getTileDrop(player, this.getWorld().getBlockState(this.getPos())));
                entityitem.setDefaultPickupDelay();
                this.getWorld().setBlockToAir(this.getPos());
                this.getWorld().spawnEntity((Entity)entityitem);
            }
            return true;
        }
        return false;
    }

    @Nullable
    public ITextComponent getDisplayName() {
        return this.name != null ? new TextComponentString(this.name) : new TextComponentTranslation("item.immersiveengineering.toolbox.name", new Object[0]);
    }

    @Override
    public boolean canOpenGui() {
        return true;
    }

    @Override
    public int getGuiID() {
        return 16;
    }

    @Override
    public TileEntity getGuiMaster() {
        return this;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return IEApi.isAllowedInCrate(stack);
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public void doGraphicalUpdates(int slot) {
        this.markDirty();
    }

    @Override
    public ItemStack getTileDrop(EntityPlayer player, IBlockState state) {
        ItemStack stack = new ItemStack((Item)IEContent.itemToolbox);
        ((ItemInternalStorage)IEContent.itemToolbox).setContainedItems(stack, this.inventory);
        if (this.name != null) {
            stack.setStackDisplayName(this.name);
        }
        if (this.enchantments != null) {
            ItemNBTHelper.getTag(stack).setTag("ench", (NBTBase)this.enchantments);
        }
        return stack;
    }

    @Override
    public void readOnPlacement(EntityLivingBase placer, ItemStack stack) {
        if (stack.getItem() instanceof ItemInternalStorage) {
            IItemHandler inv = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            if (inv != null) {
                this.inventory = NonNullList.withSize((int)inv.getSlots(), (Object)ItemStack.EMPTY);
                for (int i = 0; i < inv.getSlots(); ++i) {
                    this.inventory.set(i, (Object)inv.getStackInSlot(i));
                }
            }
            if (stack.hasDisplayName()) {
                this.name = stack.getDisplayName();
            }
            this.enchantments = stack.getEnchantmentTagList();
        }
    }

    @Override
    public boolean preventInventoryDrop() {
        return true;
    }

    @Override
    public EnumFacing getFacing() {
        return this.facing;
    }

    @Override
    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    @Override
    public int getFacingLimitation() {
        return 2;
    }

    @Override
    public boolean mirrorFacingOnPlacement(EntityLivingBase placer) {
        return false;
    }

    @Override
    public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity) {
        return false;
    }

    @Override
    public boolean canRotate(EnumFacing axis) {
        return true;
    }

    @Override
    public float[] getBlockBounds() {
        return this.facing.getAxis() == EnumFacing.Axis.Z ? boundsZ : boundsX;
    }
}

