/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorage;
import blusunrize.immersiveengineering.api.tool.ITeslaEntity;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.ChatUtils;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import blusunrize.immersiveengineering.common.util.IEPotions;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.network.MessageTileSync;
import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityTeslaCoil
extends TileEntityIEBase
implements ITickable,
EnergyHelper.IIEInternalFluxHandler,
IEBlockInterfaces.IHasDummyBlocks,
IEBlockInterfaces.IDirectionalTile,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IHammerInteraction {
    public boolean dummy = false;
    public FluxStorage energyStorage = new FluxStorage(48000);
    public boolean redstoneControlInverted = false;
    public EnumFacing facing = EnumFacing.UP;
    public boolean lowPower = false;
    private Vec3d soundPos = null;
    @SideOnly(value=Side.CLIENT)
    public static ArrayListMultimap<BlockPos, LightningAnimation> effectMap;
    AxisAlignedBB renderBB;
    EnergyHelper.IEForgeEnergyWrapper[] wrappers = EnergyHelper.IEForgeEnergyWrapper.getDefaultWrapperArray(this);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        ApiUtils.checkForNeedlessTicking(this);
        if (this.dummy) {
            return;
        }
        TileEntityTeslaCoil tileEntityTeslaCoil = this;
        synchronized (tileEntityTeslaCoil) {
            if (this.world.isRemote && this.soundPos != null) {
                this.world.playSound(this.soundPos.x, this.soundPos.y, this.soundPos.z, IESounds.tesla, SoundCategory.BLOCKS, 2.5f, 0.5f + Utils.RAND.nextFloat(), true);
                this.soundPos = null;
            }
        }
        if (this.world.isRemote && effectMap.containsKey((Object)this.pos)) {
            effectMap.get((Object)this.pos).removeIf(LightningAnimation::tick);
        }
        int timeKey = this.getPos().getX() ^ this.getPos().getZ();
        int energyDrain = Config.IEConfig.Machines.teslacoil_consumption;
        if (this.lowPower) {
            energyDrain /= 2;
        }
        if (this.world.getTotalWorldTime() % 32L == (long)(timeKey & 0x1F) && this.canRun(energyDrain)) {
            List targets;
            if (!this.world.isRemote) {
                this.energyStorage.extractEnergy(energyDrain, false);
            }
            double radius = 6.0;
            if (this.lowPower) {
                radius /= 2.0;
            }
            AxisAlignedBB aabbSmall = new AxisAlignedBB((double)this.getPos().getX() + 0.5 - radius, (double)this.getPos().getY() + 0.5 - radius, (double)this.getPos().getZ() + 0.5 - radius, (double)this.getPos().getX() + 0.5 + radius, (double)this.getPos().getY() + 0.5 + radius, (double)this.getPos().getZ() + 0.5 + radius);
            AxisAlignedBB aabb = aabbSmall.grow(radius / 2.0);
            List targetsAll = this.world.getEntitiesWithinAABB(Entity.class, aabb);
            if (!this.world.isRemote) {
                for (Entity e2 : targetsAll) {
                    if (!(e2 instanceof ITeslaEntity)) continue;
                    ((ITeslaEntity)e2).onHit(this, this.lowPower);
                }
            }
            if (!(targets = targetsAll.stream().filter(e -> e instanceof EntityLivingBase && aabbSmall.intersects(e.getEntityBoundingBox())).collect(Collectors.toList())).isEmpty()) {
                IEDamageSources.TeslaDamageSource dmgsrc = IEDamageSources.causeTeslaDamage(Config.IEConfig.Machines.teslacoil_damage, this.lowPower);
                int randomTarget = Utils.RAND.nextInt(targets.size());
                EntityLivingBase target = (EntityLivingBase)targets.get(randomTarget);
                if (target != null && !this.world.isRemote) {
                    energyDrain = Config.IEConfig.Machines.teslacoil_consumption_active;
                    if (this.lowPower) {
                        energyDrain /= 2;
                    }
                    if (this.energyStorage.extractEnergy(energyDrain, true) == energyDrain) {
                        this.energyStorage.extractEnergy(energyDrain, false);
                        if (dmgsrc.apply((Entity)target)) {
                            int prevFire = target.fire;
                            target.fire = 1;
                            target.addPotionEffect(new PotionEffect(IEPotions.stunned, 128));
                            target.fire = prevFire;
                        }
                        this.sendRenderPacket((Entity)target);
                    }
                }
            } else if (!this.world.isRemote && this.world.getTotalWorldTime() % 128L == (long)(timeKey & 0x7F)) {
                double tV = (Utils.RAND.nextDouble() - 0.5) * 8.0;
                double tH = (Utils.RAND.nextDouble() - 0.5) * 8.0;
                if (this.lowPower) {
                    tV /= 2.0;
                    tH /= 2.0;
                }
                BlockPos targetBlock = this.getPos().add(this.facing.getAxis() == EnumFacing.Axis.X ? 0.0 : (tH += tH < 0.0 ? -2.0 : 2.0), this.facing.getAxis() == EnumFacing.Axis.Y ? 0.0 : (tV += tV < 0.0 ? -2.0 : 2.0), this.facing.getAxis() == EnumFacing.Axis.Y ? tV : (this.facing.getAxis() == EnumFacing.Axis.X ? tH : 0.0));
                double tL = 0.0;
                boolean targetFound = false;
                if (!this.world.isAirBlock(targetBlock)) {
                    IBlockState state = this.world.getBlockState(targetBlock);
                    AxisAlignedBB blockBounds = state.getBoundingBox((IBlockAccess)this.world, targetBlock);
                    tL = this.facing == EnumFacing.UP ? (double)(targetBlock.getY() - this.getPos().getY()) + blockBounds.maxY : (this.facing == EnumFacing.DOWN ? (double)(targetBlock.getY() - this.getPos().getY()) + blockBounds.minY : (this.facing == EnumFacing.NORTH ? (double)(targetBlock.getZ() - this.getPos().getZ()) + blockBounds.minZ : (this.facing == EnumFacing.SOUTH ? (double)(targetBlock.getZ() - this.getPos().getZ()) + blockBounds.maxZ : (this.facing == EnumFacing.WEST ? (double)(targetBlock.getX() - this.getPos().getX()) + blockBounds.minX : (double)(targetBlock.getX() - this.getPos().getX()) + blockBounds.maxX))));
                    targetFound = true;
                } else {
                    boolean positiveFirst = Utils.RAND.nextBoolean();
                    for (int i = 0; i < 2; ++i) {
                        for (int ll = 0; ll <= 6; ++ll) {
                            EnumFacing tempF;
                            BlockPos targetBlock2 = targetBlock.offset(positiveFirst ? this.facing : this.facing.getOpposite(), ll);
                            if (this.world.isAirBlock(targetBlock2)) continue;
                            IBlockState state = this.world.getBlockState(targetBlock2);
                            AxisAlignedBB blockBounds = state.getBoundingBox((IBlockAccess)this.world, targetBlock2);
                            tL = this.facing.getAxis() == EnumFacing.Axis.Y ? (double)(targetBlock2.getY() - this.getPos().getY()) : (this.facing.getAxis() == EnumFacing.Axis.Z ? (double)(targetBlock2.getZ() - this.getPos().getZ()) : (double)(targetBlock2.getZ() - this.getPos().getZ()));
                            EnumFacing enumFacing = tempF = positiveFirst ? this.facing : this.facing.getOpposite();
                            tL = tempF == EnumFacing.UP ? (tL += blockBounds.maxY) : (tempF == EnumFacing.DOWN ? (tL += blockBounds.minY) : (tempF == EnumFacing.NORTH ? (tL += blockBounds.minZ) : (tempF == EnumFacing.SOUTH ? (tL += blockBounds.maxZ) : (tempF == EnumFacing.WEST ? (tL += blockBounds.minX) : (tL += blockBounds.maxX)))));
                            targetFound = true;
                            break;
                        }
                        if (targetFound) break;
                        positiveFirst = !positiveFirst;
                    }
                }
                if (targetFound) {
                    this.sendFreePacket(tL, tH, tV);
                }
            }
            this.markDirty();
        }
    }

    protected void sendRenderPacket(Entity target) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.setInteger("targetEntity", target.getEntityId());
        ImmersiveEngineering.packetHandler.sendToAll((IMessage)new MessageTileSync(this, tag));
    }

    protected void sendFreePacket(double tL, double tH, double tV) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.setDouble("tL", tL);
        tag.setDouble("tV", tV);
        tag.setDouble("tH", tH);
        ImmersiveEngineering.packetHandler.sendToAll((IMessage)new MessageTileSync(this, tag));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveMessageFromServer(NBTTagCompound message) {
        if (message.hasKey("targetEntity")) {
            Entity target = this.world.getEntityByID(message.getInteger("targetEntity"));
            if (target instanceof EntityLivingBase) {
                double dx = target.posX - (double)this.getPos().getX();
                double dy = target.posY - (double)this.getPos().getY();
                double dz = target.posZ - (double)this.getPos().getZ();
                EnumFacing f = null;
                f = this.facing.getAxis() == EnumFacing.Axis.Y ? (Math.abs(dz) > Math.abs(dx) ? (dz < 0.0 ? EnumFacing.NORTH : EnumFacing.SOUTH) : (dx < 0.0 ? EnumFacing.WEST : EnumFacing.EAST)) : (this.facing.getAxis() == EnumFacing.Axis.Z ? (Math.abs(dy) > Math.abs(dx) ? (dy < 0.0 ? EnumFacing.DOWN : EnumFacing.UP) : (dx < 0.0 ? EnumFacing.WEST : EnumFacing.EAST)) : (Math.abs(dy) > Math.abs(dz) ? (dy < 0.0 ? EnumFacing.DOWN : EnumFacing.UP) : (dz < 0.0 ? EnumFacing.NORTH : EnumFacing.SOUTH)));
                double verticalOffset = 1.0 + Utils.RAND.nextDouble() * 0.25;
                Vec3d coilPos = new Vec3d((Vec3i)this.getPos()).addVector(0.5, 0.5, 0.5);
                coilPos = coilPos.addVector((double)this.facing.getFrontOffsetX() * verticalOffset, (double)this.facing.getFrontOffsetY() * verticalOffset, (double)this.facing.getFrontOffsetZ() * verticalOffset);
                if (f != null) {
                    coilPos = coilPos.addVector((double)f.getFrontOffsetX() * 0.375, (double)f.getFrontOffsetY() * 0.375, (double)f.getFrontOffsetZ() * 0.375);
                    f = f.rotateAround(this.facing.getAxis());
                    double dShift = (Utils.RAND.nextDouble() - 0.5) * 0.75;
                    coilPos = coilPos.addVector((double)f.getFrontOffsetX() * dShift, (double)f.getFrontOffsetY() * dShift, (double)f.getFrontOffsetZ() * dShift);
                }
                this.addAnimation(new LightningAnimation(coilPos, (EntityLivingBase)target));
                TileEntityTeslaCoil tileEntityTeslaCoil = this;
                synchronized (tileEntityTeslaCoil) {
                    this.soundPos = coilPos;
                }
            }
        } else if (message.hasKey("tL")) {
            this.initFreeStreamer(message.getDouble("tL"), message.getDouble("tV"), message.getDouble("tH"));
        }
    }

    public void initFreeStreamer(double tL, double tV, double tH) {
        double ty;
        double tx = this.facing.getAxis() == EnumFacing.Axis.X ? tL : tH;
        double d = ty = this.facing.getAxis() == EnumFacing.Axis.Y ? tL : tV;
        double tz = this.facing.getAxis() == EnumFacing.Axis.Y ? tV : (this.facing.getAxis() == EnumFacing.Axis.X ? tH : tL);
        EnumFacing f = null;
        f = this.facing.getAxis() == EnumFacing.Axis.Y ? (Math.abs(tz) > Math.abs(tx) ? (tz < 0.0 ? EnumFacing.NORTH : EnumFacing.SOUTH) : (tx < 0.0 ? EnumFacing.WEST : EnumFacing.EAST)) : (this.facing.getAxis() == EnumFacing.Axis.Z ? (Math.abs(ty) > Math.abs(tx) ? (ty < 0.0 ? EnumFacing.DOWN : EnumFacing.UP) : (tx < 0.0 ? EnumFacing.WEST : EnumFacing.EAST)) : (Math.abs(ty) > Math.abs(tz) ? (ty < 0.0 ? EnumFacing.DOWN : EnumFacing.UP) : (tz < 0.0 ? EnumFacing.NORTH : EnumFacing.SOUTH)));
        double verticalOffset = 1.0 + Utils.RAND.nextDouble() * 0.25;
        Vec3d coilPos = new Vec3d((Vec3i)this.getPos()).addVector(0.5, 0.5, 0.5);
        coilPos = coilPos.addVector((double)this.facing.getFrontOffsetX() * verticalOffset, (double)this.facing.getFrontOffsetY() * verticalOffset, (double)this.facing.getFrontOffsetZ() * verticalOffset);
        coilPos = coilPos.addVector((double)f.getFrontOffsetX() * 0.375, (double)f.getFrontOffsetY() * 0.375, (double)f.getFrontOffsetZ() * 0.375);
        f = f.rotateAround(this.facing.getAxis());
        double dShift = (Utils.RAND.nextDouble() - 0.5) * 0.75;
        coilPos = coilPos.addVector((double)f.getFrontOffsetX() * dShift, (double)f.getFrontOffsetY() * dShift, (double)f.getFrontOffsetZ() * dShift);
        this.addAnimation(new LightningAnimation(coilPos, new Vec3d((Vec3i)this.getPos()).addVector(tx, ty, tz)));
        this.world.playSound((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ(), IESounds.tesla, SoundCategory.BLOCKS, 2.5f, 0.5f + Utils.RAND.nextFloat(), true);
    }

    private void addAnimation(LightningAnimation ani) {
        Minecraft.getMinecraft().addScheduledTask(() -> effectMap.put((Object)this.getPos(), (Object)ani));
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.dummy = nbt.getBoolean("dummy");
        this.redstoneControlInverted = nbt.getBoolean("redstoneInverted");
        this.lowPower = nbt.getBoolean("lowPower");
        this.facing = EnumFacing.getFront((int)nbt.getInteger("facing"));
        this.energyStorage.readFromNBT(nbt);
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.setBoolean("dummy", this.dummy);
        nbt.setBoolean("redstoneInverted", this.redstoneControlInverted);
        nbt.setBoolean("lowPower", this.lowPower);
        if (this.facing != null) {
            nbt.setInteger("facing", this.facing.ordinal());
        }
        this.energyStorage.writeToNBT(nbt);
    }

    @Override
    public float[] getBlockBounds() {
        if (!this.dummy) {
            return null;
        }
        switch (this.facing) {
            case DOWN: {
                return new float[]{0.125f, 0.125f, 0.125f, 0.875f, 1.0f, 0.875f};
            }
            case UP: {
                return new float[]{0.125f, 0.0f, 0.125f, 0.875f, 0.875f, 0.875f};
            }
            case NORTH: {
                return new float[]{0.125f, 0.125f, 0.125f, 0.875f, 0.875f, 1.0f};
            }
            case SOUTH: {
                return new float[]{0.125f, 0.125f, 0.0f, 0.875f, 0.875f, 0.875f};
            }
            case WEST: {
                return new float[]{0.125f, 0.125f, 0.125f, 1.0f, 0.875f, 0.875f};
            }
            case EAST: {
                return new float[]{0.0f, 0.125f, 0.125f, 0.875f, 0.875f, 0.875f};
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderBB == null) {
            this.renderBB = new AxisAlignedBB(this.getPos().add(-8, -8, -8), this.getPos().add(8, 8, 8));
        }
        return this.renderBB;
    }

    @Override
    public boolean hammerUseSide(EnumFacing side, EntityPlayer player, float hitX, float hitY, float hitZ) {
        if (this.dummy) {
            TileEntity te = this.world.getTileEntity(this.getPos().offset(this.facing, -1));
            if (te instanceof TileEntityTeslaCoil) {
                return ((TileEntityTeslaCoil)te).hammerUseSide(side, player, hitX, hitY, hitZ);
            }
            return false;
        }
        if (player.isSneaking()) {
            int energyDrain = Config.IEConfig.Machines.teslacoil_consumption;
            if (this.lowPower) {
                energyDrain /= 2;
            }
            if (this.canRun(energyDrain)) {
                player.attackEntityFrom(IEDamageSources.causeTeslaPrimaryDamage(), Float.MAX_VALUE);
            } else {
                this.lowPower = !this.lowPower;
                ChatUtils.sendServerNoSpamMessages(player, new ITextComponent[]{new TextComponentTranslation("chat.immersiveengineering.info.tesla." + (this.lowPower ? "lowPower" : "highPower"), new Object[0])});
                this.markDirty();
            }
        } else {
            this.redstoneControlInverted = !this.redstoneControlInverted;
            ChatUtils.sendServerNoSpamMessages(player, new ITextComponent[]{new TextComponentTranslation("chat.immersiveengineering.info.rsControl." + (this.redstoneControlInverted ? "invertedOn" : "invertedOff"), new Object[0])});
            this.markDirty();
            this.markContainingBlockForUpdate(null);
        }
        return true;
    }

    @Override
    public EnumFacing getFacing() {
        return this.facing;
    }

    @Override
    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    @Override
    public int getFacingLimitation() {
        return 0;
    }

    @Override
    public boolean mirrorFacingOnPlacement(EntityLivingBase placer) {
        return false;
    }

    @Override
    public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity) {
        return false;
    }

    @Override
    public boolean canRotate(EnumFacing axis) {
        return false;
    }

    @Override
    public boolean isDummy() {
        return this.dummy;
    }

    @Override
    public void placeDummies(BlockPos pos, IBlockState state, EnumFacing side, float hitX, float hitY, float hitZ) {
        this.world.setBlockState(pos.offset(this.facing), state);
        ((TileEntityTeslaCoil)this.world.getTileEntity((BlockPos)pos.offset((EnumFacing)this.facing))).dummy = true;
        ((TileEntityTeslaCoil)this.world.getTileEntity((BlockPos)pos.offset((EnumFacing)this.facing))).facing = this.facing;
    }

    @Override
    public void breakDummies(BlockPos pos, IBlockState state) {
        for (int i = 0; i <= 1; ++i) {
            if (!(this.world.getTileEntity(this.getPos().offset(this.facing, this.dummy ? -1 : 0).offset(this.facing, i)) instanceof TileEntityTeslaCoil)) continue;
            this.world.setBlockToAir(this.getPos().offset(this.facing, this.dummy ? -1 : 0).offset(this.facing, i));
        }
    }

    @Override
    @Nonnull
    public FluxStorage getFluxStorage() {
        TileEntity te;
        if (this.dummy && (te = this.world.getTileEntity(this.getPos().offset(this.facing, -1))) instanceof TileEntityTeslaCoil) {
            return ((TileEntityTeslaCoil)te).getFluxStorage();
        }
        return this.energyStorage;
    }

    @Override
    @Nonnull
    public IEEnums.SideConfig getEnergySideConfig(EnumFacing facing) {
        return !this.dummy ? IEEnums.SideConfig.INPUT : IEEnums.SideConfig.NONE;
    }

    @Override
    public EnergyHelper.IEForgeEnergyWrapper getCapabilityWrapper(EnumFacing facing) {
        if (!this.dummy) {
            return this.wrappers[facing == null ? 0 : facing.ordinal()];
        }
        return null;
    }

    public boolean canRun(int energyDrain) {
        return this.world.isBlockIndirectlyGettingPowered(this.getPos()) > 0 ^ this.redstoneControlInverted && this.energyStorage.getEnergyStored() >= energyDrain;
    }

    public static class LightningAnimation {
        public Vec3d startPos;
        public EntityLivingBase targetEntity;
        public Vec3d targetPos;
        private int lifeTimer = 20;
        private final int ANIMATION_MAX = 4;
        private int animationTimer = 4;
        public List<Vec3d> subPoints = new ArrayList<Vec3d>();
        private Vec3d prevTarget;

        public LightningAnimation(Vec3d startPos, EntityLivingBase targetEntity) {
            this.startPos = startPos;
            this.targetEntity = targetEntity;
        }

        public LightningAnimation(Vec3d startPos, Vec3d targetPos) {
            this.startPos = startPos;
            this.targetPos = targetPos;
        }

        public boolean shoudlRecalculateLightning() {
            Vec3d end;
            if (this.subPoints.isEmpty() || this.animationTimer == 0) {
                return true;
            }
            boolean b = false;
            Vec3d vec3d = end = this.targetEntity != null ? this.targetEntity.getPositionVector() : this.targetPos;
            if (this.prevTarget != null) {
                b = this.prevTarget.distanceTo(end) > 1.0;
            }
            this.prevTarget = end;
            return b;
        }

        public void createLightning(Random rand) {
            this.subPoints.clear();
            Vec3d end = this.targetEntity != null ? this.targetEntity.getPositionVector() : this.targetPos;
            Vec3d dist = end.subtract(this.startPos);
            double points = 12.0;
            int i = 0;
            while ((double)i < points) {
                Vec3d sub = this.startPos.addVector(dist.x / points * (double)i, dist.y / points * (double)i, dist.z / points * (double)i);
                double fixPointDist = ((double)i - points / 2.0) / (points / 2.0);
                double mod = 1.0 - 0.75 * Math.abs(fixPointDist);
                double offX = (rand.nextDouble() - 0.5) * mod;
                double offY = (rand.nextDouble() - 0.5) * mod;
                double offZ = (rand.nextDouble() - 0.5) * mod;
                if (fixPointDist < 0.0) {
                    offY += 0.75 * mod * (0.75 + fixPointDist);
                    offX = sub.x - this.startPos.x < 0.0 ? -Math.abs(offX) : Math.abs(offX);
                    offZ = sub.z - this.startPos.z < 0.0 ? -Math.abs(offZ) : Math.abs(offZ);
                } else {
                    offY = Math.min(end.y + 1.0 * (1.0 - fixPointDist) * -Math.signum(dist.y), offY);
                    offX = Math.abs(offX) * (end.x - sub.x);
                    offZ = Math.abs(offZ) * (end.z - sub.z);
                }
                this.subPoints.add(sub.addVector(offX, offY, offZ));
                ++i;
            }
            this.animationTimer = 4 + Utils.RAND.nextInt(5) - 2;
        }

        public boolean tick() {
            --this.animationTimer;
            --this.lifeTimer;
            return this.lifeTimer <= 0;
        }
    }
}

