/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.crafting.SqueezerRecipe;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockMetal;
import blusunrize.immersiveengineering.common.blocks.multiblocks.MultiblockSqueezer;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntitySqueezer
extends TileEntityMultiblockMetal<TileEntitySqueezer, SqueezerRecipe>
implements IEBlockInterfaces.IAdvancedSelectionBounds,
IEBlockInterfaces.IAdvancedCollisionBounds,
IEBlockInterfaces.IGuiTile {
    public FluidTank[] tanks = new FluidTank[]{new FluidTank(24000)};
    public NonNullList<ItemStack> inventory = NonNullList.withSize((int)11, (Object)ItemStack.EMPTY);
    public float animation_piston = 0.0f;
    public boolean animation_down = true;
    IItemHandler insertionHandler = new IEInventoryHandler(8, (IIEInventory)this, 0, new boolean[]{true, true, true, true, true, true, true, true}, new boolean[8]);
    IItemHandler extractionHandler = new IEInventoryHandler(1, (IIEInventory)this, 8, new boolean[1], new boolean[]{true});

    public TileEntitySqueezer() {
        super(MultiblockSqueezer.instance, new int[]{3, 3, 3}, 16000, true);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.tanks[0].readFromNBT(nbt.getCompoundTag("tank"));
        if (!descPacket) {
            this.inventory = Utils.readInventory(nbt.getTagList("inventory", 10), 11);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        NBTTagCompound tankTag = this.tanks[0].writeToNBT(new NBTTagCompound());
        nbt.setTag("tank", (NBTBase)tankTag);
        if (!descPacket) {
            nbt.setTag("inventory", (NBTBase)Utils.writeInventory(this.inventory));
        }
    }

    @Override
    public void update() {
        super.update();
        if (this.isDummy() || this.isRSDisabled()) {
            return;
        }
        if (this.world.isRemote) {
            if (this.processQueue.isEmpty() && (double)this.animation_piston < 0.6875) {
                this.animation_piston = Math.min(0.6875f, this.animation_piston + 0.03125f);
            } else if (this.shouldRenderAsActive()) {
                this.animation_piston = this.animation_down ? Math.max(0.0f, this.animation_piston - 0.03125f) : Math.min(0.6875f, this.animation_piston + 0.03125f);
                if (this.animation_piston <= 0.0f && this.animation_down) {
                    this.animation_down = false;
                } else if ((double)this.animation_piston >= 0.6875 && !this.animation_down) {
                    this.animation_down = true;
                }
            }
        } else {
            BlockPos outputPos;
            TileEntity outputTile;
            EnumFacing fw;
            boolean update = false;
            if (this.energyStorage.getEnergyStored() > 0 && this.processQueue.size() < this.getProcessQueueMaxLength()) {
                int n;
                Integer[] process2;
                final int[] usedInvSlots = new int[8];
                for (Integer[] process2 : this.processQueue) {
                    if (!(process2 instanceof TileEntityMultiblockMetal.MultiblockProcessInMachine)) continue;
                    int[] nArray = ((TileEntityMultiblockMetal.MultiblockProcessInMachine)process2).inputSlots;
                    n = nArray.length;
                    for (int i = 0; i < n; ++i) {
                        int i2;
                        int n2 = i2 = nArray[i];
                        usedInvSlots[n2] = usedInvSlots[n2] + 1;
                    }
                }
                Integer[] preferredSlots = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7};
                Arrays.sort(preferredSlots, 0, 8, new Comparator<Integer>(){

                    @Override
                    public int compare(Integer arg0, Integer arg1) {
                        return Integer.compare(usedInvSlots[arg0], usedInvSlots[arg1]);
                    }
                });
                process2 = preferredSlots;
                int n3 = process2.length;
                for (n = 0; n < n3; ++n) {
                    TileEntityMultiblockMetal.MultiblockProcessInMachine<SqueezerRecipe> process3;
                    SqueezerRecipe recipe;
                    int slot = process2[n];
                    ItemStack stack = (ItemStack)this.getInventory().get(slot);
                    if (!stack.isEmpty()) {
                        stack = stack.copy();
                        stack.shrink(usedInvSlots[slot]);
                    }
                    if (stack.isEmpty() || stack.getCount() <= 0 || (recipe = this.findRecipeForInsertion(stack)) == null || !this.addProcessToQueue(process3 = new TileEntityMultiblockMetal.MultiblockProcessInMachine<SqueezerRecipe>(recipe, slot), true)) continue;
                    this.addProcessToQueue(process3, false);
                    update = true;
                }
            }
            EnumFacing enumFacing = fw = this.mirrored ? this.facing.rotateYCCW() : this.facing.rotateY();
            if (this.tanks[0].getFluidAmount() > 0) {
                ItemStack full;
                ItemStack empty;
                int accepted;
                FluidStack out = Utils.copyFluidStackWithAmount(this.tanks[0].getFluid(), Math.min(this.tanks[0].getFluidAmount(), 80), false);
                BlockPos outputPos2 = this.getPos().add(0, -1, 0).offset(fw, 2);
                IFluidHandler output = FluidUtil.getFluidHandler((World)this.world, (BlockPos)outputPos2, (EnumFacing)fw.getOpposite());
                if (output != null && (accepted = output.fill(out, false)) > 0) {
                    int drained = output.fill(Utils.copyFluidStackWithAmount(out, Math.min(out.amount, accepted), false), true);
                    this.tanks[0].drain(drained, true);
                    update = true;
                }
                if (!(empty = (ItemStack)this.getInventory().get(9)).isEmpty() && this.tanks[0].getFluidAmount() > 0 && !(full = Utils.fillFluidContainer((IFluidHandler)this.tanks[0], empty, (ItemStack)this.getInventory().get(10), null)).isEmpty()) {
                    if (!((ItemStack)this.getInventory().get(10)).isEmpty() && OreDictionary.itemMatches((ItemStack)full, (ItemStack)((ItemStack)this.getInventory().get(10)), (boolean)true)) {
                        ((ItemStack)this.getInventory().get(10)).grow(full.getCount());
                    } else {
                        this.getInventory().set(10, (Object)full);
                    }
                    ((ItemStack)this.inventory.get(9)).shrink(1);
                    if (((ItemStack)this.inventory.get(9)).getCount() <= 0) {
                        this.inventory.set(9, (Object)ItemStack.EMPTY);
                    }
                }
            }
            if (!((ItemStack)this.inventory.get(8)).isEmpty() && this.world.getTotalWorldTime() % 8L == 0L && (outputTile = Utils.getExistingTileEntity(this.world, outputPos = this.getPos().offset(fw))) != null) {
                ItemStack stack = Utils.copyStackWithAmount((ItemStack)this.inventory.get(8), 1);
                if ((stack = Utils.insertStackIntoInventory(outputTile, stack, fw.getOpposite())).isEmpty()) {
                    ((ItemStack)this.inventory.get(8)).shrink(1);
                    if (((ItemStack)this.inventory.get(8)).getCount() <= 0) {
                        this.inventory.set(8, (Object)ItemStack.EMPTY);
                    }
                }
            }
            if (update) {
                this.markDirty();
                this.markContainingBlockForUpdate(null);
            }
        }
    }

    @Override
    public float[] getBlockBounds() {
        if (this.pos > 0 && this.pos < 9 && this.pos != 5) {
            return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f};
        }
        if (this.pos == 11) {
            return new float[]{this.facing == EnumFacing.WEST ? 0.5f : 0.0f, 0.0f, this.facing == EnumFacing.NORTH ? 0.5f : 0.0f, this.facing == EnumFacing.EAST ? 0.5f : 1.0f, 1.0f, this.facing == EnumFacing.SOUTH ? 0.5f : 1.0f};
        }
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    @Override
    public List<AxisAlignedBB> getAdvancedSelectionBounds() {
        EnumFacing fl = this.facing;
        EnumFacing fw = this.facing.rotateY();
        if (this.mirrored) {
            fw = fw.getOpposite();
        }
        if (this.pos == 2) {
            float minZ;
            float maxX;
            float minX;
            ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ())});
            float f = fl == EnumFacing.WEST ? 0.625f : (minX = fl == EnumFacing.EAST ? 0.125f : 0.125f);
            float f2 = fl == EnumFacing.EAST ? 0.375f : (maxX = fl == EnumFacing.WEST ? 0.875f : 0.25f);
            float f3 = fl == EnumFacing.NORTH ? 0.625f : (minZ = fl == EnumFacing.SOUTH ? 0.125f : 0.125f);
            float maxZ = fl == EnumFacing.SOUTH ? 0.375f : (fl == EnumFacing.NORTH ? 0.875f : 0.25f);
            list.add(new AxisAlignedBB((double)minX, 0.5, (double)minZ, (double)maxX, 1.0, (double)maxZ).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ()));
            float f4 = fl == EnumFacing.WEST ? 0.625f : (minX = fl == EnumFacing.EAST ? 0.125f : 0.75f);
            float f5 = fl == EnumFacing.EAST ? 0.375f : (maxX = fl == EnumFacing.WEST ? 0.875f : 0.875f);
            float f6 = fl == EnumFacing.NORTH ? 0.625f : (minZ = fl == EnumFacing.SOUTH ? 0.125f : 0.75f);
            maxZ = fl == EnumFacing.SOUTH ? 0.375f : (fl == EnumFacing.NORTH ? 0.875f : 0.875f);
            list.add(new AxisAlignedBB((double)minX, 0.5, (double)minZ, (double)maxX, 1.0, (double)maxZ).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ()));
            return list;
        }
        if (this.pos == 3 || this.pos == 4 || this.pos == 6 || this.pos == 7) {
            float minZ;
            float maxX;
            float minX;
            ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ())});
            if (this.pos > 5) {
                fl = fl.getOpposite();
            }
            if (this.pos % 3 == 1) {
                fw = fw.getOpposite();
            }
            float f = fl == EnumFacing.WEST ? 0.6875f : (fl == EnumFacing.EAST ? 0.0625f : (minX = fw == EnumFacing.EAST ? 0.0625f : 0.6875f));
            float f7 = fl == EnumFacing.EAST ? 0.3125f : (fl == EnumFacing.WEST ? 0.9375f : (maxX = fw == EnumFacing.EAST ? 0.3125f : 0.9375f));
            float f8 = fl == EnumFacing.NORTH ? 0.6875f : (fl == EnumFacing.SOUTH ? 0.0625f : (minZ = fw == EnumFacing.SOUTH ? 0.0625f : 0.6875f));
            float maxZ = fl == EnumFacing.SOUTH ? 0.3125f : (fl == EnumFacing.NORTH ? 0.9375f : (fw == EnumFacing.SOUTH ? 0.3125f : 0.9375f));
            list.add(new AxisAlignedBB((double)minX, 0.5, (double)minZ, (double)maxX, 1.0, (double)maxZ).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ()));
            if (this.pos == 4) {
                float f9 = fl == EnumFacing.WEST ? 0.375f : (fl == EnumFacing.EAST ? 0.625f : (minX = fw == EnumFacing.WEST ? -0.125f : 0.0f));
                float f10 = fl == EnumFacing.EAST ? 0.375f : (fl == EnumFacing.WEST ? 0.625f : (maxX = fw == EnumFacing.EAST ? 1.125f : 1.0f));
                float f11 = fl == EnumFacing.NORTH ? 0.375f : (fl == EnumFacing.SOUTH ? 0.625f : (minZ = fw == EnumFacing.NORTH ? -0.125f : 0.0f));
                maxZ = fl == EnumFacing.SOUTH ? 0.375f : (fl == EnumFacing.NORTH ? 0.625f : (fw == EnumFacing.SOUTH ? 1.125f : 1.0f));
                list.add(new AxisAlignedBB((double)minX, 0.5, (double)minZ, (double)maxX, 0.75, (double)maxZ).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ()));
                float f12 = fl == EnumFacing.WEST ? -0.125f : (fl == EnumFacing.EAST ? 0.625f : (minX = fw == EnumFacing.WEST ? -0.125f : 0.875f));
                float f13 = fl == EnumFacing.EAST ? 1.125f : (fl == EnumFacing.WEST ? 0.375f : (maxX = fw == EnumFacing.EAST ? 1.125f : 0.125f));
                float f14 = fl == EnumFacing.NORTH ? -0.125f : (fl == EnumFacing.SOUTH ? 0.625f : (minZ = fw == EnumFacing.NORTH ? -0.125f : 0.875f));
                maxZ = fl == EnumFacing.SOUTH ? 1.25f : (fl == EnumFacing.NORTH ? 0.375f : (fw == EnumFacing.SOUTH ? 1.125f : 0.125f));
                list.add(new AxisAlignedBB((double)minX, 0.5, (double)minZ, (double)maxX, 0.75, (double)maxZ).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ()));
                float f15 = fl == EnumFacing.WEST ? -0.125f : (fl == EnumFacing.EAST ? 0.875f : (minX = fw == EnumFacing.WEST ? -0.125f : 0.875f));
                float f16 = fl == EnumFacing.EAST ? 1.125f : (fl == EnumFacing.WEST ? 0.125f : (maxX = fw == EnumFacing.EAST ? 1.125f : 0.125f));
                float f17 = fl == EnumFacing.NORTH ? -0.125f : (fl == EnumFacing.SOUTH ? 0.875f : (minZ = fw == EnumFacing.NORTH ? -0.125f : 0.875f));
                maxZ = fl == EnumFacing.SOUTH ? 1.25f : (fl == EnumFacing.NORTH ? 0.125f : (fw == EnumFacing.SOUTH ? 1.125f : 0.125f));
                list.add(new AxisAlignedBB((double)minX, 0.75, (double)minZ, (double)maxX, 1.0, (double)maxZ).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ()));
            }
            return list;
        }
        if (this.pos == 12 || this.pos == 13 || this.pos == 15 || this.pos == 16 || this.pos == 21 || this.pos == 22 || this.pos == 24 || this.pos == 25) {
            float minZ;
            float maxX;
            float minX;
            float maxY;
            ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>(2);
            if (this.pos < 18) {
                list.add(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ()));
            }
            if (this.pos % 9 > 5) {
                fl = fl.getOpposite();
            }
            if (this.pos % 3 == 1) {
                fw = fw.getOpposite();
            }
            float minY = this.pos < 18 ? 0.125f : -0.875f;
            float f = maxY = this.pos < 18 ? 1.125f : 0.125f;
            float f18 = fl == EnumFacing.WEST ? 0.84375f : (fl == EnumFacing.EAST ? 0.0f : (minX = fw == EnumFacing.EAST ? 0.0f : 0.84375f));
            float f19 = fl == EnumFacing.EAST ? 0.15625f : (fl == EnumFacing.WEST ? 1.0f : (maxX = fw == EnumFacing.EAST ? 0.15625f : 1.0f));
            float f20 = fl == EnumFacing.NORTH ? 0.84375f : (fl == EnumFacing.SOUTH ? 0.0f : (minZ = fw == EnumFacing.SOUTH ? 0.0f : 0.84375f));
            float maxZ = fl == EnumFacing.SOUTH ? 0.15625f : (fl == EnumFacing.NORTH ? 1.0f : (fw == EnumFacing.SOUTH ? 0.15625f : 1.0f));
            list.add(new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ()));
            float f21 = fl == EnumFacing.WEST ? 0.0f : (fl == EnumFacing.EAST ? 0.15625f : (minX = fw == EnumFacing.EAST ? 0.0625f : 0.8125f));
            float f22 = fl == EnumFacing.EAST ? 1.0f : (fl == EnumFacing.WEST ? 0.84375f : (maxX = fw == EnumFacing.EAST ? 0.1875f : 0.9375f));
            float f23 = fl == EnumFacing.NORTH ? 0.0f : (fl == EnumFacing.SOUTH ? 0.15625f : (minZ = fw == EnumFacing.SOUTH ? 0.0625f : 0.8125f));
            maxZ = fl == EnumFacing.SOUTH ? 1.0f : (fl == EnumFacing.NORTH ? 0.84375f : (fw == EnumFacing.SOUTH ? 0.1875f : 0.9375f));
            list.add(new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ()));
            float f24 = fl == EnumFacing.WEST ? 0.8125f : (fl == EnumFacing.EAST ? 0.0625f : (minX = fw == EnumFacing.EAST ? 0.15625f : 0.0f));
            float f25 = fl == EnumFacing.EAST ? 0.1875f : (fl == EnumFacing.WEST ? 0.9375f : (maxX = fw == EnumFacing.EAST ? 1.0f : 0.84375f));
            float f26 = fl == EnumFacing.NORTH ? 0.8125f : (fl == EnumFacing.SOUTH ? 0.0625f : (minZ = fw == EnumFacing.SOUTH ? 0.15625f : 0.0f));
            maxZ = fl == EnumFacing.SOUTH ? 0.1875f : (fl == EnumFacing.NORTH ? 0.9375f : (fw == EnumFacing.SOUTH ? 1.0f : 0.84375f));
            list.add(new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ()));
            if (this.pos > 18) {
                float f27 = fl == EnumFacing.WEST ? -0.25f : (fl == EnumFacing.EAST ? 1.25f : (minX = fw == EnumFacing.EAST ? 0.75f : -0.25f));
                float f28 = fl == EnumFacing.EAST ? 0.75f : (fl == EnumFacing.WEST ? 0.25f : (maxX = fw == EnumFacing.EAST ? 1.25f : 0.25f));
                float f29 = fl == EnumFacing.NORTH ? -0.25f : (fl == EnumFacing.SOUTH ? 1.25f : (minZ = fw == EnumFacing.SOUTH ? 0.75f : -0.25f));
                maxZ = fl == EnumFacing.SOUTH ? 0.75f : (fl == EnumFacing.NORTH ? 0.25f : (fw == EnumFacing.SOUTH ? 1.25f : 0.25f));
                list.add(new AxisAlignedBB((double)minX, 0.375, (double)minZ, (double)maxX, 0.9375, (double)maxZ).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ()));
            }
            return list;
        }
        return null;
    }

    @Override
    public boolean isOverrideBox(AxisAlignedBB box, EntityPlayer player, RayTraceResult mop, ArrayList<AxisAlignedBB> list) {
        return false;
    }

    @Override
    public List<AxisAlignedBB> getAdvancedColisionBounds() {
        return this.getAdvancedSelectionBounds();
    }

    @Override
    public int[] getEnergyPos() {
        return new int[]{9};
    }

    @Override
    public int[] getRedstonePos() {
        return new int[]{11};
    }

    @Override
    public boolean isInWorldProcessingMachine() {
        return false;
    }

    @Override
    public boolean additionalCanProcessCheck(TileEntityMultiblockMetal.MultiblockProcess<SqueezerRecipe> process) {
        return true;
    }

    @Override
    public void doProcessOutput(ItemStack output) {
        BlockPos pos = this.getPos().offset(this.facing, 2);
        TileEntity inventoryTile = this.world.getTileEntity(pos);
        if (inventoryTile != null) {
            output = Utils.insertStackIntoInventory(inventoryTile, output, this.facing.getOpposite());
        }
        if (!output.isEmpty()) {
            Utils.dropStackAtPos(this.world, pos, output, this.facing);
        }
    }

    @Override
    public void doProcessFluidOutput(FluidStack output) {
    }

    @Override
    public void onProcessFinish(TileEntityMultiblockMetal.MultiblockProcess<SqueezerRecipe> process) {
    }

    @Override
    public int getMaxProcessPerTick() {
        return 8;
    }

    @Override
    public int getProcessQueueMaxLength() {
        return 8;
    }

    @Override
    public float getMinProcessDistance(TileEntityMultiblockMetal.MultiblockProcess<SqueezerRecipe> process) {
        return 0.0f;
    }

    @Override
    public int getComparatedSize() {
        return 8;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public int[] getOutputSlots() {
        return new int[]{8};
    }

    @Override
    public int[] getOutputTanks() {
        return new int[]{0};
    }

    @Override
    public IFluidTank[] getInternalTanks() {
        return this.tanks;
    }

    @Override
    protected IFluidTank[] getAccessibleFluidTanks(EnumFacing side) {
        TileEntitySqueezer master = (TileEntitySqueezer)this.master();
        if (master != null && this.pos == 5 && (side == null || side == (this.mirrored ? this.facing.rotateYCCW() : this.facing.rotateY()))) {
            return master.tanks;
        }
        return new FluidTank[0];
    }

    @Override
    protected boolean canFillTankFrom(int iTank, EnumFacing side, FluidStack resources) {
        return false;
    }

    @Override
    protected boolean canDrainTankFrom(int iTank, EnumFacing side) {
        return true;
    }

    @Override
    public void doGraphicalUpdates(int slot) {
        this.markDirty();
        this.markContainingBlockForUpdate(null);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if ((this.pos == 15 || this.pos == 13) && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.master() != null;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if ((this.pos == 15 || this.pos == 13) && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            TileEntitySqueezer master = (TileEntitySqueezer)this.master();
            if (master == null) {
                return null;
            }
            if (this.pos == 15) {
                return (T)master.insertionHandler;
            }
            if (this.pos == 13) {
                return (T)master.extractionHandler;
            }
            return null;
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public SqueezerRecipe findRecipeForInsertion(ItemStack inserting) {
        return SqueezerRecipe.findRecipe(inserting);
    }

    @Override
    protected SqueezerRecipe readRecipeFromNBT(NBTTagCompound tag) {
        return SqueezerRecipe.loadFromNBT(tag);
    }

    @Override
    public boolean canOpenGui() {
        return this.formed;
    }

    @Override
    public int getGuiID() {
        return 7;
    }

    @Override
    public TileEntity getGuiMaster() {
        return this.master();
    }
}

