/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.BlockTypes_MetalsAll;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityMultiblockPart;
import blusunrize.immersiveengineering.common.blocks.wooden.BlockTypes_WoodenDecoration;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileEntitySilo
extends TileEntityMultiblockPart<TileEntitySilo>
implements IEBlockInterfaces.IComparatorOverride {
    public ItemStack identStack = ItemStack.EMPTY;
    public int storageAmount = 0;
    static int maxStorage = 41472;
    boolean lockItem = false;
    private int[] oldComps = new int[6];
    private int masterCompOld;
    private boolean forceUpdate = false;
    private static final int[] size = new int[]{7, 3, 3};
    @SideOnly(value=Side.CLIENT)
    private AxisAlignedBB renderAABB;
    IItemHandler insertionHandler = new SiloInventoryHandler(this);

    public TileEntitySilo() {
        super(size);
    }

    public void update() {
        ApiUtils.checkForNeedlessTicking(this);
        if (this.pos == 4 && !this.world.isRemote && !this.identStack.isEmpty() && this.storageAmount > 0 && this.world.isBlockIndirectlyGettingPowered(this.getPos()) > 0 && this.world.getTotalWorldTime() % 8L == 0L) {
            this.updateComparatorValuesPart1();
            for (EnumFacing f : EnumFacing.values()) {
                if (f == EnumFacing.UP) continue;
                TileEntity inventory = Utils.getExistingTileEntity(this.world, this.getPos().offset(f));
                ItemStack stack = Utils.copyStackWithAmount(this.identStack, 1);
                if (!(stack = Utils.insertStackIntoInventory(inventory, stack, f.getOpposite())).isEmpty()) continue;
                --this.storageAmount;
                if (this.storageAmount <= 0) {
                    this.identStack = ItemStack.EMPTY;
                }
                this.markDirty();
                this.markContainingBlockForUpdate(null);
                if (this.storageAmount <= 0) break;
            }
            this.updateComparatorValuesPart2();
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        if (nbt.hasKey("identStack")) {
            NBTTagCompound t = nbt.getCompoundTag("identStack");
            this.identStack = new ItemStack(t);
        } else {
            this.identStack = ItemStack.EMPTY;
        }
        this.storageAmount = nbt.getInteger("storageAmount");
        this.lockItem = nbt.getBoolean("lockItem");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        if (!this.identStack.isEmpty()) {
            NBTTagCompound t = this.identStack.writeToNBT(new NBTTagCompound());
            nbt.setTag("identStack", (NBTBase)t);
        }
        nbt.setInteger("storageAmount", this.storageAmount);
        nbt.setBoolean("lockItem", this.lockItem);
    }

    @Override
    protected IFluidTank[] getAccessibleFluidTanks(EnumFacing side) {
        return new FluidTank[0];
    }

    @Override
    protected boolean canFillTankFrom(int iTank, EnumFacing side, FluidStack resources) {
        return false;
    }

    @Override
    protected boolean canDrainTankFrom(int iTank, EnumFacing side) {
        return false;
    }

    @Override
    public float[] getBlockBounds() {
        if (this.pos == 0 || this.pos == 2 || this.pos == 6 || this.pos == 8) {
            float zMin;
            float xMax;
            float xMin;
            float f = (this.facing.getAxis() == EnumFacing.Axis.X ? this.pos > 2 ^ this.facing == EnumFacing.EAST : this.pos % 3 == 2 ^ this.facing == EnumFacing.SOUTH) ? 0.75f : (xMin = 0.0f);
            float f2 = (this.facing.getAxis() == EnumFacing.Axis.X ? this.pos < 3 ^ this.facing == EnumFacing.EAST : this.pos % 3 == 0 ^ this.facing == EnumFacing.SOUTH) ? 0.25f : (xMax = 1.0f);
            float f3 = (this.facing.getAxis() == EnumFacing.Axis.X ? this.pos % 3 == 2 ^ this.facing == EnumFacing.EAST : this.pos < 3 ^ this.facing == EnumFacing.SOUTH) ? 0.75f : (zMin = 0.0f);
            float zMax = (this.facing.getAxis() == EnumFacing.Axis.X ? this.pos % 3 == 0 ^ this.facing == EnumFacing.EAST : this.pos > 2 ^ this.facing == EnumFacing.SOUTH) ? 0.25f : 1.0f;
            return new float[]{xMin, 0.0f, zMin, xMax, 1.0f, zMax};
        }
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    @Override
    public ItemStack getOriginalBlock() {
        return this.pos == 0 || this.pos == 2 || this.pos == 6 || this.pos == 8 ? new ItemStack((Block)IEContent.blockWoodenDecoration, 1, BlockTypes_WoodenDecoration.FENCE.getMeta()) : new ItemStack((Block)IEContent.blockSheetmetal, 1, BlockTypes_MetalsAll.IRON.getMeta());
    }

    @Override
    public BlockPos getOrigin() {
        return this.getPos().add(-this.offset[0], -this.offset[1], -this.offset[2]).offset(this.facing.rotateYCCW()).offset(this.facing.getOpposite());
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = this.pos == 4 ? new AxisAlignedBB(this.getPos().add(-1, 0, -1), this.getPos().add(2, 7, 2)) : new AxisAlignedBB(this.getPos(), this.getPos());
        }
        return this.renderAABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double getMaxRenderDistanceSquared() {
        return super.getMaxRenderDistanceSquared() * Config.IEConfig.increasedTileRenderdistance;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if ((this.pos == 4 || this.pos == 58) && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if ((this.pos == 4 || this.pos == 58) && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.insertionHandler;
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public int getComparatorInputOverride() {
        if (this.pos == 4) {
            return 15 * this.storageAmount / maxStorage;
        }
        TileEntitySilo master = (TileEntitySilo)this.master();
        if (this.offset[1] >= 1 && this.offset[1] <= 6 && master != null) {
            int layer = this.offset[1] - 1;
            int vol = maxStorage / 6;
            int filled = master.storageAmount - layer * vol;
            int ret = Math.min(15, Math.max(0, 15 * filled / vol));
            return ret;
        }
        return 0;
    }

    private void updateComparatorValuesPart1() {
        int vol = maxStorage / 6;
        for (int i = 0; i < 6; ++i) {
            int filled = this.storageAmount - i * vol;
            this.oldComps[i] = Math.min(15, Math.max(15 * filled / vol, 0));
        }
        this.masterCompOld = 15 * this.storageAmount / maxStorage;
    }

    private void updateComparatorValuesPart2() {
        int vol = maxStorage / 6;
        if (15 * this.storageAmount / maxStorage != this.masterCompOld) {
            this.world.notifyNeighborsOfStateChange(this.getPos(), this.getBlockType(), true);
        }
        for (int i = 0; i < 6; ++i) {
            int filled = this.storageAmount - i * vol;
            int now = Math.min(15, Math.max(15 * filled / vol, 0));
            if (now == this.oldComps[i]) continue;
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos pos = this.getPos().add(-this.offset[0] + x, -this.offset[1] + i + 1, -this.offset[2] + z);
                    this.world.notifyNeighborsOfStateChange(pos, this.world.getBlockState(pos).getBlock(), true);
                }
            }
        }
    }

    public static class SiloInventoryHandler
    implements IItemHandler {
        TileEntitySilo silo;

        public SiloInventoryHandler(TileEntitySilo silo) {
            this.silo = silo;
        }

        public int getSlots() {
            return 2;
        }

        public ItemStack getStackInSlot(int slot) {
            if (slot == 0) {
                return ItemStack.EMPTY;
            }
            int maxSize = Math.min(this.silo.storageAmount, this.silo.identStack.getMaxStackSize());
            return ApiUtils.copyStackWithAmount(this.silo.identStack, maxSize);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            stack = stack.copy();
            TileEntitySilo silo = (TileEntitySilo)this.silo.master();
            int space = maxStorage - silo.storageAmount;
            if (slot != 0 || space < 1 || stack.isEmpty() || !silo.identStack.isEmpty() && !ItemHandlerHelper.canItemStacksStack((ItemStack)silo.identStack, (ItemStack)stack)) {
                return stack;
            }
            int accepted = Math.min(space, stack.getCount());
            if (!simulate) {
                silo.updateComparatorValuesPart1();
                silo.storageAmount += accepted;
                if (silo.identStack.isEmpty()) {
                    silo.identStack = stack.copy();
                }
                silo.markDirty();
                silo.markContainingBlockForUpdate(null);
                silo.updateComparatorValuesPart2();
            }
            stack.shrink(accepted);
            if (stack.getCount() < 1) {
                stack = ItemStack.EMPTY;
            }
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            TileEntitySilo silo = (TileEntitySilo)this.silo.master();
            if (slot != 1 || silo.storageAmount < 1 || amount < 1 || silo.identStack.isEmpty()) {
                return ItemStack.EMPTY;
            }
            ItemStack out = silo.storageAmount >= amount ? Utils.copyStackWithAmount(silo.identStack, amount) : Utils.copyStackWithAmount(silo.identStack, silo.storageAmount);
            if (!simulate) {
                silo.updateComparatorValuesPart1();
                silo.storageAmount -= out.getCount();
                if (silo.storageAmount <= 0 && !silo.lockItem) {
                    silo.identStack = ItemStack.EMPTY;
                }
                silo.markDirty();
                silo.markContainingBlockForUpdate(null);
                silo.updateComparatorValuesPart2();
            }
            return out;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }
    }
}

