/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorage;
import blusunrize.immersiveengineering.api.tool.ExcavatorHandler;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntitySampleDrill
extends TileEntityIEBase
implements ITickable,
EnergyHelper.IIEInternalFluxHandler,
IEBlockInterfaces.IHasDummyBlocks,
IEBlockInterfaces.IPlayerInteraction,
IEBlockInterfaces.IHasObjProperty {
    public FluxStorage energyStorage = new FluxStorage(8000);
    public int dummy = 0;
    public int process = 0;
    public boolean active = false;
    @Nonnull
    public ItemStack sample = ItemStack.EMPTY;
    @SideOnly(value=Side.CLIENT)
    private AxisAlignedBB renderAABB;
    EnergyHelper.IEForgeEnergyWrapper[] wrappers = new EnergyHelper.IEForgeEnergyWrapper[]{new EnergyHelper.IEForgeEnergyWrapper(this, EnumFacing.NORTH), new EnergyHelper.IEForgeEnergyWrapper(this, EnumFacing.SOUTH), new EnergyHelper.IEForgeEnergyWrapper(this, EnumFacing.WEST), new EnergyHelper.IEForgeEnergyWrapper(this, EnumFacing.EAST)};
    static ArrayList<String> displayList = Lists.newArrayList((Object[])new String[]{"drill_base"});

    public static boolean _Immovable() {
        return true;
    }

    public void update() {
        ApiUtils.checkForNeedlessTicking(this);
        if (this.dummy != 0 || this.world.isAirBlock(this.getPos().add(0, -1, 0)) || !this.sample.isEmpty()) {
            return;
        }
        if (this.world.isRemote && this.active) {
            ++this.process;
            return;
        }
        boolean powered = this.world.isBlockIndirectlyGettingPowered(this.getPos()) > 0;
        boolean prevActive = this.active;
        if (!this.active && powered) {
            this.active = true;
        } else if (this.active && !powered && this.process >= Config.IEConfig.Machines.coredrill_time) {
            this.active = false;
        }
        if (this.active && this.process < Config.IEConfig.Machines.coredrill_time && this.energyStorage.extractEnergy(Config.IEConfig.Machines.coredrill_consumption, false) == Config.IEConfig.Machines.coredrill_consumption) {
            ++this.process;
            if (this.process >= Config.IEConfig.Machines.coredrill_time) {
                int cx = this.getPos().getX() >> 4;
                int cz = this.getPos().getZ() >> 4;
                ExcavatorHandler.MineralWorldInfo info = ExcavatorHandler.getMineralWorldInfo(this.world, cx, cz);
                this.sample = this.createCoreSample(this.world, this.getPos().getX() >> 4, this.getPos().getZ() >> 4, info);
            }
            this.markDirty();
            this.markContainingBlockForUpdate(null);
        }
        if (prevActive != this.active) {
            this.markDirty();
            this.markContainingBlockForUpdate(null);
        }
    }

    public float getSampleProgress() {
        return (float)this.process / (float)Config.IEConfig.Machines.coredrill_time;
    }

    public boolean isSamplingFinished() {
        return this.process >= Config.IEConfig.Machines.coredrill_time;
    }

    public String getVein() {
        if (this.sample.isEmpty()) {
            return "";
        }
        return this.sample.getTagCompound().getString("mineral");
    }

    public int getExpectedVeinYield() {
        if (this.sample.isEmpty()) {
            return -1;
        }
        return ExcavatorHandler.mineralVeinCapacity - this.sample.getTagCompound().getInteger("depletion");
    }

    @Nonnull
    public ItemStack createCoreSample(World world, int chunkX, int chunkZ, ExcavatorHandler.MineralWorldInfo info) {
        ItemStack stack = new ItemStack((Item)IEContent.itemCoresample);
        ItemNBTHelper.setLong(stack, "timestamp", world.getTotalWorldTime());
        ItemNBTHelper.setIntArray(stack, "coords", new int[]{world.provider.getDimension(), chunkX, chunkZ});
        if (info.mineralOverride != null) {
            ItemNBTHelper.setString(stack, "mineral", info.mineralOverride.name);
        } else if (info.mineral != null) {
            ItemNBTHelper.setString(stack, "mineral", info.mineral.name);
        } else {
            return stack;
        }
        if (ExcavatorHandler.mineralVeinCapacity < 0 || info.depletion < 0) {
            ItemNBTHelper.setBoolean(stack, "infinite", true);
        } else {
            ItemNBTHelper.setInt(stack, "depletion", info.depletion);
        }
        return stack;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.energyStorage.writeToNBT(nbt);
        nbt.setInteger("dummy", this.dummy);
        nbt.setInteger("process", this.process);
        nbt.setBoolean("active", this.active);
        if (!this.sample.isEmpty()) {
            nbt.setTag("sample", (NBTBase)this.sample.writeToNBT(new NBTTagCompound()));
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.energyStorage.readFromNBT(nbt);
        this.dummy = nbt.getInteger("dummy");
        this.process = nbt.getInteger("process");
        this.active = nbt.getBoolean("active");
        if (nbt.hasKey("sample")) {
            this.sample = new ItemStack(nbt.getCompoundTag("sample"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = this.dummy == 0 ? new AxisAlignedBB(this.getPos(), this.getPos().add(1, 3, 1)) : new AxisAlignedBB(this.getPos(), this.getPos());
        }
        return this.renderAABB;
    }

    @Override
    @Nonnull
    public FluxStorage getFluxStorage() {
        TileEntity te;
        if (this.dummy > 0 && (te = this.world.getTileEntity(this.getPos().add(0, -this.dummy, 0))) instanceof TileEntitySampleDrill) {
            return ((TileEntitySampleDrill)te).getFluxStorage();
        }
        return this.energyStorage;
    }

    @Override
    @Nonnull
    public IEEnums.SideConfig getEnergySideConfig(EnumFacing facing) {
        return this.dummy == 0 && facing != null && facing.getAxis() != EnumFacing.Axis.Y ? IEEnums.SideConfig.INPUT : IEEnums.SideConfig.NONE;
    }

    @Override
    public EnergyHelper.IEForgeEnergyWrapper getCapabilityWrapper(EnumFacing facing) {
        if (this.dummy == 0 && facing != null && facing.getAxis() != EnumFacing.Axis.Y) {
            return this.wrappers[facing.ordinal() - 2];
        }
        return null;
    }

    @Override
    public boolean isDummy() {
        return this.dummy > 0;
    }

    @Override
    public void placeDummies(BlockPos pos, IBlockState state, EnumFacing side, float hitX, float hitY, float hitZ) {
        for (int i = 1; i <= 2; ++i) {
            this.world.setBlockState(pos.add(0, i, 0), state);
            ((TileEntitySampleDrill)this.world.getTileEntity((BlockPos)pos.add((int)0, (int)i, (int)0))).dummy = i;
        }
    }

    @Override
    public void breakDummies(BlockPos pos, IBlockState state) {
        for (int i = 0; i <= 2; ++i) {
            if (!(this.world.getTileEntity(this.getPos().add(0, -this.dummy, 0).add(0, i, 0)) instanceof TileEntitySampleDrill)) continue;
            this.world.setBlockToAir(this.getPos().add(0, -this.dummy, 0).add(0, i, 0));
        }
    }

    @Override
    public boolean interact(EnumFacing side, EntityPlayer player, EnumHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        TileEntity te;
        if (this.dummy != 0 && (te = this.world.getTileEntity(this.getPos().add(0, -this.dummy, 0))) instanceof TileEntitySampleDrill) {
            return ((TileEntitySampleDrill)te).interact(side, player, hand, heldItem, hitX, hitY, hitZ);
        }
        if (!this.sample.isEmpty()) {
            if (!this.world.isRemote) {
                player.entityDropItem(this.sample.copy(), 0.5f);
            }
            this.sample = ItemStack.EMPTY;
            this.active = false;
            this.markDirty();
            this.markContainingBlockForUpdate(null);
            return true;
        }
        if (!this.active) {
            this.active = true;
            this.markDirty();
            this.markContainingBlockForUpdate(null);
            return true;
        }
        return false;
    }

    @Override
    public ArrayList<String> compileDisplayList() {
        return displayList;
    }
}

