/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.crafting.RefineryRecipe;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockMetal;
import blusunrize.immersiveengineering.common.blocks.multiblocks.MultiblockRefinery;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityRefinery
extends TileEntityMultiblockMetal<TileEntityRefinery, RefineryRecipe>
implements IEBlockInterfaces.IAdvancedSelectionBounds,
IEBlockInterfaces.IAdvancedCollisionBounds,
IEBlockInterfaces.IGuiTile {
    public FluidTank[] tanks = new FluidTank[]{new FluidTank(24000), new FluidTank(24000), new FluidTank(24000)};
    public NonNullList<ItemStack> inventory = NonNullList.withSize((int)6, (Object)ItemStack.EMPTY);

    public TileEntityRefinery() {
        super(MultiblockRefinery.instance, new int[]{3, 3, 5}, 16000, true);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.tanks[0].readFromNBT(nbt.getCompoundTag("tank0"));
        this.tanks[1].readFromNBT(nbt.getCompoundTag("tank1"));
        this.tanks[2].readFromNBT(nbt.getCompoundTag("tank2"));
        if (!descPacket) {
            this.inventory = Utils.readInventory(nbt.getTagList("inventory", 10), 6);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.setTag("tank0", (NBTBase)this.tanks[0].writeToNBT(new NBTTagCompound()));
        nbt.setTag("tank1", (NBTBase)this.tanks[1].writeToNBT(new NBTTagCompound()));
        nbt.setTag("tank2", (NBTBase)this.tanks[2].writeToNBT(new NBTTagCompound()));
        if (!descPacket) {
            nbt.setTag("inventory", (NBTBase)Utils.writeInventory(this.inventory));
        }
    }

    @Override
    public void update() {
        RefineryRecipe recipe;
        super.update();
        if (this.world.isRemote || this.isDummy()) {
            return;
        }
        boolean update = false;
        if (this.energyStorage.getEnergyStored() > 0 && this.processQueue.size() < this.getProcessQueueMaxLength() && (this.tanks[0].getFluidAmount() > 0 || this.tanks[1].getFluidAmount() > 0) && (recipe = RefineryRecipe.findRecipe(this.tanks[0].getFluid(), this.tanks[1].getFluid())) != null) {
            int[] nArray;
            TileEntityMultiblockMetal.MultiblockProcessInMachine<RefineryRecipe> multiblockProcessInMachine = new TileEntityMultiblockMetal.MultiblockProcessInMachine<RefineryRecipe>(recipe, new int[0]);
            if (this.tanks[0].getFluidAmount() > 0 && this.tanks[1].getFluidAmount() > 0) {
                int[] nArray2 = new int[2];
                nArray2[0] = 0;
                nArray = nArray2;
                nArray2[1] = 1;
            } else if (this.tanks[0].getFluidAmount() > 0) {
                int[] nArray3 = new int[1];
                nArray = nArray3;
                nArray3[0] = 0;
            } else {
                int[] nArray4 = new int[1];
                nArray = nArray4;
                nArray4[0] = 1;
            }
            TileEntityMultiblockMetal.MultiblockProcessInMachine process = multiblockProcessInMachine.setInputTanks(nArray);
            if (this.addProcessToQueue(process, true)) {
                this.addProcessToQueue(process, false);
                update = true;
            }
        }
        if (this.tanks[2].getFluidAmount() > 0) {
            ItemStack filledContainer = Utils.fillFluidContainer((IFluidHandler)this.tanks[2], (ItemStack)this.inventory.get(4), (ItemStack)this.inventory.get(5), null);
            if (!filledContainer.isEmpty()) {
                if (!((ItemStack)this.inventory.get(5)).isEmpty() && OreDictionary.itemMatches((ItemStack)((ItemStack)this.inventory.get(5)), (ItemStack)filledContainer, (boolean)true)) {
                    ((ItemStack)this.inventory.get(5)).grow(filledContainer.getCount());
                } else if (((ItemStack)this.inventory.get(5)).isEmpty()) {
                    this.inventory.set(5, (Object)filledContainer.copy());
                }
                ((ItemStack)this.inventory.get(4)).shrink(1);
                if (((ItemStack)this.inventory.get(4)).getCount() <= 0) {
                    this.inventory.set(4, (Object)ItemStack.EMPTY);
                }
                update = true;
            }
            if (this.tanks[2].getFluidAmount() > 0) {
                int accepted;
                FluidStack out = Utils.copyFluidStackWithAmount(this.tanks[2].getFluid(), Math.min(this.tanks[2].getFluidAmount(), 80), false);
                BlockPos outputPos = this.getPos().add(0, -1, 0).offset(this.facing.getOpposite());
                IFluidHandler output = FluidUtil.getFluidHandler((World)this.world, (BlockPos)outputPos, (EnumFacing)this.facing);
                if (output != null && (accepted = output.fill(out, false)) > 0) {
                    int drained = output.fill(Utils.copyFluidStackWithAmount(out, Math.min(out.amount, accepted), false), true);
                    this.tanks[2].drain(drained, true);
                    update = true;
                }
            }
        }
        int amount_prev = this.tanks[0].getFluidAmount();
        ItemStack emptyContainer = Utils.drainFluidContainer((IFluidHandler)this.tanks[0], (ItemStack)this.inventory.get(0), (ItemStack)this.inventory.get(1), null);
        if (amount_prev != this.tanks[0].getFluidAmount()) {
            if (!((ItemStack)this.inventory.get(1)).isEmpty() && OreDictionary.itemMatches((ItemStack)((ItemStack)this.inventory.get(1)), (ItemStack)emptyContainer, (boolean)true)) {
                ((ItemStack)this.inventory.get(1)).grow(emptyContainer.getCount());
            } else if (((ItemStack)this.inventory.get(1)).isEmpty()) {
                this.inventory.set(1, (Object)emptyContainer.copy());
            }
            ((ItemStack)this.inventory.get(0)).shrink(1);
            if (((ItemStack)this.inventory.get(0)).getCount() <= 0) {
                this.inventory.set(0, (Object)ItemStack.EMPTY);
            }
            update = true;
        }
        amount_prev = this.tanks[1].getFluidAmount();
        emptyContainer = Utils.drainFluidContainer((IFluidHandler)this.tanks[1], (ItemStack)this.inventory.get(2), (ItemStack)this.inventory.get(3), null);
        if (amount_prev != this.tanks[1].getFluidAmount()) {
            if (!((ItemStack)this.inventory.get(3)).isEmpty() && OreDictionary.itemMatches((ItemStack)((ItemStack)this.inventory.get(3)), (ItemStack)emptyContainer, (boolean)true)) {
                ((ItemStack)this.inventory.get(3)).grow(emptyContainer.getCount());
            } else if (((ItemStack)this.inventory.get(3)).isEmpty()) {
                this.inventory.set(3, (Object)emptyContainer.copy());
            }
            ((ItemStack)this.inventory.get(2)).shrink(1);
            if (((ItemStack)this.inventory.get(2)).getCount() <= 0) {
                this.inventory.set(2, (Object)ItemStack.EMPTY);
            }
            update = true;
        }
        if (update) {
            this.markDirty();
            this.markContainingBlockForUpdate(null);
        }
    }

    @Override
    public float[] getBlockBounds() {
        if (this.pos == 0 || this.pos == 1 || this.pos == 3) {
            return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f};
        }
        if (this.pos == 19) {
            return new float[]{this.facing == EnumFacing.WEST ? 0.5f : 0.0f, 0.0f, this.facing == EnumFacing.NORTH ? 0.5f : 0.0f, this.facing == EnumFacing.EAST ? 0.5f : 1.0f, 1.0f, this.facing == EnumFacing.SOUTH ? 0.5f : 1.0f};
        }
        if (this.pos == 17) {
            return new float[]{0.0625f, 0.0f, 0.0625f, 0.9375f, 1.0f, 0.9375f};
        }
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    @Override
    public List<AxisAlignedBB> getAdvancedSelectionBounds() {
        EnumFacing fl = this.facing;
        EnumFacing fw = this.facing.rotateY();
        if (this.mirrored) {
            fw = fw.getOpposite();
        }
        if (this.pos == 0 || this.pos == 4 || this.pos == 10 || this.pos == 14) {
            float minZ;
            float maxX;
            float minX;
            ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ())});
            if (this.pos >= 10) {
                fl = fl.getOpposite();
            }
            if (this.pos % 10 == 0) {
                fw = fw.getOpposite();
            }
            float f = fl == EnumFacing.WEST ? 0.0f : (fl == EnumFacing.EAST ? 0.75f : (minX = fw == EnumFacing.WEST ? 0.5f : 0.25f));
            float f2 = fl == EnumFacing.EAST ? 1.0f : (fl == EnumFacing.WEST ? 0.25f : (maxX = fw == EnumFacing.EAST ? 0.5f : 0.75f));
            float f3 = fl == EnumFacing.NORTH ? 0.0f : (fl == EnumFacing.SOUTH ? 0.75f : (minZ = fw == EnumFacing.NORTH ? 0.5f : 0.25f));
            float maxZ = fl == EnumFacing.SOUTH ? 1.0f : (fl == EnumFacing.NORTH ? 0.25f : (fw == EnumFacing.SOUTH ? 0.5f : 0.75f));
            list.add(new AxisAlignedBB((double)minX, 0.5, (double)minZ, (double)maxX, 1.375, (double)maxZ).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ()));
            if (this.pos == 4) {
                float f4 = fl == EnumFacing.WEST ? 0.625f : (minX = fl == EnumFacing.EAST ? 0.125f : 0.125f);
                float f5 = fl == EnumFacing.EAST ? 0.375f : (maxX = fl == EnumFacing.WEST ? 0.875f : 0.25f);
                float f6 = fl == EnumFacing.NORTH ? 0.625f : (minZ = fl == EnumFacing.SOUTH ? 0.125f : 0.125f);
                maxZ = fl == EnumFacing.SOUTH ? 0.375f : (fl == EnumFacing.NORTH ? 0.875f : 0.25f);
                list.add(new AxisAlignedBB((double)minX, 0.5, (double)minZ, (double)maxX, 1.0, (double)maxZ).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ()));
                float f7 = fl == EnumFacing.WEST ? 0.625f : (minX = fl == EnumFacing.EAST ? 0.125f : 0.75f);
                float f8 = fl == EnumFacing.EAST ? 0.375f : (maxX = fl == EnumFacing.WEST ? 0.875f : 0.875f);
                float f9 = fl == EnumFacing.NORTH ? 0.625f : (minZ = fl == EnumFacing.SOUTH ? 0.125f : 0.75f);
                maxZ = fl == EnumFacing.SOUTH ? 0.375f : (fl == EnumFacing.NORTH ? 0.875f : 0.875f);
                list.add(new AxisAlignedBB((double)minX, 0.5, (double)minZ, (double)maxX, 1.0, (double)maxZ).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ()));
            }
            return list;
        }
        if (this.pos == 1 || this.pos == 3 || this.pos == 11 || this.pos == 13) {
            float minZ;
            float maxX;
            float minX;
            ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0, 1.0).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ())});
            if (this.pos >= 10) {
                fl = fl.getOpposite();
            }
            if (this.pos % 10 == 1) {
                fw = fw.getOpposite();
            }
            float f = fl == EnumFacing.WEST ? 0.0f : (fl == EnumFacing.EAST ? 0.75f : (minX = fw == EnumFacing.WEST ? 0.75f : 0.0f));
            float f10 = fl == EnumFacing.EAST ? 1.0f : (fl == EnumFacing.WEST ? 0.25f : (maxX = fw == EnumFacing.EAST ? 0.25f : 1.0f));
            float f11 = fl == EnumFacing.NORTH ? 0.0f : (fl == EnumFacing.SOUTH ? 0.75f : (minZ = fw == EnumFacing.NORTH ? 0.75f : 0.0f));
            float maxZ = fl == EnumFacing.SOUTH ? 1.0f : (fl == EnumFacing.NORTH ? 0.25f : (fw == EnumFacing.SOUTH ? 0.25f : 1.0f));
            list.add(new AxisAlignedBB((double)minX, 0.5, (double)minZ, (double)maxX, 1.375, (double)maxZ).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ()));
            return list;
        }
        if (this.pos == 20 || this.pos == 24 || this.pos == 25 || this.pos == 29 || this.pos == 35 || this.pos == 39 || this.pos == 40 || this.pos == 44) {
            float maxY;
            float minZ;
            float maxX;
            float minX;
            ArrayList list = Lists.newArrayList();
            if (this.pos % 5 == 4) {
                fw = fw.getOpposite();
            }
            float f = fl == EnumFacing.WEST ? -0.25f : (fl == EnumFacing.EAST ? -0.25f : (minX = fw == EnumFacing.WEST ? -1.0f : 0.5f));
            float f12 = fl == EnumFacing.EAST ? 1.25f : (fl == EnumFacing.WEST ? 1.25f : (maxX = fw == EnumFacing.EAST ? 2.0f : 0.5f));
            float f13 = fl == EnumFacing.NORTH ? -0.25f : (fl == EnumFacing.SOUTH ? -0.25f : (minZ = fw == EnumFacing.NORTH ? -1.0f : 0.5f));
            float maxZ = fl == EnumFacing.SOUTH ? 1.25f : (fl == EnumFacing.NORTH ? 1.25f : (fw == EnumFacing.SOUTH ? 2.0f : 0.5f));
            float minY = this.pos < 35 ? 0.5f : -0.5f;
            float f14 = maxY = this.pos < 35 ? 2.0f : 1.0f;
            if (this.pos % 15 >= 10) {
                minX += fl == EnumFacing.WEST ? 1.0f : (fl == EnumFacing.EAST ? -1.0f : 0.0f);
                maxX += fl == EnumFacing.WEST ? 1.0f : (fl == EnumFacing.EAST ? -1.0f : 0.0f);
                minZ += fl == EnumFacing.NORTH ? 1.0f : (fl == EnumFacing.SOUTH ? -1.0f : 0.0f);
                maxZ += fl == EnumFacing.NORTH ? 1.0f : (fl == EnumFacing.SOUTH ? -1.0f : 0.0f);
            }
            list.add(new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ()));
            return list;
        }
        if (this.pos == 21 || this.pos == 23 || this.pos == 26 || this.pos == 28 || this.pos == 36 || this.pos == 38 || this.pos == 41 || this.pos == 43) {
            float maxY;
            float minZ;
            float maxX;
            float minX;
            ArrayList list = Lists.newArrayList();
            if (this.pos % 5 == 3) {
                fw = fw.getOpposite();
            }
            float f = fl == EnumFacing.WEST ? -0.25f : (fl == EnumFacing.EAST ? -0.25f : (minX = fw == EnumFacing.WEST ? 0.0f : -0.5f));
            float f15 = fl == EnumFacing.EAST ? 1.25f : (fl == EnumFacing.WEST ? 1.25f : (maxX = fw == EnumFacing.EAST ? 1.0f : 1.5f));
            float f16 = fl == EnumFacing.NORTH ? -0.25f : (fl == EnumFacing.SOUTH ? -0.25f : (minZ = fw == EnumFacing.NORTH ? 0.0f : -0.5f));
            float maxZ = fl == EnumFacing.SOUTH ? 1.25f : (fl == EnumFacing.NORTH ? 1.25f : (fw == EnumFacing.SOUTH ? 1.0f : 1.5f));
            float minY = this.pos < 35 ? 0.5f : -0.5f;
            float f17 = maxY = this.pos < 35 ? 2.0f : 1.0f;
            if (this.pos % 15 >= 10) {
                minX += fl == EnumFacing.WEST ? 1.0f : (fl == EnumFacing.EAST ? -1.0f : 0.0f);
                maxX += fl == EnumFacing.WEST ? 1.0f : (fl == EnumFacing.EAST ? -1.0f : 0.0f);
                minZ += fl == EnumFacing.NORTH ? 1.0f : (fl == EnumFacing.SOUTH ? -1.0f : 0.0f);
                maxZ += fl == EnumFacing.NORTH ? 1.0f : (fl == EnumFacing.SOUTH ? -1.0f : 0.0f);
            }
            list.add(new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ()));
            return list;
        }
        return null;
    }

    @Override
    public boolean isOverrideBox(AxisAlignedBB box, EntityPlayer player, RayTraceResult mop, ArrayList<AxisAlignedBB> list) {
        return false;
    }

    @Override
    public List<AxisAlignedBB> getAdvancedColisionBounds() {
        return this.getAdvancedSelectionBounds();
    }

    @Override
    public int[] getEnergyPos() {
        return new int[]{27};
    }

    @Override
    public int[] getRedstonePos() {
        return new int[]{19};
    }

    @Override
    public boolean isInWorldProcessingMachine() {
        return false;
    }

    @Override
    public boolean additionalCanProcessCheck(TileEntityMultiblockMetal.MultiblockProcess<RefineryRecipe> process) {
        return true;
    }

    @Override
    public void doProcessOutput(ItemStack output) {
        BlockPos pos = this.getPos().offset(this.facing, 2);
        TileEntity inventoryTile = this.world.getTileEntity(pos);
        if (inventoryTile != null) {
            output = Utils.insertStackIntoInventory(inventoryTile, output, this.facing.getOpposite());
        }
        if (!output.isEmpty()) {
            Utils.dropStackAtPos(this.world, pos, output, this.facing);
        }
    }

    @Override
    public void doProcessFluidOutput(FluidStack output) {
    }

    @Override
    public void onProcessFinish(TileEntityMultiblockMetal.MultiblockProcess<RefineryRecipe> process) {
    }

    @Override
    public int getMaxProcessPerTick() {
        return 1;
    }

    @Override
    public int getProcessQueueMaxLength() {
        return 1;
    }

    @Override
    public float getMinProcessDistance(TileEntityMultiblockMetal.MultiblockProcess<RefineryRecipe> process) {
        return 0.0f;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public int[] getOutputSlots() {
        return new int[0];
    }

    @Override
    public int[] getOutputTanks() {
        return new int[]{2};
    }

    @Override
    public IFluidTank[] getInternalTanks() {
        return this.tanks;
    }

    @Override
    protected IFluidTank[] getAccessibleFluidTanks(EnumFacing side) {
        TileEntityRefinery master = (TileEntityRefinery)this.master();
        if (master != null) {
            if (this.pos == 2 && (side == null || side == this.facing.getOpposite())) {
                return new FluidTank[]{master.tanks[2]};
            }
            if (!(this.pos != 5 && this.pos != 9 || side != null && side.getAxis() != this.facing.rotateYCCW().getAxis())) {
                return new FluidTank[]{master.tanks[0], master.tanks[1]};
            }
        }
        return this.tanks;
    }

    @Override
    protected boolean canFillTankFrom(int iTank, EnumFacing side, FluidStack resource) {
        if (!(this.pos != 5 && this.pos != 9 || side != null && side.getAxis() != this.facing.rotateYCCW().getAxis())) {
            TileEntityRefinery master = (TileEntityRefinery)this.master();
            if (master == null || master.tanks[iTank].getFluidAmount() >= master.tanks[iTank].getCapacity()) {
                return false;
            }
            if (master.tanks[0].getFluid() == null && master.tanks[1].getFluid() == null) {
                List<RefineryRecipe> incompleteRecipes = RefineryRecipe.findIncompleteRefineryRecipe(resource, null);
                return incompleteRecipes != null && !incompleteRecipes.isEmpty();
            }
            List<RefineryRecipe> incompleteRecipes = RefineryRecipe.findIncompleteRefineryRecipe(resource, master.tanks[iTank == 0 ? 1 : 0].getFluid());
            return incompleteRecipes != null && !incompleteRecipes.isEmpty();
        }
        return false;
    }

    @Override
    protected boolean canDrainTankFrom(int iTank, EnumFacing side) {
        return this.pos == 2 && (side == null || side == this.facing.getOpposite());
    }

    @Override
    public void doGraphicalUpdates(int slot) {
        this.markDirty();
        this.markContainingBlockForUpdate(null);
    }

    @Override
    public RefineryRecipe findRecipeForInsertion(ItemStack inserting) {
        return null;
    }

    @Override
    protected RefineryRecipe readRecipeFromNBT(NBTTagCompound tag) {
        return RefineryRecipe.loadFromNBT(tag);
    }

    @Override
    public boolean canOpenGui() {
        return this.formed;
    }

    @Override
    public int getGuiID() {
        return 9;
    }

    @Override
    public TileEntity getGuiMaster() {
        return this.master();
    }
}

