/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.crafting.MixerRecipe;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockMetal;
import blusunrize.immersiveengineering.common.blocks.multiblocks.MultiblockMixer;
import blusunrize.immersiveengineering.common.crafting.MixerRecipePotion;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import blusunrize.immersiveengineering.common.util.inventory.MultiFluidTank;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionHelper;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityMixer
extends TileEntityMultiblockMetal<TileEntityMixer, MixerRecipe>
implements IEBlockInterfaces.IAdvancedSelectionBounds,
IEBlockInterfaces.IAdvancedCollisionBounds,
IEBlockInterfaces.IGuiTile {
    public MultiFluidTank tank = new MultiFluidTank(8000);
    public NonNullList<ItemStack> inventory = NonNullList.withSize((int)8, (Object)ItemStack.EMPTY);
    public float animation_agitator = 0.0f;
    public boolean outputAll;
    IItemHandler insertionHandler = new IEInventoryHandler(8, (IIEInventory)this, 0, new boolean[]{true, true, true, true, true, true, true, true}, new boolean[8]);

    public TileEntityMixer() {
        super(MultiblockMixer.instance, new int[]{3, 3, 3}, 16000, true);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.tank.readFromNBT(nbt.getCompoundTag("tank"));
        if (!descPacket) {
            this.inventory = Utils.readInventory(nbt.getTagList("inventory", 10), 8);
        }
        this.outputAll = nbt.getBoolean("outputAll");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        NBTTagCompound tankTag = this.tank.writeToNBT(new NBTTagCompound());
        nbt.setTag("tank", (NBTBase)tankTag);
        if (!descPacket) {
            nbt.setTag("inventory", (NBTBase)Utils.writeInventory(this.inventory));
        }
        nbt.setBoolean("outputAll", this.outputAll);
    }

    @Override
    public void receiveMessageFromClient(NBTTagCompound message) {
        super.receiveMessageFromClient(message);
        if (message.hasKey("outputAll")) {
            this.outputAll = message.getBoolean("outputAll");
        }
    }

    @Override
    public void update() {
        block15: {
            boolean update;
            block16: {
                IFluidHandler output;
                block17: {
                    FluidStack out;
                    int accepted;
                    BlockPos outputPos;
                    int tankAmount;
                    block14: {
                        super.update();
                        if (this.isDummy() || this.isRSDisabled()) {
                            return;
                        }
                        if (!this.world.isRemote) break block14;
                        if (this.shouldRenderAsActive()) {
                            if (Utils.RAND.nextInt(8) == 0) {
                                FluidStack fs;
                                FluidStack fluidStack = fs = !this.tank.fluids.isEmpty() ? this.tank.fluids.get(0) : null;
                                if (fs != null) {
                                    float amount = (float)this.tank.getFluidAmount() / (float)this.tank.getCapacity() * 1.125f;
                                    Vec3d partPos = new Vec3d((double)((float)this.getPos().getX() + 0.5f + (float)this.facing.getFrontOffsetX() * 0.5f + (float)(this.mirrored ? this.facing.rotateYCCW() : this.facing.rotateY()).getFrontOffsetX() * 0.5f), (double)((float)this.getPos().getY() - 0.0625f + amount), (double)((float)this.getPos().getZ() + 0.5f + (float)this.facing.getFrontOffsetZ() * 0.5f + (float)(this.mirrored ? this.facing.rotateYCCW() : this.facing.rotateY()).getFrontOffsetZ() * 0.5f));
                                    float r = Utils.RAND.nextFloat() * 0.8125f;
                                    float angleRad = (float)Math.toRadians(this.animation_agitator);
                                    partPos = partPos.addVector((double)r * Math.cos(angleRad), 0.0, (double)r * Math.sin(angleRad));
                                    if (Utils.RAND.nextBoolean()) {
                                        ImmersiveEngineering.proxy.spawnBubbleFX(this.world, fs, partPos.x, partPos.y, partPos.z, 0.0, 0.0, 0.0);
                                    } else {
                                        ImmersiveEngineering.proxy.spawnFluidSplashFX(this.world, fs, partPos.x, partPos.y, partPos.z, 0.0, 0.0, 0.0);
                                    }
                                }
                            }
                            this.animation_agitator = (this.animation_agitator + 9.0f) % 360.0f;
                        }
                        break block15;
                    }
                    update = false;
                    boolean foundRecipe = false;
                    if (this.energyStorage.getEnergyStored() > 0 && this.processQueue.size() < this.getProcessQueueMaxLength() && (tankAmount = this.tank.getFluidAmount()) > 0) {
                        HashSet<Integer> usedInvSlots = new HashSet<Integer>();
                        for (TileEntityMultiblockMetal.MultiblockProcess process : this.processQueue) {
                            if (!(process instanceof TileEntityMultiblockMetal.MultiblockProcessInMachine)) continue;
                            for (int i : ((TileEntityMultiblockMetal.MultiblockProcessInMachine)process).inputSlots) {
                                usedInvSlots.add(i);
                            }
                        }
                        NonNullList components = NonNullList.withSize((int)this.inventory.size(), (Object)ItemStack.EMPTY);
                        for (int i = 0; i < components.size(); ++i) {
                            if (usedInvSlots.contains(i)) continue;
                            components.set(i, this.inventory.get(i));
                        }
                        for (FluidStack fs : this.tank.fluids) {
                            MixerRecipe recipe = MixerRecipe.findRecipe(fs, (NonNullList<ItemStack>)components);
                            if (recipe == null) continue;
                            foundRecipe = true;
                            TileEntityMultiblockMetal.MultiblockProcessInMachine process = new MultiblockProcessMixer(recipe, recipe.getUsedSlots(fs, (NonNullList<ItemStack>)components)).setInputTanks(0);
                            if (!this.addProcessToQueue(process, true)) continue;
                            this.addProcessToQueue(process, false);
                            update = true;
                        }
                    }
                    if (this.tank.getFluidTypes() <= 1 && foundRecipe && !this.outputAll || (output = FluidUtil.getFluidHandler((World)this.world, (BlockPos)(outputPos = this.getPos().down().offset(this.facing.getOpposite(), 2)), (EnumFacing)this.facing)) == null) break block16;
                    if (this.outputAll) break block17;
                    FluidStack inTank = this.tank.getFluid();
                    if (inTank == null || (accepted = output.fill(out = Utils.copyFluidStackWithAmount(inTank, Math.min(inTank.amount, 80), false), false)) <= 0) break block16;
                    int drained = output.fill(Utils.copyFluidStackWithAmount(out, Math.min(out.amount, accepted), false), true);
                    this.tank.drain(drained, true);
                    update = true;
                    break block16;
                }
                int totalOut = 0;
                Iterator<FluidStack> it = this.tank.fluids.iterator();
                while (it.hasNext()) {
                    FluidStack fs;
                    fs = it.next();
                    if (fs == null) continue;
                    FluidStack out = Utils.copyFluidStackWithAmount(fs, Math.min(fs.amount, 80 - totalOut), false);
                    int accepted = output.fill(out, false);
                    if (accepted > 0) {
                        int drained = output.fill(Utils.copyFluidStackWithAmount(out, Math.min(out.amount, accepted), false), true);
                        MultiFluidTank.drain(drained, fs, it, true);
                        totalOut += drained;
                        update = true;
                    }
                    if (totalOut < 80) continue;
                    break;
                }
            }
            if (update) {
                this.markDirty();
                this.markContainingBlockForUpdate(null);
            }
        }
    }

    @Override
    public float[] getBlockBounds() {
        if (this.pos > 1 && this.pos < 9 && this.pos != 3) {
            return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f};
        }
        if (this.pos == 11) {
            return new float[]{this.facing == EnumFacing.WEST ? 0.5f : 0.0f, 0.0f, this.facing == EnumFacing.NORTH ? 0.5f : 0.0f, this.facing == EnumFacing.EAST ? 0.5f : 1.0f, 1.0f, this.facing == EnumFacing.SOUTH ? 0.5f : 1.0f};
        }
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    @Override
    public List<AxisAlignedBB> getAdvancedSelectionBounds() {
        EnumFacing fl = this.facing;
        EnumFacing fw = this.facing.rotateY();
        if (this.mirrored) {
            fw = fw.getOpposite();
        }
        if (this.pos == 2) {
            float minZ;
            float maxX;
            float minX;
            ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ())});
            float f = fl == EnumFacing.WEST ? 0.625f : (minX = fl == EnumFacing.EAST ? 0.125f : 0.125f);
            float f2 = fl == EnumFacing.EAST ? 0.375f : (maxX = fl == EnumFacing.WEST ? 0.875f : 0.25f);
            float f3 = fl == EnumFacing.NORTH ? 0.625f : (minZ = fl == EnumFacing.SOUTH ? 0.125f : 0.125f);
            float maxZ = fl == EnumFacing.SOUTH ? 0.375f : (fl == EnumFacing.NORTH ? 0.875f : 0.25f);
            list.add(new AxisAlignedBB((double)minX, 0.5, (double)minZ, (double)maxX, 1.0, (double)maxZ).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ()));
            float f4 = fl == EnumFacing.WEST ? 0.625f : (minX = fl == EnumFacing.EAST ? 0.125f : 0.75f);
            float f5 = fl == EnumFacing.EAST ? 0.375f : (maxX = fl == EnumFacing.WEST ? 0.875f : 0.875f);
            float f6 = fl == EnumFacing.NORTH ? 0.625f : (minZ = fl == EnumFacing.SOUTH ? 0.125f : 0.75f);
            maxZ = fl == EnumFacing.SOUTH ? 0.375f : (fl == EnumFacing.NORTH ? 0.875f : 0.875f);
            list.add(new AxisAlignedBB((double)minX, 0.5, (double)minZ, (double)maxX, 1.0, (double)maxZ).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ()));
            return list;
        }
        if (this.pos == 4 || this.pos == 5 || this.pos == 7 || this.pos == 8) {
            float minZ;
            float maxX;
            float minX;
            ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ())});
            if (this.pos > 5) {
                fl = fl.getOpposite();
            }
            if (this.pos % 3 == 2) {
                fw = fw.getOpposite();
            }
            float f = fl == EnumFacing.WEST ? 0.6875f : (fl == EnumFacing.EAST ? 0.0625f : (minX = fw == EnumFacing.EAST ? 0.0625f : 0.6875f));
            float f7 = fl == EnumFacing.EAST ? 0.3125f : (fl == EnumFacing.WEST ? 0.9375f : (maxX = fw == EnumFacing.EAST ? 0.3125f : 0.9375f));
            float f8 = fl == EnumFacing.NORTH ? 0.6875f : (fl == EnumFacing.SOUTH ? 0.0625f : (minZ = fw == EnumFacing.SOUTH ? 0.0625f : 0.6875f));
            float maxZ = fl == EnumFacing.SOUTH ? 0.3125f : (fl == EnumFacing.NORTH ? 0.9375f : (fw == EnumFacing.SOUTH ? 0.3125f : 0.9375f));
            list.add(new AxisAlignedBB((double)minX, 0.5, (double)minZ, (double)maxX, 1.0, (double)maxZ).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ()));
            if (this.pos == 4) {
                float f9 = fl == EnumFacing.WEST ? 0.375f : (fl == EnumFacing.EAST ? 0.625f : (minX = fw == EnumFacing.WEST ? -0.125f : 0.0f));
                float f10 = fl == EnumFacing.EAST ? 0.375f : (fl == EnumFacing.WEST ? 0.625f : (maxX = fw == EnumFacing.EAST ? 1.125f : 1.0f));
                float f11 = fl == EnumFacing.NORTH ? 0.375f : (fl == EnumFacing.SOUTH ? 0.625f : (minZ = fw == EnumFacing.NORTH ? -0.125f : 0.0f));
                maxZ = fl == EnumFacing.SOUTH ? 0.375f : (fl == EnumFacing.NORTH ? 0.625f : (fw == EnumFacing.SOUTH ? 1.125f : 1.0f));
                list.add(new AxisAlignedBB((double)minX, 0.5, (double)minZ, (double)maxX, 0.75, (double)maxZ).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ()));
                float f12 = fl == EnumFacing.WEST ? -0.125f : (fl == EnumFacing.EAST ? 0.625f : (minX = fw == EnumFacing.WEST ? -0.125f : 0.875f));
                float f13 = fl == EnumFacing.EAST ? 1.125f : (fl == EnumFacing.WEST ? 0.375f : (maxX = fw == EnumFacing.EAST ? 1.125f : 0.125f));
                float f14 = fl == EnumFacing.NORTH ? -0.125f : (fl == EnumFacing.SOUTH ? 0.625f : (minZ = fw == EnumFacing.NORTH ? -0.125f : 0.875f));
                maxZ = fl == EnumFacing.SOUTH ? 1.25f : (fl == EnumFacing.NORTH ? 0.375f : (fw == EnumFacing.SOUTH ? 1.125f : 0.125f));
                list.add(new AxisAlignedBB((double)minX, 0.5, (double)minZ, (double)maxX, 0.75, (double)maxZ).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ()));
                float f15 = fl == EnumFacing.WEST ? -0.125f : (fl == EnumFacing.EAST ? 0.875f : (minX = fw == EnumFacing.WEST ? -0.125f : 0.875f));
                float f16 = fl == EnumFacing.EAST ? 1.125f : (fl == EnumFacing.WEST ? 0.125f : (maxX = fw == EnumFacing.EAST ? 1.125f : 0.125f));
                float f17 = fl == EnumFacing.NORTH ? -0.125f : (fl == EnumFacing.SOUTH ? 0.875f : (minZ = fw == EnumFacing.NORTH ? -0.125f : 0.875f));
                maxZ = fl == EnumFacing.SOUTH ? 1.25f : (fl == EnumFacing.NORTH ? 0.125f : (fw == EnumFacing.SOUTH ? 1.125f : 0.125f));
                list.add(new AxisAlignedBB((double)minX, 0.75, (double)minZ, (double)maxX, 1.0, (double)maxZ).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ()));
            }
            return list;
        }
        if (this.pos == 13 || this.pos == 14 || this.pos == 16 || this.pos == 17) {
            float minZ;
            float maxX;
            float minX;
            ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>(3);
            if (this.pos % 9 > 5) {
                fl = fl.getOpposite();
            }
            if (this.pos % 3 == 2) {
                fw = fw.getOpposite();
            }
            float f = fl == EnumFacing.WEST ? 0.0f : (fl == EnumFacing.EAST ? 0.1875f : (minX = fw == EnumFacing.EAST ? 0.1875f : 0.0f));
            float f18 = fl == EnumFacing.EAST ? 1.0f : (fl == EnumFacing.WEST ? 0.8125f : (maxX = fw == EnumFacing.EAST ? 1.0f : 0.8125f));
            float f19 = fl == EnumFacing.NORTH ? 0.0f : (fl == EnumFacing.SOUTH ? 0.1875f : (minZ = fw == EnumFacing.SOUTH ? 0.1875f : 0.0f));
            float maxZ = fl == EnumFacing.SOUTH ? 1.0f : (fl == EnumFacing.NORTH ? 0.8125f : (fw == EnumFacing.SOUTH ? 1.0f : 0.8125f));
            list.add(new AxisAlignedBB((double)minX, -0.25, (double)minZ, (double)maxX, 0.0, (double)maxZ).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ()));
            float f20 = fl == EnumFacing.WEST ? 0.0f : (fl == EnumFacing.EAST ? 0.0625f : (minX = fw == EnumFacing.EAST ? 0.0625f : 0.8125f));
            float f21 = fl == EnumFacing.EAST ? 1.0f : (fl == EnumFacing.WEST ? 0.9375f : (maxX = fw == EnumFacing.EAST ? 0.1875f : 0.9375f));
            float f22 = fl == EnumFacing.NORTH ? 0.0f : (fl == EnumFacing.SOUTH ? 0.0625f : (minZ = fw == EnumFacing.SOUTH ? 0.0625f : 0.8125f));
            maxZ = fl == EnumFacing.SOUTH ? 1.0f : (fl == EnumFacing.NORTH ? 0.9375f : (fw == EnumFacing.SOUTH ? 0.1875f : 0.9375f));
            list.add(new AxisAlignedBB((double)minX, 0.0, (double)minZ, (double)maxX, 1.0, (double)maxZ).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ()));
            float f23 = fl == EnumFacing.WEST ? 0.8125f : (fl == EnumFacing.EAST ? 0.0625f : (minX = fw == EnumFacing.EAST ? 0.1875f : 0.0f));
            float f24 = fl == EnumFacing.EAST ? 0.1875f : (fl == EnumFacing.WEST ? 0.9375f : (maxX = fw == EnumFacing.EAST ? 1.0f : 0.8125f));
            float f25 = fl == EnumFacing.NORTH ? 0.8125f : (fl == EnumFacing.SOUTH ? 0.0625f : (minZ = fw == EnumFacing.SOUTH ? 0.1875f : 0.0f));
            maxZ = fl == EnumFacing.SOUTH ? 0.1875f : (fl == EnumFacing.NORTH ? 0.9375f : (fw == EnumFacing.SOUTH ? 1.0f : 0.8125f));
            list.add(new AxisAlignedBB((double)minX, 0.0, (double)minZ, (double)maxX, 1.0, (double)maxZ).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ()));
            return list;
        }
        if (this.pos == 21) {
            float minZ;
            float maxX;
            float minX;
            ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>(1);
            float f = fl == EnumFacing.WEST ? 0.1875f : (fl == EnumFacing.EAST ? 0.3125f : (minX = fw == EnumFacing.EAST ? 0.1875f : 0.0f));
            float f26 = fl == EnumFacing.EAST ? 0.8125f : (fl == EnumFacing.WEST ? 0.6875f : (maxX = fw == EnumFacing.EAST ? 1.0f : 0.8125f));
            float f27 = fl == EnumFacing.NORTH ? 0.1875f : (fl == EnumFacing.SOUTH ? 0.3125f : (minZ = fw == EnumFacing.SOUTH ? 0.1875f : 0.0f));
            float maxZ = fl == EnumFacing.SOUTH ? 0.8125f : (fl == EnumFacing.NORTH ? 0.6875f : (fw == EnumFacing.SOUTH ? 1.0f : 0.8125f));
            list.add(new AxisAlignedBB((double)minX, 0.0, (double)minZ, (double)maxX, 0.625, (double)maxZ).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ()));
            return list;
        }
        if (this.pos == 22) {
            float minZ;
            float maxX;
            float minX;
            ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>(2);
            float f = fl == EnumFacing.WEST ? -0.4375f : (fl == EnumFacing.EAST ? 0.5625f : (minX = fw == EnumFacing.EAST ? 0.5625f : -0.4375f));
            float f28 = fl == EnumFacing.EAST ? 1.4375f : (fl == EnumFacing.WEST ? 0.4375f : (maxX = fw == EnumFacing.EAST ? 1.4375f : 0.4375f));
            float f29 = fl == EnumFacing.NORTH ? -0.4375f : (fl == EnumFacing.SOUTH ? 0.5625f : (minZ = fw == EnumFacing.SOUTH ? 0.5625f : -0.4375f));
            float maxZ = fl == EnumFacing.SOUTH ? 1.4375f : (fl == EnumFacing.NORTH ? 0.4375f : (fw == EnumFacing.SOUTH ? 1.4375f : 0.4375f));
            list.add(new AxisAlignedBB((double)minX, 0.1875, (double)minZ, (double)maxX, 1.0, (double)maxZ).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ()));
            float f30 = fl == EnumFacing.WEST ? 0.0f : (fl == EnumFacing.EAST ? 0.5f : (minX = fw == EnumFacing.EAST ? 0.0f : 0.4375f));
            float f31 = fl == EnumFacing.EAST ? 1.0f : (fl == EnumFacing.WEST ? 0.5f : (maxX = fw == EnumFacing.EAST ? 0.5625f : 1.0f));
            float f32 = fl == EnumFacing.NORTH ? 0.0f : (fl == EnumFacing.SOUTH ? 0.5f : (minZ = fw == EnumFacing.SOUTH ? 0.0f : 0.4375f));
            maxZ = fl == EnumFacing.SOUTH ? 1.0f : (fl == EnumFacing.NORTH ? 0.5f : (fw == EnumFacing.SOUTH ? 0.5625f : 1.0f));
            list.add(new AxisAlignedBB((double)minX, 0.0, (double)minZ, (double)maxX, 0.875, (double)maxZ).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ()));
            return list;
        }
        return null;
    }

    @Override
    public boolean isOverrideBox(AxisAlignedBB box, EntityPlayer player, RayTraceResult mop, ArrayList<AxisAlignedBB> list) {
        return false;
    }

    @Override
    public List<AxisAlignedBB> getAdvancedColisionBounds() {
        return this.getAdvancedSelectionBounds();
    }

    @Override
    public int[] getEnergyPos() {
        return new int[]{9};
    }

    @Override
    public int[] getRedstonePos() {
        return new int[]{11};
    }

    @Override
    public boolean isInWorldProcessingMachine() {
        return false;
    }

    @Override
    public boolean additionalCanProcessCheck(TileEntityMultiblockMetal.MultiblockProcess<MixerRecipe> process) {
        return true;
    }

    @Override
    public void doProcessOutput(ItemStack output) {
        BlockPos pos = this.getPos().offset(this.facing, 2);
        TileEntity inventoryTile = this.world.getTileEntity(pos);
        if (inventoryTile != null) {
            output = Utils.insertStackIntoInventory(inventoryTile, output, this.facing.getOpposite());
        }
        if (!output.isEmpty()) {
            Utils.dropStackAtPos(this.world, pos, output, this.facing);
        }
    }

    @Override
    public void doProcessFluidOutput(FluidStack output) {
    }

    @Override
    public void onProcessFinish(TileEntityMultiblockMetal.MultiblockProcess<MixerRecipe> process) {
    }

    @Override
    public int getMaxProcessPerTick() {
        return 8;
    }

    @Override
    public int getProcessQueueMaxLength() {
        return 8;
    }

    @Override
    public float getMinProcessDistance(TileEntityMultiblockMetal.MultiblockProcess<MixerRecipe> process) {
        return 0.0f;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public int[] getOutputSlots() {
        return new int[0];
    }

    @Override
    public int[] getOutputTanks() {
        return new int[]{0};
    }

    @Override
    public IFluidTank[] getInternalTanks() {
        return new IFluidTank[]{this.tank};
    }

    @Override
    protected IFluidTank[] getAccessibleFluidTanks(EnumFacing side) {
        TileEntityMixer master = (TileEntityMixer)this.master();
        if (master != null && (this.pos == 1 && (side == null || side == this.facing.getOpposite()) || this.pos == 3 && (side == null || side == (this.mirrored ? this.facing.rotateY() : this.facing.rotateYCCW())))) {
            return master.getInternalTanks();
        }
        return new FluidTank[0];
    }

    @Override
    protected boolean canFillTankFrom(int iTank, EnumFacing side, FluidStack resources) {
        return side == null || side == (this.mirrored ? this.facing.rotateY() : this.facing.rotateYCCW());
    }

    @Override
    protected boolean canDrainTankFrom(int iTank, EnumFacing side) {
        return side == null || side == this.facing.getOpposite();
    }

    @Override
    public void doGraphicalUpdates(int slot) {
        this.markDirty();
        this.markContainingBlockForUpdate(null);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if ((facing == null || this.pos == 16) && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.master() != null;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if ((facing == null || this.pos == 16) && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            TileEntityMixer master = (TileEntityMixer)this.master();
            if (master != null) {
                return (T)master.insertionHandler;
            }
            return null;
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public MixerRecipe findRecipeForInsertion(ItemStack inserting) {
        return null;
    }

    @Override
    protected MixerRecipe readRecipeFromNBT(NBTTagCompound tag) {
        return MixerRecipe.loadFromNBT(tag);
    }

    @Override
    protected TileEntityMultiblockMetal.MultiblockProcess loadProcessFromNBT(NBTTagCompound tag) {
        MixerRecipe recipe = this.readRecipeFromNBT(tag);
        if (recipe != null && recipe instanceof MixerRecipe) {
            return new MultiblockProcessMixer(recipe, tag.getIntArray("process_inputSlots")).setInputTanks(tag.getIntArray("process_inputTanks"));
        }
        return null;
    }

    @Override
    public boolean canOpenGui() {
        return this.formed;
    }

    @Override
    public int getGuiID() {
        return 12;
    }

    @Override
    public TileEntity getGuiMaster() {
        return this.master();
    }

    public static class MultiblockProcessMixer
    extends TileEntityMultiblockMetal.MultiblockProcessInMachine<MixerRecipe> {
        public MultiblockProcessMixer(MixerRecipe recipe, int ... inputSlots) {
            super(recipe, inputSlots);
        }

        @Override
        protected List<FluidStack> getRecipeFluidOutputs(TileEntityMultiblockMetal multiblock) {
            return Collections.emptyList();
        }

        @Override
        protected List<FluidStack> getRecipeFluidInputs(TileEntityMultiblockMetal multiblock) {
            return Collections.emptyList();
        }

        @Override
        public boolean canProcess(TileEntityMultiblockMetal multiblock) {
            if (!(multiblock instanceof TileEntityMixer)) {
                return false;
            }
            TileEntityMixer mixer = (TileEntityMixer)multiblock;
            return mixer.energyStorage.extractEnergy(this.energyPerTick, true) == this.energyPerTick && mixer.tank.drain(Utils.copyFluidStackWithAmount(((MixerRecipe)this.recipe).fluidInput, 1, false), false) != null;
        }

        @Override
        public void doProcessTick(TileEntityMultiblockMetal multiblock) {
            int timerStep = this.maxTicks / ((MixerRecipe)this.recipe).fluidAmount;
            if (this.processTick % timerStep == 0) {
                FluidStack drained = ((TileEntityMixer)multiblock).tank.drain(Utils.copyFluidStackWithAmount(((MixerRecipe)this.recipe).fluidInput, 1, false), true);
                NonNullList components = NonNullList.withSize((int)this.inputSlots.length, (Object)ItemStack.EMPTY);
                for (int i = 0; i < components.size(); ++i) {
                    components.set(i, multiblock.getInventory().get(this.inputSlots[i]));
                }
                FluidStack output = ((MixerRecipe)this.recipe).getFluidOutput(drained, (NonNullList<ItemStack>)components);
                FluidStack fs = Utils.copyFluidStackWithAmount(output, 1, false);
                ((TileEntityMixer)multiblock).tank.fill(fs, true);
            }
            super.doProcessTick(multiblock);
        }

        @Override
        protected void processFinish(TileEntityMultiblockMetal multiblock) {
            super.processFinish(multiblock);
            if (this.recipe instanceof MixerRecipePotion) {
                for (int i : this.inputSlots) {
                    if (((ItemStack)multiblock.getInventory().get(i)).isEmpty() || !PotionHelper.isReagent((ItemStack)((ItemStack)multiblock.getInventory().get(i)))) continue;
                    ((ItemStack)multiblock.getInventory().get(i)).shrink(1);
                    if (((ItemStack)multiblock.getInventory().get(i)).getCount() > 0) continue;
                    multiblock.getInventory().set(i, (Object)ItemStack.EMPTY);
                }
            }
        }
    }
}

