/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.crafting.MetalPressRecipe;
import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityConveyorBelt;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockMetal;
import blusunrize.immersiveengineering.common.blocks.multiblocks.MultiblockMetalPress;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.ListUtils;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityMetalPress
extends TileEntityMultiblockMetal<TileEntityMetalPress, MetalPressRecipe>
implements IEBlockInterfaces.IPlayerInteraction,
ConveyorHandler.IConveyorAttachable {
    public ItemStack mold = ItemStack.EMPTY;
    IItemHandler insertionHandler = new TileEntityMultiblockMetal.MultiblockInventoryHandler_DirectProcessing(this);

    public TileEntityMetalPress() {
        super(MultiblockMetalPress.instance, new int[]{3, 3, 1}, 16000, true);
    }

    @Override
    public void update() {
        super.update();
        if (this.isDummy() || this.isRSDisabled() || this.world.isRemote) {
            return;
        }
        for (TileEntityMultiblockMetal.MultiblockProcess process : this.processQueue) {
            float tick = 1.0f / (float)process.maxTicks;
            float transportTime = 52.5f * tick;
            float pressTime = 3.75f * tick;
            float fProcess = (float)process.processTick * tick;
            if (fProcess >= transportTime && fProcess < transportTime + tick) {
                this.world.playSound(null, this.getPos(), IESounds.metalpress_piston, SoundCategory.BLOCKS, 0.3f, 1.0f);
            }
            if (fProcess >= transportTime + pressTime && fProcess < transportTime + pressTime + tick) {
                this.world.playSound(null, this.getPos(), IESounds.metalpress_smash, SoundCategory.BLOCKS, 0.3f, 1.0f);
            }
            if (!(fProcess >= 1.0f - transportTime) || !(fProcess < 1.0f - transportTime + tick)) continue;
            this.world.playSound(null, this.getPos(), IESounds.metalpress_piston, SoundCategory.BLOCKS, 0.3f, 1.0f);
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.mold = new ItemStack(nbt.getCompoundTag("mold"));
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        if (!this.mold.isEmpty()) {
            nbt.setTag("mold", (NBTBase)this.mold.writeToNBT(new NBTTagCompound()));
        }
    }

    @Override
    public boolean interact(EnumFacing side, EntityPlayer player, EnumHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        TileEntityMetalPress master = (TileEntityMetalPress)this.master();
        if (master != null) {
            if (player.isSneaking() && !master.mold.isEmpty()) {
                if (heldItem.isEmpty()) {
                    player.setHeldItem(hand, master.mold.copy());
                } else if (!this.world.isRemote) {
                    player.entityDropItem(master.mold.copy(), 0.0f);
                }
                master.mold = ItemStack.EMPTY;
                this.updateMasterBlock(null, true);
                return true;
            }
            if (MetalPressRecipe.isValidMold(heldItem)) {
                ItemStack tempMold = !master.mold.isEmpty() ? master.mold.copy() : ItemStack.EMPTY;
                master.mold = Utils.copyStackWithAmount(heldItem, 1);
                heldItem.shrink(1);
                if (heldItem.getCount() <= 0) {
                    heldItem = ItemStack.EMPTY;
                } else {
                    player.setHeldItem(hand, heldItem);
                }
                if (!tempMold.isEmpty()) {
                    if (heldItem.isEmpty()) {
                        player.setHeldItem(hand, tempMold);
                    } else if (!this.world.isRemote) {
                        player.entityDropItem(tempMold, 0.0f);
                    }
                }
                this.updateMasterBlock(null, true);
                return true;
            }
        }
        return false;
    }

    @Override
    public float[] getBlockBounds() {
        if (this.pos == 3 || this.pos == 5) {
            return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f};
        }
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    @Override
    public void replaceStructureBlock(BlockPos pos, IBlockState state, ItemStack stack, int h, int l, int w) {
        TileEntity tile;
        super.replaceStructureBlock(pos, state, stack, h, l, w);
        if (h == 1 && l != 1 && (tile = this.world.getTileEntity(pos)) instanceof TileEntityConveyorBelt) {
            ((TileEntityConveyorBelt)tile).setFacing(this.facing);
        }
    }

    @Override
    public void onEntityCollision(World world, Entity entity) {
        if (this.pos == 3 && !world.isRemote && entity != null && !entity.isDead && entity instanceof EntityItem && !((EntityItem)entity).getItem().isEmpty()) {
            TileEntityMetalPress master = (TileEntityMetalPress)this.master();
            if (master == null) {
                return;
            }
            ItemStack stack = ((EntityItem)entity).getItem();
            if (stack.isEmpty()) {
                return;
            }
            MetalPressRecipe recipe = master.findRecipeForInsertion(stack);
            if (recipe == null) {
                return;
            }
            ItemStack displayStack = recipe.getDisplayStack(stack);
            float transformationPoint = 56.25f / (float)recipe.getTotalProcessTime();
            TileEntityMultiblockMetal.MultiblockProcessInWorld<MetalPressRecipe> process = new TileEntityMultiblockMetal.MultiblockProcessInWorld<MetalPressRecipe>(recipe, transformationPoint, Utils.createNonNullItemStackListFromItemStack(displayStack));
            if (master.addProcessToQueue(process, true)) {
                master.addProcessToQueue(process, false);
                stack.shrink(displayStack.getCount());
                if (stack.getCount() <= 0) {
                    entity.setDead();
                }
            }
        }
    }

    @Override
    public int[] getEnergyPos() {
        return new int[]{7};
    }

    @Override
    public int[] getRedstonePos() {
        return new int[]{1};
    }

    @Override
    public boolean isInWorldProcessingMachine() {
        return true;
    }

    @Override
    public boolean additionalCanProcessCheck(TileEntityMultiblockMetal.MultiblockProcess<MetalPressRecipe> process) {
        return true;
    }

    @Override
    public void doProcessOutput(ItemStack output) {
        BlockPos pos = this.getPos().offset(this.facing, 2);
        TileEntity inventoryTile = this.world.getTileEntity(pos);
        if (inventoryTile != null) {
            output = Utils.insertStackIntoInventory(inventoryTile, output, this.facing.getOpposite());
        }
        if (!output.isEmpty()) {
            Utils.dropStackAtPos(this.world, pos, output, this.facing);
        }
    }

    @Override
    public void doProcessFluidOutput(FluidStack output) {
    }

    @Override
    public void onProcessFinish(TileEntityMultiblockMetal.MultiblockProcess<MetalPressRecipe> process) {
    }

    @Override
    public int getMaxProcessPerTick() {
        return 3;
    }

    @Override
    public int getProcessQueueMaxLength() {
        return 3;
    }

    @Override
    public float getMinProcessDistance(TileEntityMultiblockMetal.MultiblockProcess<MetalPressRecipe> process) {
        return ((float)((MetalPressRecipe)process.recipe).getTotalProcessTime() - 56.25f) / (float)((MetalPressRecipe)process.recipe).getTotalProcessTime();
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return null;
    }

    @Override
    public NonNullList<ItemStack> getDroppedItems() {
        return ListUtils.fromItem(this.mold);
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return false;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 0;
    }

    @Override
    public int[] getOutputSlots() {
        return null;
    }

    @Override
    public int[] getOutputTanks() {
        return null;
    }

    @Override
    public IFluidTank[] getInternalTanks() {
        return null;
    }

    @Override
    protected IFluidTank[] getAccessibleFluidTanks(EnumFacing side) {
        return new IFluidTank[0];
    }

    @Override
    protected boolean canFillTankFrom(int iTank, EnumFacing side, FluidStack resources) {
        return false;
    }

    @Override
    protected boolean canDrainTankFrom(int iTank, EnumFacing side) {
        return false;
    }

    @Override
    public void doGraphicalUpdates(int slot) {
        this.markDirty();
        this.markContainingBlockForUpdate(null);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            TileEntityMetalPress master = (TileEntityMetalPress)this.master();
            if (master == null) {
                return false;
            }
            return this.pos == 3 && facing == this.facing.getOpposite();
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            TileEntityMetalPress master = (TileEntityMetalPress)this.master();
            if (master == null) {
                return null;
            }
            if (this.pos == 3 && facing == this.facing.getOpposite()) {
                return (T)master.insertionHandler;
            }
            return null;
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public MetalPressRecipe findRecipeForInsertion(ItemStack inserting) {
        return MetalPressRecipe.findRecipe(this.mold, inserting);
    }

    @Override
    protected MetalPressRecipe readRecipeFromNBT(NBTTagCompound tag) {
        return MetalPressRecipe.loadFromNBT(tag);
    }

    @Override
    public EnumFacing[] sigOutputDirections() {
        if (this.pos == 5) {
            return new EnumFacing[]{this.facing};
        }
        return new EnumFacing[0];
    }
}

