/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorage;
import blusunrize.immersiveengineering.api.energy.immersiveflux.IFluxProvider;
import blusunrize.immersiveengineering.api.energy.immersiveflux.IFluxReceiver;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.TileEntityMultiblockPart;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalDecoration1;
import blusunrize.immersiveengineering.common.blocks.multiblocks.MultiblockLightningrod;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityLightningrod
extends TileEntityMultiblockPart<TileEntityLightningrod>
implements IFluxProvider {
    FluxStorage energyStorage = new FluxStorage(Config.IEConfig.Machines.lightning_output);
    ArrayList<BlockPos> fenceNet = null;
    int height;
    private static final int[] size = new int[]{3, 3, 3};
    @SideOnly(value=Side.CLIENT)
    private AxisAlignedBB renderAABB;

    public TileEntityLightningrod() {
        super(size);
    }

    public void update() {
        ApiUtils.checkForNeedlessTicking(this);
        if (!this.world.isRemote && this.formed && this.pos == 13) {
            if (this.energyStorage.getEnergyStored() > 0) {
                for (EnumFacing f : EnumFacing.HORIZONTALS) {
                    TileEntity tileEntity = Utils.getExistingTileEntity(this.world, this.getPos().offset(f, 2));
                    if (!(tileEntity instanceof IFluxReceiver)) continue;
                    IFluxReceiver ifr = (IFluxReceiver)tileEntity;
                    int accepted = ifr.receiveEnergy(f.getOpposite(), this.energyStorage.getEnergyStored(), true);
                    int extracted = this.energyStorage.extractEnergy(accepted, false);
                    ifr.receiveEnergy(f.getOpposite(), extracted, false);
                }
            }
            if (this.world.getTotalWorldTime() % 256L == (long)((this.getPos().getX() ^ this.getPos().getZ()) & 0xFF)) {
                this.fenceNet = null;
            }
            if (this.fenceNet == null) {
                this.fenceNet = this.getFenceNet();
            }
            if (this.fenceNet != null && this.world.getTotalWorldTime() % 128L == (long)((this.getPos().getX() ^ this.getPos().getZ()) & 0x7F) && (this.world.isThundering() || this.world.isRaining() && Utils.RAND.nextInt(10) == 0)) {
                int i = this.height + this.fenceNet.size();
                if (Utils.RAND.nextInt(4096 * this.world.getHeight()) < i * (this.getPos().getY() + i)) {
                    this.energyStorage.setEnergy(Config.IEConfig.Machines.lightning_output);
                    BlockPos pos = this.fenceNet.get(Utils.RAND.nextInt(this.fenceNet.size()));
                    EntityLightningBolt entityLightningBolt = new EntityLightningBolt(this.world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), true);
                    this.world.addWeatherEffect((Entity)entityLightningBolt);
                    this.world.spawnEntity((Entity)entityLightningBolt);
                }
            }
        }
    }

    ArrayList<BlockPos> getFenceNet() {
        this.height = 0;
        boolean broken = false;
        for (int i = this.getPos().getY() + 2; i < this.world.getHeight() - 1; ++i) {
            BlockPos pos = new BlockPos(this.getPos().getX(), i, this.getPos().getZ());
            if (!broken && this.isFence(pos)) {
                ++this.height;
                continue;
            }
            if (!this.world.isAirBlock(pos)) {
                return null;
            }
            if (broken) continue;
            broken = true;
        }
        ArrayList<BlockPos> openList = new ArrayList<BlockPos>();
        ArrayList<BlockPos> closedList = new ArrayList<BlockPos>();
        openList.add(this.getPos().add(0, this.height, 0));
        while (!openList.isEmpty() && closedList.size() < 256) {
            BlockPos next = (BlockPos)openList.get(0);
            if (!closedList.contains(next) && this.isFence(next)) {
                closedList.add(next);
                openList.add(next.offset(EnumFacing.WEST));
                openList.add(next.offset(EnumFacing.EAST));
                openList.add(next.offset(EnumFacing.NORTH));
                openList.add(next.offset(EnumFacing.SOUTH));
                openList.add(next.offset(EnumFacing.UP));
            }
            openList.remove(0);
        }
        return closedList;
    }

    boolean isFence(BlockPos pos) {
        return Utils.isBlockAt(this.world, pos, IEContent.blockMetalDecoration1, BlockTypes_MetalDecoration1.STEEL_FENCE.getMeta());
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.energyStorage.readFromNBT(nbt);
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        this.energyStorage.writeToNBT(nbt);
    }

    @Override
    public float[] getBlockBounds() {
        if (this.pos == 22) {
            return new float[]{-0.125f, 0.0f, -0.125f, 1.125f, 1.0f, 1.125f};
        }
        if (this.pos % 9 == 4 || this.pos < 18 && this.pos % 9 % 2 == 1) {
            return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
        }
        if (this.pos < 9) {
            return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f};
        }
        float xMin = 0.0f;
        float xMax = 1.0f;
        float yMin = 0.0f;
        float yMax = 1.0f;
        float zMin = 0.0f;
        float zMax = 1.0f;
        if (this.pos % 9 == 0 || this.pos % 9 == 2 || this.pos % 9 == 6 || this.pos % 9 == 8) {
            if (this.pos < 18) {
                yMin = -0.5f;
                yMax = 1.25f;
                float f = (this.facing.getAxis() == EnumFacing.Axis.X ? this.pos % 9 > 2 ^ this.facing == EnumFacing.EAST : this.pos % 3 == 2 ^ this.facing == EnumFacing.NORTH) ? 0.8125f : (xMin = 0.4375f);
                float f2 = (this.facing.getAxis() == EnumFacing.Axis.X ? this.pos % 9 < 3 ^ this.facing == EnumFacing.EAST : this.pos % 3 == 0 ^ this.facing == EnumFacing.NORTH) ? 0.1875f : (xMax = 0.5625f);
                float f3 = (this.facing.getAxis() == EnumFacing.Axis.X ? this.pos % 3 == 2 ^ this.facing == EnumFacing.EAST : this.pos % 9 < 3 ^ this.facing == EnumFacing.NORTH) ? 0.8125f : (zMin = 0.4375f);
                zMax = (this.facing.getAxis() == EnumFacing.Axis.X ? this.pos % 3 == 0 ^ this.facing == EnumFacing.EAST : this.pos % 9 > 2 ^ this.facing == EnumFacing.NORTH) ? 0.1875f : 0.5625f;
            } else {
                yMin = 0.25f;
                yMax = 0.75f;
                float f = (this.facing.getAxis() == EnumFacing.Axis.X ? this.pos % 9 > 2 ^ this.facing == EnumFacing.EAST : this.pos % 3 == 2 ^ this.facing == EnumFacing.NORTH) ? 1.0f : (xMin = 0.625f);
                float f4 = (this.facing.getAxis() == EnumFacing.Axis.X ? this.pos % 9 < 3 ^ this.facing == EnumFacing.EAST : this.pos % 3 == 0 ^ this.facing == EnumFacing.NORTH) ? 0.0f : (xMax = 0.375f);
                float f5 = (this.facing.getAxis() == EnumFacing.Axis.X ? this.pos % 3 == 2 ^ this.facing == EnumFacing.EAST : this.pos % 9 < 3 ^ this.facing == EnumFacing.NORTH) ? 1.0f : (zMin = 0.625f);
                zMax = (this.facing.getAxis() == EnumFacing.Axis.X ? this.pos % 3 == 0 ^ this.facing == EnumFacing.EAST : this.pos % 9 > 2 ^ this.facing == EnumFacing.NORTH) ? 0.0f : 0.375f;
            }
        } else if (this.pos > 17) {
            yMin = 0.25f;
            yMax = 0.75f;
            xMin = this.offset[0] < 0 ? 0.375f : 0.0f;
            xMax = this.offset[0] > 0 ? 0.625f : 1.0f;
            zMin = this.offset[2] < 0 ? 0.375f : 0.0f;
            zMax = this.offset[2] > 0 ? 0.625f : 1.0f;
        }
        return new float[]{xMin, yMin, zMin, xMax, yMax, zMax};
    }

    @Override
    public ItemStack getOriginalBlock() {
        if (this.pos < 0) {
            return ItemStack.EMPTY;
        }
        ItemStack s = ItemStack.EMPTY;
        try {
            s = MultiblockLightningrod.instance.getStructureManual()[this.pos / 9][this.pos % 9 / 3][this.pos % 3];
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return s.copy();
    }

    @Override
    protected IFluidTank[] getAccessibleFluidTanks(EnumFacing side) {
        return new IFluidTank[0];
    }

    @Override
    protected boolean canFillTankFrom(int iTank, EnumFacing side, FluidStack resource) {
        return false;
    }

    @Override
    protected boolean canDrainTankFrom(int iTank, EnumFacing side) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = this.pos == 4 ? new AxisAlignedBB(this.getPos().add(-1, 0, -1), this.getPos().add(2, 5, 2)) : new AxisAlignedBB(this.getPos(), this.getPos());
        }
        return this.renderAABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double getMaxRenderDistanceSquared() {
        return super.getMaxRenderDistanceSquared() * Config.IEConfig.increasedTileRenderdistance;
    }

    @Override
    public int extractEnergy(@Nullable EnumFacing from, int energy, boolean simulate) {
        if (this.pos != 10 && this.pos != 12 && this.pos != 14 & this.pos != 16) {
            return 0;
        }
        TileEntityLightningrod master = (TileEntityLightningrod)this.master();
        return master == null ? 0 : master.energyStorage.extractEnergy(energy, simulate);
    }

    @Override
    public int getEnergyStored(@Nullable EnumFacing from) {
        TileEntityLightningrod master = (TileEntityLightningrod)this.master();
        return master == null ? 0 : master.energyStorage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(@Nullable EnumFacing from) {
        TileEntityLightningrod master = (TileEntityLightningrod)this.master();
        return master == null ? 0 : master.energyStorage.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(@Nullable EnumFacing from) {
        return this.pos == 10 || this.pos == 12 || this.pos == 14 || this.pos == 16;
    }
}

