/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorage;
import blusunrize.immersiveengineering.api.fluid.IFluidPipe;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalDevice0;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityFluidPipe;
import blusunrize.immersiveengineering.common.util.ChatUtils;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class TileEntityFluidPump
extends TileEntityIEBase
implements ITickable,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IHasDummyBlocks,
IEBlockInterfaces.IConfigurableSides,
IFluidPipe,
EnergyHelper.IIEInternalFluxHandler,
IEBlockInterfaces.IBlockOverlayText {
    public int[] sideConfig = new int[]{0, -1, -1, -1, -1, -1};
    public boolean dummy = false;
    public FluidTank tank = new FluidTank(4000);
    public FluxStorage energyStorage = new FluxStorage(8000);
    public boolean placeCobble = true;
    boolean checkingArea = false;
    Fluid searchFluid = null;
    ArrayList<BlockPos> openList = new ArrayList();
    ArrayList<BlockPos> closedList = new ArrayList();
    ArrayList<BlockPos> checked = new ArrayList();
    SidedFluidHandler[] sidedFluidHandler = new SidedFluidHandler[6];
    EnergyHelper.IEForgeEnergyWrapper wrapper = new EnergyHelper.IEForgeEnergyWrapper(this, EnumFacing.UP);

    public void update() {
        ApiUtils.checkForNeedlessTicking(this);
        if (this.dummy || this.world.isRemote) {
            return;
        }
        if (this.tank.getFluidAmount() > 0) {
            int i = this.outputFluid(this.tank.getFluid(), false);
            this.tank.drain(i, true);
        }
        if (this.world.isBlockIndirectlyGettingPowered(this.getPos()) > 0 || this.world.isBlockIndirectlyGettingPowered(this.getPos().add(0, 1, 0)) > 0) {
            for (EnumFacing f : EnumFacing.values()) {
                if (this.sideConfig[f.ordinal()] != 0) continue;
                BlockPos output = this.getPos().offset(f);
                TileEntity tile = Utils.getExistingTileEntity(this.world, output);
                if (tile != null && tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, f.getOpposite())) {
                    IFluidHandler handler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, f.getOpposite());
                    FluidStack drain = handler.drain(500, false);
                    if (drain == null || drain.amount <= 0) continue;
                    int out = this.outputFluid(drain, false);
                    handler.drain(out, true);
                    continue;
                }
                if (this.world.getTotalWorldTime() % 20L != (long)((this.getPos().getX() ^ this.getPos().getZ()) & 0x13) || this.world.getBlockState(this.getPos().offset(f)).getBlock() != Blocks.WATER || !Config.IEConfig.Machines.pump_infiniteWater || this.tank.fill(new FluidStack(FluidRegistry.WATER, 1000), false) != 1000 || this.energyStorage.extractEnergy(Config.IEConfig.Machines.pump_consumption, true) < Config.IEConfig.Machines.pump_consumption) continue;
                int connectedSources = 0;
                for (EnumFacing f2 : EnumFacing.HORIZONTALS) {
                    IBlockState waterState = this.world.getBlockState(this.getPos().offset(f).offset(f2));
                    if (waterState.getBlock() != Blocks.WATER || Blocks.WATER.getMetaFromState(waterState) != 0) continue;
                    ++connectedSources;
                }
                if (connectedSources <= true) continue;
                this.energyStorage.extractEnergy(Config.IEConfig.Machines.pump_consumption, false);
                this.tank.fill(new FluidStack(FluidRegistry.WATER, 1000), true);
            }
            if (this.world.getTotalWorldTime() % 40L == (long)(((this.getPos().getX() ^ this.getPos().getZ()) % 40 + 40) % 40)) {
                if (this.closedList.isEmpty()) {
                    this.prepareAreaCheck();
                } else {
                    int target = this.closedList.size() - 1;
                    BlockPos pos = this.closedList.get(target);
                    FluidStack fs = Utils.drainFluidBlock(this.world, pos, false);
                    if (fs == null) {
                        this.closedList.remove(target);
                    } else if (this.tank.fill(fs, false) == fs.amount && this.energyStorage.extractEnergy(Config.IEConfig.Machines.pump_consumption, true) >= Config.IEConfig.Machines.pump_consumption) {
                        this.energyStorage.extractEnergy(Config.IEConfig.Machines.pump_consumption, false);
                        fs = Utils.drainFluidBlock(this.world, pos, true);
                        if (Config.IEConfig.Machines.pump_placeCobble && this.placeCobble) {
                            this.world.setBlockState(pos, Blocks.COBBLESTONE.getDefaultState());
                        }
                        this.tank.fill(fs, true);
                        this.closedList.remove(target);
                    }
                }
            }
        }
        if (this.checkingArea) {
            this.checkAreaTick();
        }
    }

    public void prepareAreaCheck() {
        this.openList.clear();
        this.closedList.clear();
        this.checked.clear();
        for (EnumFacing f : EnumFacing.values()) {
            if (this.sideConfig[f.ordinal()] != 0) continue;
            this.openList.add(this.getPos().offset(f));
            this.checkingArea = true;
        }
    }

    public void checkAreaTick() {
        BlockPos next = null;
        int closedListMax = 2048;
        int timeout = 0;
        while (timeout < 64 && this.closedList.size() < 2048 && !this.openList.isEmpty()) {
            ++timeout;
            next = this.openList.get(0);
            if (!this.checked.contains(next)) {
                Fluid fluid = Utils.getRelatedFluid(this.world, next);
                if (!(fluid == null || fluid == FluidRegistry.WATER && Config.IEConfig.Machines.pump_infiniteWater || this.searchFluid != null && fluid != this.searchFluid)) {
                    if (this.searchFluid == null) {
                        this.searchFluid = fluid;
                    }
                    if (Utils.drainFluidBlock(this.world, next, false) != null) {
                        this.closedList.add(next);
                    }
                    for (EnumFacing f : EnumFacing.values()) {
                        BlockPos pos2 = next.offset(f);
                        fluid = Utils.getRelatedFluid(this.world, pos2);
                        if (this.checked.contains(pos2) || this.closedList.contains(pos2) || this.openList.contains(pos2) || fluid == null || fluid == FluidRegistry.WATER && Config.IEConfig.Machines.pump_infiniteWater || this.searchFluid != null && fluid != this.searchFluid) continue;
                        this.openList.add(pos2);
                    }
                }
                this.checked.add(next);
            }
            this.openList.remove(0);
        }
        if (this.closedList.size() >= 2048 || this.openList.isEmpty()) {
            this.checkingArea = false;
        }
    }

    public int outputFluid(FluidStack fs, boolean simulate) {
        FluidStack insertResource;
        if (fs == null) {
            return 0;
        }
        int canAccept = fs.amount;
        if (canAccept <= 0) {
            return 0;
        }
        int accelPower = Config.IEConfig.Machines.pump_consumption_accelerate;
        int fluidForSort = canAccept;
        int sum = 0;
        HashMap<TileEntityFluidPipe.DirectionalFluidOutput, Integer> sorting = new HashMap<TileEntityFluidPipe.DirectionalFluidOutput, Integer>();
        for (EnumFacing f : EnumFacing.values()) {
            int temp;
            TileEntity tile;
            if (this.sideConfig[f.ordinal()] != 1 || (tile = Utils.getExistingTileEntity(this.world, this.getPos().offset(f))) == null || !tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, f.getOpposite())) continue;
            IFluidHandler handler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, f.getOpposite());
            insertResource = new FluidStack(fs.getFluid(), fs.amount);
            if (tile instanceof TileEntityFluidPipe && this.energyStorage.extractEnergy(accelPower, true) >= accelPower) {
                insertResource.tag = new NBTTagCompound();
                insertResource.tag.setBoolean("pressurized", true);
            }
            if ((temp = handler.fill(insertResource, false)) <= 0) continue;
            sorting.put(new TileEntityFluidPipe.DirectionalFluidOutput(handler, tile, f), temp);
            sum += temp;
        }
        if (sum > 0) {
            int f = 0;
            int i = 0;
            for (TileEntityFluidPipe.DirectionalFluidOutput output : sorting.keySet()) {
                float prio = (float)((Integer)sorting.get(output)).intValue() / (float)sum;
                int amount = (int)((float)fluidForSort * prio);
                if (i++ == sorting.size() - 1) {
                    amount = canAccept;
                }
                insertResource = new FluidStack(fs.getFluid(), amount);
                if (output.containingTile instanceof TileEntityFluidPipe && this.energyStorage.extractEnergy(accelPower, true) >= accelPower) {
                    this.energyStorage.extractEnergy(accelPower, false);
                    insertResource.tag = new NBTTagCompound();
                    insertResource.tag.setBoolean("pressurized", true);
                }
                int r = output.output.fill(insertResource, !simulate);
                f += r;
                if ((canAccept -= r) > 0) continue;
                break;
            }
            return f;
        }
        return 0;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.sideConfig = nbt.getIntArray("sideConfig");
        if (this.sideConfig == null || this.sideConfig.length != 6) {
            this.sideConfig = new int[]{0, -1, -1, -1, -1, -1};
        }
        this.dummy = nbt.getBoolean("dummy");
        if (nbt.hasKey("placeCobble")) {
            this.placeCobble = nbt.getBoolean("placeCobble");
        }
        this.tank.readFromNBT(nbt.getCompoundTag("tank"));
        this.energyStorage.readFromNBT(nbt);
        if (descPacket) {
            this.markContainingBlockForUpdate(null);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.setIntArray("sideConfig", this.sideConfig);
        nbt.setBoolean("dummy", this.dummy);
        nbt.setBoolean("placeCobble", this.placeCobble);
        nbt.setTag("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        this.energyStorage.writeToNBT(nbt);
    }

    @Override
    public IEEnums.SideConfig getSideConfig(int side) {
        return side >= 0 && side < 6 ? IEEnums.SideConfig.values()[this.sideConfig[side] + 1] : IEEnums.SideConfig.NONE;
    }

    @Override
    public boolean toggleSide(int side, EntityPlayer p) {
        if (side != 1 && !this.dummy) {
            int n = side;
            this.sideConfig[n] = this.sideConfig[n] + 1;
            if (this.sideConfig[side] > 1) {
                this.sideConfig[side] = -1;
            }
            this.markDirty();
            this.markContainingBlockForUpdate(null);
            this.world.addBlockEvent(this.getPos(), this.getBlockType(), 0, 0);
            return true;
        }
        if (p.isSneaking()) {
            TileEntity tmp;
            TileEntityFluidPump master = this;
            if (this.dummy && (tmp = this.world.getTileEntity(this.pos.down())) instanceof TileEntityFluidPump) {
                master = (TileEntityFluidPump)tmp;
            }
            master.placeCobble = !master.placeCobble;
            ChatUtils.sendServerNoSpamMessages(p, new ITextComponent[]{new TextComponentTranslation("chat.immersiveengineering.info.pump.placeCobble." + master.placeCobble, new Object[0])});
            return true;
        }
        return false;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && facing != null && !this.dummy) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && facing != null && !this.dummy) {
            if (this.sidedFluidHandler[facing.ordinal()] == null) {
                this.sidedFluidHandler[facing.ordinal()] = new SidedFluidHandler(this, facing);
            }
            return (T)this.sidedFluidHandler[facing.ordinal()];
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public String[] getOverlayText(EntityPlayer player, RayTraceResult mop, boolean hammer) {
        if (hammer && Config.IEConfig.colourblindSupport && !this.dummy) {
            int i = this.sideConfig[Math.min(this.sideConfig.length - 1, mop.sideHit.ordinal())];
            int j = this.sideConfig[Math.min(this.sideConfig.length - 1, mop.sideHit.getOpposite().ordinal())];
            return new String[]{I18n.format((String)"desc.immersiveengineering.info.blockSide.facing", (Object[])new Object[0]) + ": " + I18n.format((String)("desc.immersiveengineering.info.blockSide.connectFluid." + i), (Object[])new Object[0]), I18n.format((String)"desc.immersiveengineering.info.blockSide.opposite", (Object[])new Object[0]) + ": " + I18n.format((String)("desc.immersiveengineering.info.blockSide.connectFluid." + j), (Object[])new Object[0])};
        }
        return null;
    }

    @Override
    public boolean useNixieFont(EntityPlayer player, RayTraceResult mop) {
        return false;
    }

    @Override
    @Nonnull
    public FluxStorage getFluxStorage() {
        TileEntity te;
        if (this.dummy && (te = this.world.getTileEntity(this.getPos().add(0, -1, 0))) instanceof TileEntityFluidPump) {
            return ((TileEntityFluidPump)te).getFluxStorage();
        }
        return this.energyStorage;
    }

    @Override
    @Nonnull
    public IEEnums.SideConfig getEnergySideConfig(EnumFacing facing) {
        return this.dummy && facing == EnumFacing.UP ? IEEnums.SideConfig.INPUT : IEEnums.SideConfig.NONE;
    }

    @Override
    public EnergyHelper.IEForgeEnergyWrapper getCapabilityWrapper(EnumFacing facing) {
        if (!this.dummy && facing == EnumFacing.UP) {
            return null;
        }
        return this.wrapper;
    }

    @Override
    public boolean isDummy() {
        return this.dummy;
    }

    @Override
    public void placeDummies(BlockPos pos, IBlockState state, EnumFacing side, float hitX, float hitY, float hitZ) {
        this.world.setBlockState(pos.add(0, 1, 0), state);
        ((TileEntityFluidPump)this.world.getTileEntity((BlockPos)pos.add((int)0, (int)1, (int)0))).dummy = true;
    }

    @Override
    public void breakDummies(BlockPos pos, IBlockState state) {
        for (int i = 0; i <= 1; ++i) {
            if (!Utils.isBlockAt(this.world, this.getPos().add(0, this.dummy ? -1 : 0, 0).add(0, i, 0), IEContent.blockMetalDevice0, BlockTypes_MetalDevice0.FLUID_PUMP.getMeta())) continue;
            this.world.setBlockToAir(this.getPos().add(0, this.dummy ? -1 : 0, 0).add(0, i, 0));
        }
    }

    @Override
    public float[] getBlockBounds() {
        if (!this.dummy) {
            return null;
        }
        return new float[]{0.1875f, 0.0f, 0.1875f, 0.8125f, 1.0f, 0.8125f};
    }

    @Override
    public boolean canOutputPressurized(boolean consumePower) {
        int accelPower = Config.IEConfig.Machines.pump_consumption_accelerate;
        if (this.energyStorage.extractEnergy(accelPower, true) >= accelPower) {
            if (consumePower) {
                this.energyStorage.extractEnergy(accelPower, false);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean hasOutputConnection(EnumFacing side) {
        return side != null && this.sideConfig[side.ordinal()] == 1;
    }

    static class SidedFluidHandler
    implements IFluidHandler {
        TileEntityFluidPump pump;
        EnumFacing facing;

        SidedFluidHandler(TileEntityFluidPump pump, EnumFacing facing) {
            this.pump = pump;
            this.facing = facing;
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (resource == null || this.pump.sideConfig[this.facing.ordinal()] != 0) {
                return 0;
            }
            return this.pump.tank.fill(resource, doFill);
        }

        public FluidStack drain(FluidStack resource, boolean doDrain) {
            if (resource == null) {
                return null;
            }
            return this.drain(resource.amount, doDrain);
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            if (this.pump.sideConfig[this.facing.ordinal()] != 1) {
                return null;
            }
            return this.pump.tank.drain(maxDrain, doDrain);
        }

        public IFluidTankProperties[] getTankProperties() {
            return this.pump.tank.getTankProperties();
        }
    }
}

