/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.TreeMap;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class TileEntityFluidPlacer
extends TileEntityIEBase
implements ITickable,
IEBlockInterfaces.IConfigurableSides,
IEBlockInterfaces.IBlockOverlayText {
    public int[] sideConfig = new int[]{1, 0, 1, 1, 1, 1};
    public FluidTank tank = new FluidTank(4000);
    private int tickCount = 0;
    HashSet<BlockPos> checkedPositions = new HashSet();
    TreeMap<Integer, Queue<BlockPos>> layeredPlacementQueue = new TreeMap();
    HashSet<BlockPos> tempFluids = new HashSet();

    public void update() {
        if (this.getWorld().isRemote || this.getWorld().isBlockIndirectlyGettingPowered(this.getPos()) != 0) {
            return;
        }
        if (this.tickCount % 16 == 0) {
            if (this.tickCount % 512 == 0) {
                this.prepareAreaCheck();
            }
            if (this.tank.getFluidAmount() >= 1000 && this.tank.getFluid().getFluid().getBlock() != null && !this.layeredPlacementQueue.isEmpty()) {
                Queue<BlockPos> lowestLayer = this.layeredPlacementQueue.firstEntry().getValue();
                if (lowestLayer == null || lowestLayer.isEmpty()) {
                    this.layeredPlacementQueue.pollFirstEntry();
                } else {
                    BlockPos targetPos = lowestLayer.poll();
                    IBlockState state = this.getWorld().getBlockState(targetPos);
                    if ((state.getBlock().isAir(state, (IBlockAccess)this.getWorld(), targetPos) || !state.getMaterial().isSolid()) && !this.isFullFluidBlock(targetPos, state) && TileEntityFluidPlacer.tryPlaceFluid(null, this.getWorld(), this.tank.getFluid(), targetPos)) {
                        this.tank.drain(1000, true);
                        this.addConnectedSpaces(targetPos);
                        this.handleTempFluids();
                    }
                }
            }
        }
        ++this.tickCount;
    }

    public static boolean tryPlaceFluid(@Nullable EntityPlayer player, World worldIn, FluidStack fluidStack, BlockPos pos) {
        if (worldIn == null || fluidStack == null || pos == null) {
            return false;
        }
        Fluid fluid = fluidStack.getFluid();
        if (fluid == null || !fluid.canBePlacedInWorld()) {
            return false;
        }
        IBlockState destBlockState = worldIn.getBlockState(pos);
        Material destMaterial = destBlockState.getMaterial();
        boolean isDestNonSolid = !destMaterial.isSolid();
        boolean isDestReplaceable = destBlockState.getBlock().isReplaceable((IBlockAccess)worldIn, pos);
        if (!(worldIn.isAirBlock(pos) || isDestNonSolid || isDestReplaceable)) {
            return false;
        }
        if (worldIn.provider.doesWaterVaporize() && fluid.doesVaporize(fluidStack)) {
            fluid.vaporize(player, worldIn, pos, fluidStack);
        } else {
            if (!worldIn.isRemote && (isDestNonSolid || isDestReplaceable) && !destMaterial.isLiquid()) {
                worldIn.destroyBlock(pos, true);
            }
            SoundEvent soundevent = fluid.getEmptySound(fluidStack);
            worldIn.playSound(player, pos, soundevent, SoundCategory.BLOCKS, 1.0f, 1.0f);
            IBlockState fluidBlockState = fluid.getBlock().getDefaultState();
            worldIn.setBlockState(pos, fluidBlockState, 11);
        }
        return true;
    }

    private void prepareAreaCheck() {
        this.checkedPositions.clear();
        this.layeredPlacementQueue.clear();
        this.tempFluids.clear();
        this.addConnectedSpaces(this.getPos());
        this.handleTempFluids();
    }

    private Queue<BlockPos> getQueueForYLevel(int yLevel) {
        Queue<BlockPos> queue = this.layeredPlacementQueue.get(yLevel);
        if (queue == null) {
            queue = new LinkedList<BlockPos>();
            this.layeredPlacementQueue.put(yLevel, queue);
        }
        return queue;
    }

    private void addConnectedSpaces(BlockPos pos) {
        for (EnumFacing facing : EnumFacing.values()) {
            if (facing == EnumFacing.UP || pos == this.getPos() && this.sideConfig[facing.ordinal()] != 1) continue;
            this.addToQueue(pos.offset(facing));
        }
    }

    private void addToQueue(BlockPos pos) {
        if (pos.getY() >= 0 && pos.getY() <= 255 && this.checkedPositions.add(pos) && pos.distanceSq((Vec3i)this.getPos()) < 4096.0 && this.getWorld().isBlockLoaded(pos)) {
            IBlockState state = this.getWorld().getBlockState(pos);
            if (this.tank.getFluid() != null && this.tank.getFluid().getFluid() == FluidRegistry.lookupFluidForBlock((Block)state.getBlock())) {
                this.tempFluids.add(pos);
            }
            if (!(!state.getBlock().isAir(state, (IBlockAccess)this.getWorld(), pos) && state.getMaterial().isSolid() || this.isFullFluidBlock(pos, state))) {
                this.getQueueForYLevel(pos.getY()).add(pos);
            }
        }
    }

    private void handleTempFluids() {
        HashSet<BlockPos> tempFluidsCopy = this.tempFluids;
        this.tempFluids = new HashSet();
        for (BlockPos pos : tempFluidsCopy) {
            this.addConnectedSpaces(pos);
        }
    }

    private boolean isFullFluidBlock(BlockPos pos, IBlockState state) {
        if (state.getBlock() instanceof IFluidBlock) {
            return Math.abs(((IFluidBlock)state.getBlock()).getFilledPercentage(this.getWorld(), pos)) == 1.0f;
        }
        if (state.getBlock() instanceof BlockLiquid) {
            return state.getBlock().getMetaFromState(state) == 0;
        }
        return false;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.sideConfig = nbt.getIntArray("sideConfig");
        if (this.sideConfig == null || this.sideConfig.length != 6) {
            this.sideConfig = new int[]{1, 0, 1, 1, 1, 1};
        }
        this.tank.readFromNBT(nbt.getCompoundTag("tank"));
        if (descPacket) {
            this.markContainingBlockForUpdate(null);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.setIntArray("sideConfig", this.sideConfig);
        nbt.setTag("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
    }

    @Override
    public IEEnums.SideConfig getSideConfig(int side) {
        return side >= 0 && side < 6 ? IEEnums.SideConfig.values()[this.sideConfig[side] + 1] : IEEnums.SideConfig.NONE;
    }

    @Override
    public boolean toggleSide(int side, EntityPlayer p) {
        int n = side;
        this.sideConfig[n] = this.sideConfig[n] + 1;
        if (this.sideConfig[side] > 1) {
            this.sideConfig[side] = -1;
        }
        this.prepareAreaCheck();
        this.markDirty();
        this.markContainingBlockForUpdate(null);
        this.getWorld().addBlockEvent(this.getPos(), this.getBlockType(), 0, 0);
        return true;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && (facing == null || this.sideConfig[facing.ordinal()] == 0)) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && (facing == null || this.sideConfig[facing.ordinal()] == 0)) {
            return (T)this.tank;
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public String[] getOverlayText(EntityPlayer player, RayTraceResult mop, boolean hammer) {
        if (hammer && Config.IEConfig.colourblindSupport) {
            int i = this.sideConfig[Math.min(this.sideConfig.length - 1, mop.sideHit.ordinal())];
            int j = this.sideConfig[Math.min(this.sideConfig.length - 1, mop.sideHit.getOpposite().ordinal())];
            return new String[]{I18n.format((String)"desc.immersiveengineering.info.blockSide.facing", (Object[])new Object[0]) + ": " + I18n.format((String)("desc.immersiveengineering.info.blockSide.connectFluid." + i), (Object[])new Object[0]), I18n.format((String)"desc.immersiveengineering.info.blockSide.opposite", (Object[])new Object[0]) + ": " + I18n.format((String)("desc.immersiveengineering.info.blockSide.connectFluid." + j), (Object[])new Object[0])};
        }
        return null;
    }

    @Override
    public boolean useNixieFont(EntityPlayer player, RayTraceResult mop) {
        return false;
    }
}

