/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.TileEntityImmersiveConnectable;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.IOBJModelCallback;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.EventHandler;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.BlockFakeLight;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.ChatUtils;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.EnumSkyBlock;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityFloodlight
extends TileEntityImmersiveConnectable
implements ITickable,
IEBlockInterfaces.IAdvancedDirectionalTile,
IEBlockInterfaces.IHammerInteraction,
IEBlockInterfaces.ISpawnInterdiction,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IActiveState,
IEBlockInterfaces.ILightValue,
IOBJModelCallback<IBlockState> {
    public int energyStorage = 0;
    private int energyDraw = Config.IEConfig.Machines.floodlight_energyDraw;
    private int maximumStorage = Config.IEConfig.Machines.floodlight_maximumStorage;
    public boolean active = false;
    public boolean redstoneControlInverted = false;
    public EnumFacing facing = EnumFacing.NORTH;
    public EnumFacing side = EnumFacing.UP;
    public float rotY = 0.0f;
    public float rotX = 0.0f;
    public List<BlockPos> fakeLights = new ArrayList<BlockPos>();
    public List<BlockPos> lightsToBePlaced = new ArrayList<BlockPos>();
    public List<BlockPos> lightsToBeRemoved = new ArrayList<BlockPos>();
    final int timeBetweenSwitches = 20;
    int switchCooldown = 0;
    private boolean shouldUpdate = true;
    public boolean computerOn = true;
    public int controllingComputers = 0;
    public int turnCooldown = 0;

    public void update() {
        boolean enabled;
        if (this.world.isRemote) {
            return;
        }
        if (this.turnCooldown > 0) {
            --this.turnCooldown;
        }
        boolean b = this.active;
        if (this.shouldUpdate) {
            this.updateFakeLights(true, this.active);
            this.markDirty();
            this.markContainingBlockForUpdate(null);
            this.shouldUpdate = false;
        }
        boolean bl = enabled = this.controllingComputers > 0 && this.computerOn || this.world.isBlockIndirectlyGettingPowered(this.getPos()) > 0 ^ this.redstoneControlInverted;
        if (this.energyStorage >= (!this.active ? this.energyDraw * 10 : this.energyDraw) && enabled && this.switchCooldown <= 0) {
            this.energyStorage -= this.energyDraw;
            if (!this.active) {
                this.active = true;
            }
        } else if (this.active) {
            this.active = false;
            this.switchCooldown = 20;
        }
        --this.switchCooldown;
        if (this.active != b || this.world.getTotalWorldTime() % 512L == (long)((this.getPos().getX() ^ this.getPos().getZ()) & 0x1FF)) {
            this.markContainingBlockForUpdate(null);
            this.updateFakeLights(true, this.active);
        }
        if (!this.active) {
            if (!this.lightsToBePlaced.isEmpty()) {
                this.lightsToBePlaced.clear();
            }
        } else if (!this.lightsToBePlaced.isEmpty() || !this.lightsToBeRemoved.isEmpty() && this.world.getTotalWorldTime() % 8L == (long)((this.getPos().getX() ^ this.getPos().getZ()) & 7)) {
            BlockPos cc;
            Iterator<BlockPos> it = this.lightsToBePlaced.iterator();
            int timeout = 0;
            while (it.hasNext() && timeout++ < 16) {
                cc = it.next();
                this.world.setBlockState(cc, IEContent.blockFakeLight.getStateFromMeta(0), 2);
                TileEntity te = this.world.getTileEntity(cc);
                if (te instanceof BlockFakeLight.TileEntityFakeLight) {
                    ((BlockFakeLight.TileEntityFakeLight)te).floodlightCoords = new int[]{this.getPos().getX(), this.getPos().getY(), this.getPos().getZ()};
                }
                this.fakeLights.add(cc);
                it.remove();
            }
            it = this.lightsToBeRemoved.iterator();
            timeout = 0;
            while (it.hasNext() && timeout++ < 16) {
                cc = it.next();
                if (Utils.getExistingTileEntity(this.world, cc) instanceof BlockFakeLight.TileEntityFakeLight) {
                    this.world.setBlockToAir(cc);
                }
                it.remove();
            }
        }
    }

    public void updateFakeLights(boolean deleteOld, boolean genNew) {
        Iterator<BlockPos> it = this.fakeLights.iterator();
        ArrayList<BlockPos> tempRemove = new ArrayList<BlockPos>();
        while (it.hasNext()) {
            BlockPos cc = it.next();
            TileEntity te = this.world.getTileEntity(cc);
            if (te instanceof BlockFakeLight.TileEntityFakeLight) {
                if (!deleteOld) continue;
                tempRemove.add(cc);
                continue;
            }
            it.remove();
        }
        if (genNew) {
            float angle = this.facing == EnumFacing.NORTH ? 180 : (this.facing == EnumFacing.EAST ? 90 : (this.facing == EnumFacing.WEST ? -90 : 0));
            float yRotation = this.rotY;
            double angleX = Math.toRadians(this.rotX);
            Vec3d[] rays = new Vec3d[]{new Vec3d(0.0, 0.0, 1.0), new Vec3d(0.0, 0.0, 1.0), new Vec3d(0.0, 0.0, 1.0), new Vec3d(0.0, 0.0, 1.0), new Vec3d(0.0, 0.0, 1.0), new Vec3d(0.0, 0.0, 1.0), new Vec3d(0.0, 0.0, 1.0), new Vec3d(0.0, 0.0, 1.0), new Vec3d(0.0, 0.0, 1.0), new Vec3d(0.0, 0.0, 1.0), new Vec3d(0.0, 0.0, 1.0), new Vec3d(0.0, 0.0, 1.0), new Vec3d(0.0, 0.0, 1.0)};
            Matrix4 mat = new Matrix4();
            if (this.side == EnumFacing.DOWN) {
                mat.scale(1.0, -1.0, 1.0);
            } else if (this.side != EnumFacing.UP) {
                float f = this.facing == EnumFacing.DOWN ? 180.0f : (this.facing == EnumFacing.NORTH ? -90.0f : (angle = this.facing == EnumFacing.SOUTH ? 90.0f : angle));
                if (this.side.getAxis() == EnumFacing.Axis.X) {
                    mat.rotate(1.5707963267948966, -1.0, 0.0, 0.0);
                    mat.rotate(1.5707963267948966, 0.0, 0.0, -this.side.getAxisDirection().getOffset());
                } else {
                    mat.rotate(1.5707963267948966, -1.0, 0.0, 0.0);
                    if (this.side == EnumFacing.SOUTH) {
                        mat.rotate(Math.PI, 0.0, 0.0, 1.0);
                        if (this.facing.getAxis() == EnumFacing.Axis.X) {
                            angle = -angle;
                        }
                    }
                }
            }
            double angleY = Math.toRadians(angle + yRotation);
            mat.rotate(angleY, 0.0, 1.0, 0.0);
            mat.rotate(-angleX, 1.0, 0.0, 0.0);
            rays[0] = mat.apply(rays[0]);
            mat.rotate(0.39269908169872414, 0.0, 1.0, 0.0);
            rays[1] = mat.apply(rays[1]);
            mat.rotate(-0.19634954084936207, 0.0, 1.0, 0.0);
            rays[5] = mat.apply(rays[5]);
            mat.rotate(-0.39269908169872414, 0.0, 1.0, 0.0);
            rays[6] = mat.apply(rays[6]);
            mat.rotate(-0.19634954084936207, 0.0, 1.0, 0.0);
            rays[2] = mat.apply(rays[2]);
            mat.rotate(0.39269908169872414, 0.0, 1.0, 0.0);
            mat.rotate(0.39269908169872414, 1.0, 0.0, 0.0);
            rays[3] = mat.apply(rays[3]);
            mat.rotate(-0.19634954084936207, 1.0, 0.0, 0.0);
            rays[7] = mat.apply(rays[7]);
            mat.rotate(-0.39269908169872414, 1.0, 0.0, 0.0);
            rays[8] = mat.apply(rays[8]);
            mat.rotate(-0.19634954084936207, 1.0, 0.0, 0.0);
            rays[4] = mat.apply(rays[4]);
            mat.rotate(0.39269908169872414, 1.0, 0.0, 0.0);
            mat.rotate(0.19634954084936207, 1.0, 0.0, 0.0);
            mat.rotate(0.19634954084936207, 0.0, 1.0, 0.0);
            rays[9] = mat.apply(rays[9]);
            mat.rotate(-0.39269908169872414, 0.0, 1.0, 0.0);
            rays[10] = mat.apply(rays[10]);
            mat.rotate(-0.39269908169872414, 1.0, 0.0, 0.0);
            rays[11] = mat.apply(rays[11]);
            mat.rotate(0.39269908169872414, 0.0, 1.0, 0.0);
            rays[12] = mat.apply(rays[12]);
            for (int ray = 0; ray < rays.length; ++ray) {
                int offset = ray == 0 ? 0 : (ray < 4 ? 3 : 1);
                this.placeLightAlongVector(rays[ray], offset, tempRemove);
            }
        }
        this.lightsToBeRemoved.addAll(tempRemove);
    }

    public void placeLightAlongVector(Vec3d vec, int offset, ArrayList<BlockPos> checklist) {
        Vec3d light = new Vec3d((Vec3i)this.getPos()).addVector(0.5, 0.75, 0.5);
        int range = 32;
        HashSet<BlockPos> ignore = new HashSet<BlockPos>();
        ignore.add(this.getPos());
        BlockPos hit = Utils.rayTraceForFirst(Utils.addVectors(vec, light), light.addVector(vec.x * (double)range, vec.y * (double)range, vec.z * (double)range), this.world, ignore);
        double maxDistance = hit != null ? new Vec3d((Vec3i)hit).addVector(0.5, 0.75, 0.5).squareDistanceTo(light) : (double)(range * range);
        for (int i = 1 + offset; i <= range; ++i) {
            BlockPos target = this.getPos().add((double)Math.round(vec.x * (double)i), (double)Math.round(vec.y * (double)i), (double)Math.round(vec.z * (double)i));
            double dist = vec.x * (double)i * vec.x * (double)i + vec.y * (double)i * vec.y * (double)i + vec.z * (double)i * vec.z * (double)i;
            if (dist > maxDistance) break;
            if (target.getY() > 255 || target.getY() < 0 || target.equals((Object)this.getPos()) || !this.world.isAirBlock(target)) continue;
            if (!checklist.remove(target)) {
                this.lightsToBePlaced.add(target);
            }
            i += 2;
        }
    }

    @Override
    public double getInterdictionRangeSquared() {
        return this.active ? 1024.0 : 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate() {
        ArrayList<IEBlockInterfaces.ISpawnInterdiction> arrayList = EventHandler.interdictionTiles;
        synchronized (arrayList) {
            if (EventHandler.interdictionTiles.contains(this)) {
                EventHandler.interdictionTiles.remove(this);
            }
        }
        super.invalidate();
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.active = nbt.getBoolean("active");
        this.energyStorage = nbt.getInteger("energy");
        this.redstoneControlInverted = nbt.getBoolean("redstoneControlInverted");
        this.facing = EnumFacing.getFront((int)nbt.getInteger("facing"));
        this.side = EnumFacing.getFront((int)nbt.getInteger("side"));
        this.rotY = nbt.getFloat("rotY");
        this.rotX = nbt.getFloat("rotX");
        int lightAmount = nbt.getInteger("lightAmount");
        this.fakeLights.clear();
        for (int i = 0; i < lightAmount; ++i) {
            int[] icc = nbt.getIntArray("fakeLight_" + i);
            this.fakeLights.add(new BlockPos(icc[0], icc[1], icc[2]));
        }
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && this.world != null) {
            this.markContainingBlockForUpdate(null);
        }
        if (descPacket) {
            this.controllingComputers = nbt.getBoolean("computerControlled") ? 1 : 0;
            this.computerOn = nbt.getBoolean("computerOn");
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.setBoolean("active", this.active);
        nbt.setInteger("energyStorage", this.energyStorage);
        nbt.setBoolean("redstoneControlInverted", this.redstoneControlInverted);
        nbt.setInteger("facing", this.facing.ordinal());
        nbt.setInteger("side", this.side.ordinal());
        nbt.setFloat("rotY", this.rotY);
        nbt.setFloat("rotX", this.rotX);
        nbt.setInteger("lightAmount", this.fakeLights.size());
        for (int i = 0; i < this.fakeLights.size(); ++i) {
            BlockPos cc = this.fakeLights.get(i);
            nbt.setIntArray("fakeLight_" + i, new int[]{cc.getX(), cc.getY(), cc.getZ()});
        }
        if (descPacket) {
            nbt.setBoolean("computerControlled", this.controllingComputers > 0);
            nbt.setBoolean("computerOn", this.computerOn);
        }
    }

    @Override
    protected boolean canTakeLV() {
        return true;
    }

    @Override
    public boolean isEnergyOutput() {
        return true;
    }

    @Override
    protected boolean isRelay() {
        return true;
    }

    @Override
    public int outputEnergy(int amount, boolean simulate, int energyType) {
        if (amount > 0 && this.energyStorage < this.maximumStorage) {
            if (!simulate) {
                int rec = Math.min(this.maximumStorage - this.energyStorage, amount);
                this.energyStorage += rec;
                return rec;
            }
            return Math.min(this.maximumStorage - this.energyStorage, amount);
        }
        return 0;
    }

    @Override
    public boolean receiveClientEvent(int id, int arg) {
        if (id == 1) {
            this.markContainingBlockForUpdate(null);
            this.world.checkLightFor(EnumSkyBlock.BLOCK, this.getPos());
            return true;
        }
        return super.receiveClientEvent(id, arg);
    }

    @Override
    public Vec3d getRaytraceOffset(IImmersiveConnectable link) {
        double z;
        double y;
        double x;
        int xDif = ((TileEntity)link).getPos().getX() - this.getPos().getX();
        int yDif = ((TileEntity)link).getPos().getY() - this.getPos().getY();
        int zDif = ((TileEntity)link).getPos().getZ() - this.getPos().getZ();
        switch (this.side) {
            case DOWN: 
            case UP: {
                x = Math.abs(xDif) >= Math.abs(zDif) ? (xDif >= 0 ? 0.9375 : 0.0625) : 0.5;
                double d = y = this.side == EnumFacing.DOWN ? 0.9375 : 0.0625;
                z = Math.abs(zDif) > Math.abs(xDif) ? (zDif >= 0 ? 0.9375 : 0.0625) : 0.5;
                break;
            }
            case NORTH: 
            case SOUTH: {
                double d = Math.abs(xDif) >= Math.abs(yDif) ? (xDif >= 0 ? 0.9375 : 0.0625) : (x = 0.5);
                y = Math.abs(yDif) > Math.abs(xDif) ? (yDif >= 0 ? 0.9375 : 0.0625) : 0.5;
                z = this.side == EnumFacing.NORTH ? 0.9375 : 0.0625;
                break;
            }
            default: {
                double d = x = this.side == EnumFacing.WEST ? 0.9375 : 0.0625;
                double d2 = Math.abs(yDif) >= Math.abs(zDif) ? (yDif >= 0 ? 0.9375 : 0.0625) : (y = 0.5);
                z = Math.abs(zDif) > Math.abs(yDif) ? (zDif >= 0 ? 0.9375 : 0.0625) : 0.5;
            }
        }
        return new Vec3d(x, y, z);
    }

    @Override
    public Vec3d getConnectionOffset(ImmersiveNetHandler.Connection con) {
        double z;
        double y;
        double x;
        int yDif;
        int xDif;
        int n = con == null || con.start == null || con.end == null ? 0 : (con.start.equals((Object)Utils.toCC(this)) && con.end != null ? con.end.getX() - this.getPos().getX() : (xDif = con.end.equals((Object)Utils.toCC(this)) && con.start != null ? con.start.getX() - this.getPos().getX() : 0));
        int n2 = con == null || con.start == null || con.end == null ? 0 : (con.start.equals((Object)Utils.toCC(this)) && con.end != null ? con.end.getY() - this.getPos().getY() : (yDif = con.end.equals((Object)Utils.toCC(this)) && con.start != null ? con.start.getY() - this.getPos().getY() : 0));
        int zDif = con == null || con.start == null || con.end == null ? 0 : (con.start.equals((Object)Utils.toCC(this)) && con.end != null ? con.end.getZ() - this.getPos().getZ() : (con.end.equals((Object)Utils.toCC(this)) && con.start != null ? con.start.getZ() - this.getPos().getZ() : 0));
        switch (this.side) {
            case DOWN: 
            case UP: {
                x = Math.abs(xDif) >= Math.abs(zDif) ? (xDif >= 0 ? 0.9375 : 0.0625) : 0.5;
                double d = y = this.side == EnumFacing.DOWN ? 0.9375 : 0.0625;
                z = Math.abs(zDif) > Math.abs(xDif) ? (zDif >= 0 ? 0.9375 : 0.0625) : 0.5;
                break;
            }
            case NORTH: 
            case SOUTH: {
                double d = Math.abs(xDif) >= Math.abs(yDif) ? (xDif >= 0 ? 0.9375 : 0.0625) : (x = 0.5);
                y = Math.abs(yDif) > Math.abs(xDif) ? (yDif >= 0 ? 0.9375 : 0.0625) : 0.5;
                z = this.side == EnumFacing.NORTH ? 0.9375 : 0.0625;
                break;
            }
            default: {
                double d = x = this.side == EnumFacing.WEST ? 0.9375 : 0.0625;
                double d2 = Math.abs(yDif) >= Math.abs(zDif) ? (yDif >= 0 ? 0.9375 : 0.0625) : (y = 0.5);
                z = Math.abs(zDif) > Math.abs(yDif) ? (zDif >= 0 ? 0.9375 : 0.0625) : 0.5;
            }
        }
        return new Vec3d(x, y, z);
    }

    @Override
    public float[] getBlockBounds() {
        return new float[]{this.side.getAxis() == EnumFacing.Axis.X ? 0.0f : 0.0625f, this.side.getAxis() == EnumFacing.Axis.Y ? 0.0f : 0.0625f, this.side.getAxis() == EnumFacing.Axis.Z ? 0.0f : 0.0625f, this.side.getAxis() == EnumFacing.Axis.X ? 1.0f : 0.9375f, this.side.getAxis() == EnumFacing.Axis.Y ? 1.0f : 0.9375f, this.side.getAxis() == EnumFacing.Axis.Z ? 1.0f : 0.9375f};
    }

    @Override
    public IEProperties.PropertyBoolInverted getBoolProperty(Class<? extends IEBlockInterfaces.IUsesBooleanProperty> inf) {
        return IEProperties.BOOLEANS[0];
    }

    @Override
    public boolean getIsActive() {
        return this.active;
    }

    @Override
    public int getLightValue() {
        return this.active ? 15 : 0;
    }

    @Override
    public boolean hammerUseSide(EnumFacing side, EntityPlayer player, float hitX, float hitY, float hitZ) {
        if (player.isSneaking() && side != this.side) {
            boolean base;
            boolean bl = this.side == EnumFacing.DOWN ? (double)hitY >= 0.8125 : (this.side == EnumFacing.UP ? (double)hitY <= 0.1875 : (this.side == EnumFacing.NORTH ? (double)hitZ >= 0.8125 : (this.side == EnumFacing.UP ? (double)hitZ <= 0.1875 : (this.side == EnumFacing.WEST ? (double)hitX >= 0.8125 : (base = (double)hitX <= 0.1875)))));
            if (base) {
                this.redstoneControlInverted = !this.redstoneControlInverted;
                ChatUtils.sendServerNoSpamMessages(player, new ITextComponent[]{new TextComponentTranslation("chat.immersiveengineering.info.rsControl." + (this.redstoneControlInverted ? "invertedOn" : "invertedOff"), new Object[0])});
                this.markDirty();
                this.markContainingBlockForUpdate(null);
                return true;
            }
        }
        if (side.getAxis() == this.side.getAxis()) {
            this.turnY(player.isSneaking(), false);
        } else {
            this.turnX(player.isSneaking(), false);
        }
        return true;
    }

    @Override
    public EnumFacing getFacing() {
        return this.side;
    }

    @Override
    public void setFacing(EnumFacing facing) {
        this.side = facing;
    }

    @Override
    public int getFacingLimitation() {
        return 0;
    }

    @Override
    public boolean mirrorFacingOnPlacement(EntityLivingBase placer) {
        return false;
    }

    @Override
    public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity) {
        return false;
    }

    @Override
    public boolean canRotate(EnumFacing axis) {
        return false;
    }

    @Override
    public void onDirectionalPlacement(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase placer) {
        EnumFacing f = EnumFacing.fromAngle((double)placer.rotationYaw);
        if (f == side.getOpposite()) {
            f = placer.rotationPitch > 0.0f ? EnumFacing.DOWN : EnumFacing.UP;
        }
        this.facing = f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldRenderGroup(IBlockState object, String group) {
        if ("glass".equals(group)) {
            return MinecraftForgeClient.getRenderLayer() == BlockRenderLayer.TRANSLUCENT;
        }
        return MinecraftForgeClient.getRenderLayer() == BlockRenderLayer.SOLID;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Optional<TRSRTransformation> applyTransformations(IBlockState object, String group, Optional<TRSRTransformation> transform) {
        if (!transform.isPresent()) {
            transform = Optional.of(new TRSRTransformation((Matrix4f)null));
        }
        Matrix4f mat = transform.get().getMatrix();
        Vector3f transl = new Vector3f(0.5f, 0.5f, 0.5f);
        double yaw = 0.0;
        double pitch = 0.0;
        double roll = 0.0;
        if (this.side.getAxis() == EnumFacing.Axis.Y) {
            double d = this.facing == EnumFacing.SOUTH ? 180.0 : (this.facing == EnumFacing.WEST ? 90.0 : (yaw = this.facing == EnumFacing.EAST ? -90.0 : 0.0));
            if (this.side == EnumFacing.DOWN) {
                roll = 180.0;
            }
        } else {
            if (this.side == EnumFacing.NORTH) {
                pitch = 90.0;
                yaw = 180.0;
            }
            if (this.side == EnumFacing.SOUTH) {
                pitch = 90.0;
            }
            if (this.side == EnumFacing.WEST) {
                pitch = 90.0;
                yaw = -90.0;
            }
            if (this.side == EnumFacing.EAST) {
                pitch = 90.0;
                yaw = 90.0;
            }
            if (this.facing == EnumFacing.DOWN) {
                roll += 180.0;
            } else if (this.side.getAxis() == EnumFacing.Axis.X && this.facing.getAxis() == EnumFacing.Axis.Z) {
                roll += (double)(90 * this.facing.getAxisDirection().getOffset() * this.side.getAxisDirection().getOffset());
            } else if (this.side.getAxis() == EnumFacing.Axis.Z && this.facing.getAxis() == EnumFacing.Axis.X) {
                roll += (double)(-90 * this.facing.getAxisDirection().getOffset() * this.side.getAxisDirection().getOffset());
            }
        }
        transl.add((Tuple3f)new Vector3f((float)this.side.getFrontOffsetX() * 0.125f, (float)this.side.getFrontOffsetY() * 0.125f, (float)this.side.getFrontOffsetZ() * 0.125f));
        if ("axis".equals(group) || "light".equals(group) || "off".equals(group) || "glass".equals(group)) {
            if (this.side.getAxis() == EnumFacing.Axis.Y) {
                yaw += (double)this.rotY;
            } else {
                roll += (double)this.rotY;
            }
            if ("light".equals(group) || "off".equals(group) || "glass".equals(group)) {
                pitch += (double)this.rotX;
            }
        }
        mat.setRotation(ClientUtils.degreeToQuaterion(pitch, yaw, roll));
        mat.setTranslation(transl);
        return Optional.of(new TRSRTransformation(mat));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getCacheKey(IBlockState object) {
        return this.rotX + ":" + this.rotY + ":" + this.active;
    }

    public boolean canComputerTurn() {
        return this.turnCooldown <= 0 || !this.active;
    }

    public void turnX(boolean dir, boolean throwException) {
        if (!this.canComputerTurn()) {
            if (throwException) {
                throw new IllegalArgumentException("The floodlight can't turn again yet.");
            }
            return;
        }
        this.rotX = Math.min(191.25f, Math.max(-11.25f, this.rotX + (dir ? -11.25f : 11.25f)));
        this.markDirty();
        this.markContainingBlockForUpdate(null);
        this.world.addBlockEvent(this.getPos(), this.getBlockType(), 255, 0);
        this.turnCooldown = 20;
    }

    public void turnY(boolean dir, boolean throwException) {
        if (!this.canComputerTurn()) {
            if (throwException) {
                throw new IllegalArgumentException("The floodlight can't turn again yet.");
            }
            return;
        }
        this.rotY = (float)((double)this.rotY + (dir ? -11.25 : 11.25));
        this.rotY %= 360.0f;
        this.markDirty();
        this.markContainingBlockForUpdate(null);
        this.world.addBlockEvent(this.getPos(), this.getBlockType(), 255, 0);
        this.turnCooldown = 20;
    }
}

