/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.crafting.IMultiblockRecipe;
import blusunrize.immersiveengineering.api.tool.ExcavatorHandler;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityBucketWheel;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockMetal;
import blusunrize.immersiveengineering.common.blocks.multiblocks.MultiblockExcavator;
import blusunrize.immersiveengineering.common.util.FakePlayerUtil;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.network.MessageTileSync;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileEntityExcavator
extends TileEntityMultiblockMetal<TileEntityExcavator, IMultiblockRecipe>
implements IEBlockInterfaces.IAdvancedSelectionBounds,
IEBlockInterfaces.IAdvancedCollisionBounds {
    public boolean active = false;

    public TileEntityExcavator() {
        super(MultiblockExcavator.instance, new int[]{3, 6, 3}, 64000, true);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
    }

    @Override
    public int getComparatorInputOverride() {
        if (!this.isRedstonePos()) {
            return 0;
        }
        BlockPos wheelPos = this.getBlockPosForPos(31);
        if (this.world.isBlockLoaded(wheelPos) && this.world.getTileEntity(wheelPos) instanceof TileEntityBucketWheel) {
            ExcavatorHandler.MineralWorldInfo info = ExcavatorHandler.getMineralWorldInfo(this.world, wheelPos.getX() >> 4, wheelPos.getZ() >> 4);
            float remain = (float)(ExcavatorHandler.mineralVeinCapacity - info.depletion) / (float)ExcavatorHandler.mineralVeinCapacity;
            return MathHelper.floor((float)(Math.max(remain, 0.0f) * 15.0f));
        }
        return 0;
    }

    @Override
    public void update() {
        TileEntity center;
        super.update();
        if (this.isDummy()) {
            return;
        }
        BlockPos wheelPos = this.getBlockPosForPos(31);
        if (!this.world.isRemote && this.world.isBlockLoaded(wheelPos) && (center = this.world.getTileEntity(wheelPos)) instanceof TileEntityBucketWheel) {
            float rot = 0.0f;
            int target = -1;
            TileEntityBucketWheel wheel = (TileEntityBucketWheel)center;
            EnumFacing fRot = this.facing.rotateYCCW();
            if (wheel.facing == fRot) {
                if (this.active != wheel.active) {
                    this.world.addBlockEvent(wheel.getPos(), wheel.getBlockType(), 0, this.active ? 1 : 0);
                }
                if ((rot = wheel.rotation) % 45.0f > 40.0f) {
                    target = Math.round(rot / 360.0f * 8.0f) % 8;
                }
            }
            if (wheel.facing != fRot || wheel.mirrored != this.mirrored) {
                for (int h = -3; h <= 3; ++h) {
                    for (int w = -3; w <= 3; ++w) {
                        TileEntity te = this.world.getTileEntity(wheelPos.add(0, h, 0).offset(this.facing, w));
                        if (!(te instanceof TileEntityBucketWheel)) continue;
                        ((TileEntityBucketWheel)te).facing = fRot;
                        ((TileEntityBucketWheel)te).mirrored = this.mirrored;
                        te.markDirty();
                        ((TileEntityBucketWheel)te).markContainingBlockForUpdate(null);
                        this.world.addBlockEvent(te.getPos(), te.getBlockType(), 255, 0);
                    }
                }
            }
            if (!this.isRSDisabled()) {
                ExcavatorHandler.MineralMix mineral = ExcavatorHandler.getRandomMineral(this.world, wheelPos.getX() >> 4, wheelPos.getZ() >> 4);
                int consumed = Config.IEConfig.Machines.excavator_consumption;
                int extracted = this.energyStorage.extractEnergy(consumed, true);
                if (extracted >= consumed) {
                    this.energyStorage.extractEnergy(consumed, false);
                    this.active = true;
                    if (target >= 0 && target < 8) {
                        int targetDown = (target + 4) % 8;
                        NBTTagCompound packet = new NBTTagCompound();
                        if (((ItemStack)wheel.digStacks.get(targetDown)).isEmpty()) {
                            ItemStack blocking = this.digBlocksInTheWay(wheel);
                            BlockPos lowGroundPos = wheelPos.add(0, -5, 0);
                            if (!blocking.isEmpty()) {
                                wheel.digStacks.set(targetDown, (Object)blocking);
                                wheel.markDirty();
                                this.markContainingBlockForUpdate(null);
                            } else if (!(mineral == null || this.world.isAirBlock(lowGroundPos.offset(this.facing, -2)) || this.world.isAirBlock(lowGroundPos.offset(this.facing, 2)) || this.world.isAirBlock(lowGroundPos.offset(this.facing, -1)) || this.world.isAirBlock(lowGroundPos.offset(this.facing, 1)) || this.world.isAirBlock(lowGroundPos))) {
                                ItemStack ore = mineral.getRandomOre(Utils.RAND);
                                float configChance = Utils.RAND.nextFloat();
                                float failChance = Utils.RAND.nextFloat();
                                if (!ore.isEmpty() && (double)configChance > Config.IEConfig.Machines.excavator_fail_chance && failChance > mineral.failChance) {
                                    wheel.digStacks.set(targetDown, (Object)ore);
                                    wheel.markDirty();
                                    this.markContainingBlockForUpdate(null);
                                }
                                ExcavatorHandler.depleteMinerals(this.world, wheelPos.getX() >> 4, wheelPos.getZ() >> 4);
                            }
                            if (!((ItemStack)wheel.digStacks.get(targetDown)).isEmpty()) {
                                packet.setInteger("fill", targetDown);
                                packet.setTag("fillStack", (NBTBase)((ItemStack)wheel.digStacks.get(targetDown)).writeToNBT(new NBTTagCompound()));
                            }
                        }
                        if (!((ItemStack)wheel.digStacks.get(target)).isEmpty()) {
                            this.doProcessOutput(((ItemStack)wheel.digStacks.get(target)).copy());
                            Block b = Block.getBlockFromItem((Item)((ItemStack)wheel.digStacks.get(target)).getItem());
                            if (b != null && b != Blocks.AIR) {
                                wheel.particleStack = ((ItemStack)wheel.digStacks.get(target)).copy();
                            }
                            wheel.digStacks.set(target, (Object)ItemStack.EMPTY);
                            wheel.markDirty();
                            this.markContainingBlockForUpdate(null);
                            packet.setInteger("empty", target);
                        }
                        if (!packet.hasNoTags()) {
                            ImmersiveEngineering.packetHandler.sendToAll((IMessage)new MessageTileSync(wheel, packet));
                        }
                    }
                } else if (this.active) {
                    this.active = false;
                }
            } else if (this.active) {
                this.active = false;
            }
        }
    }

    ItemStack digBlocksInTheWay(TileEntityBucketWheel wheel) {
        BlockPos pos = wheel.getPos().add(0, -4, 0);
        ItemStack s = this.digBlock(pos);
        if (!s.isEmpty()) {
            return s;
        }
        s = this.digBlock(pos.offset(this.facing, -1));
        if (!s.isEmpty()) {
            return s;
        }
        s = this.digBlock(pos.offset(this.facing, -2));
        if (!s.isEmpty()) {
            return s;
        }
        s = this.digBlock(pos.offset(this.facing, 1));
        if (!s.isEmpty()) {
            return s;
        }
        s = this.digBlock(pos.offset(this.facing, 2));
        if (!s.isEmpty()) {
            return s;
        }
        s = this.digBlock(pos.offset(this.facing, -1).offset(this.facing.rotateY()));
        if (!s.isEmpty()) {
            return s;
        }
        s = this.digBlock(pos.offset(this.facing, -1).offset(this.facing.rotateYCCW()));
        if (!s.isEmpty()) {
            return s;
        }
        s = this.digBlock(pos.offset(this.facing.rotateY()));
        if (!s.isEmpty()) {
            return s;
        }
        s = this.digBlock(pos.offset(this.facing.rotateYCCW()));
        if (!s.isEmpty()) {
            return s;
        }
        s = this.digBlock(pos.offset(this.facing, 1).offset(this.facing.rotateY()));
        if (!s.isEmpty()) {
            return s;
        }
        s = this.digBlock(pos.offset(this.facing, 1).offset(this.facing.rotateYCCW()));
        if (!s.isEmpty()) {
            return s;
        }
        return ItemStack.EMPTY;
    }

    ItemStack digBlock(BlockPos pos) {
        if (!(this.world instanceof WorldServer)) {
            return ItemStack.EMPTY;
        }
        FakePlayer fakePlayer = FakePlayerUtil.getFakePlayer((WorldServer)this.world);
        IBlockState blockstate = this.world.getBlockState(pos);
        Block block = blockstate.getBlock();
        if (block != null && !this.world.isAirBlock(pos) && blockstate.getPlayerRelativeBlockHardness((EntityPlayer)fakePlayer, this.world, pos) != 0.0f) {
            if (!block.canHarvestBlock((IBlockAccess)this.world, pos, (EntityPlayer)fakePlayer)) {
                return ItemStack.EMPTY;
            }
            block.onBlockHarvested(this.world, pos, blockstate, (EntityPlayer)fakePlayer);
            if (block.removedByPlayer(blockstate, this.world, pos, (EntityPlayer)fakePlayer, true)) {
                block.onBlockDestroyedByPlayer(this.world, pos, blockstate);
                if (block.canSilkHarvest(this.world, pos, blockstate, (EntityPlayer)fakePlayer)) {
                    ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                    Item bitem = Item.getItemFromBlock((Block)block);
                    if (bitem == Items.AIR) {
                        return ItemStack.EMPTY;
                    }
                    ItemStack itemstack = new ItemStack(bitem, 1, block.getMetaFromState(blockstate));
                    if (!itemstack.isEmpty()) {
                        items.add(itemstack);
                    }
                    ForgeEventFactory.fireBlockHarvesting(items, (World)this.world, (BlockPos)pos, (IBlockState)blockstate, (int)0, (float)1.0f, (boolean)true, (EntityPlayer)fakePlayer);
                    for (int i = 0; i < items.size(); ++i) {
                        if (i == 0) continue;
                        EntityItem ei = new EntityItem(this.world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, ((ItemStack)items.get(i)).copy());
                        this.world.spawnEntity((Entity)ei);
                    }
                    this.world.playEvent(2001, pos, Block.getStateId((IBlockState)blockstate));
                    if (items.size() > 0) {
                        return (ItemStack)items.get(0);
                    }
                } else {
                    block.harvestBlock(this.world, (EntityPlayer)fakePlayer, pos, blockstate, this.world.getTileEntity(pos), ItemStack.EMPTY);
                    this.world.playEvent(2001, pos, Block.getStateId((IBlockState)blockstate));
                }
            }
        }
        return ItemStack.EMPTY;
    }

    @Override
    public float[] getBlockBounds() {
        EnumFacing fl = this.facing;
        EnumFacing fw = this.facing.rotateY();
        if (this.mirrored) {
            fw = fw.getOpposite();
        }
        if (this.pos == 45) {
            return new float[]{fl == EnumFacing.EAST ? 0.5f : 0.0f, 0.0f, fl == EnumFacing.SOUTH ? 0.5f : 0.0f, fl == EnumFacing.WEST ? 0.5f : 1.0f, 0.5f, fl == EnumFacing.NORTH ? 0.5f : 1.0f};
        }
        if (this.pos == 48) {
            return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f};
        }
        if (this.pos == 51) {
            return new float[]{fl == EnumFacing.WEST ? 0.5f : 0.0f, 0.0f, fl == EnumFacing.NORTH ? 0.5f : 0.0f, fl == EnumFacing.EAST ? 0.5f : 1.0f, 0.5f, fl == EnumFacing.SOUTH ? 0.5f : 1.0f};
        }
        if (this.pos == 47) {
            float[] fArray = new float[6];
            fArray[0] = fl == EnumFacing.EAST ? 0.5f : (fl == EnumFacing.WEST ? 0.375f : 0.0f);
            fArray[1] = 0.0f;
            float f = fl == EnumFacing.SOUTH ? 0.5f : (fArray[2] = fl == EnumFacing.NORTH ? 0.375f : 0.0f);
            fArray[3] = fl == EnumFacing.WEST ? 0.5f : (fl == EnumFacing.EAST ? 0.625f : 1.0f);
            fArray[4] = 1.0f;
            fArray[5] = fl == EnumFacing.NORTH ? 0.5f : (fl == EnumFacing.SOUTH ? 0.625f : 1.0f);
            return fArray;
        }
        if (this.pos == 50) {
            return new float[]{fw == EnumFacing.EAST ? 0.875f : 0.0f, 0.0f, fw == EnumFacing.SOUTH ? 0.875f : 0.0f, fw == EnumFacing.WEST ? 0.125f : 1.0f, 1.0f, fw == EnumFacing.NORTH ? 0.125f : 1.0f};
        }
        if (this.pos == 53) {
            float[] fArray = new float[6];
            fArray[0] = fl == EnumFacing.WEST ? 0.5f : (fl == EnumFacing.EAST ? 0.375f : 0.0f);
            fArray[1] = 0.0f;
            float f = fl == EnumFacing.NORTH ? 0.5f : (fArray[2] = fl == EnumFacing.SOUTH ? 0.375f : 0.0f);
            fArray[3] = fl == EnumFacing.EAST ? 0.5f : (fl == EnumFacing.WEST ? 0.625f : 1.0f);
            fArray[4] = 1.0f;
            fArray[5] = fl == EnumFacing.SOUTH ? 0.5f : (fl == EnumFacing.NORTH ? 0.625f : 1.0f);
            return fArray;
        }
        if (this.pos == 5 || this.pos == 23 || this.pos == 41) {
            return new float[]{fw == EnumFacing.WEST ? 0.5f : 0.0f, 0.0f, fw == EnumFacing.NORTH ? 0.5f : 0.0f, fw == EnumFacing.EAST ? 0.5f : 1.0f, 1.0f, fw == EnumFacing.SOUTH ? 0.5f : 1.0f};
        }
        if (this.pos == 9 || this.pos == 12 || this.pos == 15) {
            return new float[]{fw == EnumFacing.EAST ? 0.5f : 0.0f, 0.0f, fw == EnumFacing.SOUTH ? 0.5f : 0.0f, fw == EnumFacing.WEST ? 0.5f : 1.0f, 1.0f, fw == EnumFacing.NORTH ? 0.5f : 1.0f};
        }
        if (this.pos == 11 || this.pos == 14 || this.pos == 17) {
            return new float[]{fw == EnumFacing.WEST ? 0.5f : 0.0f, 0.0f, fw == EnumFacing.NORTH ? 0.5f : 0.0f, fw == EnumFacing.EAST ? 0.5f : 1.0f, 1.0f, fw == EnumFacing.SOUTH ? 0.5f : 1.0f};
        }
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    @Override
    public List<AxisAlignedBB> getAdvancedSelectionBounds() {
        EnumFacing fl = this.facing;
        EnumFacing fw = this.facing.rotateY();
        if (this.mirrored) {
            fw = fw.getOpposite();
        }
        if (this.pos == 5 || this.pos == 23 || this.pos == 41) {
            ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(fw == EnumFacing.WEST ? 0.5 : 0.0, 0.0, fw == EnumFacing.NORTH ? 0.5 : 0.0, fw == EnumFacing.EAST ? 0.5 : 1.0, 1.0, fw == EnumFacing.SOUTH ? 0.5 : 1.0).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ())});
            list.add(new AxisAlignedBB(fw == EnumFacing.EAST ? 0.5 : (fw == EnumFacing.WEST ? 0.0 : 0.25), 0.25, fw == EnumFacing.SOUTH ? 0.5 : (fw == EnumFacing.NORTH ? 0.0 : 0.25), fw == EnumFacing.WEST ? 0.5 : (fw == EnumFacing.EAST ? 1.0 : 0.75), 0.75, fw == EnumFacing.NORTH ? 0.5 : (fw == EnumFacing.SOUTH ? 1.0 : 0.75)).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ()));
            return list;
        }
        if (this.pos == 9 || this.pos == 12 || this.pos == 15) {
            ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(fw == EnumFacing.EAST ? 0.5 : 0.0, 0.0, fw == EnumFacing.SOUTH ? 0.5 : 0.0, fw == EnumFacing.WEST ? 0.5 : 1.0, 1.0, fw == EnumFacing.NORTH ? 0.5 : 1.0).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ())});
            if (this.pos == 9) {
                list.add(new AxisAlignedBB(fw == EnumFacing.WEST || fl == EnumFacing.EAST ? 0.5 : 0.0, 0.5, fw == EnumFacing.NORTH || fl == EnumFacing.SOUTH ? 0.5 : 0.0, fw == EnumFacing.EAST || fl == EnumFacing.WEST ? 0.5 : 1.0, 1.0, fw == EnumFacing.SOUTH || fl == EnumFacing.NORTH ? 0.5 : 1.0).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ()));
            } else if (this.pos == 12) {
                list.add(new AxisAlignedBB(fw == EnumFacing.WEST ? 0.5 : 0.0, 0.5, fw == EnumFacing.NORTH ? 0.5 : 0.0, fw == EnumFacing.EAST ? 0.5 : 1.0, 1.0, fw == EnumFacing.SOUTH ? 0.5 : 1.0).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ()));
            } else {
                list.add(new AxisAlignedBB(fw == EnumFacing.WEST || fl == EnumFacing.WEST ? 0.5 : 0.0, 0.5, fw == EnumFacing.NORTH || fl == EnumFacing.NORTH ? 0.5 : 0.0, fw == EnumFacing.EAST || fl == EnumFacing.EAST ? 0.5 : 1.0, 1.0, fw == EnumFacing.SOUTH || fl == EnumFacing.SOUTH ? 0.5 : 1.0).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ()));
            }
            return list;
        }
        if (this.pos == 47) {
            ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(fl == EnumFacing.EAST ? 0.5 : (fl == EnumFacing.WEST ? 0.375 : 0.0), 0.0, fl == EnumFacing.SOUTH ? 0.5 : (fl == EnumFacing.NORTH ? 0.375 : 0.0), fl == EnumFacing.WEST ? 0.5 : (fl == EnumFacing.EAST ? 0.625 : 1.0), 1.0, fl == EnumFacing.NORTH ? 0.5 : (fl == EnumFacing.SOUTH ? 0.625 : 1.0)).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ())});
            list.add(new AxisAlignedBB(fl == EnumFacing.EAST ? 0.625 : (fw == EnumFacing.EAST ? 0.875 : 0.0), 0.0, fl == EnumFacing.SOUTH ? 0.625 : (fw == EnumFacing.SOUTH ? 0.875 : 0.0), fl == EnumFacing.WEST ? 0.375 : (fw == EnumFacing.WEST ? 0.125 : 1.0), 1.0, fl == EnumFacing.NORTH ? 0.375 : (fw == EnumFacing.NORTH ? 0.125 : 1.0)).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ()));
            return list;
        }
        if (this.pos == 53) {
            ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(fl == EnumFacing.WEST ? 0.5 : (fl == EnumFacing.EAST ? 0.375 : 0.0), 0.0, fl == EnumFacing.NORTH ? 0.5 : (fl == EnumFacing.SOUTH ? 0.375 : 0.0), fl == EnumFacing.EAST ? 0.5 : (fl == EnumFacing.WEST ? 0.625 : 1.0), 1.0, fl == EnumFacing.SOUTH ? 0.5 : (fl == EnumFacing.NORTH ? 0.625 : 1.0)).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ())});
            list.add(new AxisAlignedBB(fl == EnumFacing.WEST ? 0.625 : (fw == EnumFacing.EAST ? 0.875 : 0.0), 0.0, fl == EnumFacing.NORTH ? 0.625 : (fw == EnumFacing.SOUTH ? 0.875 : 0.0), fl == EnumFacing.EAST ? 0.375 : (fw == EnumFacing.WEST ? 0.125 : 1.0), 1.0, fl == EnumFacing.SOUTH ? 0.375 : (fw == EnumFacing.NORTH ? 0.125 : 1.0)).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ()));
            return list;
        }
        return null;
    }

    @Override
    public boolean isOverrideBox(AxisAlignedBB box, EntityPlayer player, RayTraceResult mop, ArrayList<AxisAlignedBB> list) {
        return false;
    }

    @Override
    public List<AxisAlignedBB> getAdvancedColisionBounds() {
        return this.getAdvancedSelectionBounds();
    }

    @Override
    public int[] getEnergyPos() {
        return new int[]{5, 23, 41};
    }

    @Override
    public int[] getRedstonePos() {
        return new int[]{18};
    }

    @Override
    public boolean isInWorldProcessingMachine() {
        return false;
    }

    @Override
    public boolean additionalCanProcessCheck(TileEntityMultiblockMetal.MultiblockProcess<IMultiblockRecipe> process) {
        return false;
    }

    @Override
    public void doProcessOutput(ItemStack output) {
        BlockPos pos = this.getPos().offset(this.facing, -1);
        TileEntity inventoryTile = this.world.getTileEntity(pos);
        if (inventoryTile != null) {
            output = Utils.insertStackIntoInventory(inventoryTile, output, this.facing.getOpposite());
        }
        if (!output.isEmpty()) {
            Utils.dropStackAtPos(this.world, pos, output, this.facing);
        }
    }

    @Override
    public void doProcessFluidOutput(FluidStack output) {
    }

    @Override
    public void onProcessFinish(TileEntityMultiblockMetal.MultiblockProcess<IMultiblockRecipe> process) {
    }

    @Override
    public int getMaxProcessPerTick() {
        return 0;
    }

    @Override
    public int getProcessQueueMaxLength() {
        return 0;
    }

    @Override
    public float getMinProcessDistance(TileEntityMultiblockMetal.MultiblockProcess<IMultiblockRecipe> process) {
        return 0.0f;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return null;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return false;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 0;
    }

    @Override
    public int[] getOutputSlots() {
        return new int[0];
    }

    @Override
    public int[] getOutputTanks() {
        return new int[0];
    }

    @Override
    public IFluidTank[] getInternalTanks() {
        return null;
    }

    @Override
    protected IFluidTank[] getAccessibleFluidTanks(EnumFacing side) {
        return new IFluidTank[0];
    }

    @Override
    protected boolean canFillTankFrom(int iTank, EnumFacing side, FluidStack resources) {
        return false;
    }

    @Override
    protected boolean canDrainTankFrom(int iTank, EnumFacing side) {
        return false;
    }

    @Override
    public void doGraphicalUpdates(int slot) {
        this.markDirty();
        this.markContainingBlockForUpdate(null);
    }

    @Override
    public IMultiblockRecipe findRecipeForInsertion(ItemStack inserting) {
        return null;
    }

    @Override
    protected IMultiblockRecipe readRecipeFromNBT(NBTTagCompound tag) {
        return null;
    }

    @Override
    public void disassemble() {
        super.disassemble();
        BlockPos wheelPos = this.getBlockPosForPos(31);
        TileEntity center = this.world.getTileEntity(wheelPos);
        if (center instanceof TileEntityBucketWheel) {
            this.world.addBlockEvent(center.getPos(), center.getBlockType(), 0, 0);
        }
    }
}

