/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.IWireCoil;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.TileEntityImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.ChatUtils;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class TileEntityEnergyMeter
extends TileEntityImmersiveConnectable
implements ITickable,
IEBlockInterfaces.IDirectionalTile,
IEBlockInterfaces.IHasDummyBlocks,
IEBlockInterfaces.IAdvancedCollisionBounds,
IEBlockInterfaces.IAdvancedSelectionBounds,
IEBlockInterfaces.IPlayerInteraction,
IEBlockInterfaces.IComparatorOverride {
    public EnumFacing facing = EnumFacing.NORTH;
    public int lastEnergyPassed = 0;
    public ArrayList<Integer> lastPackets = new ArrayList(25);
    public boolean lower = true;
    private int compVal = -1;

    @Override
    protected boolean canTakeLV() {
        return true;
    }

    @Override
    protected boolean canTakeMV() {
        return true;
    }

    @Override
    protected boolean canTakeHV() {
        return true;
    }

    @Override
    protected boolean isRelay() {
        return true;
    }

    @Override
    public boolean interact(EnumFacing side, EntityPlayer player, EnumHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        TileEntity above;
        if (!heldItem.isEmpty() && heldItem.getItem() instanceof IWireCoil) {
            return false;
        }
        int transfer = this.getAveragePower();
        int packets = this.lastPackets.size();
        if (this.lower && (above = this.world.getTileEntity(this.getPos().add(0, 1, 0))) instanceof TileEntityEnergyMeter) {
            packets = ((TileEntityEnergyMeter)above).lastPackets.size();
        }
        String transferred = "0";
        if (transfer > 0) {
            transferred = Utils.formatDouble(transfer, "0.###");
        }
        ChatUtils.sendServerNoSpamMessages(player, new ITextComponent[]{new TextComponentTranslation("chat.immersiveengineering.info.energyTransfered", new Object[]{packets, transferred})});
        return true;
    }

    public void update() {
        ApiUtils.checkForNeedlessTicking(this);
        if (this.lower || this.world.isRemote) {
            return;
        }
        if ((this.world.getTotalWorldTime() & 0x1FL) == (this.pos.toLong() & 0x1FL) || this.compVal < 0) {
            this.updateComparatorValues();
        }
        this.lastPackets.add(this.lastEnergyPassed);
        if (this.lastPackets.size() > 20) {
            this.lastPackets.remove(0);
        }
        this.lastEnergyPassed = 0;
    }

    @Override
    public boolean canConnect() {
        return true;
    }

    @Override
    public void onEnergyPassthrough(int amount) {
        this.lastEnergyPassed += amount;
    }

    @Override
    public boolean canConnectCable(WireType cableType, TargetingInfo target) {
        if (this.lower) {
            TileEntity above = this.world.getTileEntity(this.getPos().add(0, 1, 0));
            if (above instanceof TileEntityEnergyMeter) {
                return ((TileEntityEnergyMeter)above).canConnectCable(cableType, target);
            }
            return false;
        }
        return super.canConnectCable(cableType, target);
    }

    @Override
    public void connectCable(WireType cableType, TargetingInfo target, IImmersiveConnectable other) {
        if (this.lower) {
            TileEntity above = this.world.getTileEntity(this.getPos().add(0, 1, 0));
            if (above instanceof TileEntityEnergyMeter) {
                ((TileEntityEnergyMeter)above).connectCable(cableType, target, other);
            }
        } else {
            super.connectCable(cableType, target, other);
        }
    }

    @Override
    public BlockPos getConnectionMaster(WireType cableType, TargetingInfo target) {
        if (this.lower) {
            return this.pos.up();
        }
        return this.pos;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.setInteger("facing", this.facing.ordinal());
        nbt.setBoolean("dummy", this.lower);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.facing = EnumFacing.values()[nbt.getInteger("facing")];
        this.lower = nbt.getBoolean("dummy");
    }

    @Override
    public Vec3d getRaytraceOffset(IImmersiveConnectable link) {
        int xDif = ((TileEntity)link).getPos().getX() - this.getPos().getX();
        int zDif = ((TileEntity)link).getPos().getZ() - this.getPos().getZ();
        if (this.facing.getAxis() == EnumFacing.Axis.X) {
            return new Vec3d(0.5, 0.4375, zDif > 0 ? 0.8125 : 0.1875);
        }
        return new Vec3d(xDif > 0 ? 0.8125 : 0.1875, 0.4375, 0.5);
    }

    @Override
    public Vec3d getConnectionOffset(ImmersiveNetHandler.Connection con) {
        int zDif;
        int xDif;
        int n = con == null || con.start == null || con.end == null ? 0 : (con.start.equals((Object)Utils.toCC(this)) && con.end != null ? con.end.getX() - this.getPos().getX() : (xDif = con.end.equals((Object)Utils.toCC(this)) && con.start != null ? con.start.getX() - this.getPos().getX() : 0));
        int n2 = con == null || con.start == null || con.end == null ? 0 : (con.start.equals((Object)Utils.toCC(this)) && con.end != null ? con.end.getZ() - this.getPos().getZ() : (zDif = con.end.equals((Object)Utils.toCC(this)) && con.start != null ? con.start.getZ() - this.getPos().getZ() : 0));
        if (this.facing.getAxis() == EnumFacing.Axis.X) {
            return new Vec3d(0.5, 0.4375, zDif > 0 ? 0.8125 : 0.1875);
        }
        return new Vec3d(xDif > 0 ? 0.8125 : 0.1875, 0.4375, 0.5);
    }

    @Override
    public boolean isDummy() {
        return !this.lower;
    }

    @Override
    public boolean isLogicDummy() {
        return this.lower;
    }

    @Override
    public void placeDummies(BlockPos pos, IBlockState state, EnumFacing side, float hitX, float hitY, float hitZ) {
        this.world.setBlockState(pos.add(0, 1, 0), state);
        ((TileEntityEnergyMeter)this.world.getTileEntity((BlockPos)pos.add((int)0, (int)1, (int)0))).lower = false;
        ((TileEntityEnergyMeter)this.world.getTileEntity((BlockPos)pos.add((int)0, (int)1, (int)0))).facing = this.facing;
    }

    @Override
    public void breakDummies(BlockPos pos, IBlockState state) {
        for (int i = 0; i <= 1; ++i) {
            if (!(this.world.getTileEntity(this.getPos().add(0, !this.lower ? -1 : 0, 0).add(0, i, 0)) instanceof TileEntityEnergyMeter)) continue;
            this.world.setBlockToAir(this.getPos().add(0, !this.lower ? -1 : 0, 0).add(0, i, 0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAveragePower() {
        TileEntityEnergyMeter te = this;
        if (te.lower) {
            TileEntity tmp = this.world.getTileEntity(this.getPos().add(0, 1, 0));
            if (!(tmp instanceof TileEntityEnergyMeter)) {
                return -1;
            }
            te = (TileEntityEnergyMeter)tmp;
        }
        if (te.lastPackets.size() == 0) {
            return 0;
        }
        int sum = 0;
        ArrayList<Integer> arrayList = te.lastPackets;
        synchronized (arrayList) {
            for (int transfer : te.lastPackets) {
                sum += transfer;
            }
        }
        return sum / te.lastPackets.size();
    }

    @Override
    public float[] getBlockBounds() {
        return null;
    }

    @Override
    public List<AxisAlignedBB> getAdvancedSelectionBounds() {
        ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(0.1875, -0.625, 0.1875, 0.8125, 0.8125, 0.8125).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ())});
        if (this.lower) {
            list.set(0, ((AxisAlignedBB)list.get(0)).offset(0.0, 1.0, 0.0));
            list.add(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ()));
        }
        return list;
    }

    @Override
    public boolean isOverrideBox(AxisAlignedBB box, EntityPlayer player, RayTraceResult mop, ArrayList<AxisAlignedBB> list) {
        return false;
    }

    @Override
    public List<AxisAlignedBB> getAdvancedColisionBounds() {
        return this.getAdvancedSelectionBounds();
    }

    @Override
    public EnumFacing getFacing() {
        return this.facing;
    }

    @Override
    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    @Override
    public int getFacingLimitation() {
        return 2;
    }

    @Override
    public boolean mirrorFacingOnPlacement(EntityLivingBase placer) {
        return false;
    }

    @Override
    public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity) {
        return false;
    }

    @Override
    public boolean canRotate(EnumFacing axis) {
        return false;
    }

    private void updateComparatorValues() {
        int oldVal = this.compVal;
        int maxTrans = 0;
        Set<ImmersiveNetHandler.Connection> conns = ImmersiveNetHandler.INSTANCE.getConnections(this.world, this.pos);
        if (conns == null) {
            this.compVal = 0;
        } else {
            for (ImmersiveNetHandler.Connection c : conns) {
                maxTrans += c.cableType.getTransferRate();
            }
            double val = (double)this.getAveragePower() / (double)(maxTrans /= 2);
            this.compVal = (int)Math.ceil(15.0 * val);
        }
        if (oldVal != this.compVal) {
            this.world.updateComparatorOutputLevel(this.pos, this.getBlockType());
            this.world.updateComparatorOutputLevel(this.pos.down(), this.getBlockType());
        }
    }

    @Override
    public int getComparatorInputOverride() {
        return this.compVal;
    }
}

