/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.TileEntityImmersiveConnectable;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.EventHandler;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import java.util.ArrayList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumSkyBlock;

public class TileEntityElectricLantern
extends TileEntityImmersiveConnectable
implements IEBlockInterfaces.ISpawnInterdiction,
ITickable,
IEBlockInterfaces.IDirectionalTile,
IEBlockInterfaces.IHammerInteraction,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IActiveState,
IEBlockInterfaces.ILightValue {
    public int energyStorage = 0;
    private int energyDraw = Config.IEConfig.Machines.lantern_energyDraw;
    private int maximumStorage = Config.IEConfig.Machines.lantern_maximumStorage;
    public boolean active = false;
    private boolean interdictionList = false;
    private boolean flipped = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        if (this.world.isRemote) {
            return;
        }
        if (!this.interdictionList && Config.IEConfig.Machines.lantern_spawnPrevent) {
            ArrayList<IEBlockInterfaces.ISpawnInterdiction> arrayList = EventHandler.interdictionTiles;
            synchronized (arrayList) {
                if (!EventHandler.interdictionTiles.contains(this)) {
                    EventHandler.interdictionTiles.add(this);
                }
            }
            this.interdictionList = true;
        }
        boolean b = this.active;
        if (this.energyStorage >= this.energyDraw) {
            this.energyStorage -= this.energyDraw;
            if (!this.active) {
                this.active = true;
            }
        } else if (this.active) {
            this.active = false;
        }
        if (this.active != b) {
            this.markContainingBlockForUpdate(null);
            this.world.checkLightFor(EnumSkyBlock.BLOCK, this.getPos());
            this.world.addBlockEvent(this.getPos(), this.getBlockType(), 1, 0);
        }
    }

    @Override
    public double getInterdictionRangeSquared() {
        return this.active ? 1024.0 : 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate() {
        ArrayList<IEBlockInterfaces.ISpawnInterdiction> arrayList = EventHandler.interdictionTiles;
        synchronized (arrayList) {
            if (EventHandler.interdictionTiles.contains(this)) {
                EventHandler.interdictionTiles.remove(this);
            }
        }
        super.invalidate();
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.active = nbt.getBoolean("active");
        this.energyStorage = nbt.getInteger("energyStorage");
        this.flipped = nbt.getBoolean("flipped");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.setBoolean("active", this.active);
        nbt.setInteger("energyStorage", this.energyStorage);
        nbt.setBoolean("flipped", this.flipped);
    }

    @Override
    protected boolean canTakeLV() {
        return true;
    }

    @Override
    public boolean isEnergyOutput() {
        return true;
    }

    @Override
    protected boolean isRelay() {
        return true;
    }

    @Override
    public int outputEnergy(int amount, boolean simulate, int energyType) {
        if (amount > 0 && this.energyStorage < this.maximumStorage) {
            if (!simulate) {
                int rec = Math.min(this.maximumStorage - this.energyStorage, this.energyDraw);
                this.energyStorage += rec;
                return rec;
            }
            return Math.min(this.maximumStorage - this.energyStorage, this.energyDraw);
        }
        return 0;
    }

    @Override
    public boolean receiveClientEvent(int id, int arg) {
        if (id == 1) {
            this.markContainingBlockForUpdate(null);
            this.world.checkLightFor(EnumSkyBlock.BLOCK, this.getPos());
            return true;
        }
        return super.receiveClientEvent(id, arg);
    }

    @Override
    public Vec3d getRaytraceOffset(IImmersiveConnectable link) {
        int xDif = this.getPos().getX() - ((TileEntity)link).getPos().getX();
        int zDif = this.getPos().getZ() - ((TileEntity)link).getPos().getZ();
        if (xDif == 0 && zDif == 0) {
            return new Vec3d(0.5, 0.0625, 0.5);
        }
        if (Math.abs(xDif) >= Math.abs(zDif)) {
            return new Vec3d(xDif < 0 ? 0.25 : (xDif > 0 ? 0.75 : 0.5), this.flipped ? 0.9375 : 0.0625, 0.5);
        }
        return new Vec3d(0.5, this.flipped ? 0.9375 : 0.0625, zDif < 0 ? 0.25 : (zDif > 0 ? 0.75 : 0.5));
    }

    @Override
    public Vec3d getConnectionOffset(ImmersiveNetHandler.Connection con) {
        int zDif;
        int xDif;
        int n = con == null || con.start == null || con.end == null ? 0 : (con.start.equals((Object)this.getPos()) && con.end != null ? con.end.getX() - this.getPos().getX() : (xDif = con.end.equals((Object)this.getPos()) && con.start != null ? con.start.getX() - this.getPos().getX() : 0));
        int n2 = con == null || con.start == null || con.end == null ? 0 : (con.start.equals((Object)this.getPos()) && con.end != null ? con.end.getZ() - this.getPos().getZ() : (zDif = con.end.equals((Object)this.getPos()) && con.start != null ? con.start.getZ() - this.getPos().getZ() : 0));
        if (Math.abs(xDif) >= Math.abs(zDif)) {
            return new Vec3d(xDif < 0 ? 0.25 : (xDif > 0 ? 0.75 : 0.5), this.flipped ? 0.9375 : 0.0625, 0.5);
        }
        return new Vec3d(0.5, this.flipped ? 0.9375 : 0.0625, zDif < 0 ? 0.25 : (zDif > 0 ? 0.75 : 0.5));
    }

    @Override
    public float[] getBlockBounds() {
        return new float[]{0.1875f, 0.0f, 0.1875f, 0.8125f, 1.0f, 0.8125f};
    }

    @Override
    public IEProperties.PropertyBoolInverted getBoolProperty(Class<? extends IEBlockInterfaces.IUsesBooleanProperty> inf) {
        return IEProperties.BOOLEANS[0];
    }

    @Override
    public boolean getIsActive() {
        return this.active;
    }

    @Override
    public int getLightValue() {
        return this.active ? 15 : 0;
    }

    @Override
    public EnumFacing getFacing() {
        return this.flipped ? EnumFacing.UP : EnumFacing.NORTH;
    }

    @Override
    public void setFacing(EnumFacing facing) {
    }

    @Override
    public int getFacingLimitation() {
        return -1;
    }

    @Override
    public boolean mirrorFacingOnPlacement(EntityLivingBase placer) {
        return false;
    }

    @Override
    public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity) {
        return false;
    }

    @Override
    public boolean canRotate(EnumFacing axis) {
        return false;
    }

    @Override
    public boolean hammerUseSide(EnumFacing side, EntityPlayer player, float hitX, float hitY, float hitZ) {
        this.flipped = !this.flipped;
        this.markContainingBlockForUpdate(null);
        this.world.addBlockEvent(this.getPos(), this.getBlockType(), this.active ? 1 : 0, 0);
        return true;
    }
}

