/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.crafting.CrusherRecipe;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.EventHandler;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockMetal;
import blusunrize.immersiveengineering.common.blocks.multiblocks.MultiblockCrusher;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityCrusher
extends TileEntityMultiblockMetal<TileEntityCrusher, CrusherRecipe>
implements IEBlockInterfaces.ISoundTile,
IEBlockInterfaces.IAdvancedSelectionBounds,
IEBlockInterfaces.IAdvancedCollisionBounds {
    public List<ItemStack> inputs = new ArrayList<ItemStack>();
    public int process = 0;
    public float animation_barrelRotation = 0.0f;
    @SideOnly(value=Side.CLIENT)
    private AxisAlignedBB renderAABB;
    IItemHandler insertionHandler = new TileEntityMultiblockMetal.MultiblockInventoryHandler_DirectProcessing(this).setProcessStacking(true);

    public TileEntityCrusher() {
        super(MultiblockCrusher.instance, new int[]{3, 3, 5}, 32000, true);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        if (!descPacket) {
            NBTTagList invList = nbt.getTagList("inputs", 10);
            this.inputs.clear();
            for (int i = 0; i < invList.tagCount(); ++i) {
                this.inputs.add(new ItemStack(invList.getCompoundTagAt(i)));
            }
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        if (!descPacket) {
            NBTTagList invList = new NBTTagList();
            for (ItemStack s : this.inputs) {
                invList.appendTag((NBTBase)s.writeToNBT(new NBTTagCompound()));
            }
            nbt.setTag("inputs", (NBTBase)invList);
        }
    }

    @Override
    public void update() {
        super.update();
        if (this.world.isRemote && !this.isDummy()) {
            boolean active = this.shouldRenderAsActive();
            ImmersiveEngineering.proxy.handleTileSound(IESounds.crusher, this, active, 0.5f, 1.0f);
            if (active) {
                this.animation_barrelRotation += 18.0f;
                this.animation_barrelRotation %= 360.0f;
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)(this.getPos().getX() - (this.facing.getAxis() == EnumFacing.Axis.Z ? 2 : 1)), (double)this.getPos().getY(), (double)(this.getPos().getZ() - (this.facing.getAxis() == EnumFacing.Axis.X ? 2 : 1)), (double)(this.getPos().getX() + (this.facing.getAxis() == EnumFacing.Axis.Z ? 3 : 2)), (double)(this.getPos().getY() + 3), (double)(this.getPos().getZ() + (this.facing.getAxis() == EnumFacing.Axis.X ? 3 : 2)));
    }

    @SideOnly(value=Side.CLIENT)
    public double getMaxRenderDistanceSquared() {
        return super.getMaxRenderDistanceSquared() * Config.IEConfig.increasedTileRenderdistance;
    }

    @Override
    public float[] getBlockBounds() {
        if (this.pos == 1 || this.pos == 3 || this.pos == 4 || this.pos == 6 || this.pos == 8 || this.pos == 11 || this.pos == 12 || this.pos == 13 || this.pos == 14 || this.pos == 24) {
            return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f};
        }
        if (this.pos == 22) {
            return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 0.75f, 1.0f};
        }
        if (this.pos == 37) {
            return new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
        }
        EnumFacing fl = this.facing;
        EnumFacing fw = this.facing.rotateY();
        if (this.mirrored) {
            fw = fw.getOpposite();
        }
        if (this.pos > 15 && this.pos % 5 > 0 && this.pos % 5 < 4) {
            float minX = 0.0f;
            float maxX = 1.0f;
            float minZ = 0.0f;
            float maxZ = 1.0f;
            if (this.pos % 5 == 1) {
                minX = fw == EnumFacing.EAST ? 0.1875f : 0.0f;
                maxX = fw == EnumFacing.WEST ? 0.8125f : 1.0f;
                minZ = fw == EnumFacing.SOUTH ? 0.1875f : 0.0f;
                maxZ = fw == EnumFacing.NORTH ? 0.8125f : 1.0f;
            } else if (this.pos % 5 == 3) {
                minX = fw == EnumFacing.WEST ? 0.1875f : 0.0f;
                maxX = fw == EnumFacing.EAST ? 0.8125f : 1.0f;
                minZ = fw == EnumFacing.NORTH ? 0.1875f : 0.0f;
                float f = maxZ = fw == EnumFacing.SOUTH ? 0.8125f : 1.0f;
            }
            if (this.pos % 15 / 5 == 0) {
                if (fl == EnumFacing.EAST) {
                    minX = 0.1875f;
                }
                if (fl == EnumFacing.WEST) {
                    maxX = 0.8125f;
                }
                if (fl == EnumFacing.SOUTH) {
                    minZ = 0.1875f;
                }
                if (fl == EnumFacing.NORTH) {
                    maxZ = 0.8125f;
                }
            }
            return new float[]{minX, 0.0f, minZ, maxX, 1.0f, maxZ};
        }
        if (this.pos == 19) {
            return new float[]{this.facing == EnumFacing.WEST ? 0.5f : 0.0f, 0.0f, this.facing == EnumFacing.NORTH ? 0.5f : 0.0f, this.facing == EnumFacing.EAST ? 0.5f : 1.0f, 1.0f, this.facing == EnumFacing.SOUTH ? 0.5f : 1.0f};
        }
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    @Override
    public List<AxisAlignedBB> getAdvancedSelectionBounds() {
        if (this.pos % 15 == 7) {
            return null;
        }
        EnumFacing fl = this.facing;
        EnumFacing fw = this.facing.rotateY();
        if (this.mirrored) {
            fw = fw.getOpposite();
        }
        if (this.pos == 4) {
            float minZ;
            float maxX;
            float minX;
            ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ())});
            float f = fl == EnumFacing.WEST ? 0.625f : (minX = fl == EnumFacing.EAST ? 0.125f : 0.125f);
            float f2 = fl == EnumFacing.EAST ? 0.375f : (maxX = fl == EnumFacing.WEST ? 0.875f : 0.25f);
            float f3 = fl == EnumFacing.NORTH ? 0.625f : (minZ = fl == EnumFacing.SOUTH ? 0.125f : 0.125f);
            float maxZ = fl == EnumFacing.SOUTH ? 0.375f : (fl == EnumFacing.NORTH ? 0.875f : 0.25f);
            list.add(new AxisAlignedBB((double)minX, 0.5, (double)minZ, (double)maxX, 1.0, (double)maxZ).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ()));
            float f4 = fl == EnumFacing.WEST ? 0.625f : (minX = fl == EnumFacing.EAST ? 0.125f : 0.75f);
            float f5 = fl == EnumFacing.EAST ? 0.375f : (maxX = fl == EnumFacing.WEST ? 0.875f : 0.875f);
            float f6 = fl == EnumFacing.NORTH ? 0.625f : (minZ = fl == EnumFacing.SOUTH ? 0.125f : 0.75f);
            maxZ = fl == EnumFacing.SOUTH ? 0.375f : (fl == EnumFacing.NORTH ? 0.875f : 0.875f);
            list.add(new AxisAlignedBB((double)minX, 0.5, (double)minZ, (double)maxX, 1.0, (double)maxZ).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ()));
            return list;
        }
        if (this.pos > 20 && this.pos < 24 || this.pos > 35 && this.pos < 39) {
            float maxZ;
            ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>(3);
            float minY = 0.5f;
            float minX = this.pos % 5 == 1 && fw == EnumFacing.EAST || this.pos % 5 == 3 && fw == EnumFacing.WEST ? 0.4375f : 0.0f;
            float maxX = this.pos % 5 == 1 && fw == EnumFacing.WEST || this.pos % 5 == 3 && fw == EnumFacing.EAST ? 0.5625f : 1.0f;
            float minZ = this.pos % 5 == 1 && fw == EnumFacing.SOUTH || this.pos % 5 == 3 && fw == EnumFacing.NORTH ? 0.4375f : 0.0f;
            float f = maxZ = this.pos % 5 == 1 && fw == EnumFacing.NORTH || this.pos % 5 == 3 && fw == EnumFacing.SOUTH ? 0.5625f : 1.0f;
            if (this.pos > 20 && this.pos < 24) {
                list.add(new AxisAlignedBB((double)minX, 0.5, (double)minZ, (double)maxX, 0.75, (double)maxZ).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ()));
            } else {
                minY = 0.0f;
            }
            float f7 = this.pos % 5 == 1 && fw == EnumFacing.EAST || this.pos % 5 == 3 && fw == EnumFacing.WEST ? 0.1875f : (minX = this.pos % 5 == 1 && fw == EnumFacing.WEST || this.pos % 5 == 3 && fw == EnumFacing.EAST ? 0.5625f : 0.0f);
            float f8 = this.pos % 5 == 1 && fw == EnumFacing.WEST || this.pos % 5 == 3 && fw == EnumFacing.EAST ? 0.8125f : (maxX = this.pos % 5 == 1 && fw == EnumFacing.EAST || this.pos % 5 == 3 && fw == EnumFacing.WEST ? 0.4375f : 1.0f);
            float f9 = this.pos % 5 == 1 && fw == EnumFacing.SOUTH || this.pos % 5 == 3 && fw == EnumFacing.NORTH ? 0.1875f : (minZ = this.pos % 5 == 1 && fw == EnumFacing.NORTH || this.pos % 5 == 3 && fw == EnumFacing.SOUTH ? 0.5625f : 0.0f);
            maxZ = this.pos % 5 == 1 && fw == EnumFacing.NORTH || this.pos % 5 == 3 && fw == EnumFacing.SOUTH ? 0.8125f : (this.pos % 5 == 1 && fw == EnumFacing.SOUTH || this.pos % 5 == 3 && fw == EnumFacing.NORTH ? 0.4375f : 1.0f);
            list.add(new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)maxX, 1.0, (double)maxZ).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ()));
            return list;
        }
        if (this.pos > 15 && this.pos < 19 || this.pos > 30 && this.pos < 34 || this.pos > 25 && this.pos < 29 || this.pos > 40 && this.pos < 44) {
            float maxZ;
            float minZ;
            float maxX;
            float minX;
            if (this.pos % 15 > 9) {
                fl = fl.getOpposite();
            }
            ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>(3);
            float minY = 0.5f;
            float f = this.pos % 5 == 1 && fw == EnumFacing.EAST || this.pos % 5 == 3 && fw == EnumFacing.WEST ? 0.4375f : (minX = fl == EnumFacing.EAST ? 0.4375f : 0.0f);
            float f10 = this.pos % 5 == 1 && fw == EnumFacing.WEST || this.pos % 5 == 3 && fw == EnumFacing.EAST ? 0.5625f : (maxX = fl == EnumFacing.WEST ? 0.5625f : 1.0f);
            float f11 = this.pos % 5 == 1 && fw == EnumFacing.SOUTH || this.pos % 5 == 3 && fw == EnumFacing.NORTH ? 0.4375f : (minZ = fl == EnumFacing.SOUTH ? 0.4375f : 0.0f);
            float f12 = this.pos % 5 == 1 && fw == EnumFacing.NORTH || this.pos % 5 == 3 && fw == EnumFacing.SOUTH ? 0.5625f : (maxZ = fl == EnumFacing.NORTH ? 0.5625f : 1.0f);
            if (this.pos > 15 && this.pos < 19 || this.pos > 25 && this.pos < 29) {
                list.add(new AxisAlignedBB((double)minX, 0.5, (double)minZ, (double)maxX, 0.75, (double)maxZ).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ()));
            } else {
                minY = 0.0f;
            }
            if (this.pos / 15 > 9) {
                fl = fl.getOpposite();
            }
            float f13 = this.pos % 5 == 1 && fw == EnumFacing.EAST || this.pos % 5 == 3 && fw == EnumFacing.WEST ? 0.1875f : (fl == EnumFacing.EAST ? 0.1875f : (minX = fl == EnumFacing.WEST ? 0.5625f : 0.0f));
            float f14 = this.pos % 5 == 1 && fw == EnumFacing.WEST || this.pos % 5 == 3 && fw == EnumFacing.EAST ? 0.8125f : (fl == EnumFacing.WEST ? 0.8125f : (maxX = fl == EnumFacing.EAST ? 0.4375f : 1.0f));
            float f15 = this.pos % 5 == 1 && fw == EnumFacing.SOUTH || this.pos % 5 == 3 && fw == EnumFacing.NORTH ? 0.1875f : (fl == EnumFacing.SOUTH ? 0.1875f : (minZ = fl == EnumFacing.NORTH ? 0.5625f : 0.0f));
            maxZ = this.pos % 5 == 1 && fw == EnumFacing.NORTH || this.pos % 5 == 3 && fw == EnumFacing.SOUTH ? 0.8125f : (fl == EnumFacing.NORTH ? 0.8125f : (fl == EnumFacing.SOUTH ? 0.4375f : 1.0f));
            list.add(new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)maxX, 1.0, (double)maxZ).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ()));
            if (this.pos != 17 && this.pos != 32 && this.pos != 27 && this.pos != 42) {
                float f16 = this.pos % 5 == 1 && fw == EnumFacing.EAST || this.pos % 5 == 3 && fw == EnumFacing.WEST ? 0.1875f : (fl == EnumFacing.EAST ? 0.4375f : (minX = fl == EnumFacing.WEST ? 0.0f : 0.5625f));
                float f17 = this.pos % 5 == 1 && fw == EnumFacing.WEST || this.pos % 5 == 3 && fw == EnumFacing.EAST ? 0.8125f : (fl == EnumFacing.WEST ? 0.5625f : (maxX = fl == EnumFacing.EAST ? 1.0f : 0.4375f));
                float f18 = this.pos % 5 == 1 && fw == EnumFacing.SOUTH || this.pos % 5 == 3 && fw == EnumFacing.NORTH ? 0.1875f : (fl == EnumFacing.SOUTH ? 0.4375f : (minZ = fl == EnumFacing.NORTH ? 0.0f : 0.5625f));
                maxZ = this.pos % 5 == 1 && fw == EnumFacing.NORTH || this.pos % 5 == 3 && fw == EnumFacing.SOUTH ? 0.8125f : (fl == EnumFacing.NORTH ? 0.5625f : (fl == EnumFacing.SOUTH ? 1.0f : 0.4375f));
                list.add(new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)maxX, 1.0, (double)maxZ).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ()));
                if (this.pos % 15 % 10 == 1) {
                    fw = fw.getOpposite();
                }
                if (this.pos > 15 && this.pos < 19 || this.pos > 25 && this.pos < 29) {
                    float f19 = fl == EnumFacing.WEST ? 0.5f : (fl == EnumFacing.EAST ? 0.25f : (minX = fw == EnumFacing.EAST ? 0.5f : 0.25f));
                    float f20 = fl == EnumFacing.EAST ? 0.5f : (fl == EnumFacing.WEST ? 0.75f : (maxX = fw == EnumFacing.EAST ? 0.75f : 0.5f));
                    float f21 = fl == EnumFacing.NORTH ? 0.5f : (fl == EnumFacing.SOUTH ? 0.25f : (minZ = fw == EnumFacing.SOUTH ? 0.5f : 0.25f));
                    maxZ = fl == EnumFacing.SOUTH ? 0.5f : (fl == EnumFacing.NORTH ? 0.75f : (fw == EnumFacing.SOUTH ? 0.75f : 0.5f));
                    list.add(new AxisAlignedBB((double)minX, 0.0, (double)minZ, (double)maxX, 0.5, (double)maxZ).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ()));
                }
            }
            return list;
        }
        if (this.pos == 1 || this.pos == 3 || this.pos == 11 || this.pos == 13) {
            float minZ;
            float maxX;
            float minX;
            ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ())});
            if (this.pos % 15 > 9) {
                fl = fl.getOpposite();
            }
            if (this.pos % 15 % 10 == 1) {
                fw = fw.getOpposite();
            }
            float f = fl == EnumFacing.WEST ? 0.5f : (fl == EnumFacing.EAST ? 0.25f : (minX = fw == EnumFacing.EAST ? 0.5f : 0.25f));
            float f22 = fl == EnumFacing.EAST ? 0.5f : (fl == EnumFacing.WEST ? 0.75f : (maxX = fw == EnumFacing.EAST ? 0.75f : 0.5f));
            float f23 = fl == EnumFacing.NORTH ? 0.5f : (fl == EnumFacing.SOUTH ? 0.25f : (minZ = fw == EnumFacing.SOUTH ? 0.5f : 0.25f));
            float maxZ = fl == EnumFacing.SOUTH ? 0.5f : (fl == EnumFacing.NORTH ? 0.75f : (fw == EnumFacing.SOUTH ? 0.75f : 0.5f));
            list.add(new AxisAlignedBB((double)minX, 0.5, (double)minZ, (double)maxX, 1.0, (double)maxZ).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ()));
            return list;
        }
        return null;
    }

    @Override
    public boolean isOverrideBox(AxisAlignedBB box, EntityPlayer player, RayTraceResult mop, ArrayList<AxisAlignedBB> list) {
        return false;
    }

    @Override
    public List<AxisAlignedBB> getAdvancedColisionBounds() {
        return this.getAdvancedSelectionBounds();
    }

    @Override
    public void onEntityCollision(World world, Entity entity) {
        boolean bpos;
        boolean bl = bpos = this.pos == 16 || this.pos == 17 || this.pos == 18 || this.pos == 21 || this.pos == 22 || this.pos == 23 || this.pos == 26 || this.pos == 27 || this.pos == 28;
        if (bpos && !world.isRemote && entity != null && !entity.isDead && !this.isRSDisabled()) {
            int consumed;
            TileEntityCrusher master = (TileEntityCrusher)this.master();
            if (master == null) {
                return;
            }
            Vec3d center = new Vec3d((Vec3i)master.getPos()).addVector(0.5, 0.75, 0.5);
            AxisAlignedBB crusherInternal = new AxisAlignedBB(center.x - 1.0625, center.y, center.z - 1.0625, center.x + 1.0625, center.y + 1.25, center.z + 1.0625);
            if (!entity.getEntityBoundingBox().intersects(crusherInternal)) {
                return;
            }
            if (entity instanceof EntityItem && !((EntityItem)entity).getItem().isEmpty()) {
                ItemStack stack = ((EntityItem)entity).getItem();
                if (stack.isEmpty()) {
                    return;
                }
                CrusherRecipe recipe = master.findRecipeForInsertion(stack);
                if (recipe == null) {
                    return;
                }
                ItemStack displayStack = recipe.getDisplayStack(stack);
                TileEntityMultiblockMetal.MultiblockProcessInWorld<CrusherRecipe> process = new TileEntityMultiblockMetal.MultiblockProcessInWorld<CrusherRecipe>(recipe, 0.5f, Utils.createNonNullItemStackListFromItemStack(displayStack));
                if (master.addProcessToQueue(process, true, true)) {
                    master.addProcessToQueue(process, false, true);
                    stack.shrink(displayStack.getCount());
                    if (stack.getCount() <= 0) {
                        entity.setDead();
                    }
                }
            } else if (!(!(entity instanceof EntityLivingBase) || entity instanceof EntityPlayer && ((EntityPlayer)entity).capabilities.disableDamage || (consumed = master.energyStorage.extractEnergy(80, true)) <= 0)) {
                master.energyStorage.extractEnergy(consumed, false);
                EventHandler.crusherMap.put(entity.getUniqueID(), master);
                entity.attackEntityFrom(IEDamageSources.crusher, (float)consumed / 20.0f);
            }
        }
    }

    @Override
    public int[] getEnergyPos() {
        return new int[]{20};
    }

    @Override
    public int[] getRedstonePos() {
        return new int[]{19};
    }

    @Override
    public boolean isInWorldProcessingMachine() {
        return true;
    }

    @Override
    public boolean additionalCanProcessCheck(TileEntityMultiblockMetal.MultiblockProcess<CrusherRecipe> process) {
        return true;
    }

    @Override
    public void doProcessOutput(ItemStack output) {
        BlockPos pos = this.getPos().add(0, -1, 0).offset(this.facing, -2);
        TileEntity inventoryTile = this.world.getTileEntity(pos);
        if (inventoryTile != null) {
            output = Utils.insertStackIntoInventory(inventoryTile, output, this.facing);
        }
        if (!output.isEmpty()) {
            Utils.dropStackAtPos(this.world, pos, output, this.facing.getOpposite());
        }
    }

    @Override
    public void doProcessFluidOutput(FluidStack output) {
    }

    @Override
    public void onProcessFinish(TileEntityMultiblockMetal.MultiblockProcess<CrusherRecipe> process) {
    }

    @Override
    public int getMaxProcessPerTick() {
        return 1;
    }

    @Override
    public int getProcessQueueMaxLength() {
        return -1;
    }

    @Override
    public float getMinProcessDistance(TileEntityMultiblockMetal.MultiblockProcess<CrusherRecipe> process) {
        return 0.0f;
    }

    @Override
    public int[] getCurrentProcessesStep() {
        TileEntityCrusher master = (TileEntityCrusher)this.master();
        if (master != this && master != null) {
            return master.getCurrentProcessesStep();
        }
        int[] ia = new int[this.processQueue.size() > 0 ? 1 : 0];
        for (int i = 0; i < ia.length; ++i) {
            ia[i] = ((TileEntityMultiblockMetal.MultiblockProcess)this.processQueue.get((int)i)).processTick;
        }
        return ia;
    }

    @Override
    public int[] getCurrentProcessesMax() {
        TileEntityCrusher master = (TileEntityCrusher)this.master();
        if (master != this && master != null) {
            return master.getCurrentProcessesMax();
        }
        int[] ia = new int[this.processQueue.size() > 0 ? 1 : 0];
        for (int i = 0; i < ia.length; ++i) {
            ia[i] = ((TileEntityMultiblockMetal.MultiblockProcess)this.processQueue.get((int)i)).maxTicks;
        }
        return ia;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return null;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return false;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 0;
    }

    @Override
    public int[] getOutputSlots() {
        return null;
    }

    @Override
    public int[] getOutputTanks() {
        return null;
    }

    @Override
    public IFluidTank[] getInternalTanks() {
        return null;
    }

    @Override
    protected IFluidTank[] getAccessibleFluidTanks(EnumFacing side) {
        return new IFluidTank[0];
    }

    @Override
    protected boolean canFillTankFrom(int iTank, EnumFacing side, FluidStack resources) {
        return false;
    }

    @Override
    protected boolean canDrainTankFrom(int iTank, EnumFacing side) {
        return false;
    }

    @Override
    public void doGraphicalUpdates(int slot) {
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (this.pos > 30 && this.pos < 44 && this.pos % 5 > 0 && this.pos % 5 < 4 && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.master() != null;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (this.pos > 30 && this.pos < 44 && this.pos % 5 > 0 && this.pos % 5 < 4 && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            TileEntityCrusher master = (TileEntityCrusher)this.master();
            if (master != null) {
                return (T)master.insertionHandler;
            }
            return null;
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public CrusherRecipe findRecipeForInsertion(ItemStack inserting) {
        return CrusherRecipe.findRecipe(inserting);
    }

    @Override
    protected CrusherRecipe readRecipeFromNBT(NBTTagCompound tag) {
        return CrusherRecipe.loadFromNBT(tag);
    }

    @Override
    public boolean shoudlPlaySound(String sound) {
        return this.shouldRenderAsActive();
    }
}

