/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.common.blocks.metal.TileEntityConveyorBelt;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;

public class TileEntityConveyorVertical
extends TileEntityConveyorBelt {
    @Override
    public void onEntityCollision(World world, Entity entity) {
        if (entity != null && !entity.isDead) {
            if (world.isBlockIndirectlyGettingPowered(this.pos) > 0) {
                return;
            }
            double vBase = entity instanceof EntityLivingBase ? 1.5 : 1.15;
            double distY = Math.abs((double)this.getPos().add(0, 1, 0).getY() + 0.5 - entity.posY);
            double treshold = 0.9;
            boolean contact = distY < treshold;
            double vX = entity.motionX;
            double vY = 0.1 * vBase;
            double vZ = entity.motionZ;
            if (entity.motionY < 0.0) {
                vY += entity.motionY * 0.9;
            }
            if (!(entity instanceof EntityPlayer)) {
                vX = 0.05 * (double)this.facing.getFrontOffsetX();
                vZ = 0.05 * (double)this.facing.getFrontOffsetZ();
                if (this.facing == EnumFacing.WEST || this.facing == EnumFacing.EAST) {
                    if (entity.posZ > (double)this.getPos().getZ() + 0.65) {
                        vZ = -0.1 * vBase;
                    } else if (entity.posZ < (double)this.getPos().getZ() + 0.35) {
                        vZ = 0.1 * vBase;
                    }
                } else if (this.facing == EnumFacing.NORTH || this.facing == EnumFacing.SOUTH) {
                    if (entity.posX > (double)this.getPos().getX() + 0.65) {
                        vX = -0.1 * vBase;
                    } else if (entity.posX < (double)this.getPos().getX() + 0.35) {
                        vX = 0.1 * vBase;
                    }
                }
            }
            if (contact && !(world.getTileEntity(this.getPos().add(0, 1, 0)) instanceof TileEntityConveyorVertical)) {
                vY *= 2.25;
            }
            entity.onGround = false;
            entity.fallDistance = entity.fallDistance < 3.0f ? 0.0f : (float)((double)entity.fallDistance * 0.9);
            entity.motionX = vX;
            entity.motionY = vY;
            entity.motionZ = vZ;
            if (entity instanceof EntityItem) {
                ItemStack stack;
                ((EntityItem)entity).setNoDespawn();
                TileEntity inventoryTile = world.getTileEntity(this.getPos().add(0, 1, 0));
                if (!world.isRemote && contact && inventoryTile != null && !(inventoryTile instanceof TileEntityConveyorBelt) && !(stack = ((EntityItem)entity).getItem()).isEmpty()) {
                    ItemStack ret = Utils.insertStackIntoInventory(inventoryTile, stack, EnumFacing.DOWN);
                    if (ret.isEmpty()) {
                        entity.setDead();
                    } else if (ret.getCount() < stack.getCount()) {
                        ((EntityItem)entity).setItem(ret);
                    }
                }
            }
        }
    }

    @Override
    public boolean mirrorFacingOnPlacement(EntityLivingBase placer) {
        return false;
    }

    @Override
    public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity) {
        return true;
    }

    @Override
    public float[] getBlockBounds() {
        float minX = this.facing == EnumFacing.EAST ? 0.875f : 0.0f;
        float maxX = this.facing == EnumFacing.WEST ? 0.125f : 1.0f;
        float minZ = this.facing == EnumFacing.SOUTH ? 0.875f : 0.0f;
        float maxZ = this.facing == EnumFacing.NORTH ? 0.125f : 1.0f;
        return new float[]{minX, 0.0f, minZ, maxX, 1.0f, maxZ};
    }

    @Override
    public List<AxisAlignedBB> getAdvancedColisionBounds() {
        return null;
    }
}

