/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileEntityConveyorBelt
extends TileEntityIEBase
implements IEBlockInterfaces.IDirectionalTile,
IEBlockInterfaces.IAdvancedCollisionBounds,
IEBlockInterfaces.IAdvancedSelectionBounds,
IEBlockInterfaces.IHammerInteraction,
IEBlockInterfaces.IPlayerInteraction,
ConveyorHandler.IConveyorTile,
IEBlockInterfaces.IPropertyPassthrough,
IEBlockInterfaces.ITileDrop {
    public EnumFacing facing = EnumFacing.NORTH;
    private ConveyorHandler.IConveyorBelt conveyorBeltSubtype;
    static AxisAlignedBB COLISIONBB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
    IItemHandler insertionHandler = new ConveyorInventoryHandler(this);

    @Override
    public ConveyorHandler.IConveyorBelt getConveyorSubtype() {
        return this.conveyorBeltSubtype;
    }

    @Override
    public void setConveyorSubtype(ConveyorHandler.IConveyorBelt conveyor) {
        this.conveyorBeltSubtype = conveyor;
    }

    @Override
    public void onEntityCollision(World world, Entity entity) {
        if (this.conveyorBeltSubtype != null) {
            this.conveyorBeltSubtype.onEntityCollision(this, entity, this.facing);
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.facing = EnumFacing.getFront((int)nbt.getInteger("facing"));
        if (nbt.hasKey("conveyorBeltSubtype")) {
            this.conveyorBeltSubtype = ConveyorHandler.getConveyor(new ResourceLocation(nbt.getString("conveyorBeltSubtype")), this);
            this.conveyorBeltSubtype.readConveyorNBT(nbt.getCompoundTag("conveyorBeltSubtypeNBT"));
        }
        if (descPacket && this.world != null) {
            this.markContainingBlockForUpdate(null);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.setInteger("facing", this.facing.ordinal());
        if (this.conveyorBeltSubtype != null) {
            nbt.setString("conveyorBeltSubtype", ConveyorHandler.reverseClassRegistry.get(this.conveyorBeltSubtype.getClass()).toString());
            nbt.setTag("conveyorBeltSubtypeNBT", (NBTBase)this.conveyorBeltSubtype.writeConveyorNBT());
        }
    }

    @Override
    public EnumFacing getFacing() {
        return this.facing;
    }

    @Override
    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    @Override
    public int getFacingLimitation() {
        return 5;
    }

    @Override
    public boolean mirrorFacingOnPlacement(EntityLivingBase placer) {
        return false;
    }

    @Override
    public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity) {
        return !entity.isSneaking();
    }

    @Override
    public boolean canRotate(EnumFacing axis) {
        return true;
    }

    @Override
    public void afterRotation(EnumFacing oldDir, EnumFacing newDir) {
        if (this.conveyorBeltSubtype != null) {
            this.conveyorBeltSubtype.afterRotation(oldDir, newDir);
        }
    }

    @Override
    public boolean hammerUseSide(EnumFacing side, EntityPlayer player, float hitX, float hitY, float hitZ) {
        if (player.isSneaking() && this.conveyorBeltSubtype != null && this.conveyorBeltSubtype.changeConveyorDirection()) {
            this.markDirty();
            this.markContainingBlockForUpdate(null);
            this.world.addBlockEvent(this.getPos(), this.getBlockType(), 0, 0);
            return true;
        }
        return false;
    }

    @Override
    public boolean interact(EnumFacing side, EntityPlayer player, EnumHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        EnumDyeColor dye;
        boolean update;
        if (this.conveyorBeltSubtype != null && (update = this.conveyorBeltSubtype.canBeDyed() && Utils.isDye(heldItem) ? (dye = EnumDyeColor.byDyeDamage((int)Utils.getDye(heldItem))) != null && this.conveyorBeltSubtype.setDyeColour(dye.getColorValue()) : this.conveyorBeltSubtype.playerInteraction(this, player, hand, heldItem, hitX, hitY, hitZ, side))) {
            this.markDirty();
            this.markContainingBlockForUpdate(null);
            this.world.addBlockEvent(this.getPos(), this.getBlockType(), 0, 0);
            return true;
        }
        return false;
    }

    @Override
    public float[] getBlockBounds() {
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f};
    }

    @Override
    public List<AxisAlignedBB> getAdvancedColisionBounds() {
        if (this.conveyorBeltSubtype != null) {
            ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
            for (AxisAlignedBB aabb : this.conveyorBeltSubtype.getColisionBoxes(this, this.facing)) {
                boxes.add(aabb.offset(this.getPos()));
            }
            return boxes;
        }
        return Lists.newArrayList((Object[])new AxisAlignedBB[]{COLISIONBB.offset(this.getPos())});
    }

    @Override
    public List<AxisAlignedBB> getAdvancedSelectionBounds() {
        if (this.conveyorBeltSubtype != null) {
            ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
            for (AxisAlignedBB aabb : this.conveyorBeltSubtype.getSelectionBoxes(this, this.facing)) {
                boxes.add(aabb.offset(this.getPos()));
            }
            return boxes;
        }
        return Lists.newArrayList((Object[])new AxisAlignedBB[]{COLISIONBB.offset(this.getPos())});
    }

    @Override
    public boolean isOverrideBox(AxisAlignedBB box, EntityPlayer player, RayTraceResult mop, ArrayList<AxisAlignedBB> list) {
        return false;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.insertionHandler;
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public ItemStack getTileDrop(EntityPlayer player, IBlockState state) {
        ItemStack stack = new ItemStack(state.getBlock());
        if (this.conveyorBeltSubtype != null) {
            ItemNBTHelper.setString(stack, "conveyorType", ConveyorHandler.reverseClassRegistry.get(this.conveyorBeltSubtype.getClass()).toString());
        }
        return stack;
    }

    @Override
    public void readOnPlacement(EntityLivingBase placer, ItemStack stack) {
        String key = ItemNBTHelper.getString(stack, "conveyorType");
        ConveyorHandler.IConveyorBelt subType = ConveyorHandler.getConveyor(new ResourceLocation(key), this);
        this.setConveyorSubtype(subType);
    }

    public static class ConveyorInventoryHandler
    implements IItemHandlerModifiable {
        TileEntityConveyorBelt conveyor;

        public ConveyorInventoryHandler(TileEntityConveyorBelt conveyor) {
            this.conveyor = conveyor;
        }

        public int getSlots() {
            return 1;
        }

        public ItemStack getStackInSlot(int slot) {
            return ItemStack.EMPTY;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (!simulate) {
                EntityItem entity = new EntityItem(this.conveyor.getWorld(), (double)this.conveyor.getPos().getX() + 0.5, (double)this.conveyor.getPos().getY() + 0.1875, (double)this.conveyor.getPos().getZ() + 0.5, stack.copy());
                entity.motionX = 0.0;
                entity.motionY = 0.0;
                entity.motionZ = 0.0;
                this.conveyor.getWorld().spawnEntity((Entity)entity);
                if (this.conveyor.conveyorBeltSubtype != null) {
                    this.conveyor.conveyorBeltSubtype.onItemDeployed(this.conveyor, entity, this.conveyor.facing);
                }
            }
            return ItemStack.EMPTY;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.EMPTY;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public void setStackInSlot(int slot, ItemStack stack) {
        }
    }
}

