/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.TileEntityImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import blusunrize.immersiveengineering.api.energy.wires.redstone.IRedstoneConnector;
import blusunrize.immersiveengineering.api.energy.wires.redstone.RedstoneWireNetwork;
import blusunrize.immersiveengineering.client.models.IOBJModelCallback;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityConnectorRedstone
extends TileEntityImmersiveConnectable
implements ITickable,
IEBlockInterfaces.IDirectionalTile,
IEBlockInterfaces.IRedstoneOutput,
IEBlockInterfaces.IHammerInteraction,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IBlockOverlayText,
IOBJModelCallback<IBlockState>,
IRedstoneConnector {
    public EnumFacing facing = EnumFacing.DOWN;
    public int ioMode = 0;
    public int redstoneChannel = 0;
    public boolean rsDirty = false;
    protected RedstoneWireNetwork wireNetwork = new RedstoneWireNetwork().add(this);
    private boolean loaded = false;
    private int outputClient = -1;
    @SideOnly(value=Side.CLIENT)
    private AxisAlignedBB renderAABB;

    public void update() {
        if (this.hasWorld() && !this.world.isRemote && !this.loaded) {
            this.loaded = true;
            this.wireNetwork.removeFromNetwork(null);
        }
        if (this.hasWorld() && !this.world.isRemote && this.rsDirty) {
            this.wireNetwork.updateValues();
        }
    }

    @Override
    public int getStrongRSOutput(IBlockState state, EnumFacing side) {
        if (!this.isRSOutput() || side != this.facing.getOpposite()) {
            return 0;
        }
        if (this.world.isRemote) {
            return this.outputClient;
        }
        return this.wireNetwork != null ? this.wireNetwork.getPowerOutput(this.redstoneChannel) : 0;
    }

    @Override
    public int getWeakRSOutput(IBlockState state, EnumFacing side) {
        if (!this.isRSOutput()) {
            return 0;
        }
        if (this.world.isRemote) {
            return this.outputClient;
        }
        return this.wireNetwork != null ? this.wireNetwork.getPowerOutput(this.redstoneChannel) : 0;
    }

    @Override
    public boolean canConnectRedstone(IBlockState state, EnumFacing side) {
        return true;
    }

    @Override
    public void setNetwork(RedstoneWireNetwork net) {
        this.wireNetwork = net;
    }

    @Override
    public RedstoneWireNetwork getNetwork() {
        return this.wireNetwork;
    }

    @Override
    public void onChange() {
        if (!this.isInvalid() && this.isRSOutput()) {
            this.markDirty();
            this.markContainingBlockForUpdate(null);
            this.markBlockForUpdate(this.pos.offset(this.facing), null);
        }
    }

    @Override
    public World getConnectorWorld() {
        return this.getWorld();
    }

    public boolean isRSInput() {
        return this.ioMode == 0;
    }

    @Override
    public void updateInput(byte[] signals) {
        if (this.isRSInput()) {
            signals[this.redstoneChannel] = (byte)Math.max(this.getLocalRS(), signals[this.redstoneChannel]);
        }
        this.rsDirty = false;
    }

    protected int getLocalRS() {
        int val = this.world.isBlockIndirectlyGettingPowered(this.pos);
        if (val == 0) {
            for (EnumFacing f : EnumFacing.HORIZONTALS) {
                IBlockState state = this.world.getBlockState(this.pos.offset(f));
                if (state.getBlock() != Blocks.REDSTONE_WIRE || (Integer)state.getValue((IProperty)BlockRedstoneWire.POWER) <= val) continue;
                val = (Integer)state.getValue((IProperty)BlockRedstoneWire.POWER);
            }
        }
        return val;
    }

    public boolean isRSOutput() {
        return this.ioMode == 1;
    }

    @Override
    public boolean hammerUseSide(EnumFacing side, EntityPlayer player, float hitX, float hitY, float hitZ) {
        if (player.isSneaking()) {
            this.redstoneChannel = (this.redstoneChannel + 1) % 16;
        } else {
            this.ioMode = this.ioMode == 0 ? 1 : 0;
        }
        this.markDirty();
        this.wireNetwork.updateValues();
        this.onChange();
        this.markContainingBlockForUpdate(null);
        this.world.addBlockEvent(this.getPos(), this.getBlockType(), 254, 0);
        return true;
    }

    @Override
    public boolean canConnectCable(WireType cableType, TargetingInfo target) {
        if (cableType != WireType.REDSTONE) {
            return false;
        }
        return this.limitType == null || this.limitType == cableType;
    }

    @Override
    public void connectCable(WireType cableType, TargetingInfo target, IImmersiveConnectable other) {
        super.connectCable(cableType, target, other);
        if (other instanceof IRedstoneConnector && ((IRedstoneConnector)other).getNetwork() != this.wireNetwork) {
            this.wireNetwork.mergeNetwork(((IRedstoneConnector)other).getNetwork());
        }
    }

    @Override
    public void removeCable(ImmersiveNetHandler.Connection connection) {
        super.removeCable(connection);
        this.wireNetwork.removeFromNetwork(this);
    }

    @Override
    public EnumFacing getFacing() {
        return this.facing;
    }

    @Override
    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    @Override
    public int getFacingLimitation() {
        return 0;
    }

    @Override
    public boolean mirrorFacingOnPlacement(EntityLivingBase placer) {
        return true;
    }

    @Override
    public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity) {
        return false;
    }

    @Override
    public boolean canRotate(EnumFacing axis) {
        return false;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.setInteger("facing", this.facing.ordinal());
        nbt.setInteger("ioMode", this.ioMode);
        nbt.setInteger("redstoneChannel", this.redstoneChannel);
        nbt.setInteger("output", this.wireNetwork != null ? this.wireNetwork.getPowerOutput(this.redstoneChannel) : 0);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.facing = EnumFacing.getFront((int)nbt.getInteger("facing"));
        this.ioMode = nbt.getInteger("ioMode");
        this.redstoneChannel = nbt.getInteger("redstoneChannel");
        this.outputClient = nbt.getInteger("output");
    }

    @Override
    public Vec3d getRaytraceOffset(IImmersiveConnectable link) {
        EnumFacing side = this.facing.getOpposite();
        return new Vec3d(0.5 + (double)side.getFrontOffsetX() * 0.0625, 0.5 + (double)side.getFrontOffsetY() * 0.0625, 0.5 + (double)side.getFrontOffsetZ() * 0.0625);
    }

    @Override
    public Vec3d getConnectionOffset(ImmersiveNetHandler.Connection con) {
        EnumFacing side = this.facing.getOpposite();
        double conRadius = con.cableType.getRenderDiameter() / 2.0;
        return new Vec3d(0.5 - conRadius * (double)side.getFrontOffsetX(), 0.5 - conRadius * (double)side.getFrontOffsetY(), 0.5 - conRadius * (double)side.getFrontOffsetZ());
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        int inc = this.getRenderRadiusIncrease();
        return new AxisAlignedBB((double)(this.pos.getX() - inc), (double)(this.pos.getY() - inc), (double)(this.pos.getZ() - inc), (double)(this.pos.getX() + inc + 1), (double)(this.pos.getY() + inc + 1), (double)(this.pos.getZ() + inc + 1));
    }

    int getRenderRadiusIncrease() {
        return WireType.REDSTONE.getMaxLength();
    }

    @Override
    public float[] getBlockBounds() {
        float length = 0.625f;
        float wMin = 0.3125f;
        float wMax = 0.6875f;
        switch (this.facing.getOpposite()) {
            case UP: {
                return new float[]{wMin, 0.0f, wMin, wMax, length, wMax};
            }
            case DOWN: {
                return new float[]{wMin, 1.0f - length, wMin, wMax, 1.0f, wMax};
            }
            case SOUTH: {
                return new float[]{wMin, wMin, 0.0f, wMax, wMax, length};
            }
            case NORTH: {
                return new float[]{wMin, wMin, 1.0f - length, wMax, wMax, 1.0f};
            }
            case EAST: {
                return new float[]{0.0f, wMin, wMin, length, wMax, wMax};
            }
            case WEST: {
                return new float[]{1.0f - length, wMin, wMin, 1.0f, wMax, wMax};
            }
        }
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldRenderGroup(IBlockState object, String group) {
        if ("io_out".equals(group)) {
            return this.ioMode == 1;
        }
        if ("io_in".equals(group)) {
            return this.ioMode == 0;
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getRenderColour(IBlockState object, String group) {
        if ("coloured".equals(group)) {
            return 0xFF000000 | EnumDyeColor.byMetadata((int)this.redstoneChannel).getColorValue();
        }
        return -1;
    }

    @Override
    public String getCacheKey(IBlockState object) {
        return this.redstoneChannel + ";" + this.ioMode;
    }

    @Override
    public String[] getOverlayText(EntityPlayer player, RayTraceResult mop, boolean hammer) {
        if (!hammer) {
            return null;
        }
        return new String[]{I18n.format((String)"desc.immersiveengineering.info.redstoneChannel", (Object[])new Object[]{I18n.format((String)("item.fireworksCharge." + EnumDyeColor.byMetadata((int)this.redstoneChannel).getUnlocalizedName()), (Object[])new Object[0])}), I18n.format((String)("desc.immersiveengineering.info.blockSide.io." + this.ioMode), (Object[])new Object[0])};
    }

    @Override
    public boolean useNixieFont(EntityPlayer player, RayTraceResult mop) {
        return false;
    }
}

