/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityConnectorRedstone;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityConnectorProbe
extends TileEntityConnectorRedstone {
    private int redstoneChannelSending = 0;
    private int lastOutput = 0;

    @Override
    public void update() {
        int out;
        if (!this.world.isRemote && this.world.getTotalWorldTime() % 8L != (long)((this.getPos().getX() ^ this.getPos().getZ()) & 8) && (out = this.getComparatorSignal()) != this.lastOutput) {
            this.lastOutput = out;
            this.rsDirty = true;
        }
        super.update();
    }

    @Override
    public boolean isRSInput() {
        return true;
    }

    @Override
    public boolean isRSOutput() {
        return true;
    }

    private int getComparatorSignal() {
        BlockPos pos = this.getPos().offset(this.facing);
        IBlockState state = this.world.getBlockState(pos);
        if (state.hasComparatorInputOverride()) {
            return state.getComparatorInputOverride(this.world, pos);
        }
        if (state.isNormalCube()) {
            EntityItemFrame entityitemframe;
            state = this.world.getBlockState(pos = pos.offset(this.facing));
            if (state.hasComparatorInputOverride()) {
                return state.getComparatorInputOverride(this.world, pos);
            }
            if (state.getMaterial() == Material.AIR && (entityitemframe = this.findItemFrame(this.world, this.facing, pos)) != null) {
                return entityitemframe.getAnalogOutput();
            }
        }
        return 0;
    }

    private EntityItemFrame findItemFrame(World world, EnumFacing facing, BlockPos pos) {
        List list = world.getEntitiesWithinAABB(EntityItemFrame.class, new AxisAlignedBB(pos), entity -> entity != null && entity.getHorizontalFacing() == facing);
        return list.size() == 1 ? (EntityItemFrame)list.get(0) : null;
    }

    @Override
    public void updateInput(byte[] signals) {
        signals[this.redstoneChannelSending] = (byte)Math.max(this.lastOutput, signals[this.redstoneChannelSending]);
        this.rsDirty = false;
    }

    @Override
    public boolean hammerUseSide(EnumFacing side, EntityPlayer player, float hitX, float hitY, float hitZ) {
        if (player.isSneaking()) {
            this.redstoneChannel = (this.redstoneChannel + 1) % 16;
        } else {
            this.redstoneChannelSending = (this.redstoneChannelSending + 1) % 16;
        }
        this.markDirty();
        this.wireNetwork.updateValues();
        this.onChange();
        this.markContainingBlockForUpdate(null);
        this.world.addBlockEvent(this.getPos(), this.getBlockType(), 254, 0);
        return true;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.setInteger("redstoneChannelSending", this.redstoneChannelSending);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.redstoneChannelSending = nbt.getInteger("redstoneChannelSending");
    }

    @Override
    public Vec3d getRaytraceOffset(IImmersiveConnectable link) {
        EnumFacing side = this.facing.getOpposite();
        return new Vec3d(0.5 + (double)side.getFrontOffsetX() * 0.375, 0.5 + (double)side.getFrontOffsetY() * 0.375, 0.5 + (double)side.getFrontOffsetZ() * 0.375);
    }

    @Override
    public Vec3d getConnectionOffset(ImmersiveNetHandler.Connection con) {
        EnumFacing side = this.facing.getOpposite();
        double conRadius = con.cableType.getRenderDiameter() / 2.0;
        return new Vec3d(0.5 + (double)side.getFrontOffsetX() * (0.375 - conRadius), 0.5 + (double)side.getFrontOffsetY() * (0.375 - conRadius), 0.5 + (double)side.getFrontOffsetZ() * (0.375 - conRadius));
    }

    @Override
    public float[] getBlockBounds() {
        float wMin = 0.28125f;
        float wMax = 0.71875f;
        switch (this.facing.getOpposite()) {
            case UP: 
            case DOWN: {
                return new float[]{wMin, 0.0f, wMin, wMax, 1.0f, wMax};
            }
            case SOUTH: 
            case NORTH: {
                return new float[]{wMin, wMin, 0.0f, wMax, wMax, 1.0f};
            }
            case EAST: 
            case WEST: {
                return new float[]{0.0f, wMin, wMin, 1.0f, wMax, wMax};
            }
        }
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldRenderGroup(IBlockState object, String group) {
        if (MinecraftForgeClient.getRenderLayer() == BlockRenderLayer.SOLID) {
            return false;
        }
        if ("glass".equals(group)) {
            return MinecraftForgeClient.getRenderLayer() == BlockRenderLayer.TRANSLUCENT;
        }
        return MinecraftForgeClient.getRenderLayer() == BlockRenderLayer.CUTOUT;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getRenderColour(IBlockState object, String group) {
        if ("colour_in".equals(group)) {
            return 0xFF000000 | EnumDyeColor.byMetadata((int)this.redstoneChannel).getColorValue();
        }
        if ("colour_out".equals(group)) {
            return 0xFF000000 | EnumDyeColor.byMetadata((int)this.redstoneChannelSending).getColorValue();
        }
        return -1;
    }

    @Override
    public String getCacheKey(IBlockState object) {
        return this.redstoneChannel + ";" + this.redstoneChannelSending;
    }

    @Override
    public String[] getOverlayText(EntityPlayer player, RayTraceResult mop, boolean hammer) {
        if (!hammer) {
            return null;
        }
        return new String[]{I18n.format((String)"desc.immersiveengineering.info.redstoneChannel.rec", (Object[])new Object[]{I18n.format((String)("item.fireworksCharge." + EnumDyeColor.byMetadata((int)this.redstoneChannel).getUnlocalizedName()), (Object[])new Object[0])}), I18n.format((String)"desc.immersiveengineering.info.redstoneChannel.send", (Object[])new Object[]{I18n.format((String)("item.fireworksCharge." + EnumDyeColor.byMetadata((int)this.redstoneChannelSending).getUnlocalizedName()), (Object[])new Object[0])})};
    }

    @Override
    public boolean useNixieFont(EntityPlayer player, RayTraceResult mop) {
        return false;
    }
}

