/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorage;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;

public class TileEntityCapacitorLV
extends TileEntityIEBase
implements ITickable,
EnergyHelper.IIEInternalFluxHandler,
IEBlockInterfaces.IBlockOverlayText,
IEBlockInterfaces.IConfigurableSides,
IEBlockInterfaces.IComparatorOverride,
IEBlockInterfaces.ITileDrop {
    public IEEnums.SideConfig[] sideConfig = new IEEnums.SideConfig[]{IEEnums.SideConfig.NONE, IEEnums.SideConfig.INPUT, IEEnums.SideConfig.NONE, IEEnums.SideConfig.NONE, IEEnums.SideConfig.NONE, IEEnums.SideConfig.NONE};
    FluxStorage energyStorage = new FluxStorage(this.getMaxStorage(), this.getMaxInput(), this.getMaxOutput());
    public int comparatorOutput = 0;
    EnergyHelper.IEForgeEnergyWrapper[] wrappers = EnergyHelper.IEForgeEnergyWrapper.getDefaultWrapperArray(this);

    public void update() {
        if (!this.world.isRemote) {
            int i;
            for (i = 0; i < 6; ++i) {
                this.transferEnergy(i);
            }
            if (this.world.getTotalWorldTime() % 32L == (long)((this.getPos().getX() ^ this.getPos().getZ()) & 0x1F) && (i = this.scaleStoredEnergyTo(15)) != this.comparatorOutput) {
                this.comparatorOutput = i;
                this.world.updateComparatorOutputLevel(this.getPos(), this.getBlockType());
            }
        }
    }

    public int scaleStoredEnergyTo(int scale) {
        return (int)((float)scale * ((float)this.energyStorage.getEnergyStored() / (float)this.energyStorage.getMaxEnergyStored()));
    }

    protected void transferEnergy(int side) {
        if (this.sideConfig[side] != IEEnums.SideConfig.OUTPUT) {
            return;
        }
        EnumFacing fd = EnumFacing.getFront((int)side);
        BlockPos outPos = this.getPos().offset(fd);
        TileEntity tileEntity = Utils.getExistingTileEntity(this.world, outPos);
        int out = Math.min(this.getMaxOutput(), this.energyStorage.getEnergyStored());
        this.energyStorage.modifyEnergyStored(-EnergyHelper.insertFlux(tileEntity, fd.getOpposite(), out, false));
    }

    @Override
    public IEEnums.SideConfig getSideConfig(int side) {
        return this.sideConfig[side];
    }

    @Override
    public boolean toggleSide(int side, EntityPlayer player) {
        this.sideConfig[side] = IEEnums.SideConfig.next(this.sideConfig[side]);
        this.markDirty();
        this.markContainingBlockForUpdate(null);
        this.world.addBlockEvent(this.getPos(), this.getBlockType(), 0, 0);
        return true;
    }

    @Override
    public boolean receiveClientEvent(int id, int arg) {
        if (id == 0) {
            this.markContainingBlockForUpdate(null);
            return true;
        }
        return false;
    }

    public int getMaxStorage() {
        return Config.IEConfig.Machines.capacitorLV_storage;
    }

    public int getMaxInput() {
        return Config.IEConfig.Machines.capacitorLV_input;
    }

    public int getMaxOutput() {
        return Config.IEConfig.Machines.capacitorLV_output;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        for (int i = 0; i < 6; ++i) {
            nbt.setInteger("sideConfig_" + i, this.sideConfig[i].ordinal());
        }
        this.energyStorage.writeToNBT(nbt);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        if (nbt.hasKey("sideConfig")) {
            int[] old = nbt.getIntArray("sideConfig");
            for (int i = 0; i < old.length; ++i) {
                this.sideConfig[i] = IEEnums.SideConfig.values()[old[i] + 1];
            }
        } else {
            for (int i = 0; i < 6; ++i) {
                this.sideConfig[i] = IEEnums.SideConfig.values()[nbt.getInteger("sideConfig_" + i)];
            }
        }
        this.energyStorage.readFromNBT(nbt);
    }

    @Override
    @Nonnull
    public FluxStorage getFluxStorage() {
        return this.energyStorage;
    }

    @Override
    @Nonnull
    public IEEnums.SideConfig getEnergySideConfig(EnumFacing facing) {
        if (facing == null) {
            return IEEnums.SideConfig.NONE;
        }
        return this.sideConfig[facing.ordinal()];
    }

    @Override
    public EnergyHelper.IEForgeEnergyWrapper getCapabilityWrapper(EnumFacing facing) {
        if (facing == null) {
            return null;
        }
        return this.wrappers[facing.ordinal()];
    }

    @Override
    public String[] getOverlayText(EntityPlayer player, RayTraceResult mop, boolean hammer) {
        if (hammer && Config.IEConfig.colourblindSupport) {
            IEEnums.SideConfig i = this.sideConfig[Math.min(this.sideConfig.length - 1, mop.sideHit.ordinal())];
            IEEnums.SideConfig j = this.sideConfig[Math.min(this.sideConfig.length - 1, mop.sideHit.getOpposite().ordinal())];
            return new String[]{I18n.format((String)"desc.immersiveengineering.info.blockSide.facing", (Object[])new Object[0]) + ": " + I18n.format((String)("desc.immersiveengineering.info.blockSide.connectEnergy." + (Object)((Object)i)), (Object[])new Object[0]), I18n.format((String)"desc.immersiveengineering.info.blockSide.opposite", (Object[])new Object[0]) + ": " + I18n.format((String)("desc.immersiveengineering.info.blockSide.connectEnergy." + (Object)((Object)j)), (Object[])new Object[0])};
        }
        return null;
    }

    @Override
    public boolean useNixieFont(EntityPlayer player, RayTraceResult mop) {
        return false;
    }

    @Override
    public int getComparatorInputOverride() {
        return this.comparatorOutput;
    }

    @Override
    public ItemStack getTileDrop(EntityPlayer player, IBlockState state) {
        ItemStack stack = new ItemStack(state.getBlock(), 1, state.getBlock().getMetaFromState(state));
        if (this.energyStorage.getEnergyStored() > 0) {
            ItemNBTHelper.setInt(stack, "energyStorage", this.energyStorage.getEnergyStored());
        }
        for (int i = 0; i < 6; ++i) {
            ItemNBTHelper.setInt(stack, "sideConfig_" + i, this.sideConfig[i].ordinal());
        }
        return stack;
    }

    @Override
    public void readOnPlacement(EntityLivingBase placer, ItemStack stack) {
        if (ItemNBTHelper.hasKey(stack, "energyStorage")) {
            this.energyStorage.setEnergy(ItemNBTHelper.getInt(stack, "energyStorage"));
        }
        for (int i = 0; i < 6; ++i) {
            if (!ItemNBTHelper.hasKey(stack, "sideConfig_" + i)) continue;
            this.sideConfig[i] = IEEnums.SideConfig.values()[ItemNBTHelper.getInt(stack, "sideConfig_" + i)];
        }
    }
}

