/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityMultiblockPart;
import blusunrize.immersiveengineering.common.blocks.multiblocks.MultiblockBucketWheel;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.network.MessageTileSync;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityBucketWheel
extends TileEntityMultiblockPart<TileEntityBucketWheel>
implements IEBlockInterfaces.IHasObjProperty,
IEBlockInterfaces.IDynamicTexture {
    public float rotation = 0.0f;
    public NonNullList<ItemStack> digStacks = NonNullList.withSize((int)8, (Object)ItemStack.EMPTY);
    public boolean active = false;
    public ItemStack particleStack = ItemStack.EMPTY;
    private static final int[] size = new int[]{7, 1, 7};
    static ArrayList<String> emptyDisplayList = new ArrayList();
    @SideOnly(value=Side.CLIENT)
    private AxisAlignedBB renderAABB;

    public TileEntityBucketWheel() {
        super(size);
    }

    @Override
    public ItemStack getOriginalBlock() {
        if (this.pos < 0) {
            return ItemStack.EMPTY;
        }
        ItemStack s = this.pos < 0 ? ItemStack.EMPTY : MultiblockBucketWheel.instance.getStructureManual()[this.pos / 7][this.pos % 7][0];
        return s.copy();
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        float nbtRot = nbt.getFloat("rotation");
        this.rotation = (double)Math.abs(nbtRot - this.rotation) > 5.0 * Config.IEConfig.Machines.excavator_speed ? nbtRot : this.rotation;
        this.digStacks = Utils.readInventory(nbt.getTagList("digStacks", 10), 8);
        this.active = nbt.getBoolean("active");
        this.particleStack = nbt.hasKey("particleStack") ? new ItemStack(nbt.getCompoundTag("particleStack")) : ItemStack.EMPTY;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.setFloat("rotation", this.rotation);
        nbt.setTag("digStacks", (NBTBase)Utils.writeInventory(this.digStacks));
        nbt.setBoolean("active", this.active);
        if (!this.particleStack.isEmpty()) {
            nbt.setTag("particleStack", (NBTBase)this.particleStack.writeToNBT(new NBTTagCompound()));
        }
    }

    @Override
    protected IFluidTank[] getAccessibleFluidTanks(EnumFacing side) {
        return new IFluidTank[0];
    }

    @Override
    protected boolean canFillTankFrom(int iTank, EnumFacing side, FluidStack resources) {
        return false;
    }

    @Override
    protected boolean canDrainTankFrom(int iTank, EnumFacing side) {
        return false;
    }

    public void update() {
        ApiUtils.checkForNeedlessTicking(this);
        if (!this.formed || this.pos != 24) {
            return;
        }
        if (this.active) {
            this.rotation = (float)((double)this.rotation + Config.IEConfig.Machines.excavator_speed);
            this.rotation %= 360.0f;
        }
        if (this.world.isRemote) {
            if (!this.particleStack.isEmpty()) {
                ImmersiveEngineering.proxy.spawnBucketWheelFX(this, this.particleStack);
                this.particleStack = ItemStack.EMPTY;
            }
        } else if (this.active && this.world.getTotalWorldTime() % 20L == 0L) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.setFloat("rotation", this.rotation);
            MessageTileSync sync = new MessageTileSync(this, nbt);
            ImmersiveEngineering.packetHandler.sendToAllAround((IMessage)sync, new NetworkRegistry.TargetPoint(this.world.provider.getDimension(), (double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ(), 100.0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SideOnly(value=Side.CLIENT)
    public HashMap<String, String> getTextureReplacements() {
        NonNullList<ItemStack> nonNullList = this.digStacks;
        synchronized (nonNullList) {
            HashMap<String, String> texMap = new HashMap<String, String>();
            for (int i = 0; i < this.digStacks.size(); ++i) {
                if (((ItemStack)this.digStacks.get(i)).isEmpty()) continue;
                Block b = Block.getBlockFromItem((Item)((ItemStack)this.digStacks.get(i)).getItem());
                IBlockState state = b != null ? b.getStateFromMeta(((ItemStack)this.digStacks.get(i)).getMetadata()) : Blocks.STONE.getDefaultState();
                IBakedModel model = Minecraft.getMinecraft().getBlockRendererDispatcher().getBlockModelShapes().getModelForState(state);
                if (model == null || model.getParticleTexture() == null) continue;
                texMap.put("dig" + i, model.getParticleTexture().getIconName());
            }
            return texMap;
        }
    }

    @Override
    public ArrayList<String> compileDisplayList() {
        return emptyDisplayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveMessageFromServer(NBTTagCompound message) {
        NonNullList<ItemStack> nonNullList = this.digStacks;
        synchronized (nonNullList) {
            int packetRotation;
            if (message.hasKey("fill")) {
                this.digStacks.set(message.getInteger("fill"), (Object)new ItemStack(message.getCompoundTag("fillStack")));
            }
            if (message.hasKey("empty")) {
                this.digStacks.set(message.getInteger("empty"), (Object)ItemStack.EMPTY);
            }
            if (message.hasKey("rotation") && (double)Math.abs((float)(packetRotation = message.getInteger("rotation")) - this.rotation) > 5.0 * Config.IEConfig.Machines.excavator_speed) {
                this.rotation = packetRotation;
            }
        }
    }

    @Override
    public boolean receiveClientEvent(int id, int arg) {
        if (id == 0) {
            this.active = arg == 1;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = new AxisAlignedBB(this.getPos().add(-(this.facing.getAxis() == EnumFacing.Axis.Z ? 3 : 0), -3, -(this.facing.getAxis() == EnumFacing.Axis.X ? 3 : 0)), this.getPos().add(this.facing.getAxis() == EnumFacing.Axis.Z ? 4 : 1, 4, this.facing.getAxis() == EnumFacing.Axis.X ? 4 : 1));
        }
        return this.renderAABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double getMaxRenderDistanceSquared() {
        return super.getMaxRenderDistanceSquared() * Config.IEConfig.increasedTileRenderdistance;
    }

    @Override
    public float[] getBlockBounds() {
        if (this.pos == 3 || this.pos == 9 || this.pos == 11) {
            return new float[]{0.0f, 0.25f, 0.0f, 1.0f, 1.0f, 1.0f};
        }
        if (this.pos == 45 || this.pos == 37 || this.pos == 39) {
            return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 0.75f, 1.0f};
        }
        if (this.pos == 21) {
            return new float[]{this.facing == EnumFacing.NORTH ? 0.25f : 0.0f, 0.0f, this.facing == EnumFacing.WEST ? 0.25f : 0.0f, this.facing == EnumFacing.SOUTH ? 0.75f : 1.0f, 1.0f, this.facing == EnumFacing.EAST ? 0.75f : 1.0f};
        }
        if (this.pos == 27) {
            return new float[]{this.facing == EnumFacing.SOUTH ? 0.25f : 0.0f, 0.0f, this.facing == EnumFacing.EAST ? 0.25f : 0.0f, this.facing == EnumFacing.NORTH ? 0.75f : 1.0f, 1.0f, this.facing == EnumFacing.WEST ? 0.75f : 1.0f};
        }
        if (this.pos == 15 || this.pos == 29) {
            return new float[]{this.facing == EnumFacing.NORTH ? 0.25f : 0.0f, 0.0f, this.facing == EnumFacing.WEST ? 0.25f : 0.0f, this.facing == EnumFacing.SOUTH ? 0.75f : 1.0f, 1.0f, this.facing == EnumFacing.EAST ? 0.75f : 1.0f};
        }
        if (this.pos == 19 || this.pos == 33) {
            return new float[]{this.facing == EnumFacing.SOUTH ? 0.25f : 0.0f, 0.0f, this.facing == EnumFacing.EAST ? 0.25f : 0.0f, this.facing == EnumFacing.NORTH ? 0.75f : 1.0f, 1.0f, this.facing == EnumFacing.WEST ? 0.75f : 1.0f};
        }
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }
}

