/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.crafting.BottlingMachineRecipe;
import blusunrize.immersiveengineering.api.crafting.IMultiblockRecipe;
import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityConveyorBelt;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityFluidPump;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockMetal;
import blusunrize.immersiveengineering.common.blocks.multiblocks.MultiblockBottlingMachine;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileEntityBottlingMachine
extends TileEntityMultiblockMetal<TileEntityBottlingMachine, IMultiblockRecipe>
implements ConveyorHandler.IConveyorAttachable {
    public FluidTank[] tanks = new FluidTank[]{new FluidTank(8000)};
    public List<BottlingProcess> bottlingProcessQueue = new ArrayList<BottlingProcess>();
    IItemHandler insertionHandler = new BottlingMachineInventoryHandler(this);

    public TileEntityBottlingMachine() {
        super(MultiblockBottlingMachine.instance, new int[]{3, 2, 3}, 16000, true);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        NBTTagList processNBT = nbt.getTagList("bottlingQueue", 10);
        this.bottlingProcessQueue.clear();
        for (int i = 0; i < processNBT.tagCount(); ++i) {
            NBTTagCompound tag = processNBT.getCompoundTagAt(i);
            BottlingProcess process = BottlingProcess.readFromNBT(tag);
            this.bottlingProcessQueue.add(process);
        }
        this.tanks[0].readFromNBT(nbt.getCompoundTag("tank"));
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        NBTTagList processNBT = new NBTTagList();
        for (BottlingProcess process : this.bottlingProcessQueue) {
            processNBT.appendTag((NBTBase)process.writeToNBT());
        }
        nbt.setTag("bottlingQueue", (NBTBase)processNBT);
        nbt.setTag("tank", (NBTBase)this.tanks[0].writeToNBT(new NBTTagCompound()));
    }

    @Override
    public void receiveMessageFromClient(NBTTagCompound message) {
    }

    @Override
    public void update() {
        super.update();
        if (this.isDummy() || this.isRSDisabled() || this.world.isRemote) {
            return;
        }
        this.tickedProcesses = 0;
        int max = this.getMaxProcessPerTick();
        int i = 0;
        Iterator<BottlingProcess> processIterator = this.bottlingProcessQueue.iterator();
        this.tickedProcesses = 0;
        while (processIterator.hasNext() && i++ < max) {
            BottlingProcess process = processIterator.next();
            if (process.processStep(this)) {
                ++this.tickedProcesses;
            }
            if (!process.processFinished) continue;
            ItemStack output = !((ItemStack)process.items.get(1)).isEmpty() ? (ItemStack)process.items.get(1) : (ItemStack)process.items.get(0);
            EnumFacing outDir = this.mirrored ? this.facing.rotateYCCW() : this.facing.rotateY();
            BlockPos outPos = this.getBlockPosForPos(8).offset(outDir);
            TileEntity inventoryTile = Utils.getExistingTileEntity(this.world, outPos);
            if (inventoryTile != null) {
                output = Utils.insertStackIntoInventory(inventoryTile, output, outDir.getOpposite());
            }
            if (!output.isEmpty()) {
                Utils.dropStackAtPos(this.world, outPos, output, outDir);
            }
            processIterator.remove();
        }
    }

    @Override
    public float[] getBlockBounds() {
        if (this.pos == 4) {
            return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f};
        }
        if (this.pos < 6 || this.pos == 11) {
            return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
        }
        if (this.pos >= 6 && this.pos <= 8) {
            return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f};
        }
        if (this.pos == 9) {
            return new float[]{0.0625f, 0.0f, 0.0625f, 0.9375f, 1.0f, 0.9375f};
        }
        if (this.pos == 10) {
            float xMax;
            float zMin;
            float xMin;
            EnumFacing f;
            EnumFacing enumFacing = f = this.mirrored ? this.facing.rotateYCCW() : this.facing.rotateY();
            float f2 = f == EnumFacing.EAST ? -0.0625f : (f == EnumFacing.WEST ? 0.25f : (this.facing == EnumFacing.WEST ? 0.125f : (xMin = this.facing == EnumFacing.EAST ? 0.25f : 0.0f)));
            float f3 = this.facing == EnumFacing.NORTH ? 0.125f : (this.facing == EnumFacing.SOUTH ? 0.25f : (f == EnumFacing.SOUTH ? -0.0625f : (zMin = f == EnumFacing.NORTH ? 0.25f : 0.0f)));
            float f4 = f == EnumFacing.EAST ? 0.75f : (f == EnumFacing.WEST ? 1.0625f : (this.facing == EnumFacing.WEST ? 0.75f : (xMax = this.facing == EnumFacing.EAST ? 0.875f : 1.0f)));
            float zMax = this.facing == EnumFacing.NORTH ? 0.75f : (this.facing == EnumFacing.SOUTH ? 0.875f : (f == EnumFacing.SOUTH ? 0.75f : (f == EnumFacing.NORTH ? 1.0625f : 1.0f)));
            return new float[]{xMin, 0.0625f, zMin, xMax, 0.6875f, zMax};
        }
        if (this.pos == 13) {
            float xMin = this.facing == EnumFacing.WEST ? 0.0f : 0.21875f;
            float zMin = this.facing == EnumFacing.NORTH ? 0.0f : 0.21875f;
            float xMax = this.facing == EnumFacing.EAST ? 1.0f : 0.78125f;
            float zMax = this.facing == EnumFacing.SOUTH ? 1.0f : 0.78125f;
            return new float[]{xMin, -0.4375f, zMin, xMax, 0.5625f, zMax};
        }
        if (this.pos == 16) {
            float xMax;
            float zMin;
            float xMin;
            float f = this.facing == EnumFacing.WEST ? 0.8125f : (xMin = this.facing == EnumFacing.EAST ? 0.0f : 0.125f);
            float f5 = this.facing == EnumFacing.NORTH ? 0.8125f : (zMin = this.facing == EnumFacing.SOUTH ? 0.0f : 0.125f);
            float f6 = this.facing == EnumFacing.WEST ? 1.0f : (xMax = this.facing == EnumFacing.EAST ? 0.1875f : 0.875f);
            float zMax = this.facing == EnumFacing.NORTH ? 1.0f : (this.facing == EnumFacing.SOUTH ? 0.1875f : 0.875f);
            return new float[]{xMin, -1.0f, zMin, xMax, 0.25f, zMax};
        }
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    @Override
    public int[] getEnergyPos() {
        return new int[]{11};
    }

    @Override
    public int[] getRedstonePos() {
        return new int[]{1};
    }

    @Override
    public void replaceStructureBlock(BlockPos pos, IBlockState state, ItemStack stack, int h, int l, int w) {
        TileEntity tile;
        super.replaceStructureBlock(pos, state, stack, h, l, w);
        if (h == 2 && l == 1 && w == 1) {
            TileEntity tile2 = this.world.getTileEntity(pos);
            if (tile2 instanceof TileEntityFluidPump) {
                ((TileEntityFluidPump)tile2).dummy = true;
            }
        } else if (h == 1 && l == 0 && (tile = this.world.getTileEntity(pos)) instanceof TileEntityConveyorBelt) {
            ((TileEntityConveyorBelt)tile).setFacing(this.mirrored ? this.facing.rotateYCCW() : this.facing.rotateY());
        }
    }

    @Override
    public void onEntityCollision(World world, Entity entity) {
        if (this.pos == 6 && !world.isRemote && entity != null && !entity.isDead && entity instanceof EntityItem) {
            TileEntityBottlingMachine master = (TileEntityBottlingMachine)this.master();
            if (master == null) {
                return;
            }
            ItemStack stack = ((EntityItem)entity).getItem();
            if (stack.isEmpty()) {
                return;
            }
            if (master.bottlingProcessQueue.size() < master.getProcessQueueMaxLength()) {
                float dist = 1.0f;
                BottlingProcess p = null;
                if (master.bottlingProcessQueue.size() > 0 && (p = master.bottlingProcessQueue.get(master.bottlingProcessQueue.size() - 1)) != null) {
                    dist = (float)p.processTick / (float)p.maxProcessTick;
                }
                if (p != null && dist < master.getMinProcessDistance((TileEntityMultiblockMetal.MultiblockProcess<IMultiblockRecipe>)null)) {
                    return;
                }
                p = new BottlingProcess(Utils.copyStackWithAmount(stack, 1));
                master.bottlingProcessQueue.add(p);
                master.markDirty();
                master.markContainingBlockForUpdate(null);
                stack.shrink(1);
                if (stack.getCount() <= 0) {
                    entity.setDead();
                }
            }
        }
    }

    @Override
    public boolean isInWorldProcessingMachine() {
        return true;
    }

    @Override
    public boolean additionalCanProcessCheck(TileEntityMultiblockMetal.MultiblockProcess<IMultiblockRecipe> process) {
        return true;
    }

    @Override
    public void doProcessOutput(ItemStack output) {
        EnumFacing outDir = this.mirrored ? this.facing.rotateYCCW() : this.facing.rotateY();
        BlockPos pos = this.getPos().offset(outDir, 2);
        TileEntity inventoryTile = this.world.getTileEntity(pos);
        if (inventoryTile != null) {
            output = Utils.insertStackIntoInventory(inventoryTile, output, outDir.getOpposite());
        }
        if (!output.isEmpty()) {
            Utils.dropStackAtPos(this.world, pos, output, outDir);
        }
    }

    @Override
    public void doProcessFluidOutput(FluidStack output) {
    }

    @Override
    public void onProcessFinish(TileEntityMultiblockMetal.MultiblockProcess<IMultiblockRecipe> process) {
    }

    @Override
    public int getMaxProcessPerTick() {
        return 2;
    }

    @Override
    public int getProcessQueueMaxLength() {
        return 2;
    }

    @Override
    public float getMinProcessDistance(TileEntityMultiblockMetal.MultiblockProcess<IMultiblockRecipe> process) {
        return 0.5f;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return null;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public int[] getOutputSlots() {
        return null;
    }

    @Override
    public int[] getOutputTanks() {
        return new int[0];
    }

    @Override
    public IFluidTank[] getInternalTanks() {
        return this.tanks;
    }

    @Override
    public void doGraphicalUpdates(int slot) {
        this.markDirty();
        this.markContainingBlockForUpdate(null);
    }

    @Override
    public IMultiblockRecipe findRecipeForInsertion(ItemStack inserting) {
        return null;
    }

    @Override
    protected IMultiblockRecipe readRecipeFromNBT(NBTTagCompound tag) {
        return null;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            TileEntityBottlingMachine master = (TileEntityBottlingMachine)this.master();
            if (master == null) {
                return false;
            }
            return this.pos == 6 && facing == (this.mirrored ? this.facing.rotateY() : this.facing.rotateYCCW());
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            TileEntityBottlingMachine master = (TileEntityBottlingMachine)this.master();
            if (master == null) {
                return null;
            }
            if (this.pos == 6 && facing == (this.mirrored ? this.facing.rotateY() : this.facing.rotateYCCW())) {
                return (T)master.insertionHandler;
            }
            return null;
        }
        return super.getCapability(capability, facing);
    }

    @Override
    protected IFluidTank[] getAccessibleFluidTanks(EnumFacing side) {
        TileEntityBottlingMachine master = (TileEntityBottlingMachine)this.master();
        if (master != null && this.pos == 3 && (side == null || side.getAxis() != EnumFacing.Axis.Y)) {
            return master.tanks;
        }
        return new FluidTank[0];
    }

    @Override
    protected boolean canFillTankFrom(int iTank, EnumFacing side, FluidStack resource) {
        if (this.pos == 3 && (side == null || side.getAxis() != EnumFacing.Axis.Y)) {
            TileEntityBottlingMachine master = (TileEntityBottlingMachine)this.master();
            return master != null && master.tanks[iTank].getFluidAmount() < master.tanks[iTank].getCapacity();
        }
        return false;
    }

    @Override
    protected boolean canDrainTankFrom(int iTank, EnumFacing side) {
        return false;
    }

    @Override
    public EnumFacing[] sigOutputDirections() {
        if (this.pos == 8) {
            return new EnumFacing[]{this.mirrored ? this.facing.rotateYCCW() : this.facing.rotateY()};
        }
        return new EnumFacing[0];
    }

    public static class BottlingMachineInventoryHandler
    implements IItemHandlerModifiable {
        TileEntityBottlingMachine multiblock;

        public BottlingMachineInventoryHandler(TileEntityBottlingMachine multiblock) {
            this.multiblock = multiblock;
        }

        public int getSlots() {
            return 1;
        }

        public ItemStack getStackInSlot(int slot) {
            return ItemStack.EMPTY;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (this.multiblock.bottlingProcessQueue.size() < this.multiblock.getProcessQueueMaxLength()) {
                stack = stack.copy();
                float dist = 1.0f;
                BottlingProcess p = null;
                if (this.multiblock.bottlingProcessQueue.size() > 0 && (p = this.multiblock.bottlingProcessQueue.get(this.multiblock.bottlingProcessQueue.size() - 1)) != null) {
                    dist = (float)p.processTick / (float)p.maxProcessTick;
                }
                if (p != null && dist < this.multiblock.getMinProcessDistance((TileEntityMultiblockMetal.MultiblockProcess<IMultiblockRecipe>)null)) {
                    return stack;
                }
                if (!simulate) {
                    p = new BottlingProcess(Utils.copyStackWithAmount(stack, 1));
                    this.multiblock.bottlingProcessQueue.add(p);
                    this.multiblock.markDirty();
                    this.multiblock.markContainingBlockForUpdate(null);
                }
                stack.shrink(1);
                if (stack.getCount() <= 0) {
                    stack = ItemStack.EMPTY;
                }
            }
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.EMPTY;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public void setStackInSlot(int slot, ItemStack stack) {
        }
    }

    public static class BottlingProcess {
        public NonNullList<ItemStack> items;
        public int processTick;
        public int maxProcessTick = (int)(120.0f * Config.IEConfig.Machines.bottlingMachine_timeModifier);
        boolean processFinished = false;

        public BottlingProcess(ItemStack input) {
            this.items = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);
            this.items.set(0, (Object)input);
        }

        public boolean processStep(TileEntityBottlingMachine tile) {
            int energyExtracted = (int)(8.0f * Config.IEConfig.Machines.bottlingMachine_energyModifier);
            if (tile.energyStorage.extractEnergy(energyExtracted, true) >= energyExtracted) {
                FluidStack fs;
                tile.energyStorage.extractEnergy(energyExtracted, false);
                if (++this.processTick == (int)((double)this.maxProcessTick * 0.4375) && (fs = tile.tanks[0].getFluid()) != null) {
                    BottlingMachineRecipe recipe = BottlingMachineRecipe.findRecipe((ItemStack)this.items.get(0), fs);
                    if (recipe != null) {
                        if (tile.tanks[0].drainInternal((FluidStack)recipe.fluidInput, (boolean)false).amount == recipe.fluidInput.amount) {
                            this.items.set(1, recipe.getActualItemOutputs(tile).get(0));
                            tile.tanks[0].drainInternal(recipe.fluidInput, true);
                        }
                    } else {
                        ItemStack ret = Utils.fillFluidContainer((IFluidHandler)tile.tanks[0], (ItemStack)this.items.get(0), ItemStack.EMPTY, null);
                        if (!ret.isEmpty()) {
                            this.items.set(1, (Object)ret);
                        }
                    }
                    if (((ItemStack)this.items.get(1)).isEmpty()) {
                        this.items.set(1, this.items.get(0));
                    }
                }
                if (this.processTick >= this.maxProcessTick) {
                    this.processFinished = true;
                }
                return true;
            }
            return false;
        }

        public NBTTagCompound writeToNBT() {
            NBTTagCompound nbt = new NBTTagCompound();
            if (!((ItemStack)this.items.get(0)).isEmpty()) {
                nbt.setTag("input", (NBTBase)((ItemStack)this.items.get(0)).writeToNBT(new NBTTagCompound()));
            }
            if (!((ItemStack)this.items.get(1)).isEmpty()) {
                nbt.setTag("output", (NBTBase)((ItemStack)this.items.get(1)).writeToNBT(new NBTTagCompound()));
            }
            nbt.setInteger("processTick", this.processTick);
            return nbt;
        }

        public static BottlingProcess readFromNBT(NBTTagCompound nbt) {
            ItemStack input = new ItemStack(nbt.getCompoundTag("input"));
            BottlingProcess process = new BottlingProcess(input);
            if (nbt.hasKey("output")) {
                process.items.set(1, (Object)new ItemStack(nbt.getCompoundTag("output")));
            }
            process.processTick = nbt.getInteger("processTick");
            return process;
        }
    }
}

