/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorage;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class TileEntityBlastFurnacePreheater
extends TileEntityIEBase
implements EnergyHelper.IIEInternalFluxHandler,
IEBlockInterfaces.IDirectionalTile,
IEBlockInterfaces.IHasDummyBlocks {
    public boolean active;
    public int dummy = 0;
    public FluxStorage energyStorage = new FluxStorage(8000);
    public EnumFacing facing = EnumFacing.NORTH;
    public float angle = 0.0f;
    public long lastRenderTick = -1L;
    EnergyHelper.IEForgeEnergyWrapper wrapper = new EnergyHelper.IEForgeEnergyWrapper(this, EnumFacing.UP);

    public int doSpeedup() {
        int consumed = Config.IEConfig.Machines.preheater_consumption;
        if (this.energyStorage.extractEnergy(consumed, true) == consumed) {
            if (!this.active) {
                this.active = true;
                this.markContainingBlockForUpdate(null);
            }
            this.energyStorage.extractEnergy(consumed, false);
            return 1;
        }
        if (this.active) {
            this.active = false;
            this.markContainingBlockForUpdate(null);
        }
        return 0;
    }

    @Override
    public boolean isDummy() {
        return this.dummy > 0;
    }

    @Override
    public void placeDummies(BlockPos pos, IBlockState state, EnumFacing side, float hitX, float hitY, float hitZ) {
        for (int i = 1; i <= 2; ++i) {
            this.world.setBlockState(pos.add(0, i, 0), state);
            ((TileEntityBlastFurnacePreheater)this.world.getTileEntity((BlockPos)pos.add((int)0, (int)i, (int)0))).dummy = i;
            ((TileEntityBlastFurnacePreheater)this.world.getTileEntity((BlockPos)pos.add((int)0, (int)i, (int)0))).facing = this.facing;
        }
    }

    @Override
    public void breakDummies(BlockPos pos, IBlockState state) {
        for (int i = 0; i <= 2; ++i) {
            if (!(this.world.getTileEntity(this.getPos().add(0, -this.dummy, 0).add(0, i, 0)) instanceof TileEntityBlastFurnacePreheater)) continue;
            this.world.setBlockToAir(this.getPos().add(0, -this.dummy, 0).add(0, i, 0));
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.dummy = nbt.getInteger("dummy");
        this.facing = EnumFacing.getFront((int)nbt.getInteger("facing"));
        this.energyStorage.readFromNBT(nbt);
        this.active = nbt.getBoolean("active");
        if (descPacket) {
            this.markContainingBlockForUpdate(null);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.setInteger("dummy", this.dummy);
        nbt.setInteger("facing", this.facing.ordinal());
        nbt.setBoolean("active", this.active);
        this.energyStorage.writeToNBT(nbt);
    }

    @Override
    @Nonnull
    public FluxStorage getFluxStorage() {
        TileEntity te;
        if (this.dummy > 0 && (te = this.world.getTileEntity(this.getPos().add(0, -this.dummy, 0))) instanceof TileEntityBlastFurnacePreheater) {
            return ((TileEntityBlastFurnacePreheater)te).getFluxStorage();
        }
        return this.energyStorage;
    }

    @Override
    @Nonnull
    public IEEnums.SideConfig getEnergySideConfig(EnumFacing facing) {
        return this.dummy == 2 && facing == EnumFacing.UP ? IEEnums.SideConfig.INPUT : IEEnums.SideConfig.NONE;
    }

    @Override
    public EnergyHelper.IEForgeEnergyWrapper getCapabilityWrapper(EnumFacing facing) {
        if (this.dummy == 2 && facing == EnumFacing.UP) {
            return this.wrapper;
        }
        return null;
    }

    @Override
    public EnumFacing getFacing() {
        return this.facing;
    }

    @Override
    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    @Override
    public int getFacingLimitation() {
        return 2;
    }

    @Override
    public boolean mirrorFacingOnPlacement(EntityLivingBase placer) {
        return false;
    }

    @Override
    public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity) {
        return true;
    }

    @Override
    public boolean canRotate(EnumFacing axis) {
        return true;
    }

    @Override
    public void afterRotation(EnumFacing oldDir, EnumFacing newDir) {
        for (int i = 0; i <= 2; ++i) {
            TileEntity te = this.world.getTileEntity(this.getPos().add(0, -this.dummy + i, 0));
            if (!(te instanceof TileEntityBlastFurnacePreheater)) continue;
            ((TileEntityBlastFurnacePreheater)te).setFacing(newDir);
            te.markDirty();
            ((TileEntityBlastFurnacePreheater)te).markContainingBlockForUpdate(null);
        }
    }
}

