/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorage;
import blusunrize.immersiveengineering.api.tool.BelljarHandler;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.IOBJModelCallback;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import blusunrize.immersiveengineering.common.util.network.MessageTileSync;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileEntityBelljar
extends TileEntityIEBase
implements ITickable,
IEBlockInterfaces.IDirectionalTile,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IHasDummyBlocks,
IIEInventory,
EnergyHelper.IIEInternalFluxHandler,
IEBlockInterfaces.IGuiTile,
IOBJModelCallback<IBlockState> {
    public EnumFacing facing = EnumFacing.NORTH;
    public int dummy = 0;
    private NonNullList<ItemStack> inventory = NonNullList.withSize((int)7, (Object)ItemStack.EMPTY);
    public FluidTank tank = new FluidTank(4000){

        protected void onContentsChanged() {
            TileEntityBelljar.this.sendSyncPacket(2);
        }
    };
    public FluxStorage energyStorage = new FluxStorage(16000, Math.max(256, Config.IEConfig.Machines.belljar_consumption));
    private BelljarHandler.IPlantHandler curPlantHandler;
    public int fertilizerAmount = 0;
    public float fertilizerMod = 1.0f;
    private float growth = 0.0f;
    public float renderGrowth = 0.0f;
    public boolean renderActive = false;
    IItemHandler inputHandler = new IEInventoryHandler(1, (IIEInventory)this, 2, true, false);
    IItemHandler outputHandler = new IEInventoryHandler(4, (IIEInventory)this, 3, false, true);
    EnergyHelper.IEForgeEnergyWrapper energyWrapper = new EnergyHelper.IEForgeEnergyWrapper(this, null);
    AxisAlignedBB renderBB;

    public void update() {
        block29: {
            BlockPos outputPos;
            TileEntity outputTile;
            block28: {
                BelljarHandler.IPlantHandler handler;
                ApiUtils.checkForNeedlessTicking(this);
                if (this.dummy != 0 || this.world.isBlockIndirectlyGettingPowered(this.getPos()) > 0) {
                    return;
                }
                if (!this.getWorld().isRemote) break block28;
                if (this.energyStorage.getEnergyStored() <= Config.IEConfig.Machines.belljar_consumption || this.fertilizerAmount <= 0 || !this.renderActive || (handler = this.getCurrentPlantHandler()) == null || !handler.isCorrectSoil((ItemStack)this.inventory.get(1), (ItemStack)this.inventory.get(0)) || this.fertilizerAmount <= 0) break block29;
                if (this.renderGrowth < 1.0f) {
                    this.renderGrowth += handler.getGrowthStep((ItemStack)this.inventory.get(1), (ItemStack)this.inventory.get(0), this.renderGrowth, this, this.fertilizerMod, true);
                    --this.fertilizerAmount;
                } else {
                    this.renderGrowth = handler.resetGrowth((ItemStack)this.inventory.get(1), (ItemStack)this.inventory.get(0), this.renderGrowth, this, true);
                }
                if (Utils.RAND.nextInt(8) != 0) break block29;
                double partX = (double)this.getPos().getX() + 0.5;
                double partY = (double)this.getPos().getY() + 2.6875;
                double partZ = (double)this.getPos().getZ() + 0.5;
                ImmersiveEngineering.proxy.spawnRedstoneFX(this.getWorld(), partX, partY, partZ, 0.25, 0.25, 0.25, 1.0f, 0.55f, 0.1f, 0.1f);
                break block29;
            }
            if (!((ItemStack)this.inventory.get(1)).isEmpty()) {
                BelljarHandler.FluidFertilizerHandler fluidFert;
                BelljarHandler.IPlantHandler handler = this.getCurrentPlantHandler();
                if (handler != null && handler.isCorrectSoil((ItemStack)this.inventory.get(1), (ItemStack)this.inventory.get(0)) && this.fertilizerAmount > 0 && this.energyStorage.extractEnergy(Config.IEConfig.Machines.belljar_consumption, true) == Config.IEConfig.Machines.belljar_consumption) {
                    boolean consume = false;
                    if (this.growth >= 1.0f) {
                        ItemStack[] outputs = handler.getOutput((ItemStack)this.inventory.get(1), (ItemStack)this.inventory.get(0), this);
                        int canFit = 0;
                        for (int i = 0; i < outputs.length; ++i) {
                            if (outputs[i].isEmpty()) continue;
                            for (int j = 3; j < 7; ++j) {
                                if (!((ItemStack)this.inventory.get(j)).isEmpty() && (!ItemHandlerHelper.canItemStacksStack((ItemStack)((ItemStack)this.inventory.get(j)), (ItemStack)outputs[i]) || ((ItemStack)this.inventory.get(j)).getCount() + outputs[i].getCount() > ((ItemStack)this.inventory.get(j)).getMaxStackSize())) continue;
                                ++canFit;
                            }
                        }
                        if (canFit >= outputs.length) {
                            block2: for (ItemStack output : outputs) {
                                for (int j = 3; j < 7; ++j) {
                                    if (((ItemStack)this.inventory.get(j)).isEmpty()) {
                                        this.inventory.set(j, (Object)output.copy());
                                        continue block2;
                                    }
                                    if (!ItemHandlerHelper.canItemStacksStack((ItemStack)((ItemStack)this.inventory.get(j)), (ItemStack)output) || ((ItemStack)this.inventory.get(j)).getCount() + output.getCount() > ((ItemStack)this.inventory.get(j)).getMaxStackSize()) continue;
                                    ((ItemStack)this.inventory.get(j)).grow(output.getCount());
                                    continue block2;
                                }
                            }
                            this.growth = handler.resetGrowth((ItemStack)this.inventory.get(1), (ItemStack)this.inventory.get(0), this.growth, this, false);
                            consume = true;
                        }
                    } else if (this.growth < 1.0f) {
                        this.growth += handler.getGrowthStep((ItemStack)this.inventory.get(1), (ItemStack)this.inventory.get(0), this.growth, this, this.fertilizerMod, false);
                        consume = true;
                        if (this.world.getTotalWorldTime() % 32L == (long)((this.getPos().getX() ^ this.getPos().getZ()) & 0x1F)) {
                            this.sendSyncPacket(0);
                        }
                    }
                    if (consume) {
                        this.energyStorage.extractEnergy(Config.IEConfig.Machines.belljar_consumption, false);
                        --this.fertilizerAmount;
                        if (!this.renderActive) {
                            this.renderActive = true;
                            this.sendSyncPacket(0);
                        }
                    } else if (this.renderActive) {
                        this.renderActive = false;
                        this.sendSyncPacket(0);
                    }
                } else {
                    this.growth = 0.0f;
                }
                if (this.fertilizerAmount <= 0 && this.tank.getFluidAmount() >= Config.IEConfig.Machines.belljar_fluid && (fluidFert = BelljarHandler.getFluidFertilizerHandler(this.tank.getFluid())) != null) {
                    this.fertilizerMod = fluidFert.getGrowthMultiplier(this.tank.getFluid(), (ItemStack)this.inventory.get(1), (ItemStack)this.inventory.get(0), this);
                    this.tank.drain(Config.IEConfig.Machines.belljar_fluid, true);
                    if (!((ItemStack)this.inventory.get(2)).isEmpty()) {
                        BelljarHandler.ItemFertilizerHandler itemFert = BelljarHandler.getItemFertilizerHandler((ItemStack)this.inventory.get(2));
                        if (itemFert != null) {
                            this.fertilizerMod *= itemFert.getGrowthMultiplier((ItemStack)this.inventory.get(2), (ItemStack)this.inventory.get(1), (ItemStack)this.inventory.get(0), this);
                        }
                        ((ItemStack)this.inventory.get(2)).shrink(1);
                        if (((ItemStack)this.inventory.get(2)).getCount() <= 0) {
                            this.inventory.set(2, (Object)ItemStack.EMPTY);
                        }
                    }
                    this.fertilizerAmount = Config.IEConfig.Machines.belljar_fertilizer;
                    this.sendSyncPacket(1);
                }
            } else {
                this.growth = 0.0f;
            }
            if (this.world.getTotalWorldTime() % 8L == 0L && (outputTile = Utils.getExistingTileEntity(this.world, outputPos = this.getPos().up().offset(this.facing.getOpposite()))) != null) {
                for (int j = 3; j < 7; ++j) {
                    if (((ItemStack)this.inventory.get(j)).isEmpty()) continue;
                    int out = Math.min(((ItemStack)this.inventory.get(j)).getCount(), 16);
                    ItemStack stack = Utils.copyStackWithAmount((ItemStack)this.inventory.get(j), out);
                    if (!(stack = Utils.insertStackIntoInventory(outputTile, stack, this.facing)).isEmpty()) {
                        out -= stack.getCount();
                    }
                    ((ItemStack)this.inventory.get(j)).shrink(out);
                    if (((ItemStack)this.inventory.get(j)).getCount() > 0) continue;
                    this.inventory.set(j, (Object)ItemStack.EMPTY);
                }
            }
        }
    }

    public BelljarHandler.IPlantHandler getCurrentPlantHandler() {
        if (this.curPlantHandler == null || !this.curPlantHandler.isValid((ItemStack)this.inventory.get(1))) {
            this.curPlantHandler = BelljarHandler.getHandler((ItemStack)this.inventory.get(1));
        }
        return this.curPlantHandler;
    }

    protected void sendSyncPacket(int type) {
        NBTTagCompound nbt = new NBTTagCompound();
        if (type == 0) {
            nbt.setFloat("growth", this.growth);
            nbt.setInteger("energy", this.energyStorage.getEnergyStored());
            nbt.setBoolean("renderActive", this.renderActive);
        } else if (type == 1) {
            nbt.setInteger("fertilizerAmount", this.fertilizerAmount);
            nbt.setFloat("fertilizerMod", this.fertilizerMod);
        } else if (type == 2) {
            nbt.setTag("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        }
        ImmersiveEngineering.packetHandler.sendToAllAround((IMessage)new MessageTileSync(this, nbt), new NetworkRegistry.TargetPoint(this.world.provider.getDimension(), (double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ(), 128.0));
    }

    @Override
    public void receiveMessageFromServer(NBTTagCompound message) {
        if (message.hasKey("growth")) {
            this.renderGrowth = message.getFloat("growth");
        }
        if (message.hasKey("renderActive")) {
            this.renderActive = message.getBoolean("renderActive");
        }
        if (message.hasKey("energy")) {
            this.energyStorage.setEnergy(message.getInteger("energy"));
        }
        if (message.hasKey("fertilizerAmount")) {
            this.fertilizerAmount = message.getInteger("fertilizerAmount");
        }
        if (message.hasKey("fertilizerMod")) {
            this.fertilizerMod = message.getFloat("fertilizerMod");
        }
        if (message.hasKey("tank")) {
            this.tank.readFromNBT(message.getCompoundTag("tank"));
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.facing = EnumFacing.getFront((int)nbt.getInteger("facing"));
        this.dummy = nbt.getInteger("dummy");
        this.inventory = Utils.readInventory(nbt.getTagList("inventory", 10), 7);
        this.energyStorage.readFromNBT(nbt);
        this.tank.readFromNBT(nbt.getCompoundTag("tank"));
        this.fertilizerAmount = nbt.getInteger("fertilizerAmount");
        this.fertilizerMod = nbt.getFloat("fertilizerMod");
        this.growth = nbt.getFloat("growth");
        this.renderBB = null;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.setInteger("facing", this.facing.ordinal());
        nbt.setInteger("dummy", this.dummy);
        nbt.setTag("inventory", (NBTBase)Utils.writeInventory(this.inventory));
        this.energyStorage.writeToNBT(nbt);
        NBTTagCompound tankTag = this.tank.writeToNBT(new NBTTagCompound());
        nbt.setTag("tank", (NBTBase)tankTag);
        nbt.setInteger("fertilizerAmount", this.fertilizerAmount);
        nbt.setFloat("fertilizerMod", this.fertilizerMod);
        nbt.setFloat("growth", this.growth);
    }

    @Override
    public EnumFacing getFacing() {
        return this.facing;
    }

    @Override
    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    @Override
    public int getFacingLimitation() {
        return 2;
    }

    @Override
    public boolean mirrorFacingOnPlacement(EntityLivingBase placer) {
        return false;
    }

    @Override
    public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity) {
        return true;
    }

    @Override
    public boolean canRotate(EnumFacing axis) {
        return true;
    }

    @Override
    public float[] getBlockBounds() {
        return null;
    }

    @Override
    public boolean isDummy() {
        return this.dummy != 0;
    }

    @Override
    public void placeDummies(BlockPos pos, IBlockState state, EnumFacing side, float hitX, float hitY, float hitZ) {
        for (int i = 1; i <= 2; ++i) {
            this.world.setBlockState(pos.up(i), state);
            ((TileEntityBelljar)this.world.getTileEntity((BlockPos)pos.up((int)i))).dummy = i;
            ((TileEntityBelljar)this.world.getTileEntity((BlockPos)pos.up((int)i))).facing = this.facing;
        }
    }

    @Override
    public void breakDummies(BlockPos pos, IBlockState state) {
        for (int i = 0; i <= 2; ++i) {
            BlockPos p = this.getPos().down(this.dummy).up(i);
            if (!(this.world.getTileEntity(p) instanceof TileEntityBelljar)) continue;
            this.world.setBlockToAir(p);
        }
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public int getSlotLimit(int slot) {
        return slot < 2 ? 1 : 64;
    }

    @Override
    public void doGraphicalUpdates(int slot) {
        if (slot == 0) {
            this.markDirty();
            this.markContainingBlockForUpdate(null);
        }
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (this.getGuiMaster() != null) {
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return this.dummy == 0 ? facing == null || facing.getAxis() != this.facing.rotateY().getAxis() : this.dummy == 1 && (facing == null || facing == this.facing.getOpposite());
            }
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                return this.dummy == 0 && (facing == null || facing.getAxis() != this.facing.rotateY().getAxis());
            }
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            TileEntityBelljar te;
            if (this.dummy == 0 && (facing == null || facing.getAxis() != this.facing.rotateY().getAxis())) {
                return (T)this.inputHandler;
            }
            if (this.dummy == 1 && (facing == null || facing == this.facing.getOpposite()) && (te = this.getGuiMaster()) != null) {
                return (T)te.outputHandler;
            }
        } else if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.dummy == 0 && (facing == null || facing.getAxis() != this.facing.rotateY().getAxis())) {
            return (T)this.tank;
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean canOpenGui() {
        return true;
    }

    @Override
    public int getGuiID() {
        return 15;
    }

    @Override
    public TileEntityBelljar getGuiMaster() {
        if (this.dummy == 0) {
            return this;
        }
        TileEntity te = this.world.getTileEntity(this.getPos().down(this.dummy));
        if (te instanceof TileEntityBelljar) {
            return (TileEntityBelljar)te;
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTextureReplacement(IBlockState object, String material) {
        ResourceLocation rl;
        if (!((ItemStack)this.inventory.get(0)).isEmpty() && "farmland".equals(material) && (rl = this.getSoilTexture()) != null) {
            return ClientUtils.getSprite(rl);
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldRenderGroup(IBlockState object, String group) {
        return !"glass".equals(group);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Optional<TRSRTransformation> applyTransformations(IBlockState object, String group, Optional<TRSRTransformation> transform) {
        return transform;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getCacheKey(IBlockState object) {
        ResourceLocation rl;
        if (!((ItemStack)this.inventory.get(0)).isEmpty() && (rl = this.getSoilTexture()) != null) {
            return rl.toString();
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private ResourceLocation getSoilTexture() {
        FluidStack fs;
        ResourceLocation rl;
        ResourceLocation resourceLocation = rl = this.curPlantHandler != null ? this.curPlantHandler.getSoilTexture((ItemStack)this.inventory.get(1), (ItemStack)this.inventory.get(0), this) : null;
        if (rl == null) {
            rl = BelljarHandler.getSoilTexture((ItemStack)this.inventory.get(0));
        }
        if (rl == null) {
            try {
                IBlockState state = Utils.getStateFromItemStack((ItemStack)this.inventory.get(0));
                if (state != null) {
                    rl = ClientUtils.getSideTexture(state, EnumFacing.UP);
                }
            }
            catch (Exception e) {
                rl = ClientUtils.getSideTexture((ItemStack)this.inventory.get(0), EnumFacing.UP);
            }
        }
        if (rl == null && !((ItemStack)this.inventory.get(0)).isEmpty() && Utils.isFluidRelatedItemStack((ItemStack)this.inventory.get(0)) && (fs = FluidUtil.getFluidContained((ItemStack)((ItemStack)this.inventory.get(0)))) != null) {
            rl = fs.getFluid().getStill(fs);
        }
        return rl;
    }

    @Override
    @Nonnull
    public FluxStorage getFluxStorage() {
        TileEntity te;
        if (this.dummy != 0 && (te = this.world.getTileEntity(this.getPos().down(this.dummy))) instanceof TileEntityBelljar) {
            return ((TileEntityBelljar)te).energyStorage;
        }
        return this.energyStorage;
    }

    @Override
    @Nonnull
    public IEEnums.SideConfig getEnergySideConfig(@Nullable EnumFacing facing) {
        return facing == null || this.dummy == 0 && facing.getAxis() == this.facing.rotateY().getAxis() || this.dummy == 2 && facing == EnumFacing.UP ? IEEnums.SideConfig.INPUT : IEEnums.SideConfig.NONE;
    }

    @Override
    public EnergyHelper.IEForgeEnergyWrapper getCapabilityWrapper(EnumFacing facing) {
        if (facing == null || this.dummy == 0 && facing.getAxis() == this.facing.rotateY().getAxis() || this.dummy == 2 && facing == EnumFacing.UP) {
            return this.energyWrapper;
        }
        return null;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderBB == null) {
            this.renderBB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 2.0, 1.0).offset(this.pos);
        }
        return this.renderBB;
    }
}

