/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.crafting.IMultiblockRecipe;
import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockMetal;
import blusunrize.immersiveengineering.common.blocks.multiblocks.MultiblockAutoWorkbench;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityAutoWorkbench
extends TileEntityMultiblockMetal<TileEntityAutoWorkbench, IMultiblockRecipe>
implements IEBlockInterfaces.IGuiTile,
ConveyorHandler.IConveyorAttachable {
    public NonNullList<ItemStack> inventory = NonNullList.withSize((int)17, (Object)ItemStack.EMPTY);
    public int selectedRecipe = -1;
    IItemHandler insertionHandler = new IEInventoryHandler(16, (IIEInventory)this, 1, true, false);

    public TileEntityAutoWorkbench() {
        super(MultiblockAutoWorkbench.instance, new int[]{2, 3, 3}, 32000, true);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.selectedRecipe = nbt.getInteger("selectedRecipe");
        if (!descPacket) {
            this.inventory = Utils.readInventory(nbt.getTagList("inventory", 10), 17);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.setInteger("selectedRecipe", this.selectedRecipe);
        nbt.setTag("inventory", (NBTBase)Utils.writeInventory(this.inventory));
    }

    @Override
    public void receiveMessageFromClient(NBTTagCompound message) {
        if (message.hasKey("recipe")) {
            this.selectedRecipe = message.getInteger("recipe");
        }
    }

    @Override
    public void update() {
        BlueprintCraftingRecipe recipe;
        super.update();
        if (this.isDummy() || this.isRSDisabled() || this.world.isRemote || this.world.getTotalWorldTime() % 16L != (long)((this.getPos().getX() ^ this.getPos().getZ()) & 0xF) || ((ItemStack)this.inventory.get(0)).isEmpty()) {
            return;
        }
        BlueprintCraftingRecipe[] recipes = BlueprintCraftingRecipe.findRecipes(ItemNBTHelper.getString((ItemStack)this.inventory.get(0), "blueprint"));
        if (recipes.length > 0 && this.selectedRecipe >= 0 && this.selectedRecipe < recipes.length && (recipe = recipes[this.selectedRecipe]) != null && !recipe.output.isEmpty()) {
            NonNullList query = NonNullList.withSize((int)16, (Object)ItemStack.EMPTY);
            for (int i = 0; i < query.size(); ++i) {
                query.set(i, this.inventory.get(i + 1));
            }
            int crafted = recipe.getMaxCrafted((NonNullList<ItemStack>)query);
            if (crafted > 0 && this.addProcessToQueue(new TileEntityMultiblockMetal.MultiblockProcessInWorld<BlueprintCraftingRecipe>(recipe, 0.78f, (NonNullList<ItemStack>)NonNullList.create()), true)) {
                this.addProcessToQueue(new TileEntityMultiblockMetal.MultiblockProcessInWorld<BlueprintCraftingRecipe>(recipe, 0.78f, recipe.consumeInputs((NonNullList<ItemStack>)query, 1)), false);
                for (int i = 0; i < query.size(); ++i) {
                    this.inventory.set(i + 1, query.get(i));
                }
                this.markDirty();
                this.markContainingBlockForUpdate(null);
            }
        }
    }

    @Override
    public float[] getBlockBounds() {
        if (this.pos < 10 || this.pos == 12) {
            return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
        }
        if (this.pos >= 13 && this.pos <= 16) {
            return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f};
        }
        float xMin = 0.0f;
        float yMin = 0.0f;
        float zMin = 0.0f;
        float xMax = 1.0f;
        float yMax = 1.0f;
        float zMax = 1.0f;
        if (this.pos == 10 || this.pos == 11) {
            yMax = 0.8125f;
            if (this.facing == EnumFacing.NORTH) {
                zMin = 0.1875f;
                if (this.pos == 11) {
                    xMax = 0.875f;
                }
            } else if (this.facing == EnumFacing.SOUTH) {
                zMax = 0.8125f;
                if (this.pos == 11) {
                    xMin = 0.125f;
                }
            } else if (this.facing == EnumFacing.WEST) {
                xMin = 0.1875f;
                if (this.pos == 11) {
                    zMin = 0.125f;
                }
            } else if (this.facing == EnumFacing.EAST) {
                xMax = 0.8125f;
                if (this.pos == 11) {
                    zMax = 0.875f;
                }
            }
        }
        if (this.pos == 17) {
            yMax = 0.3125f;
            if (this.facing == EnumFacing.NORTH) {
                zMin = 0.25f;
                xMax = 0.875f;
            } else if (this.facing == EnumFacing.SOUTH) {
                zMax = 0.75f;
                xMin = 0.125f;
            } else if (this.facing == EnumFacing.WEST) {
                xMin = 0.25f;
                zMin = 0.125f;
            } else if (this.facing == EnumFacing.EAST) {
                xMax = 0.75f;
                zMax = 0.875f;
            }
        }
        return new float[]{xMin, yMin, zMin, xMax, yMax, zMax};
    }

    @Override
    public int[] getEnergyPos() {
        return new int[]{9};
    }

    @Override
    public int[] getRedstonePos() {
        return new int[]{1};
    }

    @Override
    public boolean isInWorldProcessingMachine() {
        return true;
    }

    @Override
    public boolean additionalCanProcessCheck(TileEntityMultiblockMetal.MultiblockProcess<IMultiblockRecipe> process) {
        return true;
    }

    @Override
    public void doProcessOutput(ItemStack output) {
        EnumFacing outDir = this.mirrored ? this.facing.rotateYCCW() : this.facing.rotateY();
        BlockPos pos = this.getPos().offset(outDir, 2);
        TileEntity inventoryTile = this.world.getTileEntity(pos);
        if (inventoryTile != null) {
            output = Utils.insertStackIntoInventory(inventoryTile, output, outDir.getOpposite());
        }
        if (!output.isEmpty()) {
            Utils.dropStackAtPos(this.world, pos, output, outDir);
        }
    }

    @Override
    public void doProcessFluidOutput(FluidStack output) {
    }

    @Override
    public void onProcessFinish(TileEntityMultiblockMetal.MultiblockProcess<IMultiblockRecipe> process) {
    }

    @Override
    public int getMaxProcessPerTick() {
        return 3;
    }

    @Override
    public int getProcessQueueMaxLength() {
        return 3;
    }

    @Override
    public float getMinProcessDistance(TileEntityMultiblockMetal.MultiblockProcess<IMultiblockRecipe> process) {
        return 0.4375f;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public int[] getOutputSlots() {
        return null;
    }

    @Override
    public int[] getOutputTanks() {
        return new int[0];
    }

    @Override
    public IFluidTank[] getInternalTanks() {
        return null;
    }

    @Override
    public void doGraphicalUpdates(int slot) {
        this.markDirty();
        this.markContainingBlockForUpdate(null);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (this.pos == 9 && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.master() != null;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (this.pos == 9 && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            TileEntityAutoWorkbench master = (TileEntityAutoWorkbench)this.master();
            if (master == null) {
                return null;
            }
            return (T)master.insertionHandler;
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public IMultiblockRecipe findRecipeForInsertion(ItemStack inserting) {
        return null;
    }

    @Override
    protected IMultiblockRecipe readRecipeFromNBT(NBTTagCompound tag) {
        return BlueprintCraftingRecipe.loadFromNBT(tag);
    }

    @Override
    public boolean canOpenGui() {
        return this.formed;
    }

    @Override
    public int getGuiID() {
        return 11;
    }

    @Override
    public TileEntity getGuiMaster() {
        return this.master();
    }

    @Override
    protected IFluidTank[] getAccessibleFluidTanks(EnumFacing side) {
        return new FluidTank[0];
    }

    @Override
    protected boolean canFillTankFrom(int iTank, EnumFacing side, FluidStack resource) {
        return true;
    }

    @Override
    protected boolean canDrainTankFrom(int iTank, EnumFacing side) {
        return true;
    }

    @Override
    public EnumFacing[] sigOutputDirections() {
        if (this.pos == 14) {
            return new EnumFacing[]{this.facing.rotateY()};
        }
        return new EnumFacing[0];
    }
}

