/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.crafting.IMultiblockRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.api.tool.AssemblerHandler;
import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityConveyorBelt;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockMetal;
import blusunrize.immersiveengineering.common.blocks.multiblocks.MultiblockAssembler;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityAssembler
extends TileEntityMultiblockMetal<TileEntityAssembler, IMultiblockRecipe>
implements IEBlockInterfaces.IGuiTile,
ConveyorHandler.IConveyorAttachable {
    public boolean[] computerOn = new boolean[3];
    public FluidTank[] tanks = new FluidTank[]{new FluidTank(8000), new FluidTank(8000), new FluidTank(8000)};
    public NonNullList<ItemStack> inventory = NonNullList.withSize((int)21, (Object)ItemStack.EMPTY);
    public CrafterPatternInventory[] patterns = new CrafterPatternInventory[]{new CrafterPatternInventory(this), new CrafterPatternInventory(this), new CrafterPatternInventory(this)};
    public boolean recursiveIngredients = false;
    IItemHandler insertionHandler = new IEInventoryHandler(18, (IIEInventory)this, 0, true, false);
    IItemHandler extractionHandler = new IEInventoryHandler(3, (IIEInventory)this, 18, false, true);

    public TileEntityAssembler() {
        super(MultiblockAssembler.instance, new int[]{3, 3, 3}, 32000, true);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.tanks[0].readFromNBT(nbt.getCompoundTag("tank0"));
        this.tanks[1].readFromNBT(nbt.getCompoundTag("tank1"));
        this.tanks[2].readFromNBT(nbt.getCompoundTag("tank2"));
        this.recursiveIngredients = nbt.getBoolean("recursiveIngredients");
        if (!descPacket) {
            this.inventory = Utils.readInventory(nbt.getTagList("inventory", 10), 21);
            for (int iPattern = 0; iPattern < this.patterns.length; ++iPattern) {
                NBTTagList patternList = nbt.getTagList("pattern" + iPattern, 10);
                this.patterns[iPattern] = new CrafterPatternInventory(this);
                this.patterns[iPattern].readFromNBT(patternList);
            }
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.setTag("tank0", (NBTBase)this.tanks[0].writeToNBT(new NBTTagCompound()));
        nbt.setTag("tank1", (NBTBase)this.tanks[1].writeToNBT(new NBTTagCompound()));
        nbt.setTag("tank2", (NBTBase)this.tanks[2].writeToNBT(new NBTTagCompound()));
        nbt.setBoolean("recursiveIngredients", this.recursiveIngredients);
        if (!descPacket) {
            nbt.setTag("inventory", (NBTBase)Utils.writeInventory(this.inventory));
            for (int iPattern = 0; iPattern < this.patterns.length; ++iPattern) {
                NBTTagList patternList = new NBTTagList();
                this.patterns[iPattern].writeToNBT(patternList);
                nbt.setTag("pattern" + iPattern, (NBTBase)patternList);
            }
        }
    }

    @Override
    public void receiveMessageFromClient(NBTTagCompound message) {
        block5: {
            block3: {
                int id;
                block4: {
                    if (!message.hasKey("buttonID")) break block3;
                    id = message.getInteger("buttonID");
                    if (id < 0 || id >= this.patterns.length) break block4;
                    CrafterPatternInventory pattern = this.patterns[id];
                    for (int i = 0; i < pattern.inv.size(); ++i) {
                        pattern.inv.set(i, (Object)ItemStack.EMPTY);
                    }
                    break block5;
                }
                if (id != 3) break block5;
                this.recursiveIngredients = !this.recursiveIngredients;
                break block5;
            }
            if (message.hasKey("patternSync")) {
                int r = message.getInteger("recipe");
                NBTTagList list = message.getTagList("patternSync", 10);
                CrafterPatternInventory pattern = this.patterns[r];
                for (int i = 0; i < list.tagCount(); ++i) {
                    NBTTagCompound itemTag = list.getCompoundTagAt(i);
                    pattern.inv.set(itemTag.getInteger("slot"), (Object)new ItemStack(itemTag));
                }
            }
        }
    }

    @Override
    public void update() {
        super.update();
        if (this.isDummy() || this.isRSDisabled() || this.world.isRemote || this.world.getTotalWorldTime() % 16L != (long)((this.getPos().getX() ^ this.getPos().getZ()) & 0xF)) {
            return;
        }
        boolean update = false;
        NonNullList[] outputBuffer = new NonNullList[this.patterns.length];
        for (int p = 0; p < this.patterns.length; ++p) {
            CrafterPatternInventory pattern = this.patterns[p];
            if (this.controllingComputers != 0 && !this.computerOn[p]) {
                return;
            }
            if (((ItemStack)pattern.inv.get(9)).isEmpty() || !this.canOutput((ItemStack)pattern.inv.get(9), p)) continue;
            ItemStack output = ((ItemStack)pattern.inv.get(9)).copy();
            ArrayList<ItemStack> queryList = new ArrayList<ItemStack>();
            for (NonNullList bufferedStacks : outputBuffer) {
                if (bufferedStacks == null) continue;
                for (ItemStack stack : bufferedStacks) {
                    if (stack.isEmpty()) continue;
                    queryList.add(stack.copy());
                }
            }
            for (ItemStack stack : this.inventory) {
                if (stack.isEmpty()) continue;
                queryList.add(stack.copy());
            }
            int consumed = Config.IEConfig.Machines.assembler_consumption;
            if (this.energyStorage.extractEnergy(consumed, true) != consumed || !this.hasIngredients(pattern, queryList)) continue;
            this.energyStorage.extractEnergy(consumed, false);
            NonNullList outputList = NonNullList.create();
            outputList.add((Object)output);
            AssemblerHandler.IRecipeAdapter adapter = AssemblerHandler.findAdapter(pattern.recipe);
            AssemblerHandler.RecipeQuery[] queries = adapter.getQueriedInputs(pattern.recipe, pattern.inv);
            NonNullList gridItems = NonNullList.withSize((int)9, (Object)ItemStack.EMPTY);
            for (int i = 0; i < queries.length; ++i) {
                if (queries[i] == null) continue;
                AssemblerHandler.RecipeQuery recipeQuery = queries[i];
                Optional<ItemStack> taken = Optional.absent();
                for (int j = 0; !(j >= outputBuffer.length || outputBuffer[j] != null && (taken = this.consumeItem(recipeQuery.query, recipeQuery.querySize, (NonNullList<ItemStack>)outputBuffer[j], (NonNullList<ItemStack>)outputList)).isPresent()); ++j) {
                }
                if (!taken.isPresent()) {
                    taken = this.consumeItem(recipeQuery.query, recipeQuery.querySize, this.inventory, (NonNullList<ItemStack>)outputList);
                }
                gridItems.set(i, taken.or((Object)ItemStack.EMPTY));
            }
            NonNullList remainingItems = pattern.recipe.getRemainingItems(Utils.InventoryCraftingFalse.createFilledCraftingInventory(3, 3, (NonNullList<ItemStack>)gridItems));
            for (ItemStack rem : remainingItems) {
                if (rem.isEmpty()) continue;
                outputList.add((Object)rem);
            }
            outputBuffer[p] = outputList;
            update = true;
        }
        BlockPos outputPos = this.getPos().offset(this.facing, 2);
        TileEntity inventoryTile = Utils.getExistingTileEntity(this.world, outputPos);
        for (int buffer = 0; buffer < outputBuffer.length; ++buffer) {
            if (outputBuffer[buffer] == null || outputBuffer[buffer].size() <= 0) continue;
            for (int iOutput = 0; iOutput < outputBuffer[buffer].size(); ++iOutput) {
                ItemStack output = (ItemStack)outputBuffer[buffer].get(iOutput);
                if (output.isEmpty() || output.getCount() <= 0 || !this.isRecipeIngredient(output, buffer) && inventoryTile != null && ((output = Utils.insertStackIntoInventory(inventoryTile, output, this.facing.getOpposite())).isEmpty() || output.getCount() <= 0)) continue;
                int free = -1;
                if (iOutput == 0) {
                    if (((ItemStack)this.inventory.get(18 + buffer)).isEmpty() && free < 0) {
                        free = 18 + buffer;
                    } else if (!((ItemStack)this.inventory.get(18 + buffer)).isEmpty() && OreDictionary.itemMatches((ItemStack)output, (ItemStack)((ItemStack)this.inventory.get(18 + buffer)), (boolean)true) && ((ItemStack)this.inventory.get(18 + buffer)).getCount() + output.getCount() <= ((ItemStack)this.inventory.get(18 + buffer)).getMaxStackSize()) {
                        ((ItemStack)this.inventory.get(18 + buffer)).grow(output.getCount());
                        free = -1;
                        continue;
                    }
                } else {
                    for (int i = 0; i < this.inventory.size(); ++i) {
                        if (((ItemStack)this.inventory.get(i)).isEmpty() && free < 0) {
                            free = i;
                            continue;
                        }
                        if (((ItemStack)this.inventory.get(i)).isEmpty() || !OreDictionary.itemMatches((ItemStack)output, (ItemStack)((ItemStack)this.inventory.get(i)), (boolean)true) || ((ItemStack)this.inventory.get(i)).getCount() + output.getCount() > ((ItemStack)this.inventory.get(i)).getMaxStackSize()) continue;
                        ((ItemStack)this.inventory.get(i)).grow(output.getCount());
                        free = -1;
                        break;
                    }
                }
                if (free < 0) continue;
                this.inventory.set(free, (Object)output.copy());
            }
        }
        for (int i = 0; i < 3; ++i) {
            if (this.isRecipeIngredient((ItemStack)this.inventory.get(18 + i), i) || inventoryTile == null) continue;
            this.inventory.set(18 + i, (Object)Utils.insertStackIntoInventory(inventoryTile, (ItemStack)this.inventory.get(18 + i), this.facing.getOpposite()));
        }
        if (update) {
            this.markDirty();
            this.markContainingBlockForUpdate(null);
        }
    }

    public Optional<ItemStack> consumeItem(Object query, int querySize, NonNullList<ItemStack> inventory, NonNullList<ItemStack> containerItems) {
        FluidStack fs;
        Object object = query instanceof FluidStack ? (FluidStack)query : (fs = query instanceof IngredientStack && ((IngredientStack)query).fluid != null ? ((IngredientStack)query).fluid : null);
        if (fs != null) {
            for (FluidTank tank : this.tanks) {
                if (tank.getFluid() == null || !tank.getFluid().containsFluid(fs)) continue;
                tank.drain(fs.amount, true);
                this.markDirty();
                this.markContainingBlockForUpdate(null);
                return Optional.absent();
            }
        }
        Optional ret = Optional.absent();
        for (int i = 0; i < inventory.size(); ++i) {
            if (((ItemStack)inventory.get(i)).isEmpty() || !Utils.stackMatchesObject((ItemStack)inventory.get(i), query, true)) continue;
            int taken = Math.min(querySize, ((ItemStack)inventory.get(i)).getCount());
            boolean doTake = true;
            if (doTake) {
                ret = Optional.of((Object)((ItemStack)inventory.get(i)).splitStack(taken));
                if (((ItemStack)inventory.get(i)).getCount() <= 0) {
                    inventory.set(i, (Object)ItemStack.EMPTY);
                }
            }
            if ((querySize -= taken) <= 0) break;
        }
        if (querySize <= 0) {
            return ret;
        }
        return Optional.absent();
    }

    public boolean hasIngredients(CrafterPatternInventory pattern, ArrayList<ItemStack> queryList) {
        AssemblerHandler.RecipeQuery[] queries;
        boolean match = true;
        AssemblerHandler.IRecipeAdapter adapter = AssemblerHandler.findAdapter(pattern.recipe);
        if (adapter == null) {
            return false;
        }
        for (AssemblerHandler.RecipeQuery recipeQuery : queries = adapter.getQueriedInputs(pattern.recipe, pattern.inv)) {
            FluidStack fs;
            if (recipeQuery == null || recipeQuery.query == null) continue;
            Object object = recipeQuery.query instanceof FluidStack ? (FluidStack)recipeQuery.query : (fs = recipeQuery.query instanceof IngredientStack && ((IngredientStack)recipeQuery.query).fluid != null ? ((IngredientStack)recipeQuery.query).fluid : null);
            if (fs != null) {
                boolean hasFluid = false;
                for (FluidTank tank : this.tanks) {
                    if (tank.getFluid() == null || !tank.getFluid().containsFluid(fs)) continue;
                    hasFluid = true;
                    break;
                }
                if (hasFluid) continue;
            }
            int querySize = recipeQuery.querySize;
            Iterator<ItemStack> it = queryList.iterator();
            while (it.hasNext()) {
                ItemStack next = it.next();
                if (next.isEmpty() || !Utils.stackMatchesObject(next, recipeQuery.query, true)) continue;
                int taken = Math.min(querySize, next.getCount());
                next.shrink(taken);
                if (next.getCount() <= 0) {
                    it.remove();
                }
                if ((querySize -= taken) > 0) continue;
                break;
            }
            if (querySize <= 0) continue;
            match = false;
            break;
        }
        return match;
    }

    public boolean canOutput(ItemStack output, int iPattern) {
        if (((ItemStack)this.inventory.get(18 + iPattern)).isEmpty()) {
            return true;
        }
        return OreDictionary.itemMatches((ItemStack)output, (ItemStack)((ItemStack)this.inventory.get(18 + iPattern)), (boolean)true) && Utils.compareItemNBT(output, (ItemStack)this.inventory.get(18 + iPattern)) && ((ItemStack)this.inventory.get(18 + iPattern)).getCount() + output.getCount() <= ((ItemStack)this.inventory.get(18 + iPattern)).getMaxStackSize();
    }

    public boolean isRecipeIngredient(ItemStack stack, int slot) {
        if (stack.isEmpty()) {
            return false;
        }
        if (slot - 1 < this.patterns.length || this.recursiveIngredients) {
            int p;
            int n = p = this.recursiveIngredients ? 0 : slot;
            while (p < this.patterns.length) {
                CrafterPatternInventory pattern = this.patterns[p];
                for (int i = 0; i < 9; ++i) {
                    if (((ItemStack)pattern.inv.get(i)).isEmpty()) continue;
                    if (OreDictionary.itemMatches((ItemStack)((ItemStack)pattern.inv.get(i)), (ItemStack)stack, (boolean)false)) {
                        return true;
                    }
                    if (((ItemStack)pattern.inv.get(i)).getItem() != stack.getItem() || ((ItemStack)pattern.inv.get(i)).getHasSubtypes() || !((ItemStack)pattern.inv.get(i)).isItemStackDamageable()) continue;
                    return true;
                }
                ++p;
            }
        }
        return false;
    }

    @Override
    public float[] getBlockBounds() {
        if (this.pos < 9 || this.pos == 10 || this.pos == 13 || this.pos == 16 || this.pos == 22) {
            return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
        }
        float xMin = 0.0f;
        float yMin = 0.0f;
        float zMin = 0.0f;
        float xMax = 1.0f;
        float yMax = 1.0f;
        float zMax = 1.0f;
        if (this.pos % 9 < 3 && this.facing == EnumFacing.SOUTH || this.pos % 9 >= 6 && this.facing == EnumFacing.NORTH) {
            zMin = 0.25f;
        } else if (this.pos % 9 < 3 && this.facing == EnumFacing.NORTH || this.pos % 9 >= 6 && this.facing == EnumFacing.SOUTH) {
            zMax = 0.75f;
        } else if (this.pos % 9 < 3 && this.facing == EnumFacing.EAST || this.pos % 9 >= 6 && this.facing == EnumFacing.WEST) {
            xMin = 0.25f;
        } else if (this.pos % 9 < 3 && this.facing == EnumFacing.WEST || this.pos % 9 >= 6 && this.facing == EnumFacing.EAST) {
            xMax = 0.75f;
        }
        if (this.pos % 3 == 0 && this.facing == EnumFacing.EAST || this.pos % 3 == 2 && this.facing == EnumFacing.WEST) {
            zMin = 0.1875f;
        } else if (this.pos % 3 == 0 && this.facing == EnumFacing.WEST || this.pos % 3 == 2 && this.facing == EnumFacing.EAST) {
            zMax = 0.8125f;
        } else if (this.pos % 3 == 0 && this.facing == EnumFacing.NORTH || this.pos % 3 == 2 && this.facing == EnumFacing.SOUTH) {
            xMin = 0.1875f;
        } else if (this.pos % 3 == 0 && this.facing == EnumFacing.SOUTH || this.pos % 3 == 2 && this.facing == EnumFacing.NORTH) {
            xMax = 0.8125f;
        }
        return new float[]{xMin, yMin, zMin, xMax, yMax, zMax};
    }

    @Override
    public int[] getEnergyPos() {
        return new int[]{22};
    }

    @Override
    public int[] getRedstonePos() {
        return new int[]{3, 5};
    }

    @Override
    public void replaceStructureBlock(BlockPos pos, IBlockState state, ItemStack stack, int h, int l, int w) {
        TileEntity tile;
        super.replaceStructureBlock(pos, state, stack, h, l, w);
        if (h == 1 && w == 1 && l != 1 && (tile = this.world.getTileEntity(pos)) instanceof TileEntityConveyorBelt) {
            ((TileEntityConveyorBelt)tile).setFacing(this.facing);
        }
    }

    @Override
    public boolean isInWorldProcessingMachine() {
        return false;
    }

    @Override
    public boolean additionalCanProcessCheck(TileEntityMultiblockMetal.MultiblockProcess<IMultiblockRecipe> process) {
        return false;
    }

    @Override
    public void doProcessOutput(ItemStack output) {
        BlockPos pos = this.getPos().offset(this.facing, -1);
        TileEntity inventoryTile = this.world.getTileEntity(pos);
        if (inventoryTile != null) {
            output = Utils.insertStackIntoInventory(inventoryTile, output, this.facing.getOpposite());
        }
        if (!output.isEmpty()) {
            Utils.dropStackAtPos(this.world, pos, output, this.facing);
        }
    }

    @Override
    public void doProcessFluidOutput(FluidStack output) {
    }

    @Override
    public void onProcessFinish(TileEntityMultiblockMetal.MultiblockProcess<IMultiblockRecipe> process) {
    }

    @Override
    public int getMaxProcessPerTick() {
        return 0;
    }

    @Override
    public int getProcessQueueMaxLength() {
        return 0;
    }

    @Override
    public float getMinProcessDistance(TileEntityMultiblockMetal.MultiblockProcess<IMultiblockRecipe> process) {
        return 0.0f;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public int[] getOutputSlots() {
        return new int[0];
    }

    @Override
    public int[] getOutputTanks() {
        return new int[0];
    }

    @Override
    public IFluidTank[] getInternalTanks() {
        return this.tanks;
    }

    @Override
    public void doGraphicalUpdates(int slot) {
        this.markDirty();
        this.markContainingBlockForUpdate(null);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if ((this.pos == 10 || this.pos == 16) && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (this.pos == 10 && facing == this.facing.getOpposite() || this.pos == 16 && facing == this.facing) && this.master() != null;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if ((this.pos == 10 || this.pos == 16) && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            TileEntityAssembler master = (TileEntityAssembler)this.master();
            if (master == null) {
                return null;
            }
            if (this.pos == 10 && facing == this.facing.getOpposite()) {
                return (T)master.insertionHandler;
            }
            if (this.pos == 16 && facing == this.facing) {
                return (T)master.extractionHandler;
            }
            return null;
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public IMultiblockRecipe findRecipeForInsertion(ItemStack inserting) {
        return null;
    }

    @Override
    protected IMultiblockRecipe readRecipeFromNBT(NBTTagCompound tag) {
        return null;
    }

    @Override
    public boolean canOpenGui() {
        return this.formed;
    }

    @Override
    public int getGuiID() {
        return 5;
    }

    @Override
    public TileEntity getGuiMaster() {
        return this.master();
    }

    @Override
    protected IFluidTank[] getAccessibleFluidTanks(EnumFacing side) {
        TileEntityAssembler master = (TileEntityAssembler)this.master();
        if (master != null && this.pos == 1 && (side == null || side == this.facing.getOpposite())) {
            return master.tanks;
        }
        return new FluidTank[0];
    }

    @Override
    protected boolean canFillTankFrom(int iTank, EnumFacing side, FluidStack resource) {
        return true;
    }

    @Override
    protected boolean canDrainTankFrom(int iTank, EnumFacing side) {
        return true;
    }

    @Override
    public EnumFacing[] sigOutputDirections() {
        if (this.pos == 16) {
            return new EnumFacing[]{this.facing};
        }
        return new EnumFacing[0];
    }

    public static class CrafterPatternInventory
    implements IInventory {
        public NonNullList<ItemStack> inv = NonNullList.withSize((int)10, (Object)ItemStack.EMPTY);
        public IRecipe recipe;
        final TileEntityAssembler tile;

        public CrafterPatternInventory(TileEntityAssembler tile) {
            this.tile = tile;
        }

        public int getSizeInventory() {
            return 10;
        }

        public boolean isEmpty() {
            for (ItemStack stack : this.inv) {
                if (stack.isEmpty()) continue;
                return false;
            }
            return true;
        }

        public ItemStack getStackInSlot(int slot) {
            return (ItemStack)this.inv.get(slot);
        }

        public ItemStack decrStackSize(int slot, int amount) {
            ItemStack stack = this.getStackInSlot(slot);
            if (slot < 9 && !stack.isEmpty()) {
                if (stack.getCount() <= amount) {
                    this.setInventorySlotContents(slot, ItemStack.EMPTY);
                } else if ((stack = stack.splitStack(amount)).getCount() == 0) {
                    this.setInventorySlotContents(slot, ItemStack.EMPTY);
                }
            }
            return stack;
        }

        public ItemStack removeStackFromSlot(int slot) {
            ItemStack stack = this.getStackInSlot(slot);
            if (!stack.isEmpty()) {
                this.setInventorySlotContents(slot, ItemStack.EMPTY);
            }
            return stack;
        }

        public void setInventorySlotContents(int slot, ItemStack stack) {
            if (slot < 9) {
                this.inv.set(slot, (Object)stack);
                if (!stack.isEmpty() && stack.getCount() > this.getInventoryStackLimit()) {
                    stack.setCount(this.getInventoryStackLimit());
                }
            }
            this.recalculateOutput();
        }

        public void clear() {
            for (int i = 0; i < this.inv.size(); ++i) {
                this.inv.set(i, (Object)ItemStack.EMPTY);
            }
        }

        public void recalculateOutput() {
            InventoryCrafting invC = Utils.InventoryCraftingFalse.createFilledCraftingInventory(3, 3, this.inv);
            this.recipe = Utils.findRecipe(invC, this.tile.getWorld());
            this.inv.set(9, (Object)(this.recipe != null ? this.recipe.getCraftingResult(invC) : ItemStack.EMPTY));
        }

        public ArrayList<ItemStack> getTotalPossibleOutputs() {
            ArrayList<ItemStack> outputList = new ArrayList<ItemStack>();
            outputList.add(((ItemStack)this.inv.get(9)).copy());
            for (int i = 0; i < 9; ++i) {
                FluidStack fs = FluidUtil.getFluidContained((ItemStack)((ItemStack)this.inv.get(i)));
                if (fs == null) continue;
                boolean hasFluid = false;
                for (FluidTank tank : this.tile.tanks) {
                    if (tank.getFluid() == null || !tank.getFluid().containsFluid(fs)) continue;
                    hasFluid = true;
                    break;
                }
                if (!hasFluid) continue;
            }
            InventoryCrafting invC = Utils.InventoryCraftingFalse.createFilledCraftingInventory(3, 3, this.inv);
            for (ItemStack ss : this.recipe.getRemainingItems(invC)) {
                if (ss.isEmpty()) continue;
                outputList.add(ss);
            }
            return outputList;
        }

        public String getName() {
            return "IECrafterPattern";
        }

        public boolean hasCustomName() {
            return false;
        }

        public int getInventoryStackLimit() {
            return 1;
        }

        public boolean isUsableByPlayer(EntityPlayer player) {
            return true;
        }

        public void openInventory(EntityPlayer player) {
        }

        public void closeInventory(EntityPlayer player) {
        }

        public boolean isItemValidForSlot(int slot, ItemStack stack) {
            return true;
        }

        public void markDirty() {
            this.tile.markDirty();
        }

        public void writeToNBT(NBTTagList list) {
            for (int i = 0; i < this.inv.size(); ++i) {
                if (((ItemStack)this.inv.get(i)).isEmpty()) continue;
                NBTTagCompound itemTag = new NBTTagCompound();
                itemTag.setByte("Slot", (byte)i);
                ((ItemStack)this.inv.get(i)).writeToNBT(itemTag);
                list.appendTag((NBTBase)itemTag);
            }
        }

        public void readFromNBT(NBTTagList list) {
            for (int i = 0; i < list.tagCount(); ++i) {
                NBTTagCompound itemTag = list.getCompoundTagAt(i);
                int slot = itemTag.getByte("Slot") & 0xFF;
                if (slot < 0 || slot >= this.getSizeInventory()) continue;
                this.inv.set(slot, (Object)new ItemStack(itemTag));
            }
            this.recalculateOutput();
        }

        public ITextComponent getDisplayName() {
            return new TextComponentString(this.getName());
        }

        public int getField(int id) {
            return 0;
        }

        public void setField(int id, int value) {
        }

        public int getFieldCount() {
            return 0;
        }
    }
}

