/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockMetal;
import blusunrize.immersiveengineering.common.blocks.multiblocks.MultiblockArcFurnace;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileEntityArcFurnace
extends TileEntityMultiblockMetal<TileEntityArcFurnace, ArcFurnaceRecipe>
implements IEBlockInterfaces.ISoundTile,
IEBlockInterfaces.IGuiTile,
IEBlockInterfaces.IAdvancedSelectionBounds,
IEBlockInterfaces.IAdvancedCollisionBounds {
    public NonNullList<ItemStack> inventory = NonNullList.withSize((int)26, (Object)ItemStack.EMPTY);
    @SideOnly(value=Side.CLIENT)
    private AxisAlignedBB renderAABB;
    static int[] outputSlots = new int[]{16, 17, 18, 19, 20, 21};
    IItemHandler inputHandler = new IEInventoryHandler(12, this, 0, true, false){

        @Override
        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (stack.isEmpty()) {
                return stack;
            }
            stack = stack.copy();
            ArrayList<Integer> possibleSlots = new ArrayList<Integer>(12);
            for (int i = 0; i < 12; ++i) {
                ItemStack here = (ItemStack)TileEntityArcFurnace.this.inventory.get(i);
                if (here.isEmpty()) {
                    if (!simulate) {
                        TileEntityArcFurnace.this.inventory.set(i, (Object)stack);
                    }
                    return ItemStack.EMPTY;
                }
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)here) || here.getCount() >= here.getMaxStackSize()) continue;
                possibleSlots.add(i);
            }
            Collections.sort(possibleSlots, (a, b) -> Integer.compare(((ItemStack)TileEntityArcFurnace.this.inventory.get(a.intValue())).getCount(), ((ItemStack)TileEntityArcFurnace.this.inventory.get(b.intValue())).getCount()));
            Iterator iterator = possibleSlots.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                ItemStack here = (ItemStack)TileEntityArcFurnace.this.inventory.get(i);
                int fillCount = Math.min(here.getMaxStackSize() - here.getCount(), stack.getCount());
                if (!simulate) {
                    here.grow(fillCount);
                }
                stack.shrink(fillCount);
                if (!stack.isEmpty()) continue;
                return ItemStack.EMPTY;
            }
            return stack;
        }
    };
    IItemHandler additiveHandler = new IEInventoryHandler(4, (IIEInventory)this, 12, true, false);
    IItemHandler outputHandler = new IEInventoryHandler(6, (IIEInventory)this, 16, false, true);
    IItemHandler slagHandler = new IEInventoryHandler(1, (IIEInventory)this, 22, false, true);

    public TileEntityArcFurnace() {
        super(MultiblockArcFurnace.instance, new int[]{5, 5, 5}, 64000, true);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        if (!descPacket) {
            this.inventory = Utils.readInventory(nbt.getTagList("inventory", 10), 26);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        if (!descPacket) {
            nbt.setTag("inventory", (NBTBase)Utils.writeInventory(this.inventory));
        }
    }

    @Override
    public void update() {
        super.update();
        if (!(this.world.isRemote || this.isDummy() || this.isRSDisabled() || this.energyStorage.getEnergyStored() <= 0)) {
            ItemStack stack;
            if (this.tickedProcesses > 0) {
                for (int i = 23; i < 26; ++i) {
                    if (!((ItemStack)this.inventory.get(i)).attemptDamageItem(1, Utils.RAND, null)) continue;
                    this.inventory.set(i, (Object)ItemStack.EMPTY);
                }
            }
            if (this.processQueue.size() < this.getProcessQueueMaxLength()) {
                HashSet<Integer> usedInvSlots = new HashSet<Integer>();
                for (TileEntityMultiblockMetal.MultiblockProcess process : this.processQueue) {
                    if (!(process instanceof TileEntityMultiblockMetal.MultiblockProcessInMachine)) continue;
                    for (int i : ((TileEntityMultiblockMetal.MultiblockProcessInMachine)process).inputSlots) {
                        usedInvSlots.add(i);
                    }
                }
                NonNullList additives = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
                for (int i = 0; i < 4; ++i) {
                    additives.set(i, (Object)(!((ItemStack)this.inventory.get(12 + i)).isEmpty() ? ((ItemStack)this.inventory.get(12 + i)).copy() : ItemStack.EMPTY));
                }
                for (int slot = 0; slot < 12; ++slot) {
                    MultiblockProcessArcFurnace process;
                    ArcFurnaceRecipe recipe;
                    if (usedInvSlots.contains(slot) || (stack = (ItemStack)this.getInventory().get(slot)).isEmpty() || stack.getCount() <= 0 || (recipe = ArcFurnaceRecipe.findRecipe(stack, (NonNullList<ItemStack>)additives)) == null || !this.addProcessToQueue(process = new MultiblockProcessArcFurnace(recipe, slot, 12, 13, 14, 15), true)) continue;
                    this.addProcessToQueue(process, false);
                    usedInvSlots.add(slot);
                }
            }
            if (this.world.getTotalWorldTime() % 8L == 0L) {
                BlockPos outputPos = this.getBlockPosForPos(2).offset(this.facing, -1);
                TileEntity outputTile = Utils.getExistingTileEntity(this.world, outputPos);
                if (outputTile != null) {
                    for (int j = 16; j < 22; ++j) {
                        if (((ItemStack)this.inventory.get(j)).isEmpty()) continue;
                        stack = Utils.copyStackWithAmount((ItemStack)this.inventory.get(j), 1);
                        if (!(stack = Utils.insertStackIntoInventory(outputTile, stack, this.facing.getOpposite())).isEmpty()) continue;
                        ((ItemStack)this.inventory.get(j)).shrink(1);
                        if (((ItemStack)this.inventory.get(j)).getCount() > 0) continue;
                        this.inventory.set(j, (Object)ItemStack.EMPTY);
                    }
                }
                if ((outputTile = Utils.getExistingTileEntity(this.world, outputPos = this.getBlockPosForPos(22).offset(this.facing))) != null && !((ItemStack)this.inventory.get(22)).isEmpty()) {
                    int out = Math.min(((ItemStack)this.inventory.get(22)).getCount(), 16);
                    stack = Utils.copyStackWithAmount((ItemStack)this.inventory.get(22), out);
                    if (!(stack = Utils.insertStackIntoInventory(outputTile, stack, this.facing)).isEmpty()) {
                        out -= stack.getCount();
                    }
                    ((ItemStack)this.inventory.get(22)).shrink(out);
                    if (((ItemStack)this.inventory.get(22)).getCount() <= 0) {
                        this.inventory.set(22, (Object)ItemStack.EMPTY);
                    }
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)(this.getPos().getX() - (this.facing.getAxis() == EnumFacing.Axis.Z ? 2 : 1)), (double)this.getPos().getY(), (double)(this.getPos().getZ() - (this.facing.getAxis() == EnumFacing.Axis.X ? 2 : 1)), (double)(this.getPos().getX() + (this.facing.getAxis() == EnumFacing.Axis.Z ? 3 : 2)), (double)(this.getPos().getY() + 3), (double)(this.getPos().getZ() + (this.facing.getAxis() == EnumFacing.Axis.X ? 3 : 2)));
    }

    @SideOnly(value=Side.CLIENT)
    public double getMaxRenderDistanceSquared() {
        return super.getMaxRenderDistanceSquared() * Config.IEConfig.increasedTileRenderdistance;
    }

    @Override
    public float[] getBlockBounds() {
        if (this.pos == 1 || this.pos == 3) {
            return new float[]{this.facing == EnumFacing.EAST ? 0.4375f : 0.0f, 0.0f, this.facing == EnumFacing.SOUTH ? 0.4375f : 0.0f, this.facing == EnumFacing.WEST ? 0.5625f : 1.0f, 0.5f, this.facing == EnumFacing.NORTH ? 0.5625f : 1.0f};
        }
        if (this.pos < 20 && this.pos != 2) {
            return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f};
        }
        if (this.pos == 25) {
            return new float[]{this.facing == EnumFacing.WEST ? 0.5f : 0.0f, 0.0f, this.facing == EnumFacing.NORTH ? 0.5f : 0.0f, this.facing == EnumFacing.EAST ? 0.5f : 1.0f, 1.0f, this.facing == EnumFacing.SOUTH ? 0.5f : 1.0f};
        }
        if (this.pos >= 36 && this.pos <= 38 || this.pos >= 41 && this.pos <= 43) {
            float maxZ;
            EnumFacing fw = this.facing.rotateY();
            if (this.mirrored | this.pos % 5 == 3) {
                fw = fw.getOpposite();
            }
            if (this.pos % 5 == 2) {
                fw = null;
            }
            float minX = fw == EnumFacing.EAST ? 0.125f : 0.0f;
            float maxX = fw == EnumFacing.WEST ? 0.875f : 1.0f;
            float minZ = fw == EnumFacing.SOUTH ? 0.125f : 0.0f;
            float f = maxZ = fw == EnumFacing.NORTH ? 0.875f : 1.0f;
            if (this.pos <= 38) {
                minX -= this.facing == EnumFacing.EAST ? 0.875f : 0.0f;
                maxX += this.facing == EnumFacing.WEST ? 0.875f : 0.0f;
                minZ -= this.facing == EnumFacing.SOUTH ? 0.875f : 0.0f;
                maxZ += this.facing == EnumFacing.NORTH ? 0.875f : 0.0f;
            }
            return new float[]{minX, 0.5f, minZ, maxX, 1.0f, maxZ};
        }
        if (this.pos == 40 || this.pos == 44) {
            EnumFacing fl = this.pos == 44 ? this.facing.getOpposite() : this.facing;
            float[] fArray = new float[6];
            fArray[0] = fl == EnumFacing.NORTH ? 0.125f : (fl == EnumFacing.SOUTH ? 0.625f : 0.0f);
            fArray[1] = 0.125f;
            float f = fl == EnumFacing.EAST ? 0.125f : (fArray[2] = fl == EnumFacing.WEST ? 0.625f : 0.0f);
            fArray[3] = fl == EnumFacing.SOUTH ? 0.875f : (fl == EnumFacing.NORTH ? 0.375f : 1.0f);
            fArray[4] = 0.375f;
            fArray[5] = fl == EnumFacing.WEST ? 0.875f : (fl == EnumFacing.EAST ? 0.375f : 1.0f);
            return fArray;
        }
        if (this.pos >= 46 && this.pos <= 48) {
            return new float[]{this.facing == EnumFacing.WEST ? 0.25f : 0.0f, 0.0f, this.facing == EnumFacing.NORTH ? 0.25f : 0.0f, this.facing == EnumFacing.EAST ? 0.75f : 1.0f, 1.0f, this.facing == EnumFacing.SOUTH ? 0.75f : 1.0f};
        }
        if (this.pos == 97) {
            return new float[]{this.facing.getAxis() == EnumFacing.Axis.X ? 0.375f : 0.0f, 0.0f, this.facing.getAxis() == EnumFacing.Axis.Z ? 0.375f : 0.0f, this.facing.getAxis() == EnumFacing.Axis.X ? 0.625f : 1.0f, 1.0f, this.facing.getAxis() == EnumFacing.Axis.Z ? 0.625f : 1.0f};
        }
        if (this.pos == 122) {
            return new float[]{this.facing == EnumFacing.WEST ? 0.3125f : 0.0f, 0.0f, this.facing == EnumFacing.NORTH ? 0.3125f : 0.0f, this.facing == EnumFacing.EAST ? 0.6875f : 1.0f, 0.9375f, this.facing == EnumFacing.SOUTH ? 0.6875f : 1.0f};
        }
        if (this.pos == 117) {
            return new float[]{0.0f, 0.625f, 0.0f, 1.0f, 0.9375f, 1.0f};
        }
        if (this.pos == 112) {
            return new float[]{this.facing == EnumFacing.EAST ? 0.125f : 0.0f, 0.0f, this.facing == EnumFacing.SOUTH ? 0.125f : 0.0f, this.facing == EnumFacing.WEST ? 0.875f : 1.0f, 0.9375f, this.facing == EnumFacing.NORTH ? 0.875f : 1.0f};
        }
        if (this.pos == 51 || this.pos == 53 || this.pos == 96 || this.pos == 98 || this.pos == 121 || this.pos == 123) {
            EnumFacing fw = this.facing.rotateY();
            if (this.mirrored ^ this.pos % 5 == 3) {
                fw = fw.getOpposite();
            }
            return new float[]{fw == EnumFacing.EAST ? 0.5f : 0.0f, 0.0f, fw == EnumFacing.SOUTH ? 0.5f : 0.0f, fw == EnumFacing.WEST ? 0.5f : 1.0f, 1.0f, fw == EnumFacing.NORTH ? 0.5f : 1.0f};
        }
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    @Override
    public List<AxisAlignedBB> getAdvancedSelectionBounds() {
        if (this.pos % 15 == 7) {
            return null;
        }
        EnumFacing fl = this.facing;
        EnumFacing fw = this.facing.rotateY();
        if (this.mirrored) {
            fw = fw.getOpposite();
        }
        if (this.pos == 0) {
            float minZ;
            float maxX;
            float minX;
            ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ())});
            float f = fl == EnumFacing.WEST ? 0.625f : (minX = fl == EnumFacing.EAST ? 0.125f : 0.125f);
            float f2 = fl == EnumFacing.EAST ? 0.375f : (maxX = fl == EnumFacing.WEST ? 0.875f : 0.25f);
            float f3 = fl == EnumFacing.NORTH ? 0.625f : (minZ = fl == EnumFacing.SOUTH ? 0.125f : 0.125f);
            float maxZ = fl == EnumFacing.SOUTH ? 0.375f : (fl == EnumFacing.NORTH ? 0.875f : 0.25f);
            list.add(new AxisAlignedBB((double)minX, 0.5, (double)minZ, (double)maxX, 1.0, (double)maxZ).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ()));
            float f4 = fl == EnumFacing.WEST ? 0.625f : (minX = fl == EnumFacing.EAST ? 0.125f : 0.75f);
            float f5 = fl == EnumFacing.EAST ? 0.375f : (maxX = fl == EnumFacing.WEST ? 0.875f : 0.875f);
            float f6 = fl == EnumFacing.NORTH ? 0.625f : (minZ = fl == EnumFacing.SOUTH ? 0.125f : 0.75f);
            maxZ = fl == EnumFacing.SOUTH ? 0.375f : (fl == EnumFacing.NORTH ? 0.875f : 0.875f);
            list.add(new AxisAlignedBB((double)minX, 0.5, (double)minZ, (double)maxX, 1.0, (double)maxZ).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ()));
            return list;
        }
        if (this.pos >= 46 && this.pos <= 48) {
            float minX = fl == EnumFacing.WEST ? 0.25f : 0.0f;
            float maxX = fl == EnumFacing.EAST ? 0.75f : 1.0f;
            float minZ = fl == EnumFacing.NORTH ? 0.25f : 0.0f;
            float maxZ = fl == EnumFacing.SOUTH ? 0.75f : 1.0f;
            ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB((double)minX, 0.0, (double)minZ, (double)maxX, 1.0, (double)maxZ).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ())});
            float f = fl == EnumFacing.WEST ? 0.0f : (minX = fl == EnumFacing.EAST ? 0.75f : 0.25f);
            float f7 = fl == EnumFacing.EAST ? 1.0f : (maxX = fl == EnumFacing.WEST ? 0.25f : 0.75f);
            float f8 = fl == EnumFacing.NORTH ? 0.0f : (minZ = fl == EnumFacing.SOUTH ? 0.75f : 0.25f);
            maxZ = fl == EnumFacing.SOUTH ? 1.0f : (fl == EnumFacing.NORTH ? 0.25f : 0.75f);
            list.add(new AxisAlignedBB((double)minX, 0.25, (double)minZ, (double)maxX, 0.75, (double)maxZ).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ()));
            return list;
        }
        if (this.pos % 25 >= 10 && (this.pos % 5 == 0 || this.pos % 5 == 4)) {
            float maxZ;
            ArrayList list;
            ArrayList arrayList = list = this.pos < 25 ? Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ())}) : new ArrayList(2);
            if (this.pos % 5 == 4) {
                fw = fw.getOpposite();
            }
            float minX = fw == EnumFacing.EAST ? 0.5f : 0.0f;
            float maxX = fw == EnumFacing.WEST ? 0.5f : 1.0f;
            float minZ = fw == EnumFacing.SOUTH ? 0.5f : 0.0f;
            float f = maxZ = fw == EnumFacing.NORTH ? 0.5f : 1.0f;
            if (this.pos % 25 / 5 != 3) {
                list.add(new AxisAlignedBB((double)minX, this.pos < 25 ? 0.5 : 0.0, (double)minZ, (double)maxX, 1.0, (double)maxZ).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ()));
            }
            if (this.pos < 25) {
                float f9 = fw == EnumFacing.EAST ? 0.125f : (fw == EnumFacing.WEST ? 0.625f : (minX = fl == EnumFacing.EAST ? 0.375f : -1.625f));
                float f10 = fw == EnumFacing.EAST ? 0.375f : (fw == EnumFacing.WEST ? 0.875f : (maxX = fl == EnumFacing.WEST ? 0.625f : 2.625f));
                float f11 = fw == EnumFacing.SOUTH ? 0.125f : (fw == EnumFacing.NORTH ? 0.625f : (minZ = fl == EnumFacing.SOUTH ? 0.375f : -1.625f));
                maxZ = fw == EnumFacing.SOUTH ? 0.375f : (fw == EnumFacing.NORTH ? 0.875f : (fl == EnumFacing.NORTH ? 0.625f : 2.625f));
                AxisAlignedBB aabb = new AxisAlignedBB((double)minX, 0.6875, (double)minZ, (double)maxX, 0.9375, (double)maxZ).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ());
                aabb = aabb.offset((double)(-fl.getFrontOffsetX() * (this.pos % 25 - 10) / 5), 0.0, (double)(-fl.getFrontOffsetZ() * (this.pos % 25 - 10) / 5));
                list.add(aabb);
                float f12 = fw == EnumFacing.EAST ? 0.375f : (fw == EnumFacing.WEST ? 0.5f : (minX = fl == EnumFacing.EAST ? 0.375f : 0.375f));
                float f13 = fw == EnumFacing.EAST ? 0.5f : (fw == EnumFacing.WEST ? 0.625f : (maxX = fl == EnumFacing.WEST ? 0.625f : 0.625f));
                float f14 = fw == EnumFacing.SOUTH ? 0.375f : (fw == EnumFacing.NORTH ? 0.5f : (minZ = fl == EnumFacing.SOUTH ? 0.375f : 0.375f));
                maxZ = fw == EnumFacing.SOUTH ? 0.5f : (fw == EnumFacing.NORTH ? 0.625f : (fl == EnumFacing.NORTH ? 0.625f : 0.625f));
                aabb = new AxisAlignedBB((double)minX, 0.6875, (double)minZ, (double)maxX, 0.9375, (double)maxZ).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ());
                aabb = aabb.offset((double)(-fl.getFrontOffsetX() * (this.pos % 25 - 10) / 5), 0.0, (double)(-fl.getFrontOffsetZ() * (this.pos % 25 - 10) / 5));
                list.add(aabb);
                float f15 = fw == EnumFacing.EAST ? 0.375f : (fw == EnumFacing.WEST ? 0.5f : (minX = fl == EnumFacing.EAST ? 2.375f : -1.625f));
                float f16 = fw == EnumFacing.EAST ? 0.5f : (fw == EnumFacing.WEST ? 0.625f : (maxX = fl == EnumFacing.WEST ? -1.375f : 2.625f));
                float f17 = fw == EnumFacing.SOUTH ? 0.375f : (fw == EnumFacing.NORTH ? 0.5f : (minZ = fl == EnumFacing.SOUTH ? 2.375f : -1.625f));
                maxZ = fw == EnumFacing.SOUTH ? 0.5f : (fw == EnumFacing.NORTH ? 0.625f : (fl == EnumFacing.NORTH ? -1.375f : 2.625f));
                aabb = new AxisAlignedBB((double)minX, 0.6875, (double)minZ, (double)maxX, 0.9375, (double)maxZ).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ());
                aabb = aabb.offset((double)(-fl.getFrontOffsetX() * (this.pos % 25 - 10) / 5), 0.0, (double)(-fl.getFrontOffsetZ() * (this.pos % 25 - 10) / 5));
                list.add(aabb);
            } else if (this.pos < 50) {
                float f18 = fw == EnumFacing.EAST ? 0.125f : (fw == EnumFacing.WEST ? 0.625f : (minX = fl == EnumFacing.EAST ? 0.375f : -1.625f));
                float f19 = fw == EnumFacing.EAST ? 0.375f : (fw == EnumFacing.WEST ? 0.875f : (maxX = fl == EnumFacing.WEST ? 0.625f : 2.625f));
                float f20 = fw == EnumFacing.SOUTH ? 0.125f : (fw == EnumFacing.NORTH ? 0.625f : (minZ = fl == EnumFacing.SOUTH ? 0.375f : -1.625f));
                maxZ = fw == EnumFacing.SOUTH ? 0.375f : (fw == EnumFacing.NORTH ? 0.875f : (fl == EnumFacing.NORTH ? 0.625f : 2.625f));
                AxisAlignedBB aabb = new AxisAlignedBB((double)minX, 0.125, (double)minZ, (double)maxX, 0.375, (double)maxZ).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ());
                aabb = aabb.offset((double)(-fl.getFrontOffsetX() * (this.pos % 25 - 10) / 5), 0.0, (double)(-fl.getFrontOffsetZ() * (this.pos % 25 - 10) / 5));
                list.add(aabb);
                float f21 = fw == EnumFacing.EAST ? 0.375f : (fw == EnumFacing.WEST ? 0.5f : (minX = fl == EnumFacing.EAST ? 0.375f : 0.375f));
                float f22 = fw == EnumFacing.EAST ? 0.5f : (fw == EnumFacing.WEST ? 0.625f : (maxX = fl == EnumFacing.WEST ? 0.625f : 0.625f));
                float f23 = fw == EnumFacing.SOUTH ? 0.375f : (fw == EnumFacing.NORTH ? 0.5f : (minZ = fl == EnumFacing.SOUTH ? 0.375f : 0.375f));
                maxZ = fw == EnumFacing.SOUTH ? 0.5f : (fw == EnumFacing.NORTH ? 0.625f : (fl == EnumFacing.NORTH ? 0.625f : 0.625f));
                aabb = new AxisAlignedBB((double)minX, 0.125, (double)minZ, (double)maxX, 0.375, (double)maxZ).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ());
                aabb = aabb.offset((double)(-fl.getFrontOffsetX() * (this.pos % 25 - 10) / 5), 0.0, (double)(-fl.getFrontOffsetZ() * (this.pos % 25 - 10) / 5));
                if (this.pos % 5 == 0) {
                    aabb = aabb.offset(0.0, 0.6875, 0.0);
                }
                list.add(aabb);
                if (this.pos % 5 == 0) {
                    float f24 = fw == EnumFacing.EAST ? 0.125f : (fw == EnumFacing.WEST ? 0.625f : (minX = fl == EnumFacing.EAST ? 0.375f : 0.375f));
                    float f25 = fw == EnumFacing.EAST ? 0.375f : (fw == EnumFacing.WEST ? 0.875f : (maxX = fl == EnumFacing.WEST ? 0.625f : 0.625f));
                    float f26 = fw == EnumFacing.SOUTH ? 0.125f : (fw == EnumFacing.NORTH ? 0.625f : (minZ = fl == EnumFacing.SOUTH ? 0.375f : 0.375f));
                    maxZ = fw == EnumFacing.SOUTH ? 0.375f : (fw == EnumFacing.NORTH ? 0.875f : (fl == EnumFacing.NORTH ? 0.625f : 0.625f));
                    aabb = new AxisAlignedBB((double)minX, 0.375, (double)minZ, (double)maxX, 1.0625, (double)maxZ).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ());
                    aabb = aabb.offset((double)(-fl.getFrontOffsetX() * (this.pos % 25 - 10) / 5), 0.0, (double)(-fl.getFrontOffsetZ() * (this.pos % 25 - 10) / 5));
                    list.add(aabb);
                }
                float f27 = fw == EnumFacing.EAST ? 0.375f : (fw == EnumFacing.WEST ? 0.5f : (minX = fl == EnumFacing.EAST ? 2.375f : -1.625f));
                float f28 = fw == EnumFacing.EAST ? 0.5f : (fw == EnumFacing.WEST ? 0.625f : (maxX = fl == EnumFacing.WEST ? -1.375f : 2.625f));
                float f29 = fw == EnumFacing.SOUTH ? 0.375f : (fw == EnumFacing.NORTH ? 0.5f : (minZ = fl == EnumFacing.SOUTH ? 2.375f : -1.625f));
                maxZ = fw == EnumFacing.SOUTH ? 0.5f : (fw == EnumFacing.NORTH ? 0.625f : (fl == EnumFacing.NORTH ? -1.375f : 2.625f));
                aabb = new AxisAlignedBB((double)minX, 0.125, (double)minZ, (double)maxX, 0.375, (double)maxZ).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ());
                aabb = aabb.offset((double)(-fl.getFrontOffsetX() * (this.pos % 25 - 10) / 5), 0.0, (double)(-fl.getFrontOffsetZ() * (this.pos % 25 - 10) / 5));
                list.add(aabb);
            } else if (this.pos == 60 || this.pos == 64) {
                float f30 = fw == EnumFacing.EAST ? 0.375f : (minX = fw == EnumFacing.WEST ? 0.5f : 0.25f);
                float f31 = fw == EnumFacing.EAST ? 0.5f : (maxX = fw == EnumFacing.WEST ? 0.625f : 0.75f);
                float f32 = fw == EnumFacing.SOUTH ? 0.375f : (minZ = fw == EnumFacing.NORTH ? 0.5f : 0.25f);
                maxZ = fw == EnumFacing.SOUTH ? 0.5f : (fw == EnumFacing.NORTH ? 0.625f : 0.75f);
                list.add(new AxisAlignedBB((double)minX, 0.25, (double)minZ, (double)maxX, 0.75, (double)maxZ).offset((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ()));
            }
            return list;
        }
        return null;
    }

    @Override
    public boolean isOverrideBox(AxisAlignedBB box, EntityPlayer player, RayTraceResult mop, ArrayList<AxisAlignedBB> list) {
        return false;
    }

    @Override
    public List<AxisAlignedBB> getAdvancedColisionBounds() {
        return this.getAdvancedSelectionBounds();
    }

    @Override
    public int[] getEnergyPos() {
        return new int[]{46, 47, 48};
    }

    @Override
    public int[] getRedstonePos() {
        return new int[]{25};
    }

    @Override
    public int getComparatorInputOverride() {
        TileEntityArcFurnace master;
        if (this.pos == 112 && (master = (TileEntityArcFurnace)this.master()) != null) {
            float f = 0.0f;
            for (int i = 23; i < 26; ++i) {
                if (((ItemStack)master.inventory.get(i)).isEmpty()) continue;
                f += 1.0f - (float)((ItemStack)master.inventory.get(i)).getItemDamage() / (float)((ItemStack)master.inventory.get(i)).getMaxDamage();
            }
            return MathHelper.floor((float)(Math.max(f / 3.0f, 0.0f) * 15.0f));
        }
        return super.getComparatorInputOverride();
    }

    @Override
    public boolean isInWorldProcessingMachine() {
        return false;
    }

    @Override
    public boolean shouldRenderAsActive() {
        return this.hasElectrodes() && super.shouldRenderAsActive();
    }

    @Override
    public boolean additionalCanProcessCheck(TileEntityMultiblockMetal.MultiblockProcess<ArcFurnaceRecipe> process) {
        if (!this.hasElectrodes()) {
            return false;
        }
        if (process.recipe != null && !((ArcFurnaceRecipe)process.recipe).slag.isEmpty()) {
            if (((ItemStack)this.inventory.get(22)).isEmpty()) {
                return true;
            }
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)((ItemStack)this.inventory.get(22)), (ItemStack)((ArcFurnaceRecipe)process.recipe).slag) || ((ItemStack)this.inventory.get(22)).getCount() + ((ArcFurnaceRecipe)process.recipe).slag.getCount() > this.getSlotLimit(22)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void doProcessOutput(ItemStack output) {
        BlockPos pos = this.getPos().add(0, -1, 0).offset(this.facing, -2);
        TileEntity inventoryTile = this.world.getTileEntity(pos);
        if (inventoryTile != null) {
            output = Utils.insertStackIntoInventory(inventoryTile, output, this.facing.getOpposite());
        }
        if (!output.isEmpty()) {
            Utils.dropStackAtPos(this.world, pos, output, this.facing);
        }
    }

    @Override
    public void doProcessFluidOutput(FluidStack output) {
    }

    @Override
    public void onProcessFinish(TileEntityMultiblockMetal.MultiblockProcess<ArcFurnaceRecipe> process) {
        if (!((ArcFurnaceRecipe)process.recipe).slag.isEmpty()) {
            if (((ItemStack)this.inventory.get(22)).isEmpty()) {
                this.inventory.set(22, (Object)((ArcFurnaceRecipe)process.recipe).slag.copy());
            } else if (ItemHandlerHelper.canItemStacksStack((ItemStack)((ItemStack)this.inventory.get(22)), (ItemStack)((ArcFurnaceRecipe)process.recipe).slag) || ((ItemStack)this.inventory.get(22)).getCount() + ((ArcFurnaceRecipe)process.recipe).slag.getCount() > this.getSlotLimit(22)) {
                ((ItemStack)this.inventory.get(22)).grow(((ArcFurnaceRecipe)process.recipe).slag.getCount());
            }
        }
    }

    @Override
    public int getMaxProcessPerTick() {
        return 12;
    }

    @Override
    public int getProcessQueueMaxLength() {
        return 12;
    }

    @Override
    public float getMinProcessDistance(TileEntityMultiblockMetal.MultiblockProcess<ArcFurnaceRecipe> process) {
        return 0.0f;
    }

    @Override
    public int getComparatedSize() {
        return 12;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public int getSlotLimit(int slot) {
        return slot > 22 ? 1 : 64;
    }

    @Override
    public int[] getOutputSlots() {
        return outputSlots;
    }

    @Override
    public int[] getOutputTanks() {
        return null;
    }

    @Override
    public IFluidTank[] getInternalTanks() {
        return null;
    }

    @Override
    protected IFluidTank[] getAccessibleFluidTanks(EnumFacing side) {
        return new IFluidTank[0];
    }

    @Override
    protected boolean canFillTankFrom(int iTank, EnumFacing side, FluidStack resources) {
        return false;
    }

    @Override
    protected boolean canDrainTankFrom(int iTank, EnumFacing side) {
        return false;
    }

    @Override
    public void doGraphicalUpdates(int slot) {
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if ((this.pos == 2 || this.pos == 22 || this.pos == 86 || this.pos == 88 || facing == null) && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.master() != null;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            TileEntityArcFurnace master = (TileEntityArcFurnace)this.master();
            if (master == null) {
                return null;
            }
            if (this.pos == 2) {
                return (T)master.outputHandler;
            }
            if (this.pos == 22) {
                return (T)master.slagHandler;
            }
            if (this.pos == (this.mirrored ? 88 : 86)) {
                return (T)master.inputHandler;
            }
            if (this.pos == (this.mirrored ? 86 : 88)) {
                return (T)master.additiveHandler;
            }
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public ArcFurnaceRecipe findRecipeForInsertion(ItemStack inserting) {
        return null;
    }

    @Override
    protected ArcFurnaceRecipe readRecipeFromNBT(NBTTagCompound tag) {
        return ArcFurnaceRecipe.loadFromNBT(tag);
    }

    @Override
    protected TileEntityMultiblockMetal.MultiblockProcess loadProcessFromNBT(NBTTagCompound tag) {
        ArcFurnaceRecipe recipe = this.readRecipeFromNBT(tag);
        if (recipe != null && recipe instanceof ArcFurnaceRecipe) {
            return new MultiblockProcessArcFurnace(recipe, tag.getIntArray("process_inputSlots"));
        }
        return null;
    }

    @Override
    public boolean canOpenGui() {
        return this.formed && (this.pos == 2 || this.pos == 25 || this.pos > 25 && this.pos % 5 > 0 && this.pos % 5 < 4 && this.pos % 25 / 5 < 4);
    }

    @Override
    public int getGuiID() {
        return 10;
    }

    @Override
    public TileEntity getGuiMaster() {
        return this.master();
    }

    @Override
    public boolean shoudlPlaySound(String sound) {
        return false;
    }

    public boolean hasElectrodes() {
        for (int i = 23; i < 26; ++i) {
            if (!((ItemStack)this.inventory.get(i)).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static class MultiblockProcessArcFurnace
    extends TileEntityMultiblockMetal.MultiblockProcessInMachine<ArcFurnaceRecipe> {
        public MultiblockProcessArcFurnace(ArcFurnaceRecipe recipe, int ... inputSlots) {
            super(recipe, inputSlots);
        }

        protected NonNullList<ItemStack> getRecipeItemOutputs(TileEntityMultiblockMetal multiblock) {
            ItemStack input = (ItemStack)multiblock.getInventory().get(this.inputSlots[0]);
            NonNullList additives = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
            for (int i = 0; i < 4; ++i) {
                additives.set(i, (Object)(!((ItemStack)multiblock.getInventory().get(12 + i)).isEmpty() ? ((ItemStack)multiblock.getInventory().get(12 + i)).copy() : ItemStack.EMPTY));
            }
            return ((ArcFurnaceRecipe)this.recipe).getOutputs(input, (NonNullList<ItemStack>)additives);
        }

        @Override
        protected void writeExtraDataToNBT(NBTTagCompound nbt) {
            super.writeExtraDataToNBT(nbt);
        }
    }
}

